/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;

public class SOCPutPiece
extends SOCMessage {
    private String game;
    private int pieceType;
    private int playerNumber;
    private int coordinates;

    public SOCPutPiece(String na, int pn, int pt, int co) {
        this.messageType = 1009;
        this.game = na;
        this.pieceType = pt;
        this.playerNumber = pn;
        this.coordinates = co;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPieceType() {
        return this.pieceType;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public int getCoordinates() {
        return this.coordinates;
    }

    @Override
    public String toCmd() {
        return SOCPutPiece.toCmd(this.game, this.playerNumber, this.pieceType, this.coordinates);
    }

    public static String toCmd(String na, int pn, int pt, int co) {
        return "1009|" + na + sep2 + pn + sep2 + pt + sep2 + co;
    }

    public static SOCPutPiece parseDataStr(String s) {
        int co;
        int pt;
        int pn;
        String na;
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            na = st.nextToken();
            pn = Integer.parseInt(st.nextToken());
            pt = Integer.parseInt(st.nextToken());
            co = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        return new SOCPutPiece(na, pn, pt, co);
    }

    public String toString() {
        String s = "SOCPutPiece:game=" + this.game + "|playerNumber=" + this.playerNumber + "|pieceType=" + this.pieceType + "|coord=" + Integer.toHexString(this.coordinates);
        return s;
    }
}

