/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;

public class SOCTextMsg
extends SOCMessage {
    private static String sep2 = "\u0000";
    private String channel;
    private String nickname;
    private String text;

    public SOCTextMsg(String ch, String nn, String tm) {
        this.messageType = 1005;
        this.channel = ch;
        this.nickname = nn;
        this.text = tm;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public String toCmd() {
        return SOCTextMsg.toCmd(this.channel, this.nickname, this.text);
    }

    public static String toCmd(String ch, String nn, String tm) {
        return "1005|" + ch + sep2 + nn + sep2 + tm;
    }

    public static SOCTextMsg parseDataStr(String s) {
        String tm;
        String nn;
        String ch;
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            ch = st.nextToken();
            nn = st.nextToken();
            tm = st.nextToken();
        }
        catch (Exception e) {
            return null;
        }
        return new SOCTextMsg(ch, nn, tm);
    }

    public String toString() {
        String s = "SOCTextMsg:channel=" + this.channel + "|nickname=" + this.nickname + "|text=" + this.text;
        return s;
    }
}

