/*
 * Decompiled with CFR 0.152.
 */
package soc.util;

import java.util.Vector;
import soc.util.CutoffExceededException;

public class CappedQueue {
    private Vector vec = new Vector();
    private int sizeLimit;

    public CappedQueue() {
        this.sizeLimit = 2000;
    }

    public CappedQueue(int s) {
        this.sizeLimit = s;
    }

    public synchronized void put(Object o) throws CutoffExceededException {
        this.vec.addElement(o);
        this.notifyAll();
        if (this.vec.size() == this.sizeLimit) {
            throw new CutoffExceededException("CappedQueue sizeLimit exceeded");
        }
    }

    public synchronized Object get() {
        while (true) {
            if (this.vec.size() > 0) {
                Object o = this.vec.elementAt(0);
                this.vec.removeElementAt(0);
                return o;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public synchronized boolean empty() {
        return this.vec.isEmpty();
    }
}

