/*
 * Decompiled with CFR 0.152.
 */
package soc.util;

import java.io.InputStream;
import java.util.Properties;

public class Version {
    public static String VERSION = "project.version";
    public static String COPYRIGHT = "project.copyright";
    public static String JRE_MIN_VERSION = "project.jre.min.version";
    public static String JRE_MIN_MAJOR = "project.jre.min.major";
    public static String JRE_MIN_MINOR = "project.jre.min.minor";
    public static String JRE_MIN_EDIT = "project.jre.min.edit";
    private static Properties versionInfo = null;
    private static int jreMinMajor = 1;
    private static int jreMinMinor = 4;
    private static int jreMinEdit = 0;

    public static String version() {
        return versionInfo.getProperty(VERSION);
    }

    public static String copyright() {
        return versionInfo.getProperty(COPYRIGHT);
    }

    public static String minJREVersion() {
        String jreMinVersion = versionInfo.getProperty(JRE_MIN_VERSION);
        if (jreMinVersion == null) {
            try {
                String major = versionInfo.getProperty(JRE_MIN_MAJOR, "" + jreMinMajor);
                String minor = versionInfo.getProperty(JRE_MIN_MINOR, "" + jreMinMinor);
                String edit = versionInfo.getProperty(JRE_MIN_EDIT, "" + jreMinEdit);
                jreMinMajor = Integer.parseInt(major);
                jreMinMinor = Integer.parseInt(minor);
                jreMinEdit = Integer.parseInt(edit);
            }
            catch (Exception x) {
                System.err.println("Error retrieving Version info: ");
                x.printStackTrace();
            }
            jreMinVersion = jreMinMajor + "." + jreMinMinor + "." + jreMinEdit;
            versionInfo.put(JRE_MIN_VERSION, jreMinVersion);
        }
        return jreMinVersion;
    }

    static boolean isJREValid() {
        String v = System.getProperty("java.vm.version");
        int major = Integer.parseInt(v.substring(0, 1));
        int minor = Integer.parseInt(v.substring(2, 3));
        int edit = Integer.parseInt(v.substring(4, 5));
        String build = v.substring(6);
        if (versionInfo.getProperty(JRE_MIN_VERSION) == null) {
            Version.minJREVersion();
        }
        return major >= jreMinMajor || minor >= jreMinMinor || edit >= jreMinEdit;
    }

    static {
        versionInfo = new Properties();
        versionInfo.put(VERSION, "-error-");
        versionInfo.put(COPYRIGHT, "-error-");
        try {
            String resource = "/resources/version.info";
            InputStream in = Version.class.getResourceAsStream(resource);
            versionInfo.load(in);
            in.close();
        }
        catch (Exception io) {
            System.err.println("Unable to load version information.");
            io.printStackTrace();
        }
        Version.minJREVersion();
    }
}

