/*
 * Decompiled with CFR 0.152.
 */
package uct;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import smartsettlers.boardlayout.ActionList;
import smartsettlers.boardlayout.GameStateConstants;
import uct.Trace;
import uct.TreeNode;

public class UCT
implements GameStateConstants {
    public Hashtable tree;
    public static final int MAXNTRACES = 20000;
    int ntraces = 0;
    Trace[] traceList;
    Random rnd = new Random();
    public static final int MINVISITS = 10;
    public static final double C0 = 2.0;
    public static final double MAXVAL = 100.0;

    public UCT() {
        this.tree = new Hashtable(10000000);
        this.traceList = new Trace[20000];
        for (int i = 0; i < 20000; ++i) {
            this.traceList[i] = new Trace();
        }
    }

    public static int getHashCode(int[] s) {
        int[] s2 = (int[])s.clone();
        s2[0] = 0;
        s2[1] = 0;
        s2[9] = 0;
        s2[10] = 0;
        return Arrays.hashCode(s2);
    }

    public void addState(int[] s, ActionList possibilities) {
        this.addState(s, UCT.getHashCode(s), possibilities);
    }

    public void addState(int[] s, int hc, ActionList possibilities) {
        int fsmlevel = s[1];
        int pl = s[5 + fsmlevel];
        int state = s[2 + fsmlevel];
        int[] vwins = new int[possibilities.n];
        int totalvwins = 0;
        for (int i = 0; i < possibilities.n; ++i) {
            switch (possibilities.action[i][0]) {
                case 1: {
                    if (state == 2 || state == 4) break;
                    vwins[i] = 20;
                    break;
                }
                case 3: {
                    vwins[i] = 10;
                }
            }
            totalvwins += vwins[i];
        }
        TreeNode val = new TreeNode(possibilities.n, pl, vwins);
        this.tree.put(hc, val);
    }

    public TreeNode getNode(int[] s) {
        int hc = UCT.getHashCode(s);
        return this.getNode(hc);
    }

    public TreeNode getNode(int hc) {
        TreeNode res = (TreeNode)this.tree.get(hc);
        return res;
    }

    public void clearTraces() {
        this.ntraces = 0;
    }

    public void addTrace(int hc, int pl, int aind) {
        if (this.ntraces >= 20000) {
            return;
        }
        this.traceList[this.ntraces].set(hc, pl, aind);
        ++this.ntraces;
    }

    public void update(int winner, int timeStamp) {
        for (int i = 0; i < this.ntraces; ++i) {
            Trace tr = this.traceList[i];
            TreeNode node = this.getNode(tr.hc);
            ++node.nvisits;
            int[] nArray = node.nwins[tr.aind];
            int n = winner;
            nArray[n] = nArray[n] + 1;
            int n2 = tr.aind;
            node.nactionvisits[n2] = node.nactionvisits[n2] + 1;
            node.timeStamp = timeStamp;
            this.tree.put(tr.hc, node);
        }
    }

    public int selectAction(int[] s, int pl, boolean echo) {
        return this.selectAction(UCT.getHashCode(s), pl, echo);
    }

    public int selectAction(int hc, int pl, boolean echo) {
        int maxind = 0;
        TreeNode node = this.getNode(hc);
        double maxv = 0.0;
        if (node == null) {
            return 0;
        }
        if (node.nvisits < 10) {
            return this.rnd.nextInt(node.nactions);
        }
        for (int k = 0; k < node.nactions; ++k) {
            double v;
            if (node.nactionvisits[k] == 0) {
                v = 100.0;
                if (echo) {
                    System.out.printf("%2d (%d): \t %5.2f ", k, node.nactionvisits[k], v);
                    v = 0.0;
                }
            } else {
                v = (double)node.nwins[k][pl] / (double)node.nactionvisits[k] + 2.0 * Math.sqrt(Math.log(node.nactions) / (double)node.nactionvisits[k]);
                if (echo) {
                    System.out.printf("%2d (%d): \t %5.2f = %5.2f + %5.2f\n", k, node.nactionvisits[k], v, (double)node.nwins[k][pl] / (double)node.nactionvisits[k], 2.0 * Math.sqrt(Math.log(node.nactions) / (double)node.nactionvisits[k]));
                    v = (double)node.nwins[k][pl] / (double)node.nactionvisits[k];
                }
            }
            if (!(maxv < v)) continue;
            maxv = v;
            maxind = k;
        }
        if (echo) {
            System.out.printf("sel:%d\n\n", maxind);
        }
        return maxind;
    }

    public String toString() {
        String s = this.getClass().getName() + ": " + this.tree.size() + "\n";
        Enumeration e = this.tree.keys();
        while (e.hasMoreElements()) {
            int hc = (Integer)e.nextElement();
            TreeNode node = (TreeNode)this.tree.get(hc);
            s = s + String.format("%X/%d: %3d", hc, node.nactions, node.nvisits);
            for (int i = 0; i < node.nactions; ++i) {
                s = s + String.format(" %d[%d,%d,%d,%d]", node.nactionvisits[i], node.nwins[i][0], node.nwins[i][1], node.nwins[i][2], node.nwins[i][3]);
            }
            s = s + "\n";
        }
        return s;
    }
}

