/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.Vector;
import soc.game.SOCPlayer;
import soc.game.SOCPlayingPiece;

public class SOCBuildPossibility {
    public static int[] NOSPEEDUP = new int[]{0, 0, 0, 0};
    SOCPlayingPiece piece;
    boolean buyDevCard;
    int devCardType;
    int freeRoads;
    int score;
    int[] buildingSpeedup;
    int eta;
    int priority;
    SOCPlayer player;
    SOCBuildPossibility parent;
    Vector children;

    public SOCBuildPossibility(SOCPlayingPiece pi, int sc, int[] bs, int et, int pr, SOCPlayer pl) {
        this.piece = pi;
        this.buyDevCard = false;
        this.devCardType = -1;
        this.freeRoads = 0;
        this.score = sc;
        this.buildingSpeedup = bs;
        this.eta = et;
        this.priority = pr;
        this.player = pl;
        this.parent = null;
        this.children = new Vector();
    }

    public SOCBuildPossibility(SOCPlayingPiece pi, int sc, int[] bs, int et, int pr, SOCPlayer pl, int fr) {
        this.piece = pi;
        this.buyDevCard = false;
        this.devCardType = -1;
        this.freeRoads = fr;
        this.score = sc;
        this.buildingSpeedup = bs;
        this.eta = et;
        this.priority = pr;
        this.player = pl;
        this.parent = null;
        this.children = new Vector();
    }

    public SOCBuildPossibility(int sc, int[] bs, int et, int pr, SOCPlayer pl) {
        this.piece = null;
        this.buyDevCard = true;
        this.devCardType = 0;
        this.freeRoads = 0;
        this.score = sc;
        this.buildingSpeedup = bs;
        this.eta = et;
        this.priority = pr;
        this.player = pl;
        this.parent = null;
        this.children = new Vector();
    }

    public SOCBuildPossibility(int dt, int sc, int[] bs, int et, int pr, SOCPlayer pl) {
        this.piece = null;
        this.buyDevCard = false;
        this.devCardType = dt;
        this.freeRoads = 0;
        this.score = sc;
        this.buildingSpeedup = bs;
        this.eta = et;
        this.priority = pr;
        this.player = pl;
        this.parent = null;
        this.children = new Vector();
    }

    public SOCPlayingPiece getPiece() {
        return this.piece;
    }

    public boolean isBuyDevCard() {
        return this.buyDevCard;
    }

    public boolean isPlayDevCard() {
        return this.piece == null && !this.buyDevCard;
    }

    public int getDevCardType() {
        return this.devCardType;
    }

    public int getFreeRoads() {
        return this.freeRoads;
    }

    public int getScore() {
        return this.score;
    }

    public int[] getBuildingSpeedup() {
        return this.buildingSpeedup;
    }

    public int getETA() {
        return this.eta;
    }

    public int getPriority() {
        return this.priority;
    }

    public SOCPlayer getPlayer() {
        return this.player;
    }

    public Vector getChildren() {
        return this.children;
    }

    public SOCBuildPossibility getParent() {
        return this.parent;
    }

    public void setParent(SOCBuildPossibility par) {
        this.parent = par;
    }

    public void addChild(SOCBuildPossibility poss) {
        this.children.addElement(poss);
        poss.setParent(this);
    }

    public String toString() {
        String str = "SOCBP:player=" + this.player + "|piece=" + this.piece + "|score=" + this.score + "|speedup=";
        if (this.buildingSpeedup != null) {
            for (int i = 0; i < 4; ++i) {
                str = str + " " + this.buildingSpeedup[i];
            }
        } else {
            str = str + "null";
        }
        str = str + "|eta=" + this.eta + "|priority=" + this.priority + "|children=" + this.children.size();
        return str;
    }
}

