/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import soc.disableDebug.D;
import soc.game.SOCGame;
import soc.game.SOCPlayerNumbers;
import soc.game.SOCResourceSet;
import soc.robot.SOCNumberProbabilities;
import soc.robot.SOCResSetBuildTimePair;
import soc.util.CutoffExceededException;

public class SOCBuildingSpeedEstimate {
    public static final int ROAD = 0;
    public static final int SETTLEMENT = 1;
    public static final int CITY = 2;
    public static final int CARD = 3;
    public static final int MIN = 0;
    public static final int MAXPLUSONE = 4;
    public static final int DEFAULT_ROLL_LIMIT = 40;
    protected static boolean recalc;
    int[] estimatesFromNothing = new int[4];
    int[] estimatesFromNow = new int[4];
    int[] rollsPerResource = new int[6];
    SOCResourceSet[] resourcesForRoll;

    public SOCBuildingSpeedEstimate(SOCPlayerNumbers numbers) {
        this.recalculateRollsPerResource(numbers);
        this.resourcesForRoll = new SOCResourceSet[13];
        this.recalculateResourcesForRoll(numbers);
    }

    public SOCBuildingSpeedEstimate() {
        this.resourcesForRoll = new SOCResourceSet[13];
    }

    public int[] getEstimatesFromNothingAccurate(boolean[] ports) {
        if (recalc) {
            this.estimatesFromNothing[0] = 40;
            this.estimatesFromNothing[1] = 40;
            this.estimatesFromNothing[2] = 40;
            this.estimatesFromNothing[3] = 40;
            SOCResourceSet emptySet = new SOCResourceSet();
            try {
                this.estimatesFromNothing[0] = this.calculateRollsAccurate(emptySet, SOCGame.ROAD_SET, 40, ports).getRolls();
                this.estimatesFromNothing[1] = this.calculateRollsAccurate(emptySet, SOCGame.SETTLEMENT_SET, 40, ports).getRolls();
                this.estimatesFromNothing[2] = this.calculateRollsAccurate(emptySet, SOCGame.CITY_SET, 40, ports).getRolls();
                this.estimatesFromNothing[3] = this.calculateRollsAccurate(emptySet, SOCGame.CARD_SET, 40, ports).getRolls();
            }
            catch (CutoffExceededException cutoffExceededException) {
                // empty catch block
            }
        }
        return this.estimatesFromNothing;
    }

    public int[] getEstimatesFromNothingFast(boolean[] ports) {
        if (recalc) {
            this.estimatesFromNothing[0] = 40;
            this.estimatesFromNothing[1] = 40;
            this.estimatesFromNothing[2] = 40;
            this.estimatesFromNothing[3] = 40;
            SOCResourceSet emptySet = new SOCResourceSet();
            try {
                this.estimatesFromNothing[0] = this.calculateRollsFast(emptySet, SOCGame.ROAD_SET, 40, ports).getRolls();
                this.estimatesFromNothing[1] = this.calculateRollsFast(emptySet, SOCGame.SETTLEMENT_SET, 40, ports).getRolls();
                this.estimatesFromNothing[2] = this.calculateRollsFast(emptySet, SOCGame.CITY_SET, 40, ports).getRolls();
                this.estimatesFromNothing[3] = this.calculateRollsFast(emptySet, SOCGame.CARD_SET, 40, ports).getRolls();
            }
            catch (CutoffExceededException cutoffExceededException) {
                // empty catch block
            }
        }
        return this.estimatesFromNothing;
    }

    public int[] getEstimatesFromNothingFast(boolean[] ports, int limit) {
        if (recalc) {
            this.estimatesFromNothing[0] = limit;
            this.estimatesFromNothing[1] = limit;
            this.estimatesFromNothing[2] = limit;
            this.estimatesFromNothing[3] = limit;
            SOCResourceSet emptySet = new SOCResourceSet();
            try {
                this.estimatesFromNothing[0] = this.calculateRollsFast(emptySet, SOCGame.ROAD_SET, limit, ports).getRolls();
                this.estimatesFromNothing[1] = this.calculateRollsFast(emptySet, SOCGame.SETTLEMENT_SET, limit, ports).getRolls();
                this.estimatesFromNothing[2] = this.calculateRollsFast(emptySet, SOCGame.CITY_SET, limit, ports).getRolls();
                this.estimatesFromNothing[3] = this.calculateRollsFast(emptySet, SOCGame.CARD_SET, limit, ports).getRolls();
            }
            catch (CutoffExceededException e) {
                // empty catch block
            }
        }
        return this.estimatesFromNothing;
    }

    public int[] getEstimatesFromNowAccurate(SOCResourceSet resources, boolean[] ports) {
        this.estimatesFromNow[0] = 40;
        this.estimatesFromNow[1] = 40;
        this.estimatesFromNow[2] = 40;
        this.estimatesFromNow[3] = 40;
        try {
            this.estimatesFromNow[0] = this.calculateRollsAccurate(resources, SOCGame.ROAD_SET, 40, ports).getRolls();
            this.estimatesFromNow[1] = this.calculateRollsAccurate(resources, SOCGame.SETTLEMENT_SET, 40, ports).getRolls();
            this.estimatesFromNow[2] = this.calculateRollsAccurate(resources, SOCGame.CITY_SET, 40, ports).getRolls();
            this.estimatesFromNow[3] = this.calculateRollsAccurate(resources, SOCGame.CARD_SET, 40, ports).getRolls();
        }
        catch (CutoffExceededException cutoffExceededException) {
            // empty catch block
        }
        return this.estimatesFromNow;
    }

    public int[] getEstimatesFromNowFast(SOCResourceSet resources, boolean[] ports) {
        this.estimatesFromNow[0] = 40;
        this.estimatesFromNow[1] = 40;
        this.estimatesFromNow[2] = 40;
        this.estimatesFromNow[3] = 40;
        try {
            this.estimatesFromNow[0] = this.calculateRollsFast(resources, SOCGame.ROAD_SET, 40, ports).getRolls();
            this.estimatesFromNow[1] = this.calculateRollsFast(resources, SOCGame.SETTLEMENT_SET, 40, ports).getRolls();
            this.estimatesFromNow[2] = this.calculateRollsFast(resources, SOCGame.CITY_SET, 40, ports).getRolls();
            this.estimatesFromNow[3] = this.calculateRollsFast(resources, SOCGame.CARD_SET, 40, ports).getRolls();
        }
        catch (CutoffExceededException cutoffExceededException) {
            // empty catch block
        }
        return this.estimatesFromNow;
    }

    public void recalculateEstimates(SOCPlayerNumbers numbers) {
        this.recalculateRollsPerResource(numbers);
        this.recalculateResourcesForRoll(numbers);
    }

    public void recalculateEstimates(SOCPlayerNumbers numbers, int robberHex) {
        this.recalculateRollsPerResource(numbers, robberHex);
        this.recalculateResourcesForRoll(numbers, robberHex);
    }

    public void recalculateRollsPerResource(SOCPlayerNumbers numbers) {
        recalc = true;
        for (int resource = 1; resource <= 5; ++resource) {
            float totalProbability = 0.0f;
            Enumeration numbersEnum = numbers.getNumbersForResource(resource).elements();
            while (numbersEnum.hasMoreElements()) {
                Integer number = (Integer)numbersEnum.nextElement();
                totalProbability += SOCNumberProbabilities.FLOAT_VALUES[number];
            }
            this.rollsPerResource[resource] = totalProbability != 0.0f ? Math.round(1.0f / totalProbability) : 55555;
        }
    }

    public void recalculateRollsPerResource(SOCPlayerNumbers numbers, int robberHex) {
        D.ebugPrintln("@@@@@@@@ recalculateRollsPerResource");
        D.ebugPrintln("@@@@@@@@ numbers = " + numbers);
        D.ebugPrintln("@@@@@@@@ robberHex = " + Integer.toHexString(robberHex));
        recalc = true;
        for (int resource = 1; resource <= 5; ++resource) {
            D.ebugPrintln("resource: " + resource);
            float totalProbability = 0.0f;
            Enumeration numbersEnum = numbers.getNumbersForResource(resource, robberHex).elements();
            while (numbersEnum.hasMoreElements()) {
                Integer number = (Integer)numbersEnum.nextElement();
                totalProbability += SOCNumberProbabilities.FLOAT_VALUES[number];
            }
            D.ebugPrintln("totalProbability: " + totalProbability);
            this.rollsPerResource[resource] = totalProbability != 0.0f ? Math.round(1.0f / totalProbability) : 55555;
            D.ebugPrintln("rollsPerResource: " + this.rollsPerResource[resource]);
        }
    }

    public void recalculateResourcesForRoll(SOCPlayerNumbers numbers) {
        recalc = true;
        for (int diceResult = 2; diceResult <= 12; ++diceResult) {
            SOCResourceSet resourceSet;
            Vector resources = numbers.getResourcesForNumber(diceResult);
            if (resources == null) continue;
            if (this.resourcesForRoll[diceResult] == null) {
                this.resourcesForRoll[diceResult] = resourceSet = new SOCResourceSet();
            } else {
                resourceSet = this.resourcesForRoll[diceResult];
                resourceSet.clear();
            }
            Enumeration resourcesEnum = resources.elements();
            while (resourcesEnum.hasMoreElements()) {
                Integer resourceInt = (Integer)resourcesEnum.nextElement();
                resourceSet.add(1, resourceInt);
            }
        }
    }

    public void recalculateResourcesForRoll(SOCPlayerNumbers numbers, int robberHex) {
        recalc = true;
        for (int diceResult = 2; diceResult <= 12; ++diceResult) {
            SOCResourceSet resourceSet;
            Vector resources = numbers.getResourcesForNumber(diceResult, robberHex);
            if (resources == null) continue;
            if (this.resourcesForRoll[diceResult] == null) {
                this.resourcesForRoll[diceResult] = resourceSet = new SOCResourceSet();
            } else {
                resourceSet = this.resourcesForRoll[diceResult];
                resourceSet.clear();
            }
            Enumeration resourcesEnum = resources.elements();
            while (resourcesEnum.hasMoreElements()) {
                Integer resourceInt = (Integer)resourcesEnum.nextElement();
                resourceSet.add(1, resourceInt);
            }
        }
    }

    public int[] getRollsPerResource() {
        return this.rollsPerResource;
    }

    protected SOCResSetBuildTimePair calculateRollsFast(SOCResourceSet startingResources, SOCResourceSet targetResources, int cutoff, boolean[] ports) throws CutoffExceededException {
        int resource;
        int mostNeededResource;
        int trades;
        int numTrades;
        int tradeRatio;
        int giveResource;
        SOCResourceSet ourResources = startingResources.copy();
        int rolls = 0;
        if (!ourResources.contains(targetResources)) {
            for (giveResource = 1; giveResource <= 5; ++giveResource) {
                tradeRatio = ports[giveResource] ? 2 : (ports[0] ? 3 : 4);
                numTrades = (ourResources.getAmount(giveResource) - targetResources.getAmount(giveResource)) / tradeRatio;
                for (trades = 0; trades < numTrades; ++trades) {
                    mostNeededResource = -1;
                    for (resource = 1; resource <= 5; ++resource) {
                        if (ourResources.getAmount(resource) >= targetResources.getAmount(resource)) continue;
                        if (mostNeededResource < 0) {
                            mostNeededResource = resource;
                            continue;
                        }
                        if (this.rollsPerResource[resource] <= this.rollsPerResource[mostNeededResource]) continue;
                        mostNeededResource = resource;
                    }
                    if (mostNeededResource != -1 && ourResources.getAmount(giveResource) >= tradeRatio) {
                        ourResources.add(1, mostNeededResource);
                        if (ourResources.getAmount(giveResource) < tradeRatio) {
                            System.err.println("@@@ rsrcs=" + ourResources);
                            System.err.println("@@@ tradeRatio=" + tradeRatio);
                            System.err.println("@@@ giveResource=" + giveResource);
                            System.err.println("@@@ target=" + targetResources);
                        }
                        ourResources.subtract(tradeRatio, giveResource);
                    }
                    if (ourResources.contains(targetResources)) break;
                }
                if (ourResources.contains(targetResources)) break;
            }
        }
        block3: while (!ourResources.contains(targetResources)) {
            if (++rolls > cutoff) {
                throw new CutoffExceededException();
            }
            for (int resource2 = 1; resource2 <= 5; ++resource2) {
                if (this.rollsPerResource[resource2] != 0 && rolls % this.rollsPerResource[resource2] != 0) continue;
                ourResources.add(1, resource2);
            }
            if (ourResources.contains(targetResources)) continue;
            for (giveResource = 1; giveResource <= 5; ++giveResource) {
                tradeRatio = ports[giveResource] ? 2 : (ports[0] ? 3 : 4);
                numTrades = (ourResources.getAmount(giveResource) - targetResources.getAmount(giveResource)) / tradeRatio;
                for (trades = 0; trades < numTrades; ++trades) {
                    mostNeededResource = -1;
                    for (resource = 1; resource <= 5; ++resource) {
                        if (ourResources.getAmount(resource) >= targetResources.getAmount(resource)) continue;
                        if (mostNeededResource < 0) {
                            mostNeededResource = resource;
                            continue;
                        }
                        if (this.rollsPerResource[resource] <= this.rollsPerResource[mostNeededResource]) continue;
                        mostNeededResource = resource;
                    }
                    if (mostNeededResource != -1 && ourResources.getAmount(giveResource) >= tradeRatio) {
                        ourResources.add(1, mostNeededResource);
                        if (ourResources.getAmount(giveResource) < tradeRatio) {
                            System.err.println("@@@ rsrcs=" + ourResources);
                            System.err.println("@@@ tradeRatio=" + tradeRatio);
                            System.err.println("@@@ giveResource=" + giveResource);
                            System.err.println("@@@ target=" + targetResources);
                        }
                        ourResources.subtract(tradeRatio, giveResource);
                    }
                    if (ourResources.contains(targetResources)) break;
                }
                if (ourResources.contains(targetResources)) continue block3;
            }
        }
        return new SOCResSetBuildTimePair(ourResources, rolls);
    }

    protected SOCResSetBuildTimePair calculateRollsAccurate(SOCResourceSet startingResources, SOCResourceSet targetResources, int cutoff, boolean[] ports) throws CutoffExceededException {
        D.ebugPrintln("calculateRollsAccurate");
        D.ebugPrintln("  start: " + startingResources);
        D.ebugPrintln("  target: " + targetResources);
        SOCResourceSet ourResources = startingResources.copy();
        int rolls = 0;
        Hashtable[] resourcesOnRoll = new Hashtable[]{new Hashtable(), new Hashtable()};
        int lastRoll = 0;
        int thisRoll = 1;
        resourcesOnRoll[lastRoll].put(ourResources, new Float(1.0));
        boolean targetReached = ourResources.contains(targetResources);
        SOCResourceSet targetReachedResources = null;
        float targetReachedProb = 0.0f;
        while (!targetReached) {
            if (++rolls > cutoff) {
                D.ebugPrintln("startingResources=" + startingResources + "\ntargetResources=" + targetResources + "\ncutoff=" + cutoff + "\nourResources=" + ourResources);
                throw new CutoffExceededException();
            }
            for (int diceResult = 2; diceResult <= 12; ++diceResult) {
                SOCResourceSet gainedResources = this.resourcesForRoll[diceResult];
                float diceProb = SOCNumberProbabilities.FLOAT_VALUES[diceResult];
                Enumeration lastResourcesEnum = resourcesOnRoll[lastRoll].keys();
                while (lastResourcesEnum.hasMoreElements()) {
                    SOCResourceSet lastResources = (SOCResourceSet)lastResourcesEnum.nextElement();
                    Float lastProb = (Float)resourcesOnRoll[lastRoll].get(lastResources);
                    SOCResourceSet newResources = lastResources.copy();
                    newResources.add(gainedResources);
                    float newProb = lastProb.floatValue() * diceProb;
                    if (!newResources.contains(targetResources)) {
                        for (int giveResource = 1; giveResource <= 5; ++giveResource) {
                            if (newResources.getAmount(giveResource) - targetResources.getAmount(giveResource) <= 1) continue;
                            int tradeRatio = ports[giveResource] ? 2 : (ports[0] ? 3 : 4);
                            int numTrades = (newResources.getAmount(giveResource) - targetResources.getAmount(giveResource)) / tradeRatio;
                            for (int trades = 0; trades < numTrades; ++trades) {
                                int mostNeededResource = -1;
                                for (int resource = 1; resource <= 5; ++resource) {
                                    if (newResources.getAmount(resource) >= targetResources.getAmount(resource)) continue;
                                    if (mostNeededResource < 0) {
                                        mostNeededResource = resource;
                                        continue;
                                    }
                                    if (this.rollsPerResource[resource] <= this.rollsPerResource[mostNeededResource]) continue;
                                    mostNeededResource = resource;
                                }
                                if (mostNeededResource != -1 && newResources.getAmount(giveResource) >= tradeRatio) {
                                    newResources.add(1, mostNeededResource);
                                    if (newResources.getAmount(giveResource) < tradeRatio) {
                                        System.err.println("@@@ rsrcs=" + newResources);
                                        System.err.println("@@@ tradeRatio=" + tradeRatio);
                                        System.err.println("@@@ giveResource=" + giveResource);
                                        System.err.println("@@@ target=" + targetResources);
                                    }
                                    newResources.subtract(tradeRatio, giveResource);
                                }
                                if (newResources.contains(targetResources)) break;
                            }
                            if (newResources.contains(targetResources)) break;
                        }
                    }
                    Float probFloat = (Float)resourcesOnRoll[thisRoll].get(newResources);
                    float newProb2 = newProb;
                    if (probFloat != null) {
                        newProb2 = probFloat.floatValue() + newProb;
                    }
                    if (newResources.contains(targetResources)) {
                        D.ebugPrintln("-----> TARGET HIT *");
                        D.ebugPrintln("newResources: " + newResources);
                        D.ebugPrintln("newProb: " + newProb);
                        targetReachedProb += newProb;
                        if (targetReachedResources == null) {
                            targetReachedResources = newResources;
                        }
                        if (!((double)targetReachedProb >= 0.5)) continue;
                        targetReached = true;
                        continue;
                    }
                    resourcesOnRoll[thisRoll].put(newResources, new Float(newProb2));
                }
            }
            int tmp = lastRoll;
            lastRoll = thisRoll;
            thisRoll = tmp;
            resourcesOnRoll[thisRoll].clear();
        }
        return new SOCResSetBuildTimePair(targetReachedResources, rolls);
    }
}

