/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import soc.disableDebug.D;
import soc.game.SOCBoard;
import soc.game.SOCCity;
import soc.game.SOCGame;
import soc.game.SOCLRPathData;
import soc.game.SOCPlayer;
import soc.game.SOCPlayerNumbers;
import soc.game.SOCPlayingPiece;
import soc.game.SOCRoad;
import soc.game.SOCSettlement;
import soc.robot.SOCBuildingSpeedEstimate;
import soc.robot.SOCPossibleCity;
import soc.robot.SOCPossiblePiece;
import soc.robot.SOCPossibleRoad;
import soc.robot.SOCPossibleSettlement;
import soc.robot.SOCRobotBrain;
import soc.util.CutoffExceededException;
import soc.util.NodeLenVis;
import soc.util.Pair;
import soc.util.Queue;

public class SOCPlayerTracker {
    protected static final DecimalFormat df1 = new DecimalFormat("###0.00");
    protected static int EXPAND_LEVEL = 1;
    protected static int LR_CALC_LEVEL = 2;
    protected SOCRobotBrain brain;
    protected SOCPlayer player;
    protected TreeMap possibleSettlements;
    protected TreeMap possibleRoads;
    protected TreeMap possibleCities;
    protected int longestRoadETA;
    protected int roadsToGo;
    protected int largestArmyETA;
    protected int winGameETA;
    protected int knightsToBuy;
    protected boolean needLR;
    protected boolean needLA;
    boolean inUse = false;

    public SOCPlayerTracker(SOCPlayer pl, SOCRobotBrain br) {
        this.brain = br;
        this.player = pl;
        this.possibleRoads = new TreeMap();
        this.possibleSettlements = new TreeMap();
        this.possibleCities = new TreeMap();
        this.longestRoadETA = 500;
        this.roadsToGo = 20;
        this.largestArmyETA = 500;
        this.knightsToBuy = 0;
    }

    public SOCPlayerTracker(SOCPlayerTracker pt) {
        this.brain = pt.getBrain();
        this.player = pt.getPlayer();
        this.possibleRoads = new TreeMap();
        this.possibleSettlements = new TreeMap();
        this.possibleCities = new TreeMap();
        this.longestRoadETA = pt.getLongestRoadETA();
        this.roadsToGo = pt.getRoadsToGo();
        this.largestArmyETA = pt.getLargestArmyETA();
        this.knightsToBuy = pt.getKnightsToBuy();
        for (SOCPossibleRoad posRoad : pt.getPossibleRoads().values()) {
            SOCPossibleRoad posRoadCopy = new SOCPossibleRoad(posRoad);
            this.possibleRoads.put(new Integer(posRoadCopy.getCoordinates()), posRoadCopy);
        }
        for (SOCPossibleSettlement posSettlement : pt.getPossibleSettlements().values()) {
            SOCPossibleSettlement posSettlementCopy = new SOCPossibleSettlement(posSettlement);
            this.possibleSettlements.put(new Integer(posSettlementCopy.getCoordinates()), posSettlementCopy);
        }
        for (SOCPossibleCity posCity : pt.getPossibleCities().values()) {
            SOCPossibleCity posCityCopy = new SOCPossibleCity(posCity);
            this.possibleCities.put(new Integer(posCityCopy.getCoordinates()), posCityCopy);
        }
    }

    public static HashMap copyPlayerTrackers(HashMap trackers) {
        HashMap<Integer, SOCPlayerTracker> trackersCopy = new HashMap<Integer, SOCPlayerTracker>(4);
        for (SOCPlayerTracker pt : trackers.values()) {
            trackersCopy.put(new Integer(pt.getPlayer().getPlayerNumber()), new SOCPlayerTracker(pt));
        }
        for (SOCPlayerTracker tracker : trackers.values()) {
            SOCPlayerTracker trackerCopy = (SOCPlayerTracker)trackersCopy.get(new Integer(tracker.getPlayer().getPlayerNumber()));
            TreeMap possibleRoads = tracker.getPossibleRoads();
            TreeMap possibleRoadsCopy = trackerCopy.getPossibleRoads();
            TreeMap possibleSettlements = tracker.getPossibleSettlements();
            TreeMap possibleSettlementsCopy = trackerCopy.getPossibleSettlements();
            for (SOCPossibleRoad posRoad : possibleRoads.values()) {
                SOCPossibleRoad posRoadCopy = (SOCPossibleRoad)possibleRoadsCopy.get(new Integer(posRoad.getCoordinates()));
                for (SOCPossibleRoad necRoad : posRoad.getNecessaryRoads()) {
                    SOCPossibleRoad necRoadCopy = (SOCPossibleRoad)possibleRoadsCopy.get(new Integer(necRoad.getCoordinates()));
                    if (necRoadCopy != null) {
                        posRoadCopy.addNecessaryRoad(necRoadCopy);
                        continue;
                    }
                    D.ebugPrintln("*** ERROR in copyPlayerTrackers : necRoadCopy == null");
                }
                for (SOCPossiblePiece newPos : posRoad.getNewPossibilities()) {
                    switch (newPos.getType()) {
                        case 0: {
                            SOCPossibleRoad newPosRoadCopy = (SOCPossibleRoad)possibleRoadsCopy.get(new Integer(newPos.getCoordinates()));
                            if (newPosRoadCopy != null) {
                                posRoadCopy.addNewPossibility(newPosRoadCopy);
                                break;
                            }
                            D.ebugPrintln("*** ERROR in copyPlayerTrackers : newPosRoadCopy == null");
                            break;
                        }
                        case 1: {
                            SOCPossibleSettlement newPosSettlementCopy = (SOCPossibleSettlement)possibleSettlementsCopy.get(new Integer(newPos.getCoordinates()));
                            if (newPosSettlementCopy != null) {
                                posRoadCopy.addNewPossibility(newPosSettlementCopy);
                                break;
                            }
                            D.ebugPrintln("*** ERROR in copyPlayerTrackers : newPosSettlementCopy == null");
                        }
                    }
                }
            }
            for (SOCPossibleSettlement posSet : possibleSettlements.values()) {
                SOCPossibleSettlement posSetCopy = (SOCPossibleSettlement)possibleSettlementsCopy.get(new Integer(posSet.getCoordinates()));
                for (SOCPossibleRoad necRoad : posSet.getNecessaryRoads()) {
                    SOCPossibleRoad necRoadCopy = (SOCPossibleRoad)possibleRoadsCopy.get(new Integer(necRoad.getCoordinates()));
                    if (necRoadCopy != null) {
                        posSetCopy.addNecessaryRoad(necRoadCopy);
                        continue;
                    }
                    D.ebugPrintln("*** ERROR in copyPlayerTrackers : necRoadCopy == null");
                }
                for (SOCPossibleSettlement conflict : posSet.getConflicts()) {
                    SOCPlayerTracker trackerCopy2 = (SOCPlayerTracker)trackersCopy.get(new Integer(conflict.getPlayer().getPlayerNumber()));
                    if (trackerCopy2 == null) {
                        D.ebugPrintln("*** ERROR in copyPlayerTrackers : trackerCopy2 == null");
                        continue;
                    }
                    SOCPossibleSettlement conflictCopy = (SOCPossibleSettlement)trackerCopy2.getPossibleSettlements().get(new Integer(conflict.getCoordinates()));
                    if (conflictCopy == null) {
                        D.ebugPrintln("*** ERROR in copyPlayerTrackers : conflictCopy == null");
                        continue;
                    }
                    posSetCopy.addConflict(conflictCopy);
                }
            }
        }
        return trackersCopy;
    }

    public synchronized void takeMonitor() {
    }

    public synchronized void releaseMonitor() {
    }

    public SOCRobotBrain getBrain() {
        return this.brain;
    }

    public SOCPlayer getPlayer() {
        return this.player;
    }

    public TreeMap getPossibleRoads() {
        return this.possibleRoads;
    }

    public TreeMap getPossibleSettlements() {
        return this.possibleSettlements;
    }

    public TreeMap getPossibleCities() {
        return this.possibleCities;
    }

    public int getLongestRoadETA() {
        return this.longestRoadETA;
    }

    public int getRoadsToGo() {
        return this.roadsToGo;
    }

    public int getLargestArmyETA() {
        return this.largestArmyETA;
    }

    public int getKnightsToBuy() {
        return this.knightsToBuy;
    }

    public void addNewRoad(SOCRoad road, HashMap trackers) {
        if (road.getPlayer().getPlayerNumber() == this.player.getPlayerNumber()) {
            this.addOurNewRoad(road, trackers, EXPAND_LEVEL);
        } else {
            this.addTheirNewRoad(road);
        }
    }

    public void addOurNewRoad(SOCRoad road, HashMap trackers, int expandLevel) {
        for (SOCPossibleRoad pr : this.possibleRoads.values()) {
            pr.resetExpandedFlag();
            if (pr.getCoordinates() != road.getCoordinates()) continue;
            this.possibleRoads.remove(new Integer(pr.getCoordinates()));
            this.removeFromNecessaryRoads(pr);
            break;
        }
        Enumeration adjNodeEnum = SOCBoard.getAdjacentNodesToEdge(road.getCoordinates()).elements();
        while (adjNodeEnum.hasMoreElements()) {
            Integer adjNode = (Integer)adjNodeEnum.nextElement();
            if (!this.player.isPotentialSettlement(adjNode)) continue;
            SOCPossibleSettlement posSet = (SOCPossibleSettlement)this.possibleSettlements.get(adjNode);
            if (posSet != null) {
                this.removeFromNecessaryRoads(posSet);
                posSet.getNecessaryRoads().removeAllElements();
                posSet.setNumberOfNecessaryRoads(0);
                continue;
            }
            SOCPossibleSettlement newPosSet = new SOCPossibleSettlement(this.player, adjNode, new Vector());
            newPosSet.setNumberOfNecessaryRoads(0);
            this.possibleSettlements.put(adjNode, newPosSet);
            this.updateSettlementConflicts(newPosSet, trackers);
        }
        Vector<SOCPossibleRoad> newPossibleRoads = new Vector<SOCPossibleRoad>();
        Vector<SOCPossibleRoad> roadsToExpand = new Vector<SOCPossibleRoad>();
        Enumeration adjEdgesEnum = SOCBoard.getAdjacentEdgesToEdge(road.getCoordinates()).elements();
        while (adjEdgesEnum.hasMoreElements()) {
            Integer adjEdge = (Integer)adjEdgesEnum.nextElement();
            if (!this.player.isPotentialRoad(adjEdge)) continue;
            SOCPossibleRoad pr = (SOCPossibleRoad)this.possibleRoads.get(adjEdge);
            if (pr != null) {
                if (!pr.getNecessaryRoads().isEmpty()) {
                    this.removeFromNecessaryRoads(pr);
                    pr.getNecessaryRoads().removeAllElements();
                    pr.setNumberOfNecessaryRoads(0);
                }
                roadsToExpand.addElement(pr);
                pr.setExpandedFlag();
                continue;
            }
            SOCPossibleRoad newPR = new SOCPossibleRoad(this.player, adjEdge, new Vector());
            newPR.setNumberOfNecessaryRoads(0);
            newPossibleRoads.addElement(newPR);
            roadsToExpand.addElement(newPR);
            newPR.setExpandedFlag();
        }
        Enumeration newPREnum = newPossibleRoads.elements();
        while (newPREnum.hasMoreElements()) {
            SOCPossibleRoad newPR = (SOCPossibleRoad)newPREnum.nextElement();
            this.possibleRoads.put(new Integer(newPR.getCoordinates()), newPR);
        }
        SOCPlayer dummy = new SOCPlayer(this.player);
        Enumeration expandPREnum = roadsToExpand.elements();
        while (expandPREnum.hasMoreElements()) {
            SOCPossibleRoad expandPR = (SOCPossibleRoad)expandPREnum.nextElement();
            this.expandRoad(expandPR, this.player, dummy, trackers, expandLevel);
        }
        dummy.destroyPlayer();
    }

    public void expandRoad(SOCPossibleRoad targetRoad, SOCPlayer player, SOCPlayer dummy, HashMap trackers, int level) {
        SOCRoad dummyRoad = new SOCRoad(dummy, targetRoad.getCoordinates());
        dummy.putPiece(dummyRoad);
        Enumeration adjNodeEnum = SOCBoard.getAdjacentNodesToEdge(targetRoad.getCoordinates()).elements();
        while (adjNodeEnum.hasMoreElements()) {
            Integer adjNode = (Integer)adjNodeEnum.nextElement();
            if (!dummy.isPotentialSettlement(adjNode)) continue;
            SOCPossibleSettlement posSet = (SOCPossibleSettlement)this.possibleSettlements.get(adjNode);
            if (posSet != null) {
                if (posSet.getNecessaryRoads().isEmpty() || posSet.getNecessaryRoads().contains(targetRoad)) continue;
                posSet.getNecessaryRoads().addElement(targetRoad);
                targetRoad.addNewPossibility(posSet);
                if (targetRoad.getNumberOfNecessaryRoads() + 1 >= posSet.getNumberOfNecessaryRoads()) continue;
                posSet.setNumberOfNecessaryRoads(targetRoad.getNumberOfNecessaryRoads() + 1);
                continue;
            }
            Vector<SOCPossibleRoad> nr = new Vector<SOCPossibleRoad>();
            nr.addElement(targetRoad);
            SOCPossibleSettlement newPosSet = new SOCPossibleSettlement(player, adjNode, nr);
            newPosSet.setNumberOfNecessaryRoads(targetRoad.getNumberOfNecessaryRoads() + 1);
            this.possibleSettlements.put(adjNode, newPosSet);
            targetRoad.addNewPossibility(newPosSet);
            this.updateSettlementConflicts(newPosSet, trackers);
        }
        if (level > 0) {
            Vector<SOCPossibleRoad> newPossibleRoads = new Vector<SOCPossibleRoad>();
            Vector<SOCPossibleRoad> roadsToExpand = new Vector<SOCPossibleRoad>();
            Enumeration adjEdgesEnum = SOCBoard.getAdjacentEdgesToEdge(targetRoad.getCoordinates()).elements();
            while (adjEdgesEnum.hasMoreElements()) {
                Integer adjEdge = (Integer)adjEdgesEnum.nextElement();
                if (!dummy.isPotentialRoad(adjEdge)) continue;
                SOCPossibleRoad pr = (SOCPossibleRoad)this.possibleRoads.get(adjEdge);
                if (pr != null) {
                    Vector nr = pr.getNecessaryRoads();
                    if (!nr.isEmpty() && !nr.contains(targetRoad)) {
                        nr.addElement(targetRoad);
                        targetRoad.addNewPossibility(pr);
                        if (targetRoad.getNumberOfNecessaryRoads() + 1 < pr.getNumberOfNecessaryRoads()) {
                            pr.setNumberOfNecessaryRoads(targetRoad.getNumberOfNecessaryRoads() + 1);
                        }
                    }
                    if (pr.hasBeenExpanded()) continue;
                    roadsToExpand.addElement(pr);
                    pr.setExpandedFlag();
                    continue;
                }
                Vector<SOCPossibleRoad> neededRoads = new Vector<SOCPossibleRoad>();
                neededRoads.addElement(targetRoad);
                SOCPossibleRoad newPR = new SOCPossibleRoad(player, adjEdge, neededRoads);
                newPR.setNumberOfNecessaryRoads(targetRoad.getNumberOfNecessaryRoads() + 1);
                targetRoad.addNewPossibility(newPR);
                newPossibleRoads.addElement(newPR);
                roadsToExpand.addElement(newPR);
                newPR.setExpandedFlag();
            }
            Enumeration newPREnum = newPossibleRoads.elements();
            while (newPREnum.hasMoreElements()) {
                SOCPossibleRoad newPR = (SOCPossibleRoad)newPREnum.nextElement();
                this.possibleRoads.put(new Integer(newPR.getCoordinates()), newPR);
            }
            Enumeration expandPREnum = roadsToExpand.elements();
            while (expandPREnum.hasMoreElements()) {
                SOCPossibleRoad expandPR = (SOCPossibleRoad)expandPREnum.nextElement();
                this.expandRoad(expandPR, player, dummy, trackers, level - 1);
            }
        }
        dummy.removePiece(dummyRoad);
    }

    public void addTheirNewRoad(SOCRoad road) {
        D.ebugPrintln("$$$ addTheirNewRoad : " + road);
        Integer roadCoordinates = new Integer(road.getCoordinates());
        SOCPossibleRoad pr = (SOCPossibleRoad)this.possibleRoads.get(roadCoordinates);
        if (pr != null) {
            this.possibleRoads.remove(roadCoordinates);
            this.removeFromNecessaryRoads(pr);
            this.removeDependents(pr);
        }
    }

    protected void updateSettlementConflicts(SOCPossibleSettlement ps, HashMap trackers) {
        for (SOCPlayerTracker tracker : trackers.values()) {
            SOCPossibleSettlement posSet;
            if (tracker.getPlayer().getPlayerNumber() != ps.getPlayer().getPlayerNumber() && (posSet = (SOCPossibleSettlement)tracker.getPossibleSettlements().get(new Integer(ps.getCoordinates()))) != null) {
                ps.addConflict(posSet);
                posSet.addConflict(ps);
            }
            Enumeration adjNodeEnum = SOCBoard.getAdjacentNodesToNode(ps.getCoordinates()).elements();
            while (adjNodeEnum.hasMoreElements()) {
                Integer adjNode = (Integer)adjNodeEnum.nextElement();
                SOCPossibleSettlement posSet2 = (SOCPossibleSettlement)tracker.getPossibleSettlements().get(adjNode);
                if (posSet2 == null) continue;
                ps.addConflict(posSet2);
                posSet2.addConflict(ps);
            }
        }
    }

    public synchronized void addNewSettlement(SOCSettlement settlement, HashMap trackers) {
        if (settlement.getPlayer().getPlayerNumber() == this.player.getPlayerNumber()) {
            this.addOurNewSettlement(settlement, trackers);
        } else {
            this.addTheirNewSettlement(settlement);
        }
    }

    public synchronized void addOurNewSettlement(SOCSettlement settlement, HashMap trackers) {
        D.ebugPrintln("$$$ addOurNewSettlement : " + settlement);
        Integer settlementCoords = new Integer(settlement.getCoordinates());
        this.possibleCities.put(settlementCoords, new SOCPossibleCity(this.player, settlement.getCoordinates()));
        SOCPossibleSettlement ps = (SOCPossibleSettlement)this.possibleSettlements.get(settlementCoords);
        if (ps != null) {
            D.ebugPrintln("$$$ was a possible settlement");
            Vector conflicts = (Vector)ps.getConflicts().clone();
            D.ebugPrintln("$$$ removing " + Integer.toHexString(settlement.getCoordinates()));
            this.possibleSettlements.remove(settlementCoords);
            this.removeFromNecessaryRoads(ps);
            Enumeration conflictEnum = conflicts.elements();
            while (conflictEnum.hasMoreElements()) {
                SOCPossibleSettlement conflict = (SOCPossibleSettlement)conflictEnum.nextElement();
                D.ebugPrintln("$$$ checking conflict with " + conflict.getPlayer().getPlayerNumber() + ":" + Integer.toHexString(conflict.getCoordinates()));
                SOCPlayerTracker tracker = (SOCPlayerTracker)trackers.get(new Integer(conflict.getPlayer().getPlayerNumber()));
                if (tracker == null) continue;
                D.ebugPrintln("$$$ removing " + Integer.toHexString(conflict.getCoordinates()));
                tracker.getPossibleSettlements().remove(new Integer(conflict.getCoordinates()));
                this.removeFromNecessaryRoads(conflict);
                Enumeration otherConflictEnum = conflict.getConflicts().elements();
                while (otherConflictEnum.hasMoreElements()) {
                    SOCPossibleSettlement otherConflict = (SOCPossibleSettlement)otherConflictEnum.nextElement();
                    D.ebugPrintln("$$$ removing conflict " + Integer.toHexString(conflict.getCoordinates()) + " from " + Integer.toHexString(otherConflict.getCoordinates()));
                    otherConflict.removeConflict(conflict);
                }
            }
        } else {
            D.ebugPrintln("$$$ wasn't possible settlement");
            Vector<SOCPossibleSettlement> trash = new Vector<SOCPossibleSettlement>();
            Vector adjNodes = SOCBoard.getAdjacentNodesToNode(settlement.getCoordinates());
            for (SOCPlayerTracker tracker : trackers.values()) {
                SOCPossibleSettlement posSet = (SOCPossibleSettlement)tracker.getPossibleSettlements().get(settlementCoords);
                D.ebugPrintln("$$$ tracker for player " + tracker.getPlayer().getPlayerNumber());
                D.ebugPrintln("$$$ checking node " + Integer.toHexString(settlement.getCoordinates()));
                if (posSet != null) {
                    D.ebugPrintln("$$$ trashing " + Integer.toHexString(posSet.getCoordinates()));
                    trash.addElement(posSet);
                    Enumeration conflictEnum = posSet.getConflicts().elements();
                    while (conflictEnum.hasMoreElements()) {
                        SOCPossibleSettlement conflict = (SOCPossibleSettlement)conflictEnum.nextElement();
                        D.ebugPrintln("$$$ removing conflict " + Integer.toHexString(posSet.getCoordinates()) + " from " + Integer.toHexString(conflict.getCoordinates()));
                        conflict.removeConflict(posSet);
                    }
                }
                Enumeration adjNodeEnum = adjNodes.elements();
                while (adjNodeEnum.hasMoreElements()) {
                    Integer adjNode = (Integer)adjNodeEnum.nextElement();
                    D.ebugPrintln("$$$ checking node " + Integer.toHexString(adjNode));
                    posSet = (SOCPossibleSettlement)tracker.getPossibleSettlements().get(adjNode);
                    if (posSet == null) continue;
                    D.ebugPrintln("$$$ trashing " + Integer.toHexString(posSet.getCoordinates()));
                    trash.addElement(posSet);
                    Enumeration conflictEnum = posSet.getConflicts().elements();
                    while (conflictEnum.hasMoreElements()) {
                        SOCPossibleSettlement conflict = (SOCPossibleSettlement)conflictEnum.nextElement();
                        D.ebugPrintln("$$$ removing conflict " + Integer.toHexString(posSet.getCoordinates()) + " from " + Integer.toHexString(conflict.getCoordinates()));
                        conflict.removeConflict(posSet);
                    }
                }
                D.ebugPrintln("$$$ removing trash for " + tracker.getPlayer().getPlayerNumber());
                Enumeration trashEnum = trash.elements();
                while (trashEnum.hasMoreElements()) {
                    SOCPossibleSettlement pset = (SOCPossibleSettlement)trashEnum.nextElement();
                    D.ebugPrintln("$$$ removing " + Integer.toHexString(pset.getCoordinates()) + " owned by " + pset.getPlayer().getPlayerNumber());
                    tracker.getPossibleSettlements().remove(new Integer(pset.getCoordinates()));
                    this.removeFromNecessaryRoads(pset);
                }
                trash.removeAllElements();
            }
        }
    }

    public void addTheirNewSettlement(SOCSettlement settlement) {
        D.ebugPrintln("$$$ addTheirNewSettlement : " + settlement);
        Vector<SOCPossibleRoad> prTrash = new Vector<SOCPossibleRoad>();
        Vector<SOCPossibleRoad> nrTrash = new Vector<SOCPossibleRoad>();
        Vector adjEdges = SOCBoard.getAdjacentEdgesToNode(settlement.getCoordinates());
        Enumeration edge1Enum = adjEdges.elements();
        while (edge1Enum.hasMoreElements()) {
            prTrash.removeAllElements();
            Integer edge1 = (Integer)edge1Enum.nextElement();
            SOCPossibleRoad pr = (SOCPossibleRoad)this.possibleRoads.get(edge1);
            if (pr != null) {
                if (pr.getNecessaryRoads().isEmpty()) {
                    Enumeration threatEnum = pr.getThreats().elements();
                    while (threatEnum.hasMoreElements()) {
                        SOCPossiblePiece threat = (SOCPossiblePiece)threatEnum.nextElement();
                        if (threat.getType() != 1 || threat.getCoordinates() != settlement.getCoordinates() || threat.getPlayer().getPlayerNumber() != settlement.getPlayer().getPlayerNumber()) continue;
                        D.ebugPrintln("$$$ new settlement cuts off road at " + Integer.toHexString(pr.getCoordinates()));
                        prTrash.addElement(pr);
                        break;
                    }
                } else {
                    nrTrash.removeAllElements();
                    Enumeration nrEnum = pr.getNecessaryRoads().elements();
                    block2: while (nrEnum.hasMoreElements()) {
                        SOCPossibleRoad nr = (SOCPossibleRoad)nrEnum.nextElement();
                        Enumeration edge2Enum = adjEdges.elements();
                        while (edge2Enum.hasMoreElements()) {
                            Integer edge2 = (Integer)edge2Enum.nextElement();
                            if (nr.getCoordinates() != edge2.intValue()) continue;
                            D.ebugPrintln("$$$ removing dependency " + Integer.toHexString(nr.getCoordinates()) + " from " + Integer.toHexString(pr.getCoordinates()));
                            nrTrash.addElement(nr);
                            continue block2;
                        }
                    }
                    if (!nrTrash.isEmpty()) {
                        Enumeration nrTrashEnum = nrTrash.elements();
                        while (nrTrashEnum.hasMoreElements()) {
                            SOCPossibleRoad nrTrashRoad = (SOCPossibleRoad)nrTrashEnum.nextElement();
                            pr.getNecessaryRoads().removeElement(nrTrashRoad);
                            nrTrashRoad.getNewPossibilities().removeElement(pr);
                        }
                        if (pr.getNecessaryRoads().isEmpty()) {
                            D.ebugPrintln("$$$ no more dependencies, removing " + Integer.toHexString(pr.getCoordinates()));
                            prTrash.addElement(pr);
                        }
                    }
                }
            }
            Enumeration prTrashEnum = prTrash.elements();
            while (prTrashEnum.hasMoreElements()) {
                SOCPossibleRoad prt = (SOCPossibleRoad)prTrashEnum.nextElement();
                this.possibleRoads.remove(new Integer(prt.getCoordinates()));
                this.removeFromNecessaryRoads(prt);
                this.removeDependents(prt);
            }
        }
    }

    protected void removeDependents(SOCPossibleRoad road) {
        Enumeration newPosEnum = road.getNewPossibilities().elements();
        block4: while (newPosEnum.hasMoreElements()) {
            SOCPossiblePiece newPos = (SOCPossiblePiece)newPosEnum.nextElement();
            switch (newPos.getType()) {
                case 0: {
                    SOCPossibleRoad necRoad;
                    Vector nr = ((SOCPossibleRoad)newPos).getNecessaryRoads();
                    if (nr.isEmpty()) {
                        System.out.println("ERROR in removeDependents - empty nr list for " + newPos);
                        break;
                    }
                    nr.removeElement(road);
                    if (nr.isEmpty()) {
                        this.possibleRoads.remove(new Integer(newPos.getCoordinates()));
                        this.removeFromNecessaryRoads((SOCPossibleRoad)newPos);
                        this.removeDependents((SOCPossibleRoad)newPos);
                        break;
                    }
                    int smallest = 40;
                    Enumeration nrEnum = nr.elements();
                    while (nrEnum.hasMoreElements()) {
                        necRoad = (SOCPossibleRoad)nrEnum.nextElement();
                        if (necRoad.getNumberOfNecessaryRoads() + 1 >= smallest) continue;
                        smallest = necRoad.getNumberOfNecessaryRoads() + 1;
                    }
                    ((SOCPossibleRoad)newPos).setNumberOfNecessaryRoads(smallest);
                    break;
                }
                case 1: {
                    SOCPossibleRoad necRoad;
                    Vector nr = ((SOCPossibleSettlement)newPos).getNecessaryRoads();
                    if (nr.isEmpty()) {
                        System.out.println("ERROR in removeDependents - empty nr list for " + newPos);
                        break;
                    }
                    nr.removeElement(road);
                    if (nr.isEmpty()) {
                        this.possibleSettlements.remove(new Integer(newPos.getCoordinates()));
                        this.removeFromNecessaryRoads((SOCPossibleSettlement)newPos);
                        Enumeration conflictEnum = ((SOCPossibleSettlement)newPos).getConflicts().elements();
                        while (conflictEnum.hasMoreElements()) {
                            SOCPossibleSettlement conflict = (SOCPossibleSettlement)conflictEnum.nextElement();
                            conflict.removeConflict((SOCPossibleSettlement)newPos);
                        }
                        continue block4;
                    }
                    int smallest = 40;
                    Enumeration nrEnum = nr.elements();
                    while (nrEnum.hasMoreElements()) {
                        necRoad = (SOCPossibleRoad)nrEnum.nextElement();
                        if (necRoad.getNumberOfNecessaryRoads() + 1 >= smallest) continue;
                        smallest = necRoad.getNumberOfNecessaryRoads() + 1;
                    }
                    ((SOCPossibleSettlement)newPos).setNumberOfNecessaryRoads(smallest);
                }
            }
        }
        road.getNewPossibilities().removeAllElements();
    }

    protected void removeFromNecessaryRoads(SOCPossibleRoad pr) {
        Enumeration nrEnum = pr.getNecessaryRoads().elements();
        while (nrEnum.hasMoreElements()) {
            SOCPossibleRoad nr = (SOCPossibleRoad)nrEnum.nextElement();
            nr.getNewPossibilities().removeElement(pr);
        }
    }

    protected void removeFromNecessaryRoads(SOCPossibleSettlement ps) {
        Enumeration nrEnum = ps.getNecessaryRoads().elements();
        while (nrEnum.hasMoreElements()) {
            SOCPossibleRoad nr = (SOCPossibleRoad)nrEnum.nextElement();
            nr.getNewPossibilities().removeElement(ps);
        }
    }

    public void addOurNewCity(SOCCity city) {
        this.possibleCities.remove(new Integer(city.getCoordinates()));
    }

    public void undoAddOurNewCity(SOCPossibleCity city) {
        this.possibleCities.put(new Integer(city.getCoordinates()), city);
    }

    public void updateThreats(HashMap trackers) {
        int ourPlayerNumber = this.player.getPlayerNumber();
        for (SOCPossibleRoad posRoad : this.possibleRoads.values()) {
            if (posRoad.isThreatUpdated() || !posRoad.getNecessaryRoads().isEmpty()) continue;
            Vector adjNodeVec = SOCBoard.getAdjacentNodesToEdge(posRoad.getCoordinates());
            Enumeration adjEdgeEnum = SOCBoard.getAdjacentEdgesToEdge(posRoad.getCoordinates()).elements();
            while (adjEdgeEnum.hasMoreElements()) {
                Integer adjEdge = (Integer)adjEdgeEnum.nextElement();
                Enumeration realRoadEnum = this.player.getRoads().elements();
                while (realRoadEnum.hasMoreElements()) {
                    SOCRoad realRoad = (SOCRoad)realRoadEnum.nextElement();
                    if (adjEdge.intValue() != realRoad.getCoordinates()) continue;
                    Enumeration adjNodeToPosRoadEnum = adjNodeVec.elements();
                    while (adjNodeToPosRoadEnum.hasMoreElements()) {
                        Integer adjNodeToPosRoad = (Integer)adjNodeToPosRoadEnum.nextElement();
                        Enumeration adjNodeToRealRoadEnum = realRoad.getAdjacentNodes().elements();
                        while (adjNodeToRealRoadEnum.hasMoreElements()) {
                            Integer adjNodeToRealRoad = (Integer)adjNodeToRealRoadEnum.nextElement();
                            if (adjNodeToPosRoad.intValue() != adjNodeToRealRoad.intValue()) continue;
                            for (SOCPlayerTracker tracker : trackers.values()) {
                                SOCPossibleSettlement posEnemySet;
                                if (tracker.getPlayer().getPlayerNumber() == ourPlayerNumber || (posEnemySet = (SOCPossibleSettlement)tracker.getPossibleSettlements().get(adjNodeToPosRoad)) == null) continue;
                                posRoad.addThreat(posEnemySet);
                            }
                        }
                    }
                }
            }
            for (SOCPlayerTracker tracker : trackers.values()) {
                SOCPossibleRoad posEnemyRoad;
                if (tracker.getPlayer().getPlayerNumber() == ourPlayerNumber || (posEnemyRoad = (SOCPossibleRoad)tracker.getPossibleRoads().get(new Integer(posRoad.getCoordinates()))) == null) continue;
                posRoad.addThreat(posEnemyRoad);
            }
            Vector threats = posRoad.getThreats();
            Stack<SOCPossiblePiece> stack = new Stack<SOCPossiblePiece>();
            stack.push(posRoad);
            while (!stack.empty()) {
                SOCPossiblePiece curPosPiece = (SOCPossiblePiece)stack.pop();
                if (curPosPiece.getType() != 0) continue;
                Enumeration newPosEnum = ((SOCPossibleRoad)curPosPiece).getNewPossibilities().elements();
                while (newPosEnum.hasMoreElements()) {
                    SOCPossiblePiece newPosPiece = (SOCPossiblePiece)newPosEnum.nextElement();
                    if (newPosPiece.getType() != 0) continue;
                    Vector necRoadVec = ((SOCPossibleRoad)newPosPiece).getNecessaryRoads();
                    if (necRoadVec.size() == 1 && necRoadVec.firstElement() == curPosPiece) {
                        Enumeration threatEnum = threats.elements();
                        while (threatEnum.hasMoreElements()) {
                            ((SOCPossibleRoad)newPosPiece).addThreat((SOCPossiblePiece)threatEnum.nextElement());
                        }
                    }
                    stack.push(newPosPiece);
                }
            }
            posRoad.threatUpdated();
        }
        for (SOCPossibleRoad posRoad : this.possibleRoads.values()) {
            if (posRoad.isThreatUpdated()) continue;
            for (SOCPlayerTracker tracker : trackers.values()) {
                SOCPossibleRoad posEnemyRoad;
                if (tracker.getPlayer().getPlayerNumber() == ourPlayerNumber || (posEnemyRoad = (SOCPossibleRoad)tracker.getPossibleRoads().get(new Integer(posRoad.getCoordinates()))) == null) continue;
                posRoad.addThreat(posEnemyRoad);
                posRoad.threatUpdated();
            }
            Vector necRoadVec = posRoad.getNecessaryRoads();
            if (necRoadVec.size() == 1) {
                SOCPossibleRoad necRoad = (SOCPossibleRoad)necRoadVec.firstElement();
                Enumeration adjNode1Enum = SOCBoard.getAdjacentNodesToEdge(posRoad.getCoordinates()).elements();
                while (adjNode1Enum.hasMoreElements()) {
                    Integer adjNode1 = (Integer)adjNode1Enum.nextElement();
                    Enumeration adjNode2Enum = SOCBoard.getAdjacentNodesToEdge(necRoad.getCoordinates()).elements();
                    while (adjNode2Enum.hasMoreElements()) {
                        Integer adjNode2 = (Integer)adjNode2Enum.nextElement();
                        if (adjNode1.intValue() != adjNode2.intValue()) continue;
                        for (SOCPlayerTracker tracker : trackers.values()) {
                            SOCPossibleSettlement posEnemySet;
                            if (tracker.getPlayer().getPlayerNumber() == ourPlayerNumber || (posEnemySet = (SOCPossibleSettlement)tracker.getPossibleSettlements().get(adjNode1)) == null) continue;
                            posRoad.addThreat(posEnemySet);
                        }
                    }
                }
            }
            posRoad.threatUpdated();
        }
        for (SOCPossibleSettlement posSet : this.possibleSettlements.values()) {
            if (posSet.isThreatUpdated()) continue;
            for (SOCPlayerTracker tracker : trackers.values()) {
                SOCPossibleSettlement posEnemySet;
                if (tracker.getPlayer().getPlayerNumber() == ourPlayerNumber || (posEnemySet = (SOCPossibleSettlement)tracker.getPossibleSettlements().get(new Integer(posSet.getCoordinates()))) == null) continue;
                posSet.addThreat(posEnemySet);
            }
            Vector necRoadVec = posSet.getNecessaryRoads();
            if (!necRoadVec.isEmpty()) {
                if (necRoadVec.size() == 1) {
                    Enumeration threatEnum = ((SOCPossibleRoad)necRoadVec.firstElement()).getThreats().elements();
                    while (threatEnum.hasMoreElements()) {
                        posSet.addThreat((SOCPossiblePiece)threatEnum.nextElement());
                    }
                } else {
                    SOCPossibleRoad nr = (SOCPossibleRoad)necRoadVec.firstElement();
                    Enumeration nrThreatEnum = nr.getThreats().elements();
                    while (nrThreatEnum.hasMoreElements()) {
                        SOCPossiblePiece nrThreat = (SOCPossiblePiece)nrThreatEnum.nextElement();
                        boolean allHaveIt = true;
                        Enumeration nr2Enum = necRoadVec.elements();
                        while (nr2Enum.hasMoreElements()) {
                            SOCPossibleRoad nr2 = (SOCPossibleRoad)nr2Enum.nextElement();
                            if (nr2 == nr || nr2.getThreats().contains(nrThreat)) continue;
                            allHaveIt = false;
                            break;
                        }
                        if (!allHaveIt) continue;
                        posSet.addThreat(nrThreat);
                    }
                }
            }
            posSet.threatUpdated();
        }
    }

    public void recalcLongestRoadETA() {
        int roadETA;
        D.ebugPrintln("===  recalcLongestRoadETA for player " + this.player.getPlayerNumber());
        SOCBuildingSpeedEstimate bse = new SOCBuildingSpeedEstimate(this.player.getNumbers());
        try {
            roadETA = bse.calculateRollsFast(SOCGame.EMPTY_RESOURCES, SOCGame.ROAD_SET, 500, this.player.getPortFlags()).getRolls();
        }
        catch (CutoffExceededException e) {
            roadETA = 500;
        }
        this.roadsToGo = 500;
        this.longestRoadETA = 500;
        SOCPlayer lrPlayer = this.player.getGame().getPlayerWithLongestRoad();
        if (lrPlayer != null && lrPlayer.getPlayerNumber() == this.player.getPlayerNumber()) {
            this.longestRoadETA = 0;
            this.roadsToGo = 0;
        } else {
            int longestRoadLength = lrPlayer == null ? Math.max(4, this.player.getLongestRoadLength()) : lrPlayer.getLongestRoadLength();
            for (SOCLRPathData pathData : this.player.getLRPaths()) {
                int depth = Math.min(longestRoadLength + 1 - pathData.getLength(), this.player.getNumPieces(0));
                int minRoads = this.recalcLongestRoadETAAux(pathData.getBeginning(), pathData.getLength(), longestRoadLength, depth);
                this.roadsToGo = Math.min(minRoads, this.roadsToGo);
                minRoads = this.recalcLongestRoadETAAux(pathData.getEnd(), pathData.getLength(), longestRoadLength, depth);
                this.roadsToGo = Math.min(minRoads, this.roadsToGo);
            }
        }
        D.ebugPrintln("--- roadsToGo = " + this.roadsToGo);
        this.longestRoadETA = this.roadsToGo * roadETA;
    }

    private int recalcLongestRoadETAAux(int startNode, int pathLength, int lrLength, int searchDepth) {
        D.ebugPrintln("=== recalcLongestRoadETAAux(" + Integer.toHexString(startNode) + "," + pathLength + "," + lrLength + "," + searchDepth + ")");
        int longest = 0;
        int numRoads = 500;
        Stack<NodeLenVis> pending = new Stack<NodeLenVis>();
        pending.push(new NodeLenVis(startNode, pathLength, new Vector()));
        while (!pending.empty()) {
            NodeLenVis curNode = (NodeLenVis)pending.pop();
            D.ebugPrintln("curNode = " + curNode);
            int coord = curNode.node;
            int len = curNode.len;
            Vector visited = curNode.vis;
            boolean pathEnd = false;
            Enumeration pEnum = this.player.getGame().getBoard().getPieces().elements();
            while (pEnum.hasMoreElements()) {
                SOCPlayingPiece p = (SOCPlayingPiece)pEnum.nextElement();
                if (len <= 0 || p.getPlayer().getPlayerNumber() == this.player.getPlayerNumber() || p.getType() != 1 && p.getType() != 2 || p.getCoordinates() != coord) continue;
                pathEnd = true;
                break;
            }
            if (!pathEnd) {
                for (SOCLRPathData pathData : this.player.getLRPaths()) {
                    if (startNode == pathData.getBeginning() || startNode == pathData.getEnd() || coord != pathData.getBeginning() && coord != pathData.getEnd()) continue;
                    pathEnd = true;
                    D.ebugPrintln("connecting to another path: " + pathData);
                    D.ebugPrintln("len = " + (len += pathData.getLength()));
                    break;
                }
            }
            if (!pathEnd && len - pathLength >= searchDepth) {
                pathEnd = true;
            }
            if (!pathEnd) {
                Vector newVis;
                Integer vis;
                Enumeration ev;
                pathEnd = true;
                int j = coord - 17;
                Integer edge = new Integer(j);
                boolean match = false;
                if (j >= 34 && j <= 204 && this.player.isLegalRoad(j)) {
                    ev = visited.elements();
                    while (ev.hasMoreElements()) {
                        vis = (Integer)ev.nextElement();
                        if (!vis.equals(edge)) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        newVis = (Vector)visited.clone();
                        newVis.addElement(edge);
                        pending.push(new NodeLenVis(j, len + 1, newVis));
                        pathEnd = false;
                    }
                }
                j = coord;
                edge = new Integer(j);
                match = false;
                if (j >= 34 && j <= 204 && this.player.isLegalRoad(j)) {
                    ev = visited.elements();
                    while (ev.hasMoreElements()) {
                        vis = (Integer)ev.nextElement();
                        if (!vis.equals(edge)) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        newVis = (Vector)visited.clone();
                        newVis.addElement(edge);
                        pending.push(new NodeLenVis(j += 17, len + 1, newVis));
                        pathEnd = false;
                    }
                }
                j = coord - 1;
                edge = new Integer(j);
                match = false;
                if (j >= 34 && j <= 204 && this.player.isLegalRoad(j)) {
                    ev = visited.elements();
                    while (ev.hasMoreElements()) {
                        vis = (Integer)ev.nextElement();
                        if (!vis.equals(edge)) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        newVis = (Vector)visited.clone();
                        newVis.addElement(edge);
                        pending.push(new NodeLenVis(j += 16, len + 1, newVis));
                        pathEnd = false;
                    }
                }
                j = coord - 16;
                edge = new Integer(j);
                match = false;
                if (j >= 34 && j <= 204 && this.player.isLegalRoad(j)) {
                    ev = visited.elements();
                    while (ev.hasMoreElements()) {
                        vis = (Integer)ev.nextElement();
                        if (!vis.equals(edge)) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        newVis = (Vector)visited.clone();
                        newVis.addElement(edge);
                        pending.push(new NodeLenVis(++j, len + 1, newVis));
                        pathEnd = false;
                    }
                }
            }
            if (!pathEnd) continue;
            if (len > longest) {
                longest = len;
                numRoads = curNode.len - pathLength;
                continue;
            }
            if (len != longest || curNode.len >= numRoads) continue;
            numRoads = curNode.len - pathLength;
        }
        if (longest > lrLength) {
            return numRoads;
        }
        return 500;
    }

    public void recalcLargestArmyETA() {
        int laSize = 0;
        SOCPlayer laPlayer = this.player.getGame().getPlayerWithLargestArmy();
        if (laPlayer == null) {
            laSize = 3;
        } else {
            if (laPlayer.getPlayerNumber() == this.player.getPlayerNumber()) {
                this.largestArmyETA = 0;
                return;
            }
            laSize = laPlayer.getNumKnights() + 1;
        }
        this.knightsToBuy = 0;
        if (this.player.getNumKnights() + this.player.getDevCards().getAmount(0, 0) + this.player.getDevCards().getAmount(1, 0) < laSize) {
            this.knightsToBuy = laSize - (this.player.getNumKnights() + this.player.getDevCards().getAmount(0, 0));
        }
        if (this.player.getGame().getNumDevCards() >= this.knightsToBuy) {
            SOCBuildingSpeedEstimate bse = new SOCBuildingSpeedEstimate(this.player.getNumbers());
            int[] ourBuildingSpeed = bse.getEstimatesFromNothingFast(this.player.getPortFlags());
            int cardETA = ourBuildingSpeed[3];
            this.largestArmyETA = (cardETA + 1) * this.knightsToBuy;
        } else {
            this.largestArmyETA = 500;
        }
    }

    public void updateLRValues() {
        SOCPlayer dummy = new SOCPlayer(this.player);
        int lrLength = this.player.getLongestRoadLength();
        for (SOCPossibleRoad posRoad : this.possibleRoads.values()) {
            if (posRoad.getNecessaryRoads().isEmpty()) {
                SOCRoad dummyRoad = new SOCRoad(dummy, posRoad.getCoordinates());
                dummy.putPiece(dummyRoad);
                int newLRLength = dummy.calcLongestRoad2();
                if (newLRLength <= lrLength) {
                    posRoad.setLRValue(0);
                } else {
                    posRoad.setLRValue(newLRLength - lrLength);
                }
                posRoad.setLRPotential(0);
                this.updateLRPotential(posRoad, dummy, dummyRoad, lrLength, LR_CALC_LEVEL);
                dummy.removePiece(dummyRoad);
                continue;
            }
            posRoad.setLRValue(0);
            posRoad.setLRPotential(0);
        }
        dummy.destroyPlayer();
    }

    public void updateLRPotential(SOCPossibleRoad posRoad, SOCPlayer dummy, SOCRoad dummyRoad, int lrLength, int level) {
        Integer adjEdge;
        Enumeration adjEdgeEnum;
        boolean noMoreExpansion;
        if (level <= 0) {
            noMoreExpansion = true;
        } else {
            noMoreExpansion = false;
            adjEdgeEnum = SOCBoard.getAdjacentEdgesToEdge(dummyRoad.getCoordinates()).elements();
            while (adjEdgeEnum.hasMoreElements()) {
                adjEdge = (Integer)adjEdgeEnum.nextElement();
                if (!dummy.isPotentialRoad(adjEdge)) continue;
                noMoreExpansion = false;
                break;
            }
        }
        if (noMoreExpansion) {
            int newPotentialLRValue = dummy.calcLongestRoad2() - lrLength;
            if (newPotentialLRValue > posRoad.getLRPotential()) {
                posRoad.setLRPotential(newPotentialLRValue);
            }
        } else {
            adjEdgeEnum = SOCBoard.getAdjacentEdgesToEdge(dummyRoad.getCoordinates()).elements();
            while (adjEdgeEnum.hasMoreElements()) {
                adjEdge = (Integer)adjEdgeEnum.nextElement();
                if (!dummy.isPotentialRoad(adjEdge)) continue;
                SOCRoad newDummyRoad = new SOCRoad(dummy, adjEdge);
                dummy.putPiece(newDummyRoad);
                this.updateLRPotential(posRoad, dummy, newDummyRoad, lrLength, level - 1);
                dummy.removePiece(newDummyRoad);
            }
        }
    }

    public int getWinGameETA() {
        return this.winGameETA;
    }

    public boolean needsLR() {
        return this.needLR;
    }

    public boolean needsLA() {
        return this.needLA;
    }

    public void recalcWinGameETA() {
        int oldWGETA = this.winGameETA;
        boolean good = false;
        boolean bad = false;
        try {
            this.needLR = false;
            this.needLA = false;
            this.winGameETA = 0;
            SOCPlayerNumbers tempPlayerNumbers = new SOCPlayerNumbers(this.player.getNumbers());
            boolean[] tempPortFlags = new boolean[6];
            for (int portType = 0; portType <= 5; ++portType) {
                tempPortFlags[portType] = this.player.getPortFlag(portType);
            }
            SOCBuildingSpeedEstimate[] tempSetBSE = new SOCBuildingSpeedEstimate[2];
            SOCBuildingSpeedEstimate[] tempCityBSE = new SOCBuildingSpeedEstimate[]{new SOCBuildingSpeedEstimate(), new SOCBuildingSpeedEstimate()};
            tempSetBSE[0] = new SOCBuildingSpeedEstimate();
            tempSetBSE[1] = new SOCBuildingSpeedEstimate();
            int[][] chosenSetBuildingSpeed = new int[2][4];
            int[][] chosenCityBuildingSpeed = new int[2][4];
            SOCBuildingSpeedEstimate tempBSE = new SOCBuildingSpeedEstimate();
            SOCBuildingSpeedEstimate ourBSE = new SOCBuildingSpeedEstimate(this.player.getNumbers());
            int[] ourBuildingSpeed = ourBSE.getEstimatesFromNothingFast(tempPortFlags);
            int cityETA = ourBuildingSpeed[2];
            int settlementETA = ourBuildingSpeed[1];
            int roadETA = ourBuildingSpeed[0];
            int cardETA = ourBuildingSpeed[3];
            int settlementPiecesLeft = this.player.getNumPieces(1);
            int cityPiecesLeft = this.player.getNumPieces(2);
            int citySpotsLeft = this.possibleCities.size();
            boolean haveLA = false;
            boolean haveLR = false;
            int tempLargestArmyETA = this.largestArmyETA;
            int tempLongestRoadETA = this.longestRoadETA;
            SOCPlayer laPlayer = this.player.getGame().getPlayerWithLargestArmy();
            SOCPlayer lrPlayer = this.player.getGame().getPlayerWithLongestRoad();
            SOCBoard board = this.player.getGame().getBoard();
            if (laPlayer != null && this.player.getPlayerNumber() == laPlayer.getPlayerNumber()) {
                haveLA = true;
            }
            if (lrPlayer != null && this.player.getPlayerNumber() == lrPlayer.getPlayerNumber()) {
                haveLR = true;
            }
            TreeMap posSetsCopy = (TreeMap)this.possibleSettlements.clone();
            TreeMap posCitiesCopy = (TreeMap)this.possibleCities.clone();
            int points = this.player.getTotalVP();
            Queue necRoadQueue = new Queue();
            while (points < 10) {
                Object chosenSet;
                int fastestETA;
                D.ebugPrintln("WWW points = " + points);
                D.ebugPrintln("WWW settlementPiecesLeft = " + settlementPiecesLeft);
                D.ebugPrintln("WWW cityPiecesLeft = " + cityPiecesLeft);
                D.ebugPrintln("WWW settlementSpotsLeft = " + posSetsCopy.size());
                D.ebugPrintln("WWW citySpotsLeft = " + posCitiesCopy.size());
                D.ebugPrintln("WWW settlementETA = " + settlementETA);
                D.ebugPrintln("WWW cityETA = " + cityETA);
                D.ebugPrintln("WWW roadETA = " + roadETA);
                D.ebugPrintln("WWW cardETA = " + cardETA);
                if (points == 9) {
                    fastestETA = 500;
                    chosenSet = null;
                    if (settlementPiecesLeft > 0 && !posSetsCopy.isEmpty()) {
                        for (SOCPossibleSettlement posSet : posSetsCopy.values()) {
                            int posSetETA = settlementETA + posSet.getNumberOfNecessaryRoads() * roadETA;
                            if (posSetETA >= fastestETA) continue;
                            fastestETA = posSetETA;
                            chosenSet = posSet;
                        }
                        if (chosenSet != null) {
                            int totalNecRoads = 0;
                            if (!((SOCPossibleSettlement)chosenSet).getNecessaryRoads().isEmpty()) {
                                necRoadQueue.clear();
                                necRoadQueue.put(new Pair(new Integer(0), ((SOCPossibleSettlement)chosenSet).getNecessaryRoads()));
                                while (!necRoadQueue.empty()) {
                                    Pair necRoadPair = (Pair)necRoadQueue.get();
                                    Integer number = (Integer)necRoadPair.getA();
                                    Vector necRoads = (Vector)necRoadPair.getB();
                                    totalNecRoads = number;
                                    if (necRoads.isEmpty()) {
                                        necRoadQueue.clear();
                                        continue;
                                    }
                                    Enumeration necRoadEnum = necRoads.elements();
                                    while (necRoadEnum.hasMoreElements()) {
                                        SOCPossibleRoad nr = (SOCPossibleRoad)necRoadEnum.nextElement();
                                        necRoadQueue.put(new Pair(new Integer(totalNecRoads + 1), nr.getNecessaryRoads()));
                                    }
                                }
                            }
                            fastestETA = settlementETA + totalNecRoads * roadETA;
                            D.ebugPrintln("WWW # necesesary roads = " + totalNecRoads);
                            D.ebugPrintln("WWW this settlement eta = " + (settlementETA + totalNecRoads * roadETA));
                            D.ebugPrintln("WWW settlement is " + chosenSet);
                            D.ebugPrintln("WWW settlement eta = " + fastestETA);
                        } else {
                            fastestETA = 500;
                        }
                    }
                    if (cityPiecesLeft > 0 && citySpotsLeft > 0 && cityETA <= fastestETA) {
                        D.ebugPrintln("WWW city eta = " + cityETA);
                        fastestETA = cityETA;
                    }
                    if (!haveLA && !this.needLA && tempLargestArmyETA < fastestETA) {
                        D.ebugPrintln("WWW LA eta = " + tempLargestArmyETA);
                        fastestETA = tempLargestArmyETA;
                    }
                    if (!haveLR && !this.needLR && tempLongestRoadETA < fastestETA) {
                        D.ebugPrintln("WWW LR eta = " + tempLongestRoadETA);
                        fastestETA = tempLongestRoadETA;
                    }
                    if (!haveLR && !this.needLR && fastestETA == tempLongestRoadETA) {
                        this.needLR = true;
                        if (this.brain.getDRecorder().isOn()) {
                            this.brain.getDRecorder().record(fastestETA + ": Longest Road");
                        }
                    } else if (!haveLA && !this.needLA && fastestETA == tempLargestArmyETA) {
                        this.needLA = true;
                        if (this.brain.getDRecorder().isOn()) {
                            this.brain.getDRecorder().record(fastestETA + ": Largest Army");
                        }
                    } else if (cityPiecesLeft > 0 && citySpotsLeft > 0 && cityETA == fastestETA) {
                        if (this.brain.getDRecorder().isOn()) {
                            this.brain.getDRecorder().record(fastestETA + ": City");
                        }
                    } else if (chosenSet != null && this.brain.getDRecorder().isOn()) {
                        this.brain.getDRecorder().record(fastestETA + ": Stlmt at " + board.nodeCoordToString(((SOCPossiblePiece)chosenSet).getCoordinates()));
                    }
                    D.ebugPrintln("WWW Adding " + fastestETA + " to win eta");
                    this.winGameETA += fastestETA;
                    points += 2;
                    continue;
                }
                fastestETA = 500;
                chosenSet = new SOCPossibleSettlement[2];
                boolean[][] tempPortFlagsSet = new boolean[2][6];
                SOCPossibleCity[] chosenCity = new SOCPossibleCity[2];
                chosenSet[0] = null;
                chosenSet[1] = null;
                chosenCity[0] = null;
                chosenCity[1] = null;
                int twoSettlements = 0;
                int twoCities = 500;
                int oneOfEach = 0;
                int cityBeforeSettlement = 500;
                int settlementBeforeCity = 500;
                if (cityPiecesLeft > 1 && citySpotsLeft > 1) {
                    twoCities = 500;
                    for (SOCPossibleCity posCity0 : posCitiesCopy.values()) {
                        tempPlayerNumbers.updateNumbers(posCity0.getCoordinates(), this.player.getGame().getBoard());
                        tempCityBSE[0].recalculateEstimates(tempPlayerNumbers);
                        chosenCityBuildingSpeed[0] = tempCityBSE[0].getEstimatesFromNothingFast(tempPortFlags);
                        int tempCityETA = chosenCityBuildingSpeed[0][2];
                        if (cityETA + tempCityETA < twoCities) {
                            chosenCity[0] = posCity0;
                            twoCities = cityETA + tempCityETA;
                        }
                        tempPlayerNumbers.undoUpdateNumbers(posCity0.getCoordinates(), this.player.getGame().getBoard());
                    }
                    if (twoCities <= fastestETA) {
                        D.ebugPrintln("WWW twoCities = " + twoCities);
                        fastestETA = twoCities;
                    }
                }
                boolean canBuild2Settlements = false;
                if (settlementPiecesLeft > 1 && posSetsCopy.size() > 1) {
                    canBuild2Settlements = true;
                    Vector<SOCPossibleSettlement> posSetsToPutBack = new Vector<SOCPossibleSettlement>();
                    for (int i = 0; i < 2; ++i) {
                        int fastestSetETA = 500;
                        int bestSpeedupTotal = 0;
                        if (posSetsCopy.isEmpty()) {
                            canBuild2Settlements = false;
                            continue;
                        }
                        for (SOCPossibleSettlement posSet : posSetsCopy.values()) {
                            int buildingType;
                            int posSetETA = settlementETA + posSet.getNumberOfNecessaryRoads() * roadETA;
                            if (posSetETA < fastestSetETA) {
                                fastestSetETA = posSetETA;
                                tempPlayerNumbers.updateNumbers(posSet.getCoordinates(), this.player.getGame().getBoard());
                                Integer posSetCoords = new Integer(posSet.getCoordinates());
                                for (int portType = 0; portType <= 5; ++portType) {
                                    tempPortFlagsSet[i][portType] = tempPortFlags[portType];
                                    if (!this.player.getGame().getBoard().getPortCoordinates(portType).contains(posSetCoords)) continue;
                                    tempPortFlagsSet[i][portType] = true;
                                }
                                tempSetBSE[i].recalculateEstimates(tempPlayerNumbers);
                                chosenSetBuildingSpeed[i] = tempSetBSE[i].getEstimatesFromNothingFast(tempPortFlagsSet[i]);
                                for (int buildingType2 = 0; buildingType2 < 4; ++buildingType2) {
                                    if (ourBuildingSpeed[buildingType2] - chosenSetBuildingSpeed[i][buildingType2] <= 0) continue;
                                    bestSpeedupTotal += ourBuildingSpeed[buildingType2] - chosenSetBuildingSpeed[i][buildingType2];
                                }
                                tempPlayerNumbers.undoUpdateNumbers(posSet.getCoordinates(), this.player.getGame().getBoard());
                                chosenSet[i] = posSet;
                                continue;
                            }
                            if (posSetETA != fastestSetETA) continue;
                            boolean[] veryTempPortFlags = new boolean[6];
                            tempPlayerNumbers.updateNumbers(posSet.getCoordinates(), this.player.getGame().getBoard());
                            Integer posSetCoords = new Integer(posSet.getCoordinates());
                            for (int portType = 0; portType <= 5; ++portType) {
                                veryTempPortFlags[portType] = tempPortFlags[portType];
                                if (!this.player.getGame().getBoard().getPortCoordinates(portType).contains(posSetCoords)) continue;
                                veryTempPortFlags[portType] = true;
                            }
                            tempBSE.recalculateEstimates(tempPlayerNumbers);
                            int[] tempBuildingSpeed = tempBSE.getEstimatesFromNothingFast(veryTempPortFlags);
                            int tempSpeedupTotal = 0;
                            for (buildingType = 0; buildingType < 4; ++buildingType) {
                                if (ourBuildingSpeed[buildingType] - tempBuildingSpeed[buildingType] < 0) continue;
                                tempSpeedupTotal += ourBuildingSpeed[buildingType] - tempBuildingSpeed[buildingType];
                            }
                            tempPlayerNumbers.undoUpdateNumbers(posSet.getCoordinates(), this.player.getGame().getBoard());
                            if (tempSpeedupTotal <= bestSpeedupTotal) continue;
                            fastestSetETA = posSetETA;
                            bestSpeedupTotal = tempSpeedupTotal;
                            for (buildingType = 0; buildingType < 4; ++buildingType) {
                                chosenSetBuildingSpeed[i][buildingType] = tempBuildingSpeed[buildingType];
                            }
                            for (int portType = 0; portType <= 5; ++portType) {
                                tempPortFlagsSet[i][portType] = veryTempPortFlags[portType];
                            }
                            chosenSet[i] = posSet;
                        }
                        int totalNecRoads = 0;
                        if (!((SOCPossibleSettlement)chosenSet[i]).getNecessaryRoads().isEmpty()) {
                            necRoadQueue.clear();
                            necRoadQueue.put(new Pair(new Integer(0), ((SOCPossibleSettlement)chosenSet[i]).getNecessaryRoads()));
                            while (!necRoadQueue.empty()) {
                                Pair necRoadPair = (Pair)necRoadQueue.get();
                                Integer number = (Integer)necRoadPair.getA();
                                Vector necRoads = (Vector)necRoadPair.getB();
                                totalNecRoads = number;
                                if (necRoads.isEmpty()) {
                                    necRoadQueue.clear();
                                    continue;
                                }
                                Enumeration necRoadEnum = necRoads.elements();
                                while (necRoadEnum.hasMoreElements()) {
                                    SOCPossibleRoad nr = (SOCPossibleRoad)necRoadEnum.nextElement();
                                    necRoadQueue.put(new Pair(new Integer(totalNecRoads + 1), nr.getNecessaryRoads()));
                                }
                            }
                        }
                        D.ebugPrintln("WWW # necesesary roads = " + totalNecRoads);
                        D.ebugPrintln("WWW this settlement eta = " + (settlementETA + totalNecRoads * roadETA));
                        if (i == 0 && chosenSet[0] != null) {
                            posSetsCopy.remove(new Integer(((SOCPossiblePiece)chosenSet[0]).getCoordinates()));
                            Enumeration conflicts = ((SOCPossibleSettlement)chosenSet[0]).getConflicts().elements();
                            while (conflicts.hasMoreElements()) {
                                SOCPossibleSettlement conflict = (SOCPossibleSettlement)conflicts.nextElement();
                                Integer conflictInt = new Integer(conflict.getCoordinates());
                                SOCPossibleSettlement possibleConflict = (SOCPossibleSettlement)posSetsCopy.get(conflictInt);
                                if (possibleConflict == null) continue;
                                posSetsToPutBack.add(possibleConflict);
                                posSetsCopy.remove(conflictInt);
                            }
                            twoSettlements += settlementETA + totalNecRoads * roadETA;
                        }
                        if (i != 1 || chosenSet[1] == null) continue;
                        int tempSettlementETA = chosenSetBuildingSpeed[0][1];
                        int tempRoadETA = chosenSetBuildingSpeed[0][0];
                        twoSettlements += tempSettlementETA + totalNecRoads * tempRoadETA;
                    }
                    posSetsCopy.put(new Integer(((SOCPossiblePiece)chosenSet[0]).getCoordinates()), chosenSet[0]);
                    for (SOCPossibleSettlement tmpPosSet : posSetsToPutBack) {
                        posSetsCopy.put(new Integer(tmpPosSet.getCoordinates()), tmpPosSet);
                    }
                    if (canBuild2Settlements && twoSettlements <= fastestETA) {
                        D.ebugPrintln("WWW 2 * settlement = " + twoSettlements);
                        fastestETA = twoSettlements;
                    }
                }
                if (cityPiecesLeft > 0 && (settlementPiecesLeft > 0 && citySpotsLeft >= 0 || settlementPiecesLeft >= 0 && citySpotsLeft > 0) && !posSetsCopy.isEmpty()) {
                    if (chosenCity[0] == null && citySpotsLeft > 0) {
                        int bestCitySpeedupTotal = 0;
                        for (SOCPossibleCity posCity0 : posCitiesCopy.values()) {
                            int buildingType;
                            tempPlayerNumbers.updateNumbers(posCity0.getCoordinates(), this.player.getGame().getBoard());
                            tempBSE.recalculateEstimates(tempPlayerNumbers);
                            int[] tempBuildingSpeed = tempBSE.getEstimatesFromNothingFast(tempPortFlags);
                            int tempSpeedupTotal = 0;
                            for (buildingType = 0; buildingType < 4; ++buildingType) {
                                if (ourBuildingSpeed[buildingType] - tempBuildingSpeed[buildingType] < 0) continue;
                                tempSpeedupTotal += ourBuildingSpeed[buildingType] - tempBuildingSpeed[buildingType];
                            }
                            tempPlayerNumbers.undoUpdateNumbers(posCity0.getCoordinates(), this.player.getGame().getBoard());
                            if (tempSpeedupTotal < bestCitySpeedupTotal) continue;
                            bestCitySpeedupTotal = tempSpeedupTotal;
                            for (buildingType = 0; buildingType < 4; ++buildingType) {
                                chosenCityBuildingSpeed[0][buildingType] = tempBuildingSpeed[buildingType];
                            }
                            chosenCity[0] = posCity0;
                        }
                    }
                    if (chosenSet[0] == null) {
                        int fastestSetETA = 500;
                        int bestSpeedupTotal = 0;
                        for (SOCPossibleSettlement posSet : posSetsCopy.values()) {
                            int buildingType;
                            int posSetETA = settlementETA + posSet.getNumberOfNecessaryRoads() * roadETA;
                            if (posSetETA < fastestSetETA) {
                                fastestSetETA = posSetETA;
                                tempPlayerNumbers.updateNumbers(posSet.getCoordinates(), this.player.getGame().getBoard());
                                Integer posSetCoords = new Integer(posSet.getCoordinates());
                                for (int portType = 0; portType <= 5; ++portType) {
                                    tempPortFlagsSet[0][portType] = tempPortFlags[portType];
                                    if (!this.player.getGame().getBoard().getPortCoordinates(portType).contains(posSetCoords)) continue;
                                    tempPortFlagsSet[0][portType] = true;
                                }
                                tempSetBSE[0].recalculateEstimates(tempPlayerNumbers);
                                chosenSetBuildingSpeed[0] = tempSetBSE[0].getEstimatesFromNothingFast(tempPortFlagsSet[0]);
                                for (int buildingType3 = 0; buildingType3 < 4; ++buildingType3) {
                                    if (ourBuildingSpeed[buildingType3] - chosenSetBuildingSpeed[0][buildingType3] <= 0) continue;
                                    bestSpeedupTotal += ourBuildingSpeed[buildingType3] - chosenSetBuildingSpeed[0][buildingType3];
                                }
                                tempPlayerNumbers.undoUpdateNumbers(posSet.getCoordinates(), this.player.getGame().getBoard());
                                chosenSet[0] = posSet;
                                continue;
                            }
                            if (posSetETA != fastestSetETA) continue;
                            boolean[] veryTempPortFlags = new boolean[6];
                            tempPlayerNumbers.updateNumbers(posSet.getCoordinates(), this.player.getGame().getBoard());
                            Integer posSetCoords = new Integer(posSet.getCoordinates());
                            for (int portType = 0; portType <= 5; ++portType) {
                                veryTempPortFlags[portType] = tempPortFlags[portType];
                                if (!this.player.getGame().getBoard().getPortCoordinates(portType).contains(posSetCoords)) continue;
                                veryTempPortFlags[portType] = true;
                            }
                            tempBSE.recalculateEstimates(tempPlayerNumbers);
                            int[] tempBuildingSpeed = tempBSE.getEstimatesFromNothingFast(veryTempPortFlags);
                            int tempSpeedupTotal = 0;
                            for (buildingType = 0; buildingType < 4; ++buildingType) {
                                if (ourBuildingSpeed[buildingType] - tempBuildingSpeed[buildingType] < 0) continue;
                                tempSpeedupTotal += ourBuildingSpeed[buildingType] - tempBuildingSpeed[buildingType];
                            }
                            tempPlayerNumbers.undoUpdateNumbers(posSet.getCoordinates(), this.player.getGame().getBoard());
                            if (tempSpeedupTotal <= bestSpeedupTotal) continue;
                            fastestSetETA = posSetETA;
                            bestSpeedupTotal = tempSpeedupTotal;
                            for (buildingType = 0; buildingType < 4; ++buildingType) {
                                chosenSetBuildingSpeed[0][buildingType] = tempBuildingSpeed[buildingType];
                            }
                            for (int portType = 0; portType <= 5; ++portType) {
                                tempPortFlagsSet[0][portType] = veryTempPortFlags[portType];
                            }
                            chosenSet[0] = posSet;
                        }
                    }
                    if (citySpotsLeft == 0) {
                        chosenCity[0] = new SOCPossibleCity(this.player, ((SOCPossiblePiece)chosenSet[0]).getCoordinates());
                    }
                    int totalNecRoads = 0;
                    if (!((SOCPossibleSettlement)chosenSet[0]).getNecessaryRoads().isEmpty()) {
                        necRoadQueue.clear();
                        necRoadQueue.put(new Pair(new Integer(0), ((SOCPossibleSettlement)chosenSet[0]).getNecessaryRoads()));
                        while (!necRoadQueue.empty()) {
                            Pair necRoadPair = (Pair)necRoadQueue.get();
                            Integer number = (Integer)necRoadPair.getA();
                            Vector necRoads = (Vector)necRoadPair.getB();
                            totalNecRoads = number;
                            if (necRoads.isEmpty()) {
                                necRoadQueue.clear();
                                continue;
                            }
                            Enumeration necRoadEnum = necRoads.elements();
                            while (necRoadEnum.hasMoreElements()) {
                                SOCPossibleRoad nr = (SOCPossibleRoad)necRoadEnum.nextElement();
                                necRoadQueue.put(new Pair(new Integer(totalNecRoads + 1), nr.getNecessaryRoads()));
                            }
                        }
                    }
                    D.ebugPrintln("WWW # necesesary roads = " + totalNecRoads);
                    D.ebugPrintln("WWW this settlement eta = " + (settlementETA + totalNecRoads * roadETA));
                    if (settlementPiecesLeft > 0 && citySpotsLeft >= 0) {
                        int tempCityETA = chosenSetBuildingSpeed[0][2];
                        settlementBeforeCity = tempCityETA + (settlementETA + totalNecRoads * roadETA);
                    }
                    if (settlementPiecesLeft >= 0 && citySpotsLeft > 0) {
                        int tempSettlementETA = chosenCityBuildingSpeed[0][1];
                        int tempRoadETA = chosenCityBuildingSpeed[0][0];
                        cityBeforeSettlement = cityETA + (tempSettlementETA + totalNecRoads * tempRoadETA);
                    }
                    if ((oneOfEach = settlementBeforeCity < cityBeforeSettlement ? settlementBeforeCity : cityBeforeSettlement) <= fastestETA) {
                        D.ebugPrintln("WWW one of each = " + oneOfEach);
                        fastestETA = oneOfEach;
                    }
                }
                if (!haveLA && !this.needLA && points > 5) {
                    int laSize = 0;
                    if (laPlayer == null) {
                        laSize = 3;
                    } else if (laPlayer.getPlayerNumber() == this.player.getPlayerNumber()) {
                        D.ebugPrintln("WWW ERROR CALCULATING LA ETA");
                    } else {
                        laSize = laPlayer.getNumKnights() + 1;
                    }
                    this.knightsToBuy = 0;
                    if (this.player.getNumKnights() + this.player.getDevCards().getAmount(0, 0) + this.player.getDevCards().getAmount(1, 0) < laSize) {
                        this.knightsToBuy = laSize - (this.player.getNumKnights() + this.player.getDevCards().getAmount(0, 0));
                    }
                    tempLargestArmyETA = this.player.getGame().getNumDevCards() >= this.knightsToBuy ? (cardETA + 1) * this.knightsToBuy : 500;
                    D.ebugPrintln("WWW LA eta = " + tempLargestArmyETA);
                    if (tempLargestArmyETA < fastestETA) {
                        fastestETA = tempLargestArmyETA;
                    }
                }
                if (!haveLR && !this.needLR && points > 5) {
                    tempLongestRoadETA = roadETA * this.roadsToGo;
                    D.ebugPrintln("WWW LR eta = " + tempLongestRoadETA);
                    if (tempLongestRoadETA < fastestETA) {
                        fastestETA = tempLongestRoadETA;
                    }
                }
                D.ebugPrintln("WWW Adding " + fastestETA + " to win eta");
                points += 2;
                this.winGameETA += fastestETA;
                D.ebugPrintln("WWW WGETA SO FAR FOR PLAYER " + this.player.getPlayerNumber() + " = " + this.winGameETA);
                if (settlementPiecesLeft > 1 && posSetsCopy.size() > 1 && canBuild2Settlements && fastestETA == twoSettlements) {
                    Integer conflictInt;
                    Integer chosenSet0Int = new Integer(((SOCPossiblePiece)chosenSet[0]).getCoordinates());
                    Integer chosenSet1Int = new Integer(((SOCPossiblePiece)chosenSet[1]).getCoordinates());
                    posSetsCopy.remove(chosenSet0Int);
                    posSetsCopy.remove(chosenSet1Int);
                    posCitiesCopy.put(chosenSet0Int, new SOCPossibleCity(this.player, ((SOCPossiblePiece)chosenSet[0]).getCoordinates()));
                    posCitiesCopy.put(chosenSet1Int, new SOCPossibleCity(this.player, ((SOCPossiblePiece)chosenSet[1]).getCoordinates()));
                    Enumeration conflicts = ((SOCPossibleSettlement)chosenSet[0]).getConflicts().elements();
                    while (conflicts.hasMoreElements()) {
                        SOCPossibleSettlement conflict = (SOCPossibleSettlement)conflicts.nextElement();
                        conflictInt = new Integer(conflict.getCoordinates());
                        posSetsCopy.remove(conflictInt);
                    }
                    conflicts = ((SOCPossibleSettlement)chosenSet[1]).getConflicts().elements();
                    while (conflicts.hasMoreElements()) {
                        SOCPossibleSettlement conflict = (SOCPossibleSettlement)conflicts.nextElement();
                        conflictInt = new Integer(conflict.getCoordinates());
                        posSetsCopy.remove(conflictInt);
                    }
                    settlementPiecesLeft -= 2;
                    citySpotsLeft += 2;
                    tempPlayerNumbers.updateNumbers(((SOCPossiblePiece)chosenSet[0]).getCoordinates(), this.player.getGame().getBoard());
                    tempPlayerNumbers.updateNumbers(((SOCPossiblePiece)chosenSet[1]).getCoordinates(), this.player.getGame().getBoard());
                    Integer chosenSet0Coords = new Integer(((SOCPossiblePiece)chosenSet[0]).getCoordinates());
                    Integer chosenSet1Coords = new Integer(((SOCPossiblePiece)chosenSet[1]).getCoordinates());
                    for (int portType = 0; portType <= 5; ++portType) {
                        if (this.player.getGame().getBoard().getPortCoordinates(portType).contains(chosenSet0Coords)) {
                            tempPortFlags[portType] = true;
                        }
                        if (!this.player.getGame().getBoard().getPortCoordinates(portType).contains(chosenSet1Coords)) continue;
                        tempPortFlags[portType] = true;
                    }
                    ourBSE.recalculateEstimates(tempPlayerNumbers);
                    ourBuildingSpeed = ourBSE.getEstimatesFromNothingFast(tempPortFlags);
                    settlementETA = ourBuildingSpeed[1];
                    roadETA = ourBuildingSpeed[0];
                    cityETA = ourBuildingSpeed[2];
                    cardETA = ourBuildingSpeed[3];
                    D.ebugPrintln("WWW  * build two settlements");
                    D.ebugPrintln("WWW    settlement 1: " + board.nodeCoordToString(((SOCPossiblePiece)chosenSet[0]).getCoordinates()));
                    D.ebugPrintln("WWW    settlement 2: " + board.nodeCoordToString(((SOCPossiblePiece)chosenSet[1]).getCoordinates()));
                    if (!this.brain.getDRecorder().isOn()) continue;
                    this.brain.getDRecorder().record(fastestETA + ": Stlmt at " + board.nodeCoordToString(((SOCPossiblePiece)chosenSet[0]).getCoordinates()) + "; Stlmt at " + board.nodeCoordToString(((SOCPossiblePiece)chosenSet[1]).getCoordinates()));
                    continue;
                }
                if (cityPiecesLeft > 0 && (settlementPiecesLeft > 0 && citySpotsLeft >= 0 || settlementPiecesLeft >= 0 && citySpotsLeft > 0) && !posSetsCopy.isEmpty() && fastestETA == oneOfEach) {
                    Integer chosenSet0Int = new Integer(((SOCPossiblePiece)chosenSet[0]).getCoordinates());
                    posSetsCopy.remove(chosenSet0Int);
                    if (((SOCPossiblePiece)chosenSet[0]).getCoordinates() != chosenCity[0].getCoordinates()) {
                        posCitiesCopy.put(chosenSet0Int, new SOCPossibleCity(this.player, ((SOCPossiblePiece)chosenSet[0]).getCoordinates()));
                    }
                    posCitiesCopy.remove(new Integer(chosenCity[0].getCoordinates()));
                    --cityPiecesLeft;
                    Enumeration conflicts = ((SOCPossibleSettlement)chosenSet[0]).getConflicts().elements();
                    while (conflicts.hasMoreElements()) {
                        SOCPossibleSettlement conflict = (SOCPossibleSettlement)conflicts.nextElement();
                        Integer conflictInt = new Integer(conflict.getCoordinates());
                        posSetsCopy.remove(conflictInt);
                    }
                    tempPlayerNumbers.updateNumbers(((SOCPossiblePiece)chosenSet[0]).getCoordinates(), this.player.getGame().getBoard());
                    Integer chosenSet0Coords = new Integer(((SOCPossiblePiece)chosenSet[0]).getCoordinates());
                    for (int portType = 0; portType <= 5; ++portType) {
                        if (!this.player.getGame().getBoard().getPortCoordinates(portType).contains(chosenSet0Coords)) continue;
                        tempPortFlags[portType] = true;
                    }
                    tempPlayerNumbers.updateNumbers(chosenCity[0].getCoordinates(), this.player.getGame().getBoard());
                    ourBSE.recalculateEstimates(tempPlayerNumbers);
                    ourBuildingSpeed = ourBSE.getEstimatesFromNothingFast(tempPortFlags);
                    settlementETA = ourBuildingSpeed[1];
                    roadETA = ourBuildingSpeed[0];
                    cityETA = ourBuildingSpeed[2];
                    cardETA = ourBuildingSpeed[3];
                    D.ebugPrintln("WWW  * build a settlement and a city");
                    D.ebugPrintln("WWW    settlement at " + board.nodeCoordToString(((SOCPossiblePiece)chosenSet[0]).getCoordinates()));
                    D.ebugPrintln("WWW    city at " + board.nodeCoordToString(chosenCity[0].getCoordinates()));
                    if (!this.brain.getDRecorder().isOn()) continue;
                    if (fastestETA == settlementBeforeCity) {
                        this.brain.getDRecorder().record(fastestETA + ": Stlmt at " + board.nodeCoordToString(((SOCPossiblePiece)chosenSet[0]).getCoordinates()) + "; City at " + board.nodeCoordToString(chosenCity[0].getCoordinates()));
                        continue;
                    }
                    this.brain.getDRecorder().record(fastestETA + ": City at " + board.nodeCoordToString(chosenCity[0].getCoordinates()) + "; Stlmt at " + board.nodeCoordToString(((SOCPossiblePiece)chosenSet[0]).getCoordinates()));
                    continue;
                }
                if (cityPiecesLeft > 1 && citySpotsLeft > 1 && fastestETA == twoCities) {
                    posCitiesCopy.remove(new Integer(chosenCity[0].getCoordinates()));
                    tempPlayerNumbers.updateNumbers(chosenCity[0].getCoordinates(), this.player.getGame().getBoard());
                    int bestCitySpeedupTotal = 0;
                    for (SOCPossibleCity posCity1 : posCitiesCopy.values()) {
                        tempPlayerNumbers.updateNumbers(posCity1.getCoordinates(), this.player.getGame().getBoard());
                        D.ebugPrintln("tempPlayerNumbers = " + tempPlayerNumbers);
                        tempBSE.recalculateEstimates(tempPlayerNumbers);
                        int[] tempBuildingSpeed = tempBSE.getEstimatesFromNothingFast(tempPortFlags);
                        int tempSpeedupTotal = 0;
                        for (int buildingType = 0; buildingType < 4; ++buildingType) {
                            D.ebugPrintln("ourBuildingSpeed[" + buildingType + "] = " + ourBuildingSpeed[buildingType]);
                            D.ebugPrintln("tempBuildingSpeed[" + buildingType + "] = " + tempBuildingSpeed[buildingType]);
                            if (ourBuildingSpeed[buildingType] - tempBuildingSpeed[buildingType] < 0) continue;
                            tempSpeedupTotal += ourBuildingSpeed[buildingType] - tempBuildingSpeed[buildingType];
                        }
                        tempPlayerNumbers.undoUpdateNumbers(posCity1.getCoordinates(), this.player.getGame().getBoard());
                        D.ebugPrintln("tempPlayerNumbers = " + tempPlayerNumbers);
                        D.ebugPrintln("WWW City at " + board.nodeCoordToString(posCity1.getCoordinates()) + " has tempSpeedupTotal = " + tempSpeedupTotal);
                        if (tempSpeedupTotal < bestCitySpeedupTotal) continue;
                        bestCitySpeedupTotal = tempSpeedupTotal;
                        chosenCity[1] = posCity1;
                    }
                    if (chosenCity[1] == null) {
                        System.out.println("OOPS!!!");
                    } else {
                        posCitiesCopy.remove(new Integer(chosenCity[1].getCoordinates()));
                    }
                    settlementPiecesLeft += 2;
                    cityPiecesLeft -= 2;
                    citySpotsLeft -= 2;
                    tempPlayerNumbers.updateNumbers(chosenCity[1].getCoordinates(), this.player.getGame().getBoard());
                    ourBSE.recalculateEstimates(tempPlayerNumbers);
                    ourBuildingSpeed = ourBSE.getEstimatesFromNothingFast(tempPortFlags);
                    settlementETA = ourBuildingSpeed[1];
                    roadETA = ourBuildingSpeed[0];
                    cityETA = ourBuildingSpeed[2];
                    cardETA = ourBuildingSpeed[3];
                    D.ebugPrintln("WWW  * build 2 cities");
                    D.ebugPrintln("WWW    city 1: " + board.nodeCoordToString(chosenCity[0].getCoordinates()));
                    D.ebugPrintln("WWW    city 2: " + board.nodeCoordToString(chosenCity[1].getCoordinates()));
                    if (!this.brain.getDRecorder().isOn()) continue;
                    this.brain.getDRecorder().record(fastestETA + ": City at " + board.nodeCoordToString(chosenCity[0].getCoordinates()) + "; City at " + board.nodeCoordToString(chosenCity[1].getCoordinates()));
                    continue;
                }
                if (!haveLR && !this.needLR && points > 5 && fastestETA == tempLongestRoadETA) {
                    this.needLR = true;
                    D.ebugPrintln("WWW  * take longest road");
                    if (!this.brain.getDRecorder().isOn()) continue;
                    this.brain.getDRecorder().record(fastestETA + ": Longest Road");
                    continue;
                }
                if (haveLA || this.needLA || points <= 5 || fastestETA != tempLargestArmyETA) continue;
                this.needLA = true;
                D.ebugPrintln("WWW  * take largest army");
                if (!this.brain.getDRecorder().isOn()) continue;
                this.brain.getDRecorder().record(fastestETA + ": Largest Army");
            }
            D.ebugPrintln("WWW TOTAL WGETA FOR PLAYER " + this.player.getPlayerNumber() + " = " + this.winGameETA);
            if (this.brain.getDRecorder().isOn()) {
                this.brain.getDRecorder().record("Total WGETA for " + this.player.getName() + " = " + this.winGameETA);
                this.brain.getDRecorder().record("--------------------");
            }
        }
        catch (Exception e) {
            this.winGameETA = oldWGETA;
            System.out.println("Exception in recalcWinGameETA - " + e);
            e.printStackTrace();
        }
    }

    public static HashMap tryPutPiece(SOCPlayingPiece piece, SOCGame game, HashMap trackers) {
        HashMap trackersCopy = SOCPlayerTracker.copyPlayerTrackers(trackers);
        if (piece != null) {
            game.putTempPiece(piece);
            for (SOCPlayerTracker trackerCopy : trackersCopy.values()) {
                switch (piece.getType()) {
                    case 0: {
                        trackerCopy.addNewRoad((SOCRoad)piece, trackersCopy);
                        break;
                    }
                    case 1: {
                        trackerCopy.addNewSettlement((SOCSettlement)piece, trackersCopy);
                        break;
                    }
                    case 2: {
                        trackerCopy.addOurNewCity((SOCCity)piece);
                    }
                }
            }
        }
        return trackersCopy;
    }

    public static void tryPutPieceNoCopy(SOCPlayingPiece piece, SOCGame game, HashMap trackers) {
        if (piece != null) {
            game.putTempPiece(piece);
            for (SOCPlayerTracker tracker : trackers.values()) {
                switch (piece.getType()) {
                    case 0: {
                        tracker.addNewRoad((SOCRoad)piece, trackers);
                        break;
                    }
                    case 1: {
                        tracker.addNewSettlement((SOCSettlement)piece, trackers);
                        break;
                    }
                    case 2: {
                        tracker.addOurNewCity((SOCCity)piece);
                    }
                }
            }
        }
    }

    public static void undoTryPutPiece(SOCPlayingPiece piece, SOCGame game) {
        if (piece != null) {
            game.undoPutTempPiece(piece);
        }
    }

    public static void playerTrackersDebug(HashMap playerTrackers) {
    }

    public static void updateWinGameETAs(HashMap playerTrackers) {
        for (SOCPlayerTracker tracker : playerTrackers.values()) {
            try {
                tracker.recalcLongestRoadETA();
                tracker.recalcLargestArmyETA();
                tracker.recalcWinGameETA();
            }
            catch (NullPointerException e) {
                System.out.println("Null Pointer Exception calculating winGameETA");
                e.printStackTrace();
            }
        }
    }
}

