/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.Vector;
import soc.game.SOCCity;
import soc.game.SOCPlayer;
import soc.game.SOCPlayerNumbers;
import soc.robot.SOCBuildingSpeedEstimate;
import soc.robot.SOCPossiblePiece;

public class SOCPossibleCity
extends SOCPossiblePiece {
    protected int[] speedup = new int[]{0, 0, 0, 0};

    public SOCPossibleCity(SOCPlayer pl, int co) {
        this.pieceType = 2;
        this.player = pl;
        this.coord = co;
        this.eta = 0;
        this.threats = new Vector();
        this.biggestThreats = new Vector();
        this.threatUpdatedFlag = false;
        this.hasBeenExpanded = false;
        this.updateSpeedup();
    }

    public SOCPossibleCity(SOCPossibleCity pc) {
        this.pieceType = 2;
        this.player = pc.getPlayer();
        this.coord = pc.getCoordinates();
        this.eta = pc.getETA();
        this.threats = new Vector();
        this.biggestThreats = new Vector();
        this.threatUpdatedFlag = false;
        this.hasBeenExpanded = false;
        int[] pcSpeedup = pc.getSpeedup();
        for (int buildingType = 0; buildingType < 4; ++buildingType) {
            this.speedup[buildingType] = pcSpeedup[buildingType];
        }
    }

    public void updateSpeedup() {
        SOCBuildingSpeedEstimate bse1 = new SOCBuildingSpeedEstimate(this.player.getNumbers());
        int[] ourBuildingSpeed = bse1.getEstimatesFromNothingFast(this.player.getPortFlags());
        SOCPlayerNumbers newNumbers = new SOCPlayerNumbers(this.player.getNumbers());
        newNumbers.updateNumbers(new SOCCity(this.player, this.coord), this.player.getGame().getBoard());
        SOCBuildingSpeedEstimate bse2 = new SOCBuildingSpeedEstimate(newNumbers);
        int[] speed = bse2.getEstimatesFromNothingFast(this.player.getPortFlags());
        for (int buildingType = 0; buildingType < 4; ++buildingType) {
            this.speedup[buildingType] = ourBuildingSpeed[buildingType] - speed[buildingType];
        }
    }

    public int[] getSpeedup() {
        return this.speedup;
    }

    public int getSpeedupTotal() {
        int sum = 0;
        for (int buildingType = 0; buildingType < 4; ++buildingType) {
            sum += this.speedup[buildingType];
        }
        return sum;
    }
}

