/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.Vector;
import soc.game.SOCPlayer;

public abstract class SOCPossiblePiece {
    public static final int ROAD = 0;
    public static final int SETTLEMENT = 1;
    public static final int CITY = 2;
    public static final int CARD = 4;
    public static final int MIN = 0;
    public static final int MAXPLUSONE = 4;
    protected int pieceType;
    protected SOCPlayer player;
    protected int coord;
    protected int eta;
    protected boolean updated;
    protected float score;
    protected Vector biggestThreats;
    protected Vector threats;
    protected boolean threatUpdatedFlag;
    protected boolean hasBeenExpanded;

    public int getType() {
        return this.pieceType;
    }

    public SOCPlayer getPlayer() {
        return this.player;
    }

    public int getCoordinates() {
        return this.coord;
    }

    public int getETA() {
        return this.eta;
    }

    public void setETA(int e) {
        this.eta = e;
        this.updated = true;
    }

    public boolean isETAUpdated() {
        return this.updated;
    }

    public void clearUpdateFlag() {
        this.updated = false;
    }

    public void resetScore() {
        this.score = 0.0f;
    }

    public void addToScore(float amt) {
        this.score += amt;
    }

    public void subtractFromScore(float amt) {
        this.score -= amt;
    }

    public float getScore() {
        return this.score;
    }

    public void clearBiggestThreats() {
        this.biggestThreats.removeAllElements();
    }

    public void addBiggestThreat(SOCPossiblePiece bt) {
        this.biggestThreats.addElement(bt);
    }

    public Vector getBiggestThreats() {
        return this.biggestThreats;
    }

    public Vector getThreats() {
        return this.threats;
    }

    public void addThreat(SOCPossiblePiece piece) {
        if (!this.threats.contains(piece)) {
            this.threats.addElement(piece);
        }
    }

    public boolean isThreatUpdated() {
        return this.threatUpdatedFlag;
    }

    public void clearThreats() {
        if (this.threatUpdatedFlag) {
            this.threats.removeAllElements();
            this.threatUpdatedFlag = false;
        }
    }

    public void threatUpdated() {
        this.threatUpdatedFlag = true;
    }

    public boolean hasBeenExpanded() {
        return this.hasBeenExpanded;
    }

    public void resetExpandedFlag() {
        this.hasBeenExpanded = false;
    }

    public void setExpandedFlag() {
        this.hasBeenExpanded = true;
    }

    public String toString() {
        String s = "SOCPossiblePiece:type=" + this.pieceType + "|player=" + this.player + "|coord=" + Integer.toHexString(this.coord);
        return s;
    }
}

