/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.Vector;
import soc.game.SOCPlayer;
import soc.robot.SOCPossiblePiece;

public class SOCPossibleRoad
extends SOCPossiblePiece {
    protected Vector necessaryRoads;
    protected Vector newPossibilities;
    protected int longestRoadValue;
    protected int longestRoadPotential;
    protected int numberOfNecessaryRoads;

    public SOCPossibleRoad(SOCPlayer pl, int co, Vector nr) {
        this.pieceType = 0;
        this.player = pl;
        this.coord = co;
        this.necessaryRoads = nr;
        this.eta = 0;
        this.threats = new Vector();
        this.biggestThreats = new Vector();
        this.newPossibilities = new Vector();
        this.longestRoadValue = 0;
        this.longestRoadPotential = 0;
        this.threatUpdatedFlag = false;
        this.hasBeenExpanded = false;
        this.numberOfNecessaryRoads = -1;
    }

    public SOCPossibleRoad(SOCPossibleRoad pr) {
        this.pieceType = 0;
        this.player = pr.getPlayer();
        this.coord = pr.getCoordinates();
        this.necessaryRoads = new Vector(pr.getNecessaryRoads().size());
        this.eta = pr.getETA();
        this.threats = new Vector();
        this.biggestThreats = new Vector();
        this.newPossibilities = new Vector(pr.getNewPossibilities().size());
        this.longestRoadValue = pr.getLRValue();
        this.longestRoadPotential = pr.getLRPotential();
        this.threatUpdatedFlag = false;
        this.hasBeenExpanded = false;
        this.numberOfNecessaryRoads = pr.getNumberOfNecessaryRoads();
    }

    public Vector getNecessaryRoads() {
        return this.necessaryRoads;
    }

    public int getNumberOfNecessaryRoads() {
        return this.numberOfNecessaryRoads;
    }

    public void setNumberOfNecessaryRoads(int num) {
        this.numberOfNecessaryRoads = num;
    }

    public Vector getNewPossibilities() {
        return this.newPossibilities;
    }

    public int getLRValue() {
        return this.longestRoadValue;
    }

    public int getLRPotential() {
        return this.longestRoadPotential;
    }

    public void addNecessaryRoad(SOCPossibleRoad rd) {
        this.necessaryRoads.addElement(rd);
    }

    public void addNewPossibility(SOCPossiblePiece piece) {
        this.newPossibilities.addElement(piece);
    }

    public void setLRValue(int value) {
        this.longestRoadValue = value;
    }

    public void setLRPotential(int value) {
        this.longestRoadPotential = value;
    }
}

