/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.Stack;
import java.util.Vector;
import soc.game.SOCPlayer;
import soc.robot.SOCPossiblePiece;
import soc.robot.SOCPossibleRoad;

public class SOCPossibleSettlement
extends SOCPossiblePiece {
    protected Vector necessaryRoads;
    protected Vector conflicts;
    protected int[] speedup = new int[]{0, 0, 0, 0};
    protected int numberOfNecessaryRoads;
    protected Stack roadPath;

    public SOCPossibleSettlement(SOCPlayer pl, int co, Vector nr) {
        this.pieceType = 1;
        this.player = pl;
        this.coord = co;
        this.necessaryRoads = nr;
        this.eta = 0;
        this.threats = new Vector();
        this.biggestThreats = new Vector();
        this.conflicts = new Vector();
        this.threatUpdatedFlag = false;
        this.hasBeenExpanded = false;
        this.numberOfNecessaryRoads = -1;
        this.roadPath = null;
        this.updateSpeedup();
    }

    public SOCPossibleSettlement(SOCPossibleSettlement ps) {
        this.pieceType = 1;
        this.player = ps.getPlayer();
        this.coord = ps.getCoordinates();
        this.necessaryRoads = new Vector(ps.getNecessaryRoads().size());
        this.eta = ps.getETA();
        this.threats = new Vector();
        this.biggestThreats = new Vector();
        this.conflicts = new Vector(ps.getConflicts().size());
        this.threatUpdatedFlag = false;
        this.hasBeenExpanded = false;
        int[] psSpeedup = ps.getSpeedup();
        for (int buildingType = 0; buildingType < 4; ++buildingType) {
            this.speedup[buildingType] = psSpeedup[buildingType];
        }
        this.numberOfNecessaryRoads = ps.getNumberOfNecessaryRoads();
        this.roadPath = ps.getRoadPath() == null ? null : (Stack)ps.getRoadPath().clone();
    }

    Stack getRoadPath() {
        return this.roadPath;
    }

    void setRoadPath(Stack path) {
        this.roadPath = path;
    }

    public Vector getNecessaryRoads() {
        return this.necessaryRoads;
    }

    public int getNumberOfNecessaryRoads() {
        return this.numberOfNecessaryRoads;
    }

    public void setNumberOfNecessaryRoads(int num) {
        this.numberOfNecessaryRoads = num;
    }

    public void updateSpeedup() {
    }

    public Vector getConflicts() {
        return this.conflicts;
    }

    public void addNecessaryRoad(SOCPossibleRoad rd) {
        this.necessaryRoads.addElement(rd);
    }

    public void addConflict(SOCPossibleSettlement s) {
        this.conflicts.addElement(s);
    }

    public void removeConflict(SOCPossibleSettlement s) {
        this.conflicts.removeElement(s);
    }

    public int[] getSpeedup() {
        return this.speedup;
    }

    public int getSpeedupTotal() {
        int sum = 0;
        for (int buildingType = 0; buildingType < 4; ++buildingType) {
            sum += this.speedup[buildingType];
        }
        return sum;
    }
}

