/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Random;
import java.util.Stack;
import java.util.Vector;
import soc.disableDebug.D;
import soc.game.SOCBoard;
import soc.game.SOCCity;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCPlayerNumbers;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCSettlement;
import soc.game.SOCTradeOffer;
import soc.message.SOCAcceptOffer;
import soc.message.SOCChoosePlayerRequest;
import soc.message.SOCClearOffer;
import soc.message.SOCDevCard;
import soc.message.SOCDevCardCount;
import soc.message.SOCDiceResult;
import soc.message.SOCDiscardRequest;
import soc.message.SOCFirstPlayer;
import soc.message.SOCGameState;
import soc.message.SOCGameTextMsg;
import soc.message.SOCMakeOffer;
import soc.message.SOCMessage;
import soc.message.SOCMoveRobber;
import soc.message.SOCPlayerElement;
import soc.message.SOCPotentialSettlements;
import soc.message.SOCPutPiece;
import soc.message.SOCRejectOffer;
import soc.message.SOCResourceCount;
import soc.message.SOCSetPlayedDevCard;
import soc.message.SOCSetTurn;
import soc.message.SOCTurn;
import soc.robot.BoardNodeScorePair;
import soc.robot.SOCBuildingSpeedEstimate;
import soc.robot.SOCNumberProbabilities;
import soc.robot.SOCPlayerTracker;
import soc.robot.SOCPossibleCity;
import soc.robot.SOCPossiblePiece;
import soc.robot.SOCPossibleRoad;
import soc.robot.SOCPossibleSettlement;
import soc.robot.SOCRobotClient;
import soc.robot.SOCRobotDM;
import soc.robot.SOCRobotNegotiator;
import soc.robot.SOCRobotPinger;
import soc.robot.SOCTradeTree;
import soc.util.CappedQueue;
import soc.util.CutoffExceededException;
import soc.util.DebugRecorder;
import soc.util.Queue;
import soc.util.SOCRobotParameters;

public class SOCRobotBrain
extends Thread {
    SOCRobotParameters robotParameters;
    protected boolean alive;
    protected boolean ourTurn;
    protected int turnTime;
    protected int curState;
    protected Random rand = new Random();
    protected SOCRobotClient client;
    protected SOCGame game;
    protected SOCPlayer ourPlayerData;
    protected CappedQueue gameEventQ;
    protected int counter;
    protected SOCPlayingPiece whatWeWantToBuild;
    protected Stack buildingPlan;
    protected SOCResourceSet resourceChoices;
    protected int monopolyChoice;
    protected SOCPlayerTracker ourPlayerTracker;
    protected HashMap playerTrackers;
    protected SOCRobotDM decisionMaker;
    protected SOCRobotNegotiator negotiator;
    protected boolean expectSTART1A;
    protected boolean expectSTART1B;
    protected boolean expectSTART2A;
    protected boolean expectSTART2B;
    protected boolean expectPLAY;
    protected boolean expectPLAY1;
    protected boolean expectPLACING_ROAD;
    protected boolean expectPLACING_SETTLEMENT;
    protected boolean expectPLACING_CITY;
    protected boolean expectPLACING_ROBBER;
    protected boolean expectPLACING_FREE_ROAD1;
    protected boolean expectPLACING_FREE_ROAD2;
    protected boolean expectPUTPIECE_FROM_START1A;
    protected boolean expectPUTPIECE_FROM_START1B;
    protected boolean expectPUTPIECE_FROM_START2A;
    protected boolean expectPUTPIECE_FROM_START2B;
    protected boolean expectDICERESULT;
    protected boolean expectDISCARD;
    protected boolean expectMOVEROBBER;
    protected boolean expectWAITING_FOR_DISCOVERY;
    protected boolean expectWAITING_FOR_MONOPOLY;
    protected boolean waitingForGameState;
    protected boolean waitingForOurTurn;
    protected boolean waitingForTradeMsg;
    protected boolean waitingForDevCard;
    protected boolean moveRobberOnSeven;
    protected boolean waitingForTradeResponse;
    protected boolean doneTrading;
    protected boolean[] offerRejections;
    protected int oldGameState;
    protected int[] resourceEstimates;
    protected int firstSettlement;
    protected int secondSettlement;
    protected SOCRobotPinger pinger;
    protected DebugRecorder[] dRecorder;
    protected int currentDRecorder;
    protected SOCPossiblePiece lastMove;
    protected SOCPossiblePiece lastTarget;

    public SOCRobotBrain(SOCRobotClient rc, SOCRobotParameters params, SOCGame ga, CappedQueue mq) {
        this.client = rc;
        this.robotParameters = params;
        this.game = ga;
        this.gameEventQ = mq;
        this.alive = true;
        this.counter = 0;
        this.expectSTART1A = true;
        this.expectSTART1B = false;
        this.expectSTART2A = false;
        this.expectSTART2B = false;
        this.expectPLAY = false;
        this.expectPLAY1 = false;
        this.expectPLACING_ROAD = false;
        this.expectPLACING_SETTLEMENT = false;
        this.expectPLACING_CITY = false;
        this.expectPLACING_ROBBER = false;
        this.expectPLACING_FREE_ROAD1 = false;
        this.expectPLACING_FREE_ROAD2 = false;
        this.expectPUTPIECE_FROM_START1A = false;
        this.expectPUTPIECE_FROM_START1B = false;
        this.expectPUTPIECE_FROM_START2A = false;
        this.expectPUTPIECE_FROM_START2B = false;
        this.expectDICERESULT = false;
        this.expectDISCARD = false;
        this.expectMOVEROBBER = false;
        this.expectWAITING_FOR_DISCOVERY = false;
        this.expectWAITING_FOR_MONOPOLY = false;
        this.ourTurn = false;
        this.oldGameState = this.game.getGameState();
        this.waitingForGameState = false;
        this.waitingForOurTurn = false;
        this.waitingForTradeMsg = false;
        this.waitingForDevCard = false;
        this.moveRobberOnSeven = false;
        this.waitingForTradeResponse = false;
        this.doneTrading = false;
        this.offerRejections = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            this.offerRejections[i] = false;
        }
        this.buildingPlan = new Stack();
        this.resourceChoices = new SOCResourceSet();
        this.resourceChoices.add(2, 1);
        this.monopolyChoice = 3;
        this.pinger = new SOCRobotPinger(this.gameEventQ);
        this.dRecorder = new DebugRecorder[2];
        this.dRecorder[0] = new DebugRecorder();
        this.dRecorder[1] = new DebugRecorder();
        this.currentDRecorder = 0;
    }

    public SOCRobotParameters getRobotParameters() {
        return this.robotParameters;
    }

    public SOCRobotClient getClient() {
        return this.client;
    }

    public HashMap getPlayerTrackers() {
        return this.playerTrackers;
    }

    public SOCPlayerTracker getOurPlayerTracker() {
        return this.ourPlayerTracker;
    }

    public SOCGame getGame() {
        return this.game;
    }

    public SOCPlayer getOurPlayerData() {
        return this.ourPlayerData;
    }

    public Stack getBuildingPlan() {
        return this.buildingPlan;
    }

    public SOCRobotDM getDecisionMaker() {
        return this.decisionMaker;
    }

    public void turnOnDRecorder() {
        this.dRecorder[0].turnOn();
        this.dRecorder[1].turnOn();
    }

    public void turnOffDRecorder() {
        this.dRecorder[0].turnOff();
        this.dRecorder[1].turnOff();
    }

    public DebugRecorder getDRecorder() {
        return this.dRecorder[this.currentDRecorder];
    }

    public DebugRecorder getOldDRecorder() {
        return this.dRecorder[(this.currentDRecorder + 1) % 2];
    }

    public SOCPossiblePiece getLastMove() {
        return this.lastMove;
    }

    public SOCPossiblePiece getLastTarget() {
        return this.lastTarget;
    }

    public void setOurPlayerData() {
        this.ourPlayerData = this.game.getPlayer(this.client.getNickname());
        this.ourPlayerTracker = new SOCPlayerTracker(this.ourPlayerData, this);
        this.playerTrackers = new HashMap();
        this.playerTrackers.put(new Integer(this.ourPlayerData.getPlayerNumber()), this.ourPlayerTracker);
        for (int pn = 0; pn < 4; ++pn) {
            if (pn == this.ourPlayerData.getPlayerNumber()) continue;
            SOCPlayerTracker tracker = new SOCPlayerTracker(this.game.getPlayer(pn), this);
            this.playerTrackers.put(new Integer(pn), tracker);
        }
        this.decisionMaker = new SOCRobotDM(this);
        this.negotiator = new SOCRobotNegotiator(this);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block258: {
            block245: {
                if (this.pinger == null) break block245;
                this.pinger.start();
                try {
                    while (this.alive) {
                        block256: {
                            block257: {
                                block247: {
                                    block255: {
                                        block254: {
                                            block253: {
                                                block252: {
                                                    block251: {
                                                        block250: {
                                                            block249: {
                                                                block248: {
                                                                    block246: {
                                                                        mes = (SOCMessage)this.gameEventQ.get();
                                                                        if (mes != null) {
                                                                            mesType = mes.getType();
                                                                            D.ebugPrintln("mes - " + mes);
                                                                        } else {
                                                                            mesType = -1;
                                                                        }
                                                                        if (this.waitingForTradeMsg && this.counter > 10) {
                                                                            this.waitingForTradeMsg = false;
                                                                            this.counter = 0;
                                                                        }
                                                                        if (this.waitingForTradeResponse && this.counter > 100) {
                                                                            ourCurrentOffer = this.ourPlayerData.getCurrentOffer();
                                                                            if (ourCurrentOffer != null) {
                                                                                offeredTo = ourCurrentOffer.getTo();
                                                                                getSet = ourCurrentOffer.getGetSet();
                                                                                for (rsrcType = 1; rsrcType <= 5; ++rsrcType) {
                                                                                    if (getSet.getAmount(rsrcType) <= 0) continue;
                                                                                    for (pn = 0; pn < 4; ++pn) {
                                                                                        if (!offeredTo[pn]) continue;
                                                                                        this.negotiator.markAsNotSelling(pn, rsrcType);
                                                                                        this.negotiator.markAsNotWantingAnotherOffer(pn, rsrcType);
                                                                                    }
                                                                                }
                                                                                this.pause(1500);
                                                                                this.client.clearOffer(this.game);
                                                                                this.pause(500);
                                                                            }
                                                                            this.counter = 0;
                                                                            this.waitingForTradeResponse = false;
                                                                        }
                                                                        if (this.waitingForGameState && this.counter > 10000) {
                                                                            this.counter = 0;
                                                                            this.client.resend();
                                                                        }
                                                                        if (mesType == 1025) {
                                                                            this.waitingForGameState = false;
                                                                            this.oldGameState = this.game.getGameState();
                                                                            this.game.setGameState(((SOCGameState)mes).getState());
                                                                        } else if (mesType == 1054) {
                                                                            this.game.setFirstPlayer(((SOCFirstPlayer)mes).getPlayerNumber());
                                                                        } else if (mesType == 1055) {
                                                                            this.game.setCurrentPlayerNumber(((SOCSetTurn)mes).getPlayerNumber());
                                                                        } else if (mesType == 1026) {
                                                                            if (this.game.getFirstPlayer() == -1) {
                                                                                this.game.setFirstPlayer(((SOCTurn)mes).getPlayerNumber());
                                                                            }
                                                                            this.game.setCurrentPlayerNumber(((SOCTurn)mes).getPlayerNumber());
                                                                            this.game.getPlayer(((SOCTurn)mes).getPlayerNumber()).getDevCards().newToOld();
                                                                            this.expectPLAY = false;
                                                                            this.expectPLAY1 = false;
                                                                            this.expectPLACING_ROAD = false;
                                                                            this.expectPLACING_SETTLEMENT = false;
                                                                            this.expectPLACING_CITY = false;
                                                                            this.expectPLACING_ROBBER = false;
                                                                            this.expectPLACING_FREE_ROAD1 = false;
                                                                            this.expectPLACING_FREE_ROAD2 = false;
                                                                            this.expectDICERESULT = false;
                                                                            this.expectDISCARD = false;
                                                                            this.expectMOVEROBBER = false;
                                                                            this.expectWAITING_FOR_DISCOVERY = false;
                                                                            this.expectWAITING_FOR_MONOPOLY = false;
                                                                            this.doneTrading = this.robotParameters.getTradeFlag() != 1;
                                                                            this.waitingForTradeMsg = false;
                                                                            this.waitingForTradeResponse = false;
                                                                            this.negotiator.resetIsSelling();
                                                                            this.negotiator.resetOffersMade();
                                                                            this.buildingPlan.clear();
                                                                            this.negotiator.resetTargetPieces();
                                                                        }
                                                                        this.ourTurn = this.game.getCurrentPlayerNumber() == this.ourPlayerData.getPlayerNumber();
                                                                        if (mesType == 1026 && this.ourTurn) {
                                                                            this.waitingForOurTurn = false;
                                                                        }
                                                                        if (mesType != 1024) break block246;
                                                                        pl = this.game.getPlayer(((SOCPlayerElement)mes).getPlayerNumber());
                                                                        switch (((SOCPlayerElement)mes).getElementType()) {
                                                                            case 10: {
                                                                                switch (((SOCPlayerElement)mes).getAction()) {
                                                                                    case 100: {
                                                                                        pl.setNumPieces(0, ((SOCPlayerElement)mes).getValue());
                                                                                        break;
                                                                                    }
                                                                                    case 101: {
                                                                                        pl.setNumPieces(0, pl.getNumPieces(0) + ((SOCPlayerElement)mes).getValue());
                                                                                        break;
                                                                                    }
                                                                                    case 102: {
                                                                                        pl.setNumPieces(0, pl.getNumPieces(0) - ((SOCPlayerElement)mes).getValue());
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                break;
                                                                            }
                                                                            case 11: {
                                                                                switch (((SOCPlayerElement)mes).getAction()) {
                                                                                    case 100: {
                                                                                        pl.setNumPieces(1, ((SOCPlayerElement)mes).getValue());
                                                                                        break;
                                                                                    }
                                                                                    case 101: {
                                                                                        pl.setNumPieces(1, pl.getNumPieces(1) + ((SOCPlayerElement)mes).getValue());
                                                                                        break;
                                                                                    }
                                                                                    case 102: {
                                                                                        pl.setNumPieces(1, pl.getNumPieces(1) - ((SOCPlayerElement)mes).getValue());
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                break;
                                                                            }
                                                                            case 12: {
                                                                                switch (((SOCPlayerElement)mes).getAction()) {
                                                                                    case 100: {
                                                                                        pl.setNumPieces(2, ((SOCPlayerElement)mes).getValue());
                                                                                        break;
                                                                                    }
                                                                                    case 101: {
                                                                                        pl.setNumPieces(2, pl.getNumPieces(2) + ((SOCPlayerElement)mes).getValue());
                                                                                        break;
                                                                                    }
                                                                                    case 102: {
                                                                                        pl.setNumPieces(2, pl.getNumPieces(2) - ((SOCPlayerElement)mes).getValue());
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                break;
                                                                            }
                                                                            case 15: {
                                                                                switch (((SOCPlayerElement)mes).getAction()) {
                                                                                    case 100: {
                                                                                        pl.setNumKnights(((SOCPlayerElement)mes).getValue());
                                                                                        break;
                                                                                    }
                                                                                    case 101: {
                                                                                        pl.setNumKnights(pl.getNumKnights() + ((SOCPlayerElement)mes).getValue());
                                                                                        break;
                                                                                    }
                                                                                    case 102: {
                                                                                        pl.setNumKnights(pl.getNumKnights() - ((SOCPlayerElement)mes).getValue());
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                this.game.updateLargestArmy();
                                                                                break;
                                                                            }
                                                                            case 1: {
                                                                                switch (((SOCPlayerElement)mes).getAction()) {
                                                                                    case 100: {
                                                                                        pl.getResources().setAmount(((SOCPlayerElement)mes).getValue(), 1);
                                                                                        break;
                                                                                    }
                                                                                    case 101: {
                                                                                        pl.getResources().add(((SOCPlayerElement)mes).getValue(), 1);
                                                                                        break;
                                                                                    }
                                                                                    case 102: {
                                                                                        pl.getResources().subtract(((SOCPlayerElement)mes).getValue(), 1);
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                break;
                                                                            }
                                                                            case 2: {
                                                                                switch (((SOCPlayerElement)mes).getAction()) {
                                                                                    case 100: {
                                                                                        pl.getResources().setAmount(((SOCPlayerElement)mes).getValue(), 2);
                                                                                        break;
                                                                                    }
                                                                                    case 101: {
                                                                                        pl.getResources().add(((SOCPlayerElement)mes).getValue(), 2);
                                                                                        break;
                                                                                    }
                                                                                    case 102: {
                                                                                        pl.getResources().subtract(((SOCPlayerElement)mes).getValue(), 2);
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                break;
                                                                            }
                                                                            case 3: {
                                                                                switch (((SOCPlayerElement)mes).getAction()) {
                                                                                    case 100: {
                                                                                        pl.getResources().setAmount(((SOCPlayerElement)mes).getValue(), 3);
                                                                                        break;
                                                                                    }
                                                                                    case 101: {
                                                                                        pl.getResources().add(((SOCPlayerElement)mes).getValue(), 3);
                                                                                        break;
                                                                                    }
                                                                                    case 102: {
                                                                                        pl.getResources().subtract(((SOCPlayerElement)mes).getValue(), 3);
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                break;
                                                                            }
                                                                            case 4: {
                                                                                switch (((SOCPlayerElement)mes).getAction()) {
                                                                                    case 100: {
                                                                                        pl.getResources().setAmount(((SOCPlayerElement)mes).getValue(), 4);
                                                                                        break;
                                                                                    }
                                                                                    case 101: {
                                                                                        pl.getResources().add(((SOCPlayerElement)mes).getValue(), 4);
                                                                                        break;
                                                                                    }
                                                                                    case 102: {
                                                                                        pl.getResources().subtract(((SOCPlayerElement)mes).getValue(), 4);
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                break;
                                                                            }
                                                                            case 5: {
                                                                                switch (((SOCPlayerElement)mes).getAction()) {
                                                                                    case 100: {
                                                                                        pl.getResources().setAmount(((SOCPlayerElement)mes).getValue(), 5);
                                                                                        break;
                                                                                    }
                                                                                    case 101: {
                                                                                        pl.getResources().add(((SOCPlayerElement)mes).getValue(), 5);
                                                                                        break;
                                                                                    }
                                                                                    case 102: {
                                                                                        pl.getResources().subtract(((SOCPlayerElement)mes).getValue(), 5);
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                break;
                                                                            }
                                                                            case 6: {
                                                                                switch (((SOCPlayerElement)mes).getAction()) {
                                                                                    case 100: {
                                                                                        pl.getResources().setAmount(((SOCPlayerElement)mes).getValue(), 6);
                                                                                        break;
                                                                                    }
                                                                                    case 101: {
                                                                                        pl.getResources().add(((SOCPlayerElement)mes).getValue(), 6);
                                                                                        break;
                                                                                    }
                                                                                    case 102: {
                                                                                        rs = pl.getResources();
                                                                                        rs.add(rs.getAmount(1), 6);
                                                                                        rs.setAmount(0, 1);
                                                                                        rs.add(rs.getAmount(2), 6);
                                                                                        rs.setAmount(0, 2);
                                                                                        rs.add(rs.getAmount(3), 6);
                                                                                        rs.setAmount(0, 3);
                                                                                        rs.add(rs.getAmount(4), 6);
                                                                                        rs.setAmount(0, 4);
                                                                                        rs.add(rs.getAmount(5), 6);
                                                                                        rs.setAmount(0, 5);
                                                                                        pl.getResources().subtract(((SOCPlayerElement)mes).getValue(), 6);
                                                                                    }
                                                                                }
                                                                                break;
                                                                            }
                                                                        }
                                                                        if (this.game.getGameState() == 15) {
                                                                            this.negotiator.resetIsSelling();
                                                                        }
                                                                        break block247;
                                                                    }
                                                                    if (mesType != 1063) break block248;
                                                                    pl = this.game.getPlayer(((SOCResourceCount)mes).getPlayerNumber());
                                                                    if (((SOCResourceCount)mes).getCount() != pl.getResources().getTotal()) {
                                                                        rsrcs = pl.getResources();
                                                                        if (pl.getPlayerNumber() != this.ourPlayerData.getPlayerNumber()) {
                                                                            rsrcs.clear();
                                                                            rsrcs.setAmount(((SOCResourceCount)mes).getCount(), 6);
                                                                        }
                                                                    }
                                                                    break block247;
                                                                }
                                                                if (mesType != 1028) break block249;
                                                                this.game.setCurrentDice(((SOCDiceResult)mes).getResult());
                                                                break block247;
                                                            }
                                                            if (mesType != 1009) break block250;
                                                            D.ebugPrintln("*** PUTPIECE for game ***");
                                                            pl = this.game.getPlayer(((SOCPutPiece)mes).getPlayerNumber());
                                                            switch (((SOCPutPiece)mes).getPieceType()) {
                                                                case 0: {
                                                                    rd = new SOCRoad(pl, ((SOCPutPiece)mes).getCoordinates());
                                                                    this.game.putPiece(rd);
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    se = new SOCSettlement(pl, ((SOCPutPiece)mes).getCoordinates());
                                                                    this.game.putPiece(se);
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    ci = new SOCCity(pl, ((SOCPutPiece)mes).getCoordinates());
                                                                    this.game.putPiece(ci);
                                                                    break;
                                                                }
                                                            }
                                                            break block247;
                                                        }
                                                        if (mesType != 1034) break block251;
                                                        this.moveRobberOnSeven = false;
                                                        this.game.getBoard().setRobberHex(((SOCMoveRobber)mes).getCoordinates());
                                                        break block247;
                                                    }
                                                    if (this.robotParameters.getTradeFlag() != 1 || mesType != 1041) break block252;
                                                    offer = ((SOCMakeOffer)mes).getOffer();
                                                    this.game.getPlayer(offer.getFrom()).setCurrentOffer(offer);
                                                    if (offer.getFrom() == this.ourPlayerData.getPlayerNumber()) break block247;
                                                    giveSet = offer.getGiveSet();
                                                    for (rsrcType = 1; rsrcType <= 5; ++rsrcType) {
                                                        if (giveSet.getAmount(rsrcType) <= 0) continue;
                                                        D.ebugPrintln("%%% player " + offer.getFrom() + " wants to sell " + rsrcType);
                                                        this.negotiator.markAsWantsAnotherOffer(offer.getFrom(), rsrcType);
                                                    }
                                                    getSet = offer.getGetSet();
                                                    for (rsrcType = 1; rsrcType <= 5; ++rsrcType) {
                                                        if (getSet.getAmount(rsrcType) <= 0) continue;
                                                        D.ebugPrintln("%%% player " + offer.getFrom() + " wants to buy " + rsrcType + " and therefore does not want to sell it");
                                                        this.negotiator.markAsNotSelling(offer.getFrom(), rsrcType);
                                                    }
                                                    if (this.waitingForTradeResponse) {
                                                        this.offerRejections[offer.getFrom()] = true;
                                                        everyoneRejected = true;
                                                        D.ebugPrintln("ourPlayerData.getCurrentOffer() = " + this.ourPlayerData.getCurrentOffer());
                                                        if (this.ourPlayerData.getCurrentOffer() != null) {
                                                            offeredTo = this.ourPlayerData.getCurrentOffer().getTo();
                                                            for (i = 0; i < 4; ++i) {
                                                                D.ebugPrintln("offerRejections[" + i + "]=" + this.offerRejections[i]);
                                                                if (!offeredTo[i] || this.offerRejections[i]) continue;
                                                                everyoneRejected = false;
                                                            }
                                                        }
                                                        D.ebugPrintln("everyoneRejected=" + everyoneRejected);
                                                        if (everyoneRejected) {
                                                            this.negotiator.addToOffersMade(this.ourPlayerData.getCurrentOffer());
                                                            this.client.clearOffer(this.game);
                                                            this.waitingForTradeResponse = false;
                                                        }
                                                    }
                                                    ourResponseToOffer = this.considerOffer(offer);
                                                    D.ebugPrintln("%%% ourResponseToOffer = " + ourResponseToOffer);
                                                    if (ourResponseToOffer < 0) break block247;
                                                    delayLength = Math.abs(this.rand.nextInt() % 500) + 3500;
                                                    this.pause(delayLength);
                                                    switch (ourResponseToOffer) {
                                                        case 1: {
                                                            this.client.acceptOffer(this.game, offer.getFrom());
                                                            this.buildingPlan.clear();
                                                            this.negotiator.setTargetPiece(this.ourPlayerData.getPlayerNumber(), null);
                                                            ** break;
                                                        }
                                                        case 0: {
                                                            if (!this.waitingForTradeResponse) {
                                                                this.client.rejectOffer(this.game);
                                                                ** break;
                                                            }
                                                            break block247;
                                                        }
                                                        case 2: {
                                                            if (!this.makeCounterOffer(offer)) {
                                                                this.client.rejectOffer(this.game);
                                                                ** break;
                                                            }
                                                            break block247;
                                                        }
                                                        default: {
                                                            ** break;
                                                        }
                                                    }
lbl313:
                                                    // 4 sources

                                                    break block247;
                                                }
                                                if (this.robotParameters.getTradeFlag() != 1 || mesType != 1038) break block253;
                                                this.game.getPlayer(((SOCClearOffer)mes).getPlayerNumber()).setCurrentOffer(null);
                                                break block247;
                                            }
                                            if (this.robotParameters.getTradeFlag() != 1 || mesType != 1039) break block254;
                                            if ((((SOCAcceptOffer)mes).getOfferingNumber() == this.ourPlayerData.getPlayerNumber() || ((SOCAcceptOffer)mes).getAcceptingNumber() == this.ourPlayerData.getPlayerNumber()) && this.waitingForTradeResponse) {
                                                this.waitingForTradeResponse = false;
                                            }
                                            break block247;
                                        }
                                        if (this.robotParameters.getTradeFlag() != 1 || mesType != 1037) break block255;
                                        rejector = ((SOCRejectOffer)mes).getPlayerNumber();
                                        if (this.ourPlayerData.getCurrentOffer() != null && this.waitingForTradeResponse) {
                                            D.ebugPrintln("%%%%%%%%% REJECT OFFER %%%%%%%%%%%%%");
                                            getSet = this.ourPlayerData.getCurrentOffer().getGetSet();
                                            for (rsrcType = 1; rsrcType <= 5; ++rsrcType) {
                                                if (getSet.getAmount(rsrcType) <= 0 || this.negotiator.wantsAnotherOffer(rejector, rsrcType)) continue;
                                                this.negotiator.markAsNotSelling(rejector, rsrcType);
                                            }
                                            this.offerRejections[((SOCRejectOffer)mes).getPlayerNumber()] = true;
                                            everyoneRejected = true;
                                            D.ebugPrintln("ourPlayerData.getCurrentOffer() = " + this.ourPlayerData.getCurrentOffer());
                                            offeredTo = this.ourPlayerData.getCurrentOffer().getTo();
                                            for (i = 0; i < 4; ++i) {
                                                D.ebugPrintln("offerRejections[" + i + "]=" + this.offerRejections[i]);
                                                if (!offeredTo[i] || this.offerRejections[i]) continue;
                                                everyoneRejected = false;
                                            }
                                            D.ebugPrintln("everyoneRejected=" + everyoneRejected);
                                            if (everyoneRejected) {
                                                this.negotiator.addToOffersMade(this.ourPlayerData.getCurrentOffer());
                                                this.client.clearOffer(this.game);
                                                this.waitingForTradeResponse = false;
                                            }
                                            break block247;
                                        } else {
                                            D.ebugPrintln("%%%% ALT REJECT OFFER %%%%");
                                            for (pn = 0; pn < 4; ++pn) {
                                                offer = this.game.getPlayer(pn).getCurrentOffer();
                                                if (offer == null || !(offeredTo = offer.getTo())[rejector]) continue;
                                                getSet = offer.getGetSet();
                                                for (rsrcType = 1; rsrcType <= 5; ++rsrcType) {
                                                    if (getSet.getAmount(rsrcType) <= 0 || this.negotiator.wantsAnotherOffer(rejector, rsrcType)) continue;
                                                    this.negotiator.markAsNotSelling(rejector, rsrcType);
                                                }
                                            }
                                        }
                                        break block247;
                                    }
                                    if (mesType == 1047) {
                                        this.game.setNumDevCards(((SOCDevCardCount)mes).getNumDevCards());
                                    } else if (mesType == 1046) {
                                        player = this.game.getPlayer(((SOCDevCard)mes).getPlayerNumber());
                                        switch (((SOCDevCard)mes).getAction()) {
                                            case 0: {
                                                player.getDevCards().add(1, 1, ((SOCDevCard)mes).getCardType());
                                                break;
                                            }
                                            case 1: {
                                                player.getDevCards().subtract(1, 0, ((SOCDevCard)mes).getCardType());
                                                break;
                                            }
                                            case 3: {
                                                player.getDevCards().add(1, 0, ((SOCDevCard)mes).getCardType());
                                                break;
                                            }
                                            case 2: {
                                                player.getDevCards().add(1, 1, ((SOCDevCard)mes).getCardType());
                                                break;
                                            }
                                        }
                                    } else if (mesType == 1048) {
                                        player = this.game.getPlayer(((SOCSetPlayedDevCard)mes).getPlayerNumber());
                                        player.setPlayedDevCard(((SOCSetPlayedDevCard)mes).hasPlayedDevCard());
                                    } else if (mesType == 1057) {
                                        player = this.game.getPlayer(((SOCPotentialSettlements)mes).getPlayerNumber());
                                        player.setPotentialSettlements(((SOCPotentialSettlements)mes).getPotentialSettlements());
                                    }
                                }
                                this.debugInfo();
                                if (this.game.getGameState() == 15 && !this.waitingForGameState) {
                                    this.expectPLAY = false;
                                    if (!this.waitingForOurTurn && this.ourTurn) {
                                        if (!(this.expectPLAY1 || this.expectDISCARD || this.expectPLACING_ROBBER || this.expectDICERESULT && this.counter < 4000)) {
                                            if (this.ourPlayerData.getDevCards().getAmount(0, 0) > 0 && !this.ourPlayerData.getNumbers().getNumberResourcePairsForHex(this.game.getBoard().getRobberHex()).isEmpty()) {
                                                this.expectPLACING_ROBBER = true;
                                                this.waitingForGameState = true;
                                                this.counter = 0;
                                                this.client.playDevCard(this.game, 0);
                                                this.pause(1500);
                                            } else {
                                                this.expectDICERESULT = true;
                                                this.counter = 0;
                                                this.client.rollDice(this.game);
                                            }
                                        }
                                    } else {
                                        this.expectDICERESULT = true;
                                    }
                                }
                                if (this.game.getGameState() == 33 && !this.waitingForGameState) {
                                    this.expectPLACING_ROBBER = false;
                                    if (!this.waitingForOurTurn && this.ourTurn && (!this.expectPLAY && !this.expectPLAY1 || this.counter >= 4000)) {
                                        if (this.moveRobberOnSeven) {
                                            this.moveRobberOnSeven = false;
                                            this.waitingForGameState = true;
                                            this.counter = 0;
                                            this.expectPLAY1 = true;
                                        } else {
                                            this.waitingForGameState = true;
                                            this.counter = 0;
                                            if (this.oldGameState == 15) {
                                                this.expectPLAY = true;
                                            } else if (this.oldGameState == 20) {
                                                this.expectPLAY1 = true;
                                            }
                                        }
                                        this.counter = 0;
                                        this.moveRobber();
                                    }
                                }
                                if (this.game.getGameState() == 52 && !this.waitingForGameState) {
                                    this.expectWAITING_FOR_DISCOVERY = false;
                                    if (!this.waitingForOurTurn && this.ourTurn && !this.expectPLAY1 && this.counter < 4000) {
                                        this.waitingForGameState = true;
                                        this.expectPLAY1 = true;
                                        this.counter = 0;
                                        this.client.discoveryPick(this.game, this.resourceChoices);
                                        this.pause(1500);
                                    }
                                }
                                if (this.game.getGameState() == 53 && !this.waitingForGameState) {
                                    this.expectWAITING_FOR_MONOPOLY = false;
                                    if (!this.waitingForOurTurn && this.ourTurn && !this.expectPLAY1 && this.counter < 4000) {
                                        this.waitingForGameState = true;
                                        this.expectPLAY1 = true;
                                        this.counter = 0;
                                        this.client.monopolyPick(this.game, this.monopolyChoice);
                                        this.pause(1500);
                                    }
                                }
                                if (this.waitingForTradeMsg && mesType == 1010 && ((SOCGameTextMsg)mes).getNickname().equals("Server") && ((SOCGameTextMsg)mes).getText().startsWith(this.client.getNickname() + " traded")) {
                                    this.waitingForTradeMsg = false;
                                }
                                if (this.waitingForDevCard && mesType == 1010 && ((SOCGameTextMsg)mes).getNickname().equals("Server") && ((SOCGameTextMsg)mes).getText().equals(this.client.getNickname() + " bought a development card.")) {
                                    this.waitingForDevCard = false;
                                }
                                if (!(this.game.getGameState() != 20 || this.waitingForGameState || this.waitingForTradeMsg || this.waitingForTradeResponse || this.waitingForDevCard || this.expectPLACING_ROAD || this.expectPLACING_SETTLEMENT || this.expectPLACING_CITY || this.expectPLACING_ROBBER || this.expectPLACING_FREE_ROAD1 || this.expectPLACING_FREE_ROAD2 || this.expectWAITING_FOR_DISCOVERY || this.expectWAITING_FOR_MONOPOLY)) {
                                    this.expectPLAY1 = false;
                                    if (!(this.waitingForOurTurn || !this.ourTurn || this.expectPLAY && this.counter < 4000)) {
                                        this.counter = 0;
                                        if (!this.ourPlayerData.hasPlayedDevCard() && ((laPlayer = this.game.getPlayerWithLargestArmy()) != null && laPlayer.getPlayerNumber() != this.ourPlayerData.getPlayerNumber() || laPlayer == null)) {
                                            larmySize = laPlayer == null ? 3 : laPlayer.getNumKnights() + 1;
                                            if (this.ourPlayerData.getNumKnights() + this.ourPlayerData.getDevCards().getAmount(1, 0) + this.ourPlayerData.getDevCards().getAmount(0, 0) >= larmySize && this.ourPlayerData.getDevCards().getAmount(0, 0) > 0) {
                                                this.expectPLACING_ROBBER = true;
                                                this.waitingForGameState = true;
                                                this.counter = 0;
                                                this.client.playDevCard(this.game, 0);
                                                this.pause(1500);
                                            }
                                        }
                                        if (!this.expectPLACING_ROBBER && this.buildingPlan.empty() && this.ourPlayerData.getResources().getTotal() > 1) {
                                            this.decisionMaker.planStuff(this.robotParameters.getStrategyType());
                                            if (!this.buildingPlan.empty()) {
                                                this.lastTarget = (SOCPossiblePiece)this.buildingPlan.peek();
                                                this.negotiator.setTargetPiece(this.ourPlayerData.getPlayerNumber(), (SOCPossiblePiece)this.buildingPlan.peek());
                                            }
                                        }
                                        if (!this.expectPLACING_ROBBER && !this.buildingPlan.empty()) {
                                            roadBuildingPlan = false;
                                            if (!this.ourPlayerData.hasPlayedDevCard() && this.ourPlayerData.getNumPieces(0) >= 2 && this.ourPlayerData.getDevCards().getAmount(0, 1) > 0) {
                                                topPiece = (SOCPossiblePiece)this.buildingPlan.pop();
                                                if (topPiece != null && topPiece.getType() == 0 && !this.buildingPlan.empty()) {
                                                    secondPiece = (SOCPossiblePiece)this.buildingPlan.peek();
                                                    if (secondPiece != null && secondPiece.getType() == 0) {
                                                        roadBuildingPlan = true;
                                                        this.whatWeWantToBuild = new SOCRoad(this.ourPlayerData, topPiece.getCoordinates());
                                                        this.waitingForGameState = true;
                                                        this.counter = 0;
                                                        this.expectPLACING_FREE_ROAD1 = true;
                                                        this.client.playDevCard(this.game, 1);
                                                    } else {
                                                        this.buildingPlan.push(topPiece);
                                                    }
                                                } else {
                                                    this.buildingPlan.push(topPiece);
                                                }
                                            }
                                            if (!roadBuildingPlan) {
                                                targetResources = null;
                                                targetPiece = (SOCPossiblePiece)this.buildingPlan.peek();
                                                switch (targetPiece.getType()) {
                                                    case 4: {
                                                        targetResources = SOCGame.CARD_SET;
                                                        break;
                                                    }
                                                    case 0: {
                                                        targetResources = SOCGame.ROAD_SET;
                                                        break;
                                                    }
                                                    case 1: {
                                                        targetResources = SOCGame.SETTLEMENT_SET;
                                                        break;
                                                    }
                                                    case 2: {
                                                        targetResources = SOCGame.CITY_SET;
                                                        break;
                                                    }
                                                }
                                                this.negotiator.setTargetPiece(this.ourPlayerData.getPlayerNumber(), targetPiece);
                                                if (!this.ourPlayerData.hasPlayedDevCard() && this.ourPlayerData.getDevCards().getAmount(0, 2) > 0) {
                                                    ourResources = this.ourPlayerData.getResources();
                                                    numNeededResources = 0;
                                                    for (resource = 1; resource <= 5; ++resource) {
                                                        diff = targetResources.getAmount(resource) - ourResources.getAmount(resource);
                                                        if (diff <= 0) continue;
                                                        numNeededResources += diff;
                                                    }
                                                    if (numNeededResources == 2) {
                                                        this.chooseFreeResources(targetResources);
                                                        this.expectWAITING_FOR_DISCOVERY = true;
                                                        this.waitingForGameState = true;
                                                        this.counter = 0;
                                                        this.client.playDevCard(this.game, 2);
                                                        this.pause(1500);
                                                    }
                                                }
                                                if (!this.expectWAITING_FOR_DISCOVERY) {
                                                    if (!this.ourPlayerData.hasPlayedDevCard() && this.ourPlayerData.getDevCards().getAmount(0, 3) > 0 && this.chooseMonopoly()) {
                                                        this.expectWAITING_FOR_MONOPOLY = true;
                                                        this.waitingForGameState = true;
                                                        this.counter = 0;
                                                        this.client.playDevCard(this.game, 3);
                                                        this.pause(1500);
                                                    }
                                                    if (!this.expectWAITING_FOR_MONOPOLY) {
                                                        if (!this.doneTrading && !this.ourPlayerData.getResources().contains(targetResources)) {
                                                            this.waitingForTradeResponse = false;
                                                            if (this.robotParameters.getTradeFlag() == 1) {
                                                                this.makeOffer(targetPiece);
                                                            }
                                                        }
                                                        if (!this.waitingForTradeResponse && this.tradeToTarget2(targetResources)) {
                                                            this.counter = 0;
                                                            this.waitingForTradeMsg = true;
                                                            this.pause(1500);
                                                        }
                                                        if (!this.waitingForTradeMsg && !this.waitingForTradeResponse && this.ourPlayerData.getResources().contains(targetResources)) {
                                                            this.buildingPlan.pop();
                                                            D.ebugPrintln("$ POPPED " + targetPiece);
                                                            this.lastMove = targetPiece;
                                                            this.currentDRecorder = (this.currentDRecorder + 1) % 2;
                                                            this.negotiator.setTargetPiece(this.ourPlayerData.getPlayerNumber(), targetPiece);
                                                            switch (targetPiece.getType()) {
                                                                case 4: {
                                                                    this.client.buyDevCard(this.game);
                                                                    this.waitingForDevCard = true;
                                                                    break;
                                                                }
                                                                case 0: {
                                                                    this.waitingForGameState = true;
                                                                    this.counter = 0;
                                                                    this.expectPLACING_ROAD = true;
                                                                    this.whatWeWantToBuild = new SOCRoad(this.ourPlayerData, targetPiece.getCoordinates());
                                                                    D.ebugPrintln("!!! BUILD REQUEST FOR A ROAD AT " + Integer.toHexString(targetPiece.getCoordinates()) + " !!!");
                                                                    this.client.buildRequest(this.game, 0);
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    this.waitingForGameState = true;
                                                                    this.counter = 0;
                                                                    this.expectPLACING_SETTLEMENT = true;
                                                                    this.whatWeWantToBuild = new SOCSettlement(this.ourPlayerData, targetPiece.getCoordinates());
                                                                    D.ebugPrintln("!!! BUILD REQUEST FOR A SETTLEMENT " + Integer.toHexString(targetPiece.getCoordinates()) + " !!!");
                                                                    this.client.buildRequest(this.game, 1);
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    this.waitingForGameState = true;
                                                                    this.counter = 0;
                                                                    this.expectPLACING_CITY = true;
                                                                    this.whatWeWantToBuild = new SOCCity(this.ourPlayerData, targetPiece.getCoordinates());
                                                                    D.ebugPrintln("!!! BUILD REQUEST FOR A CITY " + Integer.toHexString(targetPiece.getCoordinates()) + " !!!");
                                                                    this.client.buildRequest(this.game, 2);
                                                                    break;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        if (!(this.expectPLACING_SETTLEMENT || this.expectPLACING_FREE_ROAD1 || this.expectPLACING_FREE_ROAD2 || this.expectPLACING_ROAD || this.expectPLACING_CITY || this.expectWAITING_FOR_DISCOVERY || this.expectWAITING_FOR_MONOPOLY || this.expectPLACING_ROBBER || this.waitingForTradeMsg || this.waitingForTradeResponse || this.waitingForDevCard)) {
                                            this.waitingForGameState = true;
                                            this.counter = 0;
                                            this.expectPLAY = true;
                                            this.waitingForOurTurn = true;
                                            this.doneTrading = this.robotParameters.getTradeFlag() != 1;
                                            this.negotiator.resetIsSelling();
                                            this.negotiator.resetOffersMade();
                                            this.buildingPlan.clear();
                                            this.negotiator.resetTargetPieces();
                                            this.pause(1500);
                                            this.client.endTurn(this.game);
                                        }
                                    }
                                }
                                if (this.game.getGameState() == 31 && !this.waitingForGameState && this.ourTurn && !this.waitingForOurTurn && this.expectPLACING_SETTLEMENT) {
                                    this.expectPLACING_SETTLEMENT = false;
                                    this.waitingForGameState = true;
                                    this.counter = 0;
                                    this.expectPLAY1 = true;
                                    this.pause(500);
                                    this.client.putPiece(this.game, this.whatWeWantToBuild);
                                    this.pause(1000);
                                }
                                if (this.game.getGameState() == 30 && !this.waitingForGameState && this.ourTurn && !this.waitingForOurTurn && this.expectPLACING_ROAD) {
                                    this.expectPLACING_ROAD = false;
                                    this.waitingForGameState = true;
                                    this.counter = 0;
                                    this.expectPLAY1 = true;
                                    this.pause(500);
                                    this.client.putPiece(this.game, this.whatWeWantToBuild);
                                    this.pause(1000);
                                }
                                if (this.game.getGameState() == 32 && !this.waitingForGameState && this.ourTurn && !this.waitingForOurTurn && this.expectPLACING_CITY) {
                                    this.expectPLACING_CITY = false;
                                    this.waitingForGameState = true;
                                    this.counter = 0;
                                    this.expectPLAY1 = true;
                                    this.pause(500);
                                    this.client.putPiece(this.game, this.whatWeWantToBuild);
                                    this.pause(1000);
                                }
                                if (this.game.getGameState() == 40 && !this.waitingForGameState && this.ourTurn && !this.waitingForOurTurn && this.expectPLACING_FREE_ROAD1) {
                                    this.expectPLACING_FREE_ROAD1 = false;
                                    this.waitingForGameState = true;
                                    this.counter = 0;
                                    this.expectPLACING_FREE_ROAD2 = true;
                                    D.ebugPrintln("!!! PUTTING PIECE 1 " + this.whatWeWantToBuild + " !!!");
                                    this.pause(500);
                                    this.client.putPiece(this.game, this.whatWeWantToBuild);
                                    this.pause(1000);
                                }
                                if (this.game.getGameState() == 41 && !this.waitingForGameState && this.ourTurn && !this.waitingForOurTurn && this.expectPLACING_FREE_ROAD2) {
                                    this.expectPLACING_FREE_ROAD2 = false;
                                    this.waitingForGameState = true;
                                    this.counter = 0;
                                    this.expectPLAY1 = true;
                                    posPiece = (SOCPossiblePiece)this.buildingPlan.pop();
                                    if (posPiece.getType() == 0) {
                                        D.ebugPrintln("posPiece = " + posPiece);
                                        this.whatWeWantToBuild = new SOCRoad(this.ourPlayerData, posPiece.getCoordinates());
                                        D.ebugPrintln("$ POPPED OFF");
                                        D.ebugPrintln("!!! PUTTING PIECE 2 " + this.whatWeWantToBuild + " !!!");
                                        this.pause(500);
                                        this.client.putPiece(this.game, this.whatWeWantToBuild);
                                        this.pause(1000);
                                    }
                                }
                                if (this.game.getGameState() == 5 && !this.waitingForGameState) {
                                    this.expectSTART1A = false;
                                    if (!(this.waitingForOurTurn || !this.ourTurn || this.expectPUTPIECE_FROM_START1A && this.counter < 4000)) {
                                        this.expectPUTPIECE_FROM_START1A = true;
                                        this.counter = 0;
                                        this.waitingForGameState = true;
                                        this.planInitialSettlements();
                                        this.placeFirstSettlement();
                                    }
                                }
                                if (this.game.getGameState() == 6 && !this.waitingForGameState) {
                                    this.expectSTART1B = false;
                                    if (!(this.waitingForOurTurn || !this.ourTurn || this.expectPUTPIECE_FROM_START1B && this.counter < 4000)) {
                                        this.expectPUTPIECE_FROM_START1B = true;
                                        this.counter = 0;
                                        this.waitingForGameState = true;
                                        this.pause(1500);
                                        this.placeInitRoad();
                                    }
                                }
                                if (this.game.getGameState() == 10 && !this.waitingForGameState) {
                                    this.expectSTART2A = false;
                                    if (!(this.waitingForOurTurn || !this.ourTurn || this.expectPUTPIECE_FROM_START2A && this.counter < 4000)) {
                                        this.expectPUTPIECE_FROM_START2A = true;
                                        this.counter = 0;
                                        this.waitingForGameState = true;
                                        this.planSecondSettlement();
                                        this.placeSecondSettlement();
                                    }
                                }
                                if (this.game.getGameState() == 11 && !this.waitingForGameState) {
                                    this.expectSTART2B = false;
                                    if (!(this.waitingForOurTurn || !this.ourTurn || this.expectPUTPIECE_FROM_START2B && this.counter < 4000)) {
                                        this.expectPUTPIECE_FROM_START2B = true;
                                        this.counter = 0;
                                        this.waitingForGameState = true;
                                        this.pause(1500);
                                        this.placeInitRoad();
                                    }
                                }
                                if (mesType == 1055) {
                                    this.game.setCurrentPlayerNumber(((SOCSetTurn)mes).getPlayerNumber());
                                }
                                if (mesType == 1009) {
                                    D.ebugPrintln("*** PUTPIECE for playerTrackers ***");
                                    block94 : switch (((SOCPutPiece)mes).getPieceType()) {
                                        case 0: {
                                            newRoad = new SOCRoad(this.game.getPlayer(((SOCPutPiece)mes).getPlayerNumber()), ((SOCPutPiece)mes).getCoordinates());
                                            for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                                tracker.takeMonitor();
                                                try {
                                                    tracker.addNewRoad(newRoad, this.playerTrackers);
                                                }
                                                catch (Exception e) {
                                                    tracker.releaseMonitor();
                                                    System.out.println("Exception caught - " + e);
                                                    e.printStackTrace();
                                                }
                                                tracker.releaseMonitor();
                                            }
                                            for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                                tracker.takeMonitor();
                                                try {
                                                    posRoadsIter = tracker.getPossibleRoads().values().iterator();
                                                    while (posRoadsIter.hasNext()) {
                                                        ((SOCPossibleRoad)posRoadsIter.next()).clearThreats();
                                                    }
                                                    posSetsIter = tracker.getPossibleSettlements().values().iterator();
                                                    while (posSetsIter.hasNext()) {
                                                        ((SOCPossibleSettlement)posSetsIter.next()).clearThreats();
                                                    }
                                                }
                                                catch (Exception e) {
                                                    tracker.releaseMonitor();
                                                    System.out.println("Exception caught - " + e);
                                                    e.printStackTrace();
                                                }
                                                tracker.releaseMonitor();
                                            }
                                            for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                                tracker.updateThreats(this.playerTrackers);
                                                tracker.takeMonitor();
                                                try {
                                                    if (tracker.getPlayer().getPlayerNumber() != ((SOCPutPiece)mes).getPlayerNumber()) {
                                                        // empty if block
                                                    }
                                                }
                                                catch (Exception e) {
                                                    tracker.releaseMonitor();
                                                    System.out.println("Exception caught - " + e);
                                                    e.printStackTrace();
                                                }
                                                tracker.releaseMonitor();
                                            }
                                            break;
                                        }
                                        case 1: {
                                            newSettlement = new SOCSettlement(this.game.getPlayer(((SOCPutPiece)mes).getPlayerNumber()), ((SOCPutPiece)mes).getCoordinates());
                                            for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                                tracker.addNewSettlement(newSettlement, this.playerTrackers);
                                            }
                                            for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                                posRoadsIter = tracker.getPossibleRoads().values().iterator();
                                                while (posRoadsIter.hasNext()) {
                                                    ((SOCPossibleRoad)posRoadsIter.next()).clearThreats();
                                                }
                                                posSetsIter = tracker.getPossibleSettlements().values().iterator();
                                                while (posSetsIter.hasNext()) {
                                                    ((SOCPossibleSettlement)posSetsIter.next()).clearThreats();
                                                }
                                            }
                                            for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                                tracker.updateThreats(this.playerTrackers);
                                            }
                                            roadCount = new int[]{0, 0, 0, 0};
                                            adjEdgeEnum = SOCBoard.getAdjacentEdgesToNode(((SOCPutPiece)mes).getCoordinates()).elements();
                                            block124: while (adjEdgeEnum.hasMoreElements()) {
                                                adjEdge = (Integer)adjEdgeEnum.nextElement();
                                                roadEnum = this.game.getBoard().getRoads().elements();
                                                while (roadEnum.hasMoreElements()) {
                                                    road = (SOCRoad)roadEnum.nextElement();
                                                    if (road.getCoordinates() != adjEdge.intValue()) continue;
                                                    v0 = road.getPlayer().getPlayerNumber();
                                                    roadCount[v0] = roadCount[v0] + 1;
                                                    if (roadCount[road.getPlayer().getPlayerNumber()] != 2) continue;
                                                    if (road.getPlayer().getPlayerNumber() == this.ourPlayerData.getPlayerNumber()) continue block124;
                                                    for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                                        if (tracker.getPlayer().getPlayerNumber() == road.getPlayer().getPlayerNumber()) continue;
                                                    }
                                                    continue block124;
                                                }
                                            }
                                            for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                                if (tracker.getPlayer().getPlayerNumber() != ((SOCPutPiece)mes).getPlayerNumber()) continue;
                                                posSetsIter = tracker.getPossibleSettlements().values().iterator();
                                                while (posSetsIter.hasNext()) {
                                                    ((SOCPossibleSettlement)posSetsIter.next()).updateSpeedup();
                                                }
                                                break block127;
                                            }
                                            for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                                if (tracker.getPlayer().getPlayerNumber() != ((SOCPutPiece)mes).getPlayerNumber()) continue;
                                                posCitiesIter = tracker.getPossibleCities().values().iterator();
                                                while (posCitiesIter.hasNext()) {
                                                    ((SOCPossibleCity)posCitiesIter.next()).updateSpeedup();
                                                }
                                                break block94;
                                            }
                                            break;
                                        }
                                        case 2: {
                                            newCity = new SOCCity(this.game.getPlayer(((SOCPutPiece)mes).getPlayerNumber()), ((SOCPutPiece)mes).getCoordinates());
                                            for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                                if (tracker.getPlayer().getPlayerNumber() != ((SOCPutPiece)mes).getPlayerNumber()) continue;
                                                tracker.addOurNewCity(newCity);
                                                break;
                                            }
                                            for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                                if (tracker.getPlayer().getPlayerNumber() != ((SOCPutPiece)mes).getPlayerNumber()) continue;
                                                posSetsIter = tracker.getPossibleSettlements().values().iterator();
                                                while (posSetsIter.hasNext()) {
                                                    ((SOCPossibleSettlement)posSetsIter.next()).updateSpeedup();
                                                }
                                                break block132;
                                            }
                                            for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                                if (tracker.getPlayer().getPlayerNumber() != ((SOCPutPiece)mes).getPlayerNumber()) continue;
                                                posCitiesIter = tracker.getPossibleCities().values().iterator();
                                                while (posCitiesIter.hasNext()) {
                                                    ((SOCPossibleCity)posCitiesIter.next()).updateSpeedup();
                                                }
                                                break block94;
                                            }
                                            break;
                                        }
                                    }
                                }
                                if (this.expectPUTPIECE_FROM_START1A && mesType == 1009 && ((SOCPutPiece)mes).getPlayerNumber() == this.ourPlayerData.getPlayerNumber() && ((SOCPutPiece)mes).getPieceType() == 1 && ((SOCPutPiece)mes).getCoordinates() == this.ourPlayerData.getLastSettlementCoord()) {
                                    this.expectPUTPIECE_FROM_START1A = false;
                                    this.expectSTART1B = true;
                                }
                                if (this.expectPUTPIECE_FROM_START1B && mesType == 1009 && ((SOCPutPiece)mes).getPlayerNumber() == this.ourPlayerData.getPlayerNumber() && ((SOCPutPiece)mes).getPieceType() == 0 && ((SOCPutPiece)mes).getCoordinates() == this.ourPlayerData.getLastRoadCoord()) {
                                    this.expectPUTPIECE_FROM_START1B = false;
                                    this.expectSTART2A = true;
                                }
                                if (this.expectPUTPIECE_FROM_START2A && mesType == 1009 && ((SOCPutPiece)mes).getPlayerNumber() == this.ourPlayerData.getPlayerNumber() && ((SOCPutPiece)mes).getPieceType() == 1 && ((SOCPutPiece)mes).getCoordinates() == this.ourPlayerData.getLastSettlementCoord()) {
                                    this.expectPUTPIECE_FROM_START2A = false;
                                    this.expectSTART2B = true;
                                }
                                if (this.expectPUTPIECE_FROM_START2B && mesType == 1009 && ((SOCPutPiece)mes).getPlayerNumber() == this.ourPlayerData.getPlayerNumber() && ((SOCPutPiece)mes).getPieceType() == 0 && ((SOCPutPiece)mes).getCoordinates() == this.ourPlayerData.getLastRoadCoord()) {
                                    this.expectPUTPIECE_FROM_START2B = false;
                                    this.expectPLAY = true;
                                }
                                if (!this.expectDICERESULT || mesType != 1028) break block256;
                                this.expectDICERESULT = false;
                                if (((SOCDiceResult)mes).getResult() != 7) break block257;
                                this.moveRobberOnSeven = true;
                                if (this.ourPlayerData.getResources().getTotal() > 7) {
                                    this.expectDISCARD = true;
                                    break block256;
                                } else if (this.ourTurn) {
                                    this.expectPLACING_ROBBER = true;
                                }
                                break block256;
                            }
                            this.expectPLAY1 = true;
                        }
                        if (mesType == 1029) {
                            this.expectDISCARD = false;
                            if (this.game.getCurrentDice() == 7 && this.ourTurn) {
                                this.expectPLACING_ROBBER = true;
                            } else {
                                this.expectPLAY1 = true;
                            }
                            this.counter = 0;
                            this.discard(((SOCDiscardRequest)mes).getNumberOfDiscards());
                        }
                        if (mesType == 1036) {
                            this.chooseRobberVictim(((SOCChoosePlayerRequest)mes).getChoices());
                        }
                        if (mesType == 1056 && !this.expectDISCARD && !this.expectPLACING_ROBBER) {
                            this.client.leaveGame(this.game);
                            this.alive = false;
                        }
                        if (mesType == 1010 && ((SOCGameTextMsg)mes).getText().equals("*PING*")) {
                            ++this.counter;
                        }
                        if (this.counter > 150000) {
                            this.client.leaveGame(this.game);
                            this.alive = false;
                        }
                        SOCRobotBrain.yield();
                    }
                }
                catch (Exception e) {
                    D.ebugPrintln("*** Caught an exception - " + e);
                    System.out.println("*** Caught an exception - " + e);
                    e.printStackTrace();
                }
                break block258;
            }
            System.out.println("AGG! NO PINGER!");
        }
        this.gameEventQ = null;
        this.client.addCleanKill();
        this.client = null;
        this.game = null;
        this.ourPlayerData = null;
        this.whatWeWantToBuild = null;
        this.resourceChoices = null;
        this.ourPlayerTracker = null;
        this.playerTrackers = null;
        this.pinger.stopPinger();
        this.pinger = null;
    }

    public void kill() {
        this.alive = false;
        try {
            this.gameEventQ.put(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pause(int msec) {
        try {
            SOCRobotBrain.yield();
            SOCRobotBrain.sleep(msec);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void planInitialSettlements() {
        Enumeration hexes;
        D.ebugPrintln("--- planInitialSettlements");
        this.firstSettlement = 0;
        this.secondSettlement = 0;
        int bestSpeed = 160;
        SOCBoard board = this.game.getBoard();
        SOCResourceSet emptySet = new SOCResourceSet();
        SOCPlayerNumbers playerNumbers = new SOCPlayerNumbers();
        boolean[] ports = new boolean[6];
        SOCBuildingSpeedEstimate estimate = new SOCBuildingSpeedEstimate();
        int[] prob = SOCNumberProbabilities.INT_VALUES;
        int bestProbTotal = 0;
        for (int firstNode = 35; firstNode < 220; ++firstNode) {
            if (!this.ourPlayerData.isPotentialSettlement(firstNode)) continue;
            Integer firstNodeInt = new Integer(firstNode);
            D.ebugPrintln("FIRST NODE -----------");
            D.ebugPrintln("firstNode = " + board.nodeCoordToString(firstNode));
            D.ebugPrint("numbers:[");
            playerNumbers.clear();
            int probTotal = 0;
            hexes = SOCBoard.getAdjacentHexesToNode(firstNode).elements();
            while (hexes.hasMoreElements()) {
                Integer hex = (Integer)hexes.nextElement();
                int number = board.getNumberOnHexFromCoord(hex);
                int resource = board.getHexTypeFromCoord(hex);
                playerNumbers.addNumberForResource(number, resource, hex);
                probTotal += prob[number];
                D.ebugPrint(number + " ");
            }
            D.ebugPrintln("]");
            D.ebugPrint("ports: ");
            for (int portType = 0; portType <= 5; ++portType) {
                ports[portType] = board.getPortCoordinates(portType).contains(firstNodeInt);
                D.ebugPrint(ports[portType] + "  ");
            }
            D.ebugPrintln();
            D.ebugPrintln("probTotal = " + probTotal);
            estimate.recalculateEstimates(playerNumbers);
            int speed = 0;
            boolean allTheWay = false;
            try {
                speed += estimate.calculateRollsFast(emptySet, SOCGame.SETTLEMENT_SET, 300, ports).getRolls();
                speed += estimate.calculateRollsFast(emptySet, SOCGame.CITY_SET, 300, ports).getRolls();
                speed += estimate.calculateRollsFast(emptySet, SOCGame.CARD_SET, 300, ports).getRolls();
                speed += estimate.calculateRollsFast(emptySet, SOCGame.ROAD_SET, 300, ports).getRolls();
            }
            catch (CutoffExceededException e) {
                // empty catch block
            }
            int[] rolls = estimate.getEstimatesFromNothingFast(ports, 300);
            D.ebugPrint(" road: " + rolls[0]);
            D.ebugPrint(" stlmt: " + rolls[1]);
            D.ebugPrint(" city: " + rolls[2]);
            D.ebugPrintln(" card: " + rolls[3]);
            D.ebugPrintln("speed = " + speed);
            for (int secondNode = firstNode + 1; secondNode < 220; ++secondNode) {
                int resource;
                int number;
                if (!this.ourPlayerData.isPotentialSettlement(secondNode) || SOCBoard.getAdjacentNodesToNode(secondNode).contains(firstNodeInt)) continue;
                D.ebugPrintln("firstNode = " + board.nodeCoordToString(firstNode));
                D.ebugPrintln("secondNode = " + board.nodeCoordToString(secondNode));
                Integer secondNodeInt = new Integer(secondNode);
                D.ebugPrint("numbers:[");
                playerNumbers.clear();
                probTotal = 0;
                hexes = SOCBoard.getAdjacentHexesToNode(firstNode).elements();
                while (hexes.hasMoreElements()) {
                    Integer hex = (Integer)hexes.nextElement();
                    number = board.getNumberOnHexFromCoord(hex);
                    resource = board.getHexTypeFromCoord(hex);
                    playerNumbers.addNumberForResource(number, resource, hex);
                    probTotal += prob[number];
                    D.ebugPrint(number + " ");
                }
                D.ebugPrint("] [");
                hexes = SOCBoard.getAdjacentHexesToNode(secondNode).elements();
                while (hexes.hasMoreElements()) {
                    Integer hex = (Integer)hexes.nextElement();
                    number = board.getNumberOnHexFromCoord(hex);
                    resource = board.getHexTypeFromCoord(hex);
                    playerNumbers.addNumberForResource(number, resource, hex);
                    probTotal += prob[number];
                    D.ebugPrint(number + " ");
                }
                D.ebugPrintln("]");
                D.ebugPrint("ports: ");
                for (int portType = 0; portType <= 5; ++portType) {
                    ports[portType] = board.getPortCoordinates(portType).contains(firstNodeInt) || board.getPortCoordinates(portType).contains(secondNodeInt);
                    D.ebugPrint(ports[portType] + "  ");
                }
                D.ebugPrintln();
                D.ebugPrintln("probTotal = " + probTotal);
                estimate.recalculateEstimates(playerNumbers);
                speed = 0;
                allTheWay = false;
                try {
                    if ((speed += estimate.calculateRollsFast(emptySet, SOCGame.SETTLEMENT_SET, bestSpeed, ports).getRolls()) < bestSpeed && (speed += estimate.calculateRollsFast(emptySet, SOCGame.CITY_SET, bestSpeed, ports).getRolls()) < bestSpeed && (speed += estimate.calculateRollsFast(emptySet, SOCGame.CARD_SET, bestSpeed, ports).getRolls()) < bestSpeed) {
                        speed += estimate.calculateRollsFast(emptySet, SOCGame.ROAD_SET, bestSpeed, ports).getRolls();
                        allTheWay = true;
                    }
                }
                catch (CutoffExceededException e) {
                    speed = bestSpeed;
                }
                rolls = estimate.getEstimatesFromNothingFast(ports, bestSpeed);
                D.ebugPrint(" road: " + rolls[0]);
                D.ebugPrint(" stlmt: " + rolls[1]);
                D.ebugPrint(" city: " + rolls[2]);
                D.ebugPrintln(" card: " + rolls[3]);
                D.ebugPrintln("allTheWay = " + allTheWay);
                D.ebugPrintln("speed = " + speed);
                if (speed < bestSpeed) {
                    this.firstSettlement = firstNode;
                    this.secondSettlement = secondNode;
                    bestSpeed = speed;
                    bestProbTotal = probTotal;
                    D.ebugPrintln("bestSpeed = " + bestSpeed);
                    D.ebugPrintln("bestProbTotal = " + bestProbTotal);
                    continue;
                }
                if (speed != bestSpeed || !allTheWay || probTotal <= bestProbTotal) continue;
                D.ebugPrintln("Equal speed, better prob");
                this.firstSettlement = firstNode;
                this.secondSettlement = secondNode;
                bestSpeed = speed;
                bestProbTotal = probTotal;
                D.ebugPrintln("firstSettlement = " + Integer.toHexString(this.firstSettlement));
                D.ebugPrintln("secondSettlement = " + Integer.toHexString(this.secondSettlement));
                D.ebugPrintln("bestSpeed = " + bestSpeed);
                D.ebugPrintln("bestProbTotal = " + bestProbTotal);
            }
        }
        playerNumbers.clear();
        hexes = SOCBoard.getAdjacentHexesToNode(this.firstSettlement).elements();
        while (hexes.hasMoreElements()) {
            Integer hex = (Integer)hexes.nextElement();
            int number = board.getNumberOnHexFromCoord(hex);
            int resource = board.getHexTypeFromCoord(hex);
            playerNumbers.addNumberForResource(number, resource, hex);
        }
        Integer firstSettlementInt = new Integer(this.firstSettlement);
        for (int portType = 0; portType <= 5; ++portType) {
            ports[portType] = board.getPortCoordinates(portType).contains(firstSettlementInt);
        }
        estimate.recalculateEstimates(playerNumbers);
        int firstSpeed = 0;
        int cutoff = 100;
        try {
            firstSpeed += estimate.calculateRollsFast(emptySet, SOCGame.SETTLEMENT_SET, cutoff, ports).getRolls();
        }
        catch (CutoffExceededException e) {
            firstSpeed += cutoff;
        }
        try {
            firstSpeed += estimate.calculateRollsFast(emptySet, SOCGame.CITY_SET, cutoff, ports).getRolls();
        }
        catch (CutoffExceededException e) {
            firstSpeed += cutoff;
        }
        try {
            firstSpeed += estimate.calculateRollsFast(emptySet, SOCGame.CARD_SET, cutoff, ports).getRolls();
        }
        catch (CutoffExceededException e) {
            firstSpeed += cutoff;
        }
        try {
            firstSpeed += estimate.calculateRollsFast(emptySet, SOCGame.ROAD_SET, cutoff, ports).getRolls();
        }
        catch (CutoffExceededException e) {
            firstSpeed += cutoff;
        }
        playerNumbers.clear();
        hexes = SOCBoard.getAdjacentHexesToNode(this.secondSettlement).elements();
        while (hexes.hasMoreElements()) {
            Integer hex = (Integer)hexes.nextElement();
            int number = board.getNumberOnHexFromCoord(hex);
            int resource = board.getHexTypeFromCoord(hex);
            playerNumbers.addNumberForResource(number, resource, hex);
        }
        Integer secondSettlementInt = new Integer(this.secondSettlement);
        for (int portType = 0; portType <= 5; ++portType) {
            ports[portType] = board.getPortCoordinates(portType).contains(secondSettlementInt);
        }
        estimate.recalculateEstimates(playerNumbers);
        int secondSpeed = 0;
        try {
            secondSpeed += estimate.calculateRollsFast(emptySet, SOCGame.SETTLEMENT_SET, bestSpeed, ports).getRolls();
        }
        catch (CutoffExceededException e) {
            secondSpeed += cutoff;
        }
        try {
            secondSpeed += estimate.calculateRollsFast(emptySet, SOCGame.CITY_SET, bestSpeed, ports).getRolls();
        }
        catch (CutoffExceededException e) {
            secondSpeed += cutoff;
        }
        try {
            secondSpeed += estimate.calculateRollsFast(emptySet, SOCGame.CARD_SET, bestSpeed, ports).getRolls();
        }
        catch (CutoffExceededException e) {
            secondSpeed += cutoff;
        }
        try {
            secondSpeed += estimate.calculateRollsFast(emptySet, SOCGame.ROAD_SET, bestSpeed, ports).getRolls();
        }
        catch (CutoffExceededException e) {
            secondSpeed += cutoff;
        }
        if (firstSpeed > secondSpeed) {
            int tmp = this.firstSettlement;
            this.firstSettlement = this.secondSettlement;
            this.secondSettlement = tmp;
        }
        D.ebugPrintln(board.nodeCoordToString(this.firstSettlement) + ":" + firstSpeed + ", " + board.nodeCoordToString(this.secondSettlement) + ":" + secondSpeed);
    }

    protected void planSecondSettlement() {
        D.ebugPrintln("--- planSecondSettlement");
        int bestSpeed = 160;
        SOCBoard board = this.game.getBoard();
        SOCResourceSet emptySet = new SOCResourceSet();
        SOCPlayerNumbers playerNumbers = new SOCPlayerNumbers();
        boolean[] ports = new boolean[6];
        SOCBuildingSpeedEstimate estimate = new SOCBuildingSpeedEstimate();
        int[] prob = SOCNumberProbabilities.INT_VALUES;
        int firstNode = this.firstSettlement;
        Integer firstNodeInt = new Integer(firstNode);
        int bestProbTotal = 0;
        this.secondSettlement = -1;
        for (int secondNode = 35; secondNode < 220; ++secondNode) {
            int resource;
            int number;
            Integer hex;
            if (!this.ourPlayerData.isPotentialSettlement(secondNode) || SOCBoard.getAdjacentNodesToNode(secondNode).contains(firstNodeInt)) continue;
            Integer secondNodeInt = new Integer(secondNode);
            D.ebugPrint("numbers: ");
            playerNumbers.clear();
            int probTotal = 0;
            Enumeration hexes = SOCBoard.getAdjacentHexesToNode(firstNode).elements();
            while (hexes.hasMoreElements()) {
                hex = (Integer)hexes.nextElement();
                number = board.getNumberOnHexFromCoord(hex);
                resource = board.getHexTypeFromCoord(hex);
                playerNumbers.addNumberForResource(number, resource, hex);
                probTotal += prob[number];
                D.ebugPrint(number + " ");
            }
            hexes = SOCBoard.getAdjacentHexesToNode(secondNode).elements();
            while (hexes.hasMoreElements()) {
                hex = (Integer)hexes.nextElement();
                number = board.getNumberOnHexFromCoord(hex);
                resource = board.getHexTypeFromCoord(hex);
                playerNumbers.addNumberForResource(number, resource, hex);
                probTotal += prob[number];
                D.ebugPrint(number + " ");
            }
            D.ebugPrint("ports: ");
            for (int portType = 0; portType <= 5; ++portType) {
                ports[portType] = board.getPortCoordinates(portType).contains(firstNodeInt) || board.getPortCoordinates(portType).contains(secondNodeInt);
                D.ebugPrint(ports[portType] + "  ");
            }
            D.ebugPrintln();
            D.ebugPrintln("probTotal = " + probTotal);
            estimate.recalculateEstimates(playerNumbers);
            int speed = 0;
            try {
                if ((speed += estimate.calculateRollsFast(emptySet, SOCGame.SETTLEMENT_SET, bestSpeed, ports).getRolls()) < bestSpeed && (speed += estimate.calculateRollsFast(emptySet, SOCGame.CITY_SET, bestSpeed, ports).getRolls()) < bestSpeed && (speed += estimate.calculateRollsFast(emptySet, SOCGame.CARD_SET, bestSpeed, ports).getRolls()) < bestSpeed) {
                    speed += estimate.calculateRollsFast(emptySet, SOCGame.ROAD_SET, bestSpeed, ports).getRolls();
                }
            }
            catch (CutoffExceededException e) {
                speed = bestSpeed;
            }
            D.ebugPrintln(Integer.toHexString(firstNode) + ", " + Integer.toHexString(secondNode) + ":" + speed);
            if (speed < bestSpeed || this.secondSettlement < 0) {
                this.firstSettlement = firstNode;
                this.secondSettlement = secondNode;
                bestSpeed = speed;
                bestProbTotal = probTotal;
                D.ebugPrintln("firstSettlement = " + Integer.toHexString(this.firstSettlement));
                D.ebugPrintln("secondSettlement = " + Integer.toHexString(this.secondSettlement));
                int[] rolls = estimate.getEstimatesFromNothingFast(ports);
                D.ebugPrint("road: " + rolls[0]);
                D.ebugPrint(" stlmt: " + rolls[1]);
                D.ebugPrint(" city: " + rolls[2]);
                D.ebugPrintln(" card: " + rolls[3]);
                D.ebugPrintln("bestSpeed = " + bestSpeed);
                continue;
            }
            if (speed != bestSpeed || probTotal <= bestProbTotal) continue;
            this.firstSettlement = firstNode;
            this.secondSettlement = secondNode;
            bestSpeed = speed;
            bestProbTotal = probTotal;
            D.ebugPrintln("firstSettlement = " + Integer.toHexString(this.firstSettlement));
            D.ebugPrintln("secondSettlement = " + Integer.toHexString(this.secondSettlement));
            int[] rolls = estimate.getEstimatesFromNothingFast(ports);
            D.ebugPrint("road: " + rolls[0]);
            D.ebugPrint(" stlmt: " + rolls[1]);
            D.ebugPrint(" city: " + rolls[2]);
            D.ebugPrintln(" card: " + rolls[3]);
            D.ebugPrintln("bestSpeed = " + bestSpeed);
        }
    }

    protected void placeFirstSettlement() {
        this.pause(500);
        this.client.putPiece(this.game, new SOCSettlement(this.ourPlayerData, this.firstSettlement));
        this.pause(1000);
    }

    protected void placeSecondSettlement() {
        this.pause(500);
        this.client.putPiece(this.game, new SOCSettlement(this.ourPlayerData, this.secondSettlement));
        this.pause(1000);
    }

    public void placeInitRoad() {
        int settlementNode = this.ourPlayerData.getLastSettlementCoord();
        Hashtable<Integer, Integer> twoAway = new Hashtable<Integer, Integer>();
        D.ebugPrintln("--- placeInitRoad");
        int tmp = settlementNode - 32;
        if (tmp >= 35 && tmp <= 220 && this.ourPlayerData.isPotentialSettlement(tmp)) {
            twoAway.put(new Integer(tmp), new Integer(0));
        }
        if ((tmp = settlementNode + 2) >= 35 && tmp <= 220 && this.ourPlayerData.isPotentialSettlement(tmp)) {
            twoAway.put(new Integer(tmp), new Integer(0));
        }
        if ((tmp = settlementNode + 34) >= 35 && tmp <= 220 && this.ourPlayerData.isPotentialSettlement(tmp)) {
            twoAway.put(new Integer(tmp), new Integer(0));
        }
        if ((tmp = settlementNode + 32) >= 35 && tmp <= 220 && this.ourPlayerData.isPotentialSettlement(tmp)) {
            twoAway.put(new Integer(tmp), new Integer(0));
        }
        if ((tmp = settlementNode - 2) >= 35 && tmp <= 220 && this.ourPlayerData.isPotentialSettlement(tmp)) {
            twoAway.put(new Integer(tmp), new Integer(0));
        }
        if ((tmp = settlementNode - 34) >= 35 && tmp <= 220 && this.ourPlayerData.isPotentialSettlement(tmp)) {
            twoAway.put(new Integer(tmp), new Integer(0));
        }
        this.scoreNodesForSettlements(twoAway, 3, 5, 10);
        D.ebugPrintln("Init Road for " + this.client.getNickname());
        SOCPlayer dummy = new SOCPlayer(this.ourPlayerData.getPlayerNumber(), this.game);
        if (this.game.getGameState() == 6) {
            int numberOfBuilds = this.numberOfEnemyBuilds();
            D.ebugPrintln("Other players will build " + numberOfBuilds + " settlements before I get to build again.");
            if (numberOfBuilds > 0) {
                Hashtable<Integer, Integer> allNodes = new Hashtable<Integer, Integer>();
                for (int i = 35; i < 220; ++i) {
                    if (!this.ourPlayerData.isPotentialSettlement(i)) continue;
                    D.ebugPrintln("-- potential settlement at " + Integer.toHexString(i));
                    allNodes.put(new Integer(i), new Integer(0));
                }
                this.bestSpotForNumbers(allNodes, 100);
                Vector miscPortNodes = this.game.getBoard().getPortCoordinates(0);
                this.bestSpot2AwayFromANodeSet(allNodes, miscPortNodes, 5);
                for (int portType = 1; portType <= 5; ++portType) {
                    if (this.resourceEstimates[portType] <= 33) continue;
                    Vector portNodes = this.game.getBoard().getPortCoordinates(portType);
                    int portWeight = this.resourceEstimates[portType] * 10 / 56;
                    this.bestSpot2AwayFromANodeSet(allNodes, portNodes, portWeight);
                }
                Vector<Integer> psList = new Vector<Integer>();
                for (int j = 35; j <= 220; ++j) {
                    if (!this.ourPlayerData.isPotentialSettlement(j)) continue;
                    D.ebugPrintln("- potential settlement at " + Integer.toHexString(j));
                    psList.addElement(new Integer(j));
                }
                dummy.setPotentialSettlements(psList);
                for (int builds = 0; builds < numberOfBuilds; ++builds) {
                    BoardNodeScorePair bestNodePair = new BoardNodeScorePair(0, 0);
                    Enumeration nodesEnum = allNodes.keys();
                    while (nodesEnum.hasMoreElements()) {
                        Integer nodeCoord = (Integer)nodesEnum.nextElement();
                        Integer score = (Integer)allNodes.get(nodeCoord);
                        D.ebugPrintln("NODE = " + Integer.toHexString(nodeCoord) + " SCORE = " + score);
                        if (bestNodePair.getScore() >= score) continue;
                        bestNodePair.setScore(score);
                        bestNodePair.setNode(nodeCoord);
                    }
                    dummy.updatePotentials(new SOCSettlement(this.ourPlayerData, bestNodePair.getNode()));
                    allNodes.remove(new Integer(bestNodePair.getNode()));
                }
            }
        }
        BoardNodeScorePair bestNodePair = new BoardNodeScorePair(0, 0);
        Enumeration enum1 = twoAway.keys();
        while (enum1.hasMoreElements()) {
            Integer coord = (Integer)enum1.nextElement();
            Integer score = (Integer)twoAway.get(coord);
            D.ebugPrintln("Considering " + Integer.toHexString(coord) + " with a score of " + score);
            if (dummy.isPotentialSettlement(coord)) {
                if (bestNodePair.getScore() >= score) continue;
                bestNodePair.setScore(score);
                bestNodePair.setNode(coord);
                continue;
            }
            D.ebugPrintln("Someone is bound to ruin that spot.");
        }
        int roadEdge = 0;
        int destination = bestNodePair.getNode();
        roadEdge = (settlementNode >> 4) % 2 == 0 ? (destination == settlementNode - 2 || destination == settlementNode + 32 ? settlementNode - 1 : (destination < settlementNode ? settlementNode - 17 : settlementNode)) : (destination == settlementNode - 32 || destination == settlementNode + 2 ? settlementNode - 16 : (destination > settlementNode ? settlementNode : settlementNode - 17));
        this.pause(500);
        this.client.putPiece(this.game, new SOCRoad(this.ourPlayerData, roadEdge));
        this.pause(1000);
        dummy.destroyPlayer();
    }

    protected int[] estimateResourceRarity() {
        if (this.resourceEstimates == null) {
            SOCBoard board = this.game.getBoard();
            int[] numberWeights = SOCNumberProbabilities.INT_VALUES;
            this.resourceEstimates = new int[6];
            this.resourceEstimates[0] = 0;
            for (int i = 0; i < 37; ++i) {
                int hexNumber = board.getNumberOnHexFromNumber(i);
                if (hexNumber <= 0) continue;
                int n = board.getHexTypeFromNumber(i);
                this.resourceEstimates[n] = this.resourceEstimates[n] + numberWeights[hexNumber];
            }
        }
        for (int i = 1; i < 6; ++i) {
        }
        return this.resourceEstimates;
    }

    protected void bestSpotForNumbers(Hashtable nodes, int weight) {
        int[] numRating = SOCNumberProbabilities.INT_VALUES;
        SOCBoard board = this.game.getBoard();
        Enumeration nodesEnum = nodes.keys();
        while (nodesEnum.hasMoreElements()) {
            Integer node = (Integer)nodesEnum.nextElement();
            int oldScore = (Integer)nodes.get(node);
            int score = 0;
            Enumeration hexesEnum = SOCBoard.getAdjacentHexesToNode(node).elements();
            while (hexesEnum.hasMoreElements()) {
                Integer hex = (Integer)hexesEnum.nextElement();
                score += numRating[board.getNumberOnHexFromCoord(hex)];
            }
            int nScore = score * 100 / 40 * weight;
            Integer finalScore = new Integer(nScore + oldScore);
            nodes.put(node, finalScore);
        }
    }

    protected void bestSpotForNumbers(Hashtable nodes, SOCPlayer player, int weight) {
        int[] numRating = SOCNumberProbabilities.INT_VALUES;
        SOCBoard board = this.game.getBoard();
        Enumeration nodesEnum = nodes.keys();
        while (nodesEnum.hasMoreElements()) {
            Integer node = (Integer)nodesEnum.nextElement();
            int oldScore = (Integer)nodes.get(node);
            int score = 0;
            Enumeration hexesEnum = SOCBoard.getAdjacentHexesToNode(node).elements();
            while (hexesEnum.hasMoreElements()) {
                Integer hex = (Integer)hexesEnum.nextElement();
                Integer number = new Integer(board.getNumberOnHexFromCoord(hex));
                score += numRating[number];
                if (number == 0 || player.getNumbers().hasNumber(number)) continue;
                score += numRating[number];
            }
            int nScore = score * 100 / 80 * weight;
            Integer finalScore = new Integer(nScore + oldScore);
            nodes.put(node, finalScore);
        }
    }

    protected void bestSpot2AwayFromANodeSet(Hashtable nodesIn, Vector nodeSet, int weight) {
        Enumeration nodesInEnum = nodesIn.keys();
        while (nodesInEnum.hasMoreElements()) {
            int target;
            Integer nodeCoord = (Integer)nodesInEnum.nextElement();
            int node = nodeCoord;
            int score = 0;
            int oldScore = (Integer)nodesIn.get(nodeCoord);
            Enumeration nodeSetEnum = nodeSet.elements();
            while (nodeSetEnum.hasMoreElements() && node != (target = ((Integer)nodeSetEnum.nextElement()).intValue())) {
                if (node == target - 32) {
                    score = 100;
                    continue;
                }
                if (node == target + 2) {
                    score = 100;
                    continue;
                }
                if (node == target + 34) {
                    score = 100;
                    continue;
                }
                if (node == target + 32) {
                    score = 100;
                    continue;
                }
                if (node == target - 2) {
                    score = 100;
                    continue;
                }
                if (node != target - 34) continue;
                score = 100;
            }
            nodesIn.put(nodeCoord, new Integer(oldScore + (score *= weight)));
        }
    }

    protected void bestSpotInANodeSet(Hashtable nodesIn, Vector nodeSet, int weight) {
        Enumeration nodesInEnum = nodesIn.keys();
        while (nodesInEnum.hasMoreElements()) {
            Integer nodeCoord = (Integer)nodesInEnum.nextElement();
            int node = nodeCoord;
            int score = 0;
            int oldScore = (Integer)nodesIn.get(nodeCoord);
            Enumeration nodeSetEnum = nodeSet.elements();
            while (nodeSetEnum.hasMoreElements()) {
                int target = (Integer)nodeSetEnum.nextElement();
                if (node != target) continue;
                score = 100;
                break;
            }
            nodesIn.put(nodeCoord, new Integer(oldScore + (score *= weight)));
        }
    }

    protected void moveRobber() {
        D.ebugPrintln("%%% MOVEROBBER");
        int[] hexes = new int[]{51, 53, 55, 83, 85, 87, 89, 115, 117, 119, 121, 123, 149, 151, 153, 155, 183, 185, 187};
        int robberHex = this.game.getBoard().getRobberHex();
        int[] winGameETAs = new int[]{100, 100, 100, 100};
        for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
            D.ebugPrintln("%%%%%%%%% TRACKER FOR PLAYER " + tracker.getPlayer().getPlayerNumber());
            try {
                tracker.recalcWinGameETA();
                winGameETAs[tracker.getPlayer().getPlayerNumber()] = tracker.getWinGameETA();
                D.ebugPrintln("winGameETA = " + tracker.getWinGameETA());
            }
            catch (NullPointerException e) {
                D.ebugPrintln("Null Pointer Exception calculating winGameETA");
                winGameETAs[tracker.getPlayer().getPlayerNumber()] = 500;
            }
        }
        int victimNum = -1;
        for (int pnum = 0; pnum < 4; ++pnum) {
            if (victimNum < 0 && pnum != this.ourPlayerData.getPlayerNumber()) {
                D.ebugPrintln("Picking a robber victim: pnum=" + pnum);
                victimNum = pnum;
                continue;
            }
            if (pnum == this.ourPlayerData.getPlayerNumber() || winGameETAs[pnum] >= winGameETAs[victimNum]) continue;
            D.ebugPrintln("Picking a robber victim: pnum=" + pnum);
            victimNum = pnum;
        }
        SOCPlayer victim = this.game.getPlayer(victimNum);
        SOCBuildingSpeedEstimate estimate = new SOCBuildingSpeedEstimate();
        int bestHex = robberHex;
        int worstSpeed = 0;
        for (int i = 0; i < 19; ++i) {
            if (hexes[i] == robberHex || !this.ourPlayerData.getNumbers().getNumberResourcePairsForHex(hexes[i]).isEmpty()) continue;
            estimate.recalculateEstimates(victim.getNumbers(), hexes[i]);
            int[] speeds = estimate.getEstimatesFromNothingFast(victim.getPortFlags());
            int totalSpeed = 0;
            for (int j = 0; j < 4; ++j) {
                totalSpeed += speeds[j];
            }
            D.ebugPrintln("total Speed = " + totalSpeed);
            if (totalSpeed <= worstSpeed) continue;
            bestHex = hexes[i];
            worstSpeed = totalSpeed;
            D.ebugPrintln("bestHex = " + Integer.toHexString(bestHex));
            D.ebugPrintln("worstSpeed = " + worstSpeed);
        }
        D.ebugPrintln("%%% bestHex = " + Integer.toHexString(bestHex));
        while (bestHex == robberHex && this.ourPlayerData.getNumbers().getNumberResourcePairsForHex(hexes[bestHex]).isEmpty()) {
            bestHex = hexes[Math.abs(this.rand.nextInt() % hexes.length)];
            D.ebugPrintln("%%% random pick = " + Integer.toHexString(bestHex));
        }
        D.ebugPrintln("!!! MOVING ROBBER !!!");
        this.client.moveRobber(this.game, this.ourPlayerData, bestHex);
        this.pause(2000);
    }

    protected void discard(int numDiscards) {
        SOCResourceSet discards = new SOCResourceSet();
        if (this.buildingPlan.empty()) {
            this.decisionMaker.planStuff(this.robotParameters.getStrategyType());
        }
        if (!this.buildingPlan.empty()) {
            SOCPossiblePiece targetPiece = (SOCPossiblePiece)this.buildingPlan.peek();
            this.negotiator.setTargetPiece(this.ourPlayerData.getPlayerNumber(), targetPiece);
            SOCResourceSet targetResources = null;
            switch (targetPiece.getType()) {
                case 4: {
                    targetResources = SOCGame.CARD_SET;
                    break;
                }
                case 0: {
                    targetResources = SOCGame.ROAD_SET;
                    break;
                }
                case 1: {
                    targetResources = SOCGame.SETTLEMENT_SET;
                    break;
                }
                case 2: {
                    targetResources = SOCGame.CITY_SET;
                }
            }
            SOCResourceSet leftOvers = this.ourPlayerData.getResources().copy();
            for (int rsrc = 1; rsrc <= 5; ++rsrc) {
                if (leftOvers.getAmount(rsrc) > targetResources.getAmount(rsrc)) {
                    leftOvers.subtract(targetResources.getAmount(rsrc), rsrc);
                    continue;
                }
                leftOvers.setAmount(0, rsrc);
            }
            SOCResourceSet neededRsrcs = this.ourPlayerData.getResources().copy();
            neededRsrcs.subtract(leftOvers);
            SOCBuildingSpeedEstimate estimate = new SOCBuildingSpeedEstimate(this.ourPlayerData.getNumbers());
            int[] rollsPerResource = estimate.getRollsPerResource();
            int[] resourceOrder = new int[]{1, 2, 3, 4, 5};
            for (int j = 4; j >= 0; --j) {
                for (int i = 0; i < j; ++i) {
                    if (rollsPerResource[resourceOrder[i]] >= rollsPerResource[resourceOrder[i + 1]]) continue;
                    int tmp = resourceOrder[i];
                    resourceOrder[i] = resourceOrder[i + 1];
                    resourceOrder[i + 1] = tmp;
                }
            }
            int curRsrc = 0;
            while (discards.getTotal() < numDiscards) {
                while (discards.getTotal() < numDiscards && curRsrc < 5) {
                    if (leftOvers.getAmount(resourceOrder[curRsrc]) > 0) {
                        discards.add(1, resourceOrder[curRsrc]);
                        leftOvers.subtract(1, resourceOrder[curRsrc]);
                        continue;
                    }
                    ++curRsrc;
                }
                curRsrc = 0;
                while (discards.getTotal() < numDiscards && curRsrc < 5) {
                    if (neededRsrcs.getAmount(resourceOrder[curRsrc]) > 0) {
                        discards.add(1, resourceOrder[curRsrc]);
                        neededRsrcs.subtract(1, resourceOrder[curRsrc]);
                        continue;
                    }
                    ++curRsrc;
                }
            }
            if (curRsrc == 5) {
                System.err.println("PROBLEM IN DISCARD - curRsrc == 5");
            }
        } else {
            Vector<Integer> hand = new Vector<Integer>(16);
            boolean cnt = false;
            for (int rsrcType = 1; rsrcType <= 5; ++rsrcType) {
                for (int i = this.ourPlayerData.getResources().getAmount(rsrcType); i != 0; --i) {
                    hand.addElement(new Integer(rsrcType));
                }
            }
            while (numDiscards > 0) {
                int idx = Math.abs(this.rand.nextInt() % hand.size());
                discards.add(1, (Integer)hand.elementAt(idx));
                hand.removeElementAt(idx);
                --numDiscards;
            }
        }
        this.client.discard(this.game, discards);
    }

    protected void chooseRobberVictim(boolean[] choices) {
        int choice = -1;
        for (int i = 0; i < 4; ++i) {
            if (!choices[i]) continue;
            if (choice == -1) {
                choice = i;
                continue;
            }
            SOCPlayerTracker tracker1 = (SOCPlayerTracker)this.playerTrackers.get(new Integer(i));
            SOCPlayerTracker tracker2 = (SOCPlayerTracker)this.playerTrackers.get(new Integer(choice));
            if (tracker1 == null || tracker2 == null || tracker1.getWinGameETA() >= tracker2.getWinGameETA()) continue;
            choice = i;
        }
        this.client.choosePlayer(this.game, choice);
    }

    protected int numberOfEnemyBuilds() {
        int numberOfBuilds = 0;
        int pNum = this.game.getCurrentPlayerNumber();
        if (this.game.getGameState() == 5 || this.game.getGameState() == 6) {
            do {
                if (++pNum >= 4) {
                    pNum = 0;
                }
                if (pNum == this.game.getFirstPlayer()) continue;
                ++numberOfBuilds;
            } while (pNum != this.game.getFirstPlayer());
        }
        do {
            if (--pNum < 0) {
                pNum = 3;
            }
            if (pNum == this.game.getCurrentPlayerNumber()) continue;
            ++numberOfBuilds;
        } while (pNum != this.game.getCurrentPlayerNumber());
        return numberOfBuilds;
    }

    protected BoardNodeScorePair findBestScoringNode(Hashtable nodes) {
        BoardNodeScorePair bestNodePair = new BoardNodeScorePair(0, -1);
        Enumeration nodesEnum = nodes.keys();
        while (nodesEnum.hasMoreElements()) {
            Integer nodeCoord = (Integer)nodesEnum.nextElement();
            Integer score = (Integer)nodes.get(nodeCoord);
            if (bestNodePair.getScore() >= score) continue;
            bestNodePair.setScore(score);
            bestNodePair.setNode(nodeCoord);
        }
        return bestNodePair;
    }

    protected void scoreNodesForSettlements(Hashtable nodes, int numberWeight, int miscPortWeight, int portWeight) {
        this.bestSpotForNumbers(nodes, this.ourPlayerData, numberWeight);
        if (!this.ourPlayerData.getPortFlag(0)) {
            Vector miscPortNodes = this.game.getBoard().getPortCoordinates(0);
            this.bestSpotInANodeSet(nodes, miscPortNodes, miscPortWeight);
        }
        int[] resourceEstimates = this.estimateResourceRarity();
        for (int portType = 1; portType <= 5; ++portType) {
            if (resourceEstimates[portType] <= 33 || this.ourPlayerData.getPortFlag(portType)) continue;
            Vector portNodes = this.game.getBoard().getPortCoordinates(portType);
            int estimatedPortWeight = resourceEstimates[portType] * portWeight / 56;
            this.bestSpotInANodeSet(nodes, portNodes, estimatedPortWeight);
        }
    }

    protected void tradeStuff() {
        SOCTradeTree treeRoot = new SOCTradeTree(this.ourPlayerData.getResources(), null);
        Hashtable<SOCResourceSet, SOCTradeTree> treeNodes = new Hashtable<SOCResourceSet, SOCTradeTree>();
        treeNodes.put(treeRoot.getResourceSet(), treeRoot);
        Queue queue = new Queue();
        queue.put(treeRoot);
        while (!queue.empty()) {
            SOCTradeTree currentTreeNode = (SOCTradeTree)queue.get();
            this.expandTradeTreeNode(currentTreeNode, treeNodes);
            Enumeration childrenEnum = currentTreeNode.getChildren().elements();
            while (childrenEnum.hasMoreElements()) {
                SOCTradeTree child = (SOCTradeTree)childrenEnum.nextElement();
                if (!child.needsToBeExpanded()) continue;
                treeNodes.put(child.getResourceSet(), child);
                queue.put(child);
            }
        }
        SOCResourceSet bestTradeOutcome = null;
        int bestTradeScore = -1;
        Enumeration possibleTrades = treeNodes.keys();
        while (possibleTrades.hasMoreElements()) {
            SOCResourceSet possibleTradeOutcome = (SOCResourceSet)possibleTrades.nextElement();
            int score = this.scoreTradeOutcome(possibleTradeOutcome);
            if (score <= bestTradeScore) continue;
            bestTradeOutcome = possibleTradeOutcome;
            bestTradeScore = score;
        }
        Stack<SOCTradeTree> stack = new Stack<SOCTradeTree>();
        for (SOCTradeTree cursor = (SOCTradeTree)treeNodes.get(bestTradeOutcome); cursor != treeRoot; cursor = cursor.getParent()) {
            stack.push(cursor);
        }
        SOCResourceSet give = new SOCResourceSet();
        SOCResourceSet get = new SOCResourceSet();
        SOCTradeTree prevTreeNode = treeRoot;
        while (!stack.empty()) {
            SOCTradeTree currTreeNode = (SOCTradeTree)stack.pop();
            give.setAmounts(prevTreeNode.getResourceSet());
            give.subtract(currTreeNode.getResourceSet());
            get.setAmounts(currTreeNode.getResourceSet());
            get.subtract(prevTreeNode.getResourceSet());
            for (int rt = 1; rt <= 5; ++rt) {
                if (give.getAmount(rt) < 0) {
                    give.setAmount(0, rt);
                }
                if (get.getAmount(rt) >= 0) continue;
                get.setAmount(0, rt);
            }
            this.client.bankTrade(this.game, give, get);
            this.pause(2000);
            prevTreeNode = currTreeNode;
        }
    }

    protected void expandTradeTreeNode(SOCTradeTree currentTreeNode, Hashtable table) {
        SOCResourceSet rSet = currentTreeNode.getResourceSet();
        for (int giveResource = 1; giveResource <= 5; ++giveResource) {
            int tradeRatio = this.ourPlayerData.getPortFlag(giveResource) ? 2 : (this.ourPlayerData.getPortFlag(0) ? 3 : 4);
            if (rSet.getAmount(giveResource) < tradeRatio) continue;
            block1: for (int getResource = 1; getResource <= 5; ++getResource) {
                if (getResource == giveResource) continue;
                SOCResourceSet newTradeResult = rSet.copy();
                newTradeResult.subtract(tradeRatio, giveResource);
                newTradeResult.add(1, getResource);
                SOCTradeTree newTree = new SOCTradeTree(newTradeResult, currentTreeNode);
                Enumeration tableEnum = table.keys();
                while (tableEnum.hasMoreElements()) {
                    SOCResourceSet oldTradeResult = (SOCResourceSet)tableEnum.nextElement();
                    if (!SOCResourceSet.lte(newTradeResult, oldTradeResult)) continue;
                    newTree.setNeedsToBeExpanded(false);
                    continue block1;
                }
            }
        }
    }

    protected int scoreTradeOutcome(SOCResourceSet tradeOutcome) {
        int score = 0;
        SOCResourceSet tempTO = tradeOutcome.copy();
        if (this.ourPlayerData.getNumPieces(1) >= 1 && this.ourPlayerData.hasPotentialSettlement()) {
            while (tempTO.contains(SOCGame.SETTLEMENT_SET)) {
                score += 2;
                tempTO.subtract(SOCGame.SETTLEMENT_SET);
            }
        }
        if (this.ourPlayerData.getNumPieces(0) >= 1 && this.ourPlayerData.hasPotentialRoad()) {
            while (tempTO.contains(SOCGame.ROAD_SET)) {
                ++score;
                tempTO.subtract(SOCGame.ROAD_SET);
            }
        }
        if (this.ourPlayerData.getNumPieces(2) >= 1 && this.ourPlayerData.hasPotentialCity()) {
            while (tempTO.contains(SOCGame.CITY_SET)) {
                score += 2;
                tempTO.subtract(SOCGame.CITY_SET);
            }
        }
        return score;
    }

    protected boolean tradeToTarget2(SOCResourceSet targetResources) {
        if (this.ourPlayerData.getResources().contains(targetResources)) {
            return false;
        }
        SOCTradeOffer bankTrade = this.negotiator.getOfferToBank(targetResources, this.ourPlayerData.getResources());
        if (bankTrade != null && this.ourPlayerData.getResources().contains(bankTrade.getGiveSet())) {
            this.client.bankTrade(this.game, bankTrade.getGiveSet(), bankTrade.getGetSet());
            this.pause(2000);
            return true;
        }
        return false;
    }

    protected int considerOffer(SOCTradeOffer offer) {
        boolean[] offeredTo;
        int response = -1;
        SOCPlayer offeringPlayer = this.game.getPlayer(offer.getFrom());
        if (offeringPlayer.getCurrentOffer() != null && offer == offeringPlayer.getCurrentOffer() && (offeredTo = offer.getTo())[this.ourPlayerData.getPlayerNumber()]) {
            response = this.negotiator.considerOffer2(offer, this.ourPlayerData.getPlayerNumber());
        }
        return response;
    }

    protected boolean makeOffer(SOCPossiblePiece target) {
        boolean result = false;
        SOCTradeOffer offer = this.negotiator.makeOffer(target);
        this.ourPlayerData.setCurrentOffer(offer);
        this.negotiator.resetWantsAnotherOffer();
        if (offer != null) {
            for (int i = 0; i < 4; ++i) {
                this.offerRejections[i] = false;
            }
            this.waitingForTradeResponse = true;
            this.counter = 0;
            this.client.offerTrade(this.game, offer);
            result = true;
        } else {
            this.doneTrading = true;
            this.waitingForTradeResponse = false;
        }
        return result;
    }

    protected boolean makeCounterOffer(SOCTradeOffer offer) {
        boolean result = false;
        SOCTradeOffer counterOffer = this.negotiator.makeCounterOffer(offer);
        this.ourPlayerData.setCurrentOffer(counterOffer);
        if (counterOffer != null) {
            this.offerRejections[offer.getFrom()] = false;
            this.waitingForTradeResponse = true;
            this.counter = 0;
            this.client.offerTrade(this.game, counterOffer);
            result = true;
        } else {
            this.doneTrading = true;
            this.waitingForTradeResponse = false;
        }
        return result;
    }

    protected void chooseFreeResources(SOCResourceSet targetResources) {
        this.resourceChoices.clear();
        SOCResourceSet rsCopy = this.ourPlayerData.getResources().copy();
        SOCBuildingSpeedEstimate estimate = new SOCBuildingSpeedEstimate(this.ourPlayerData.getNumbers());
        int[] rollsPerResource = estimate.getRollsPerResource();
        for (int resourceCount = 0; resourceCount < 2; ++resourceCount) {
            int mostNeededResource = -1;
            for (int resource = 1; resource <= 5; ++resource) {
                if (rsCopy.getAmount(resource) >= targetResources.getAmount(resource)) continue;
                if (mostNeededResource < 0) {
                    mostNeededResource = resource;
                    continue;
                }
                if (rollsPerResource[resource] <= rollsPerResource[mostNeededResource]) continue;
                mostNeededResource = resource;
            }
            this.resourceChoices.add(1, mostNeededResource);
            rsCopy.add(1, mostNeededResource);
        }
    }

    protected boolean chooseMonopoly() {
        int bestResourceCount = 0;
        int bestResource = 0;
        for (int resource = 1; resource <= 5; ++resource) {
            int freeResourceCount = 0;
            boolean twoForOne = false;
            boolean threeForOne = false;
            if (this.ourPlayerData.getPortFlag(resource)) {
                twoForOne = true;
            } else if (this.ourPlayerData.getPortFlag(0)) {
                threeForOne = true;
            }
            int resourceTotal = 0;
            for (int pn = 0; pn < 4; ++pn) {
                if (this.ourPlayerData.getPlayerNumber() == pn) continue;
                resourceTotal += this.game.getPlayer(pn).getResources().getAmount(resource);
            }
            freeResourceCount = twoForOne ? resourceTotal / 2 : (threeForOne ? resourceTotal / 3 : resourceTotal / 4);
            if (freeResourceCount <= bestResourceCount) continue;
            bestResourceCount = freeResourceCount;
            bestResource = resource;
        }
        if (bestResourceCount > 2) {
            this.monopolyChoice = bestResource;
            return true;
        }
        return false;
    }

    protected void debugInfo() {
    }

    private void printResources() {
    }
}

