/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import soc.client.SOCDisplaylessPlayerClient;
import soc.disableDebug.D;
import soc.game.SOCBoard;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.message.SOCAcceptOffer;
import soc.message.SOCAdminPing;
import soc.message.SOCAdminReset;
import soc.message.SOCBoardLayout;
import soc.message.SOCChangeFace;
import soc.message.SOCChoosePlayerRequest;
import soc.message.SOCClearOffer;
import soc.message.SOCClearTradeMsg;
import soc.message.SOCDeleteGame;
import soc.message.SOCDevCard;
import soc.message.SOCDevCardCount;
import soc.message.SOCDiceResult;
import soc.message.SOCDiscardRequest;
import soc.message.SOCFirstPlayer;
import soc.message.SOCGameMembers;
import soc.message.SOCGameState;
import soc.message.SOCGameTextMsg;
import soc.message.SOCImARobot;
import soc.message.SOCJoinGame;
import soc.message.SOCJoinGameAuth;
import soc.message.SOCJoinGameRequest;
import soc.message.SOCLargestArmy;
import soc.message.SOCLeaveAll;
import soc.message.SOCLeaveGame;
import soc.message.SOCLongestRoad;
import soc.message.SOCMakeOffer;
import soc.message.SOCMessage;
import soc.message.SOCMoveRobber;
import soc.message.SOCPlayerElement;
import soc.message.SOCPotentialSettlements;
import soc.message.SOCPutPiece;
import soc.message.SOCRejectOffer;
import soc.message.SOCResourceCount;
import soc.message.SOCRobotDismiss;
import soc.message.SOCServerPing;
import soc.message.SOCSetPlayedDevCard;
import soc.message.SOCSetTurn;
import soc.message.SOCSitDown;
import soc.message.SOCStartGame;
import soc.message.SOCTurn;
import soc.message.SOCUpdateRobotParams;
import soc.robot.SOCPossiblePiece;
import soc.robot.SOCRobotBrain;
import soc.robot.SOCRobotResetThread;
import soc.util.CappedQueue;
import soc.util.CutoffExceededException;
import soc.util.SOCRobotParameters;

public class SOCRobotClient
extends SOCDisplaylessPlayerClient {
    public static final String CURRENT_PLANS = "CURRENT_PLANS";
    public static final String CURRENT_RESOURCES = "RESOURCES";
    protected Thread reader;
    protected SOCRobotParameters currentRobotParameters;
    public Hashtable robotBrains = new Hashtable();
    protected Hashtable brainQs = new Hashtable();
    protected Hashtable seatRequests = new Hashtable();
    protected int gamesPlayed = 0;
    protected int gamesFinished = 0;
    protected int gamesWon = 0;
    protected int cleanBrainKills = 0;
    protected long startTime = System.currentTimeMillis();
    SOCRobotResetThread resetThread;

    public SOCRobotClient(String h, int p, String nn, String pw) {
        this.host = h;
        this.port = p;
        this.nickname = nn;
        this.password = pw;
    }

    public void init() {
        try {
            this.s = new Socket(this.host, this.port);
            this.s.setSoTimeout(300000);
            this.in = new DataInputStream(this.s.getInputStream());
            this.out = new DataOutputStream(this.s.getOutputStream());
            this.connected = true;
            this.reader = new Thread(this);
            this.reader.start();
            this.put(SOCImARobot.toCmd(this.nickname));
        }
        catch (Exception e) {
            this.ex = e;
            System.err.println("Could not connect to the server: " + this.ex);
        }
    }

    public void disconnectReconnect() {
        D.ebugPrintln("(*)(*)(*)(*)(*)(*)(*) disconnectReconnect()");
        this.ex = null;
        try {
            this.connected = false;
            this.s.close();
            this.s = new Socket(this.host, this.port);
            this.in = new DataInputStream(this.s.getInputStream());
            this.out = new DataOutputStream(this.s.getOutputStream());
            this.connected = true;
            this.reader = new Thread(this);
            this.reader.start();
            this.put(SOCImARobot.toCmd(this.nickname));
        }
        catch (Exception e) {
            this.ex = e;
            System.err.println("disconnectReconnect error: " + this.ex);
        }
    }

    @Override
    public void treat(SOCMessage mes) {
        D.ebugPrintln("IN - " + mes);
        try {
            switch (mes.getType()) {
                case 9999: {
                    this.handleSERVERPING((SOCServerPing)mes);
                    break;
                }
                case 1064: {
                    this.handleADMINPING((SOCAdminPing)mes);
                    break;
                }
                case 1065: {
                    this.handleADMINRESET((SOCAdminReset)mes);
                    break;
                }
                case 1071: {
                    this.handleUPDATEROBOTPARAMS((SOCUpdateRobotParams)mes);
                    break;
                }
                case 1021: {
                    this.handleJOINGAMEAUTH((SOCJoinGameAuth)mes);
                    break;
                }
                case 1013: {
                    this.handleJOINGAME((SOCJoinGame)mes);
                    break;
                }
                case 1011: {
                    this.handleLEAVEGAME((SOCLeaveGame)mes);
                    break;
                }
                case 1015: {
                    this.handleDELETEGAME((SOCDeleteGame)mes);
                    break;
                }
                case 1017: {
                    this.handleGAMEMEMBERS((SOCGameMembers)mes);
                    break;
                }
                case 1010: {
                    this.handleGAMETEXTMSG((SOCGameTextMsg)mes);
                    break;
                }
                case 1012: {
                    this.handleSITDOWN((SOCSitDown)mes);
                    break;
                }
                case 1014: {
                    this.handleBOARDLAYOUT((SOCBoardLayout)mes);
                    break;
                }
                case 1018: {
                    this.handleSTARTGAME((SOCStartGame)mes);
                    break;
                }
                case 1025: {
                    this.handleGAMESTATE((SOCGameState)mes);
                    break;
                }
                case 1055: {
                    this.handleSETTURN((SOCSetTurn)mes);
                    break;
                }
                case 1054: {
                    this.handleFIRSTPLAYER((SOCFirstPlayer)mes);
                    break;
                }
                case 1026: {
                    this.handleTURN((SOCTurn)mes);
                    break;
                }
                case 1024: {
                    this.handlePLAYERELEMENT((SOCPlayerElement)mes);
                    break;
                }
                case 1063: {
                    this.handleRESOURCECOUNT((SOCResourceCount)mes);
                    break;
                }
                case 1028: {
                    this.handleDICERESULT((SOCDiceResult)mes);
                    break;
                }
                case 1009: {
                    this.handlePUTPIECE((SOCPutPiece)mes);
                    break;
                }
                case 1034: {
                    this.handleMOVEROBBER((SOCMoveRobber)mes);
                    break;
                }
                case 1029: {
                    this.handleDISCARDREQUEST((SOCDiscardRequest)mes);
                    break;
                }
                case 1036: {
                    this.handleCHOOSEPLAYERREQUEST((SOCChoosePlayerRequest)mes);
                    break;
                }
                case 1041: {
                    this.handleMAKEOFFER((SOCMakeOffer)mes);
                    break;
                }
                case 1038: {
                    this.handleCLEAROFFER((SOCClearOffer)mes);
                    break;
                }
                case 1037: {
                    this.handleREJECTOFFER((SOCRejectOffer)mes);
                    break;
                }
                case 1039: {
                    this.handleACCEPTOFFER((SOCAcceptOffer)mes);
                    break;
                }
                case 1042: {
                    this.handleCLEARTRADEMSG((SOCClearTradeMsg)mes);
                    break;
                }
                case 1047: {
                    this.handleDEVCARDCOUNT((SOCDevCardCount)mes);
                    break;
                }
                case 1046: {
                    this.handleDEVCARD((SOCDevCard)mes);
                    break;
                }
                case 1048: {
                    this.handleSETPLAYEDDEVCARD((SOCSetPlayedDevCard)mes);
                    break;
                }
                case 1057: {
                    this.handlePOTENTIALSETTLEMENTS((SOCPotentialSettlements)mes);
                    break;
                }
                case 1023: {
                    this.handleJOINGAMEREQUEST((SOCJoinGameRequest)mes);
                    break;
                }
                case 1056: {
                    this.handleROBOTDISMISS((SOCRobotDismiss)mes);
                }
            }
        }
        catch (Exception e) {
            System.out.println("SOCRobotClient treat ERROR - " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void handleSERVERPING(SOCServerPing mes) {
    }

    protected void handleADMINPING(SOCAdminPing mes) {
        D.ebugPrintln("*** Admin Ping message = " + mes);
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            this.sendText(ga, "OK");
        } else {
            this.put(SOCJoinGame.toCmd(this.nickname, this.password, this.host, mes.getGame()));
        }
    }

    protected void handleADMINRESET(SOCAdminReset mes) {
        D.ebugPrintln("*** Admin Reset message = " + mes);
        this.disconnectReconnect();
    }

    protected void handleUPDATEROBOTPARAMS(SOCUpdateRobotParams mes) {
        this.currentRobotParameters = new SOCRobotParameters(mes.getRobotParameters());
        D.ebugPrintln("*** current robot parameters = " + this.currentRobotParameters);
    }

    protected void handleJOINGAMEREQUEST(SOCJoinGameRequest mes) {
        D.ebugPrintln("**** handleJOINGAMEREQUEST ****");
        this.seatRequests.put(mes.getGame(), new Integer(mes.getPlayerNumber()));
        if (this.put(SOCJoinGame.toCmd(this.nickname, this.password, this.host, mes.getGame()))) {
            D.ebugPrintln("**** sent SOCJoinGame ****");
        }
    }

    @Override
    protected void handleJOINGAMEAUTH(SOCJoinGameAuth mes) {
        ++this.gamesPlayed;
        SOCGame ga = new SOCGame(mes.getGame(), true);
        this.games.put(mes.getGame(), ga);
        CappedQueue brainQ = new CappedQueue();
        this.brainQs.put(mes.getGame(), brainQ);
        SOCRobotBrain rb = new SOCRobotBrain(this, this.currentRobotParameters, ga, brainQ);
        this.robotBrains.put(mes.getGame(), rb);
    }

    @Override
    protected void handleJOINGAME(SOCJoinGame mes) {
    }

    @Override
    protected void handleLEAVEGAME(SOCLeaveGame mes) {
    }

    @Override
    protected void handleGAMEMEMBERS(SOCGameMembers mes) {
        Integer pn = (Integer)this.seatRequests.get(mes.getGame());
        this.put(SOCSitDown.toCmd(mes.getGame(), this.nickname, pn, true));
    }

    @Override
    protected void handleGAMETEXTMSG(SOCGameTextMsg mes) {
        CappedQueue brainQ;
        Runtime rt;
        SOCPossiblePiece lastTarget;
        String[] tokens;
        String str;
        Enumeration enum1;
        SOCGame ga;
        Vector record;
        String key;
        SOCPossiblePiece lastMove;
        SOCGame ga2;
        Vector record2;
        SOCRobotBrain brain;
        String str2;
        Enumeration enum12;
        Vector record3;
        SOCRobotBrain brain2;
        SOCGame ga3;
        if (mes.getText().startsWith(this.nickname + ":debug-off")) {
            ga3 = (SOCGame)this.games.get(mes.getGame());
            brain2 = (SOCRobotBrain)this.robotBrains.get(mes.getGame());
            if (brain2 != null) {
                brain2.turnOffDRecorder();
                this.sendText(ga3, "Debug mode OFF");
            }
        }
        if (mes.getText().startsWith(this.nickname + ":debug-on")) {
            ga3 = (SOCGame)this.games.get(mes.getGame());
            brain2 = (SOCRobotBrain)this.robotBrains.get(mes.getGame());
            if (brain2 != null) {
                brain2.turnOnDRecorder();
                this.sendText(ga3, "Debug mode ON");
            }
        }
        if (mes.getText().startsWith(this.nickname + ":current-plans") || mes.getText().startsWith(this.nickname + ":cp")) {
            ga3 = (SOCGame)this.games.get(mes.getGame());
            brain2 = (SOCRobotBrain)this.robotBrains.get(mes.getGame());
            if (brain2 != null && brain2.getDRecorder().isOn() && (record3 = brain2.getDRecorder().getRecord(CURRENT_PLANS)) != null) {
                enum12 = record3.elements();
                while (enum12.hasMoreElements()) {
                    str2 = (String)enum12.nextElement();
                    this.sendText(ga3, str2);
                }
            }
        }
        if (mes.getText().startsWith(this.nickname + ":current-resources") || mes.getText().startsWith(this.nickname + ":cr")) {
            ga3 = (SOCGame)this.games.get(mes.getGame());
            brain2 = (SOCRobotBrain)this.robotBrains.get(mes.getGame());
            if (brain2 != null && brain2.getDRecorder().isOn() && (record3 = brain2.getDRecorder().getRecord(CURRENT_RESOURCES)) != null) {
                enum12 = record3.elements();
                while (enum12.hasMoreElements()) {
                    str2 = (String)enum12.nextElement();
                    this.sendText(ga3, str2);
                }
            }
        }
        if ((mes.getText().startsWith(this.nickname + ":last-plans") || mes.getText().startsWith(this.nickname + ":lp")) && (brain = (SOCRobotBrain)this.robotBrains.get(mes.getGame())) != null && brain.getDRecorder().isOn() && (record2 = brain.getOldDRecorder().getRecord(CURRENT_PLANS)) != null) {
            ga2 = (SOCGame)this.games.get(mes.getGame());
            enum12 = record2.elements();
            while (enum12.hasMoreElements()) {
                str2 = (String)enum12.nextElement();
                this.sendText(ga2, str2);
            }
        }
        if ((mes.getText().startsWith(this.nickname + ":last-resources") || mes.getText().startsWith(this.nickname + ":lr")) && (brain = (SOCRobotBrain)this.robotBrains.get(mes.getGame())) != null && brain.getDRecorder().isOn() && (record2 = brain.getOldDRecorder().getRecord(CURRENT_RESOURCES)) != null) {
            ga2 = (SOCGame)this.games.get(mes.getGame());
            enum12 = record2.elements();
            while (enum12.hasMoreElements()) {
                str2 = (String)enum12.nextElement();
                this.sendText(ga2, str2);
            }
        }
        if ((mes.getText().startsWith(this.nickname + ":last-move") || mes.getText().startsWith(this.nickname + ":lm")) && (brain = (SOCRobotBrain)this.robotBrains.get(mes.getGame())) != null && brain.getOldDRecorder().isOn() && (lastMove = brain.getLastMove()) != null) {
            key = null;
            switch (lastMove.getType()) {
                case 4: {
                    key = "DEVCARD";
                    break;
                }
                case 0: {
                    key = "ROAD" + lastMove.getCoordinates();
                    break;
                }
                case 1: {
                    key = "SETTLEMENT" + lastMove.getCoordinates();
                    break;
                }
                case 2: {
                    key = "CITY" + lastMove.getCoordinates();
                }
            }
            record = brain.getOldDRecorder().getRecord(key);
            if (record != null) {
                ga = (SOCGame)this.games.get(mes.getGame());
                enum1 = record.elements();
                while (enum1.hasMoreElements()) {
                    str = (String)enum1.nextElement();
                    this.sendText(ga, str);
                }
            }
        }
        if ((mes.getText().startsWith(this.nickname + ":consider-move ") || mes.getText().startsWith(this.nickname + ":cm ")) && (brain = (SOCRobotBrain)this.robotBrains.get(mes.getGame())) != null && brain.getOldDRecorder().isOn()) {
            tokens = mes.getText().split(" ");
            key = null;
            if (tokens[1].trim().equals("card")) {
                key = "DEVCARD";
            } else if (tokens[1].equals("road")) {
                key = "ROAD" + tokens[2].trim();
            } else if (tokens[1].equals("settlement")) {
                key = "SETTLEMENT" + tokens[2].trim();
            } else if (tokens[1].equals("city")) {
                key = "CITY" + tokens[2].trim();
            }
            record = brain.getOldDRecorder().getRecord(key);
            if (record != null) {
                ga = (SOCGame)this.games.get(mes.getGame());
                enum1 = record.elements();
                while (enum1.hasMoreElements()) {
                    str = (String)enum1.nextElement();
                    this.sendText(ga, str);
                }
            }
        }
        if ((mes.getText().startsWith(this.nickname + ":last-target") || mes.getText().startsWith(this.nickname + ":lt")) && (brain = (SOCRobotBrain)this.robotBrains.get(mes.getGame())) != null && brain.getDRecorder().isOn() && (lastTarget = brain.getLastTarget()) != null) {
            key = null;
            switch (lastTarget.getType()) {
                case 4: {
                    key = "DEVCARD";
                    break;
                }
                case 0: {
                    key = "ROAD" + lastTarget.getCoordinates();
                    break;
                }
                case 1: {
                    key = "SETTLEMENT" + lastTarget.getCoordinates();
                    break;
                }
                case 2: {
                    key = "CITY" + lastTarget.getCoordinates();
                }
            }
            record = brain.getDRecorder().getRecord(key);
            if (record != null) {
                ga = (SOCGame)this.games.get(mes.getGame());
                enum1 = record.elements();
                while (enum1.hasMoreElements()) {
                    str = (String)enum1.nextElement();
                    this.sendText(ga, str);
                }
            }
        }
        if ((mes.getText().startsWith(this.nickname + ":consider-target ") || mes.getText().startsWith(this.nickname + ":ct ")) && (brain = (SOCRobotBrain)this.robotBrains.get(mes.getGame())) != null && brain.getDRecorder().isOn()) {
            tokens = mes.getText().split(" ");
            key = null;
            if (tokens[1].trim().equals("card")) {
                key = "DEVCARD";
            } else if (tokens[1].equals("road")) {
                key = "ROAD" + tokens[2].trim();
            } else if (tokens[1].equals("settlement")) {
                key = "SETTLEMENT" + tokens[2].trim();
            } else if (tokens[1].equals("city")) {
                key = "CITY" + tokens[2].trim();
            }
            record = brain.getDRecorder().getRecord(key);
            if (record != null) {
                ga = (SOCGame)this.games.get(mes.getGame());
                enum1 = record.elements();
                while (enum1.hasMoreElements()) {
                    str = (String)enum1.nextElement();
                    this.sendText(ga, str);
                }
            }
        }
        if (mes.getText().startsWith(this.nickname + ":stats")) {
            ga3 = (SOCGame)this.games.get(mes.getGame());
            this.sendText(ga3, "Games played:" + this.gamesPlayed);
            this.sendText(ga3, "Games finished:" + this.gamesFinished);
            this.sendText(ga3, "Games won:" + this.gamesWon);
            this.sendText(ga3, "Clean brain kills:" + this.cleanBrainKills);
            this.sendText(ga3, "Brains running: " + this.robotBrains.size());
            rt = Runtime.getRuntime();
            this.sendText(ga3, "Total Memory:" + rt.totalMemory());
            this.sendText(ga3, "Free Memory:" + rt.freeMemory());
        }
        if (mes.getText().startsWith(this.nickname + ":gc")) {
            ga3 = (SOCGame)this.games.get(mes.getGame());
            rt = Runtime.getRuntime();
            rt.gc();
            this.sendText(ga3, "Free Memory:" + rt.freeMemory());
        }
        if ((brainQ = (CappedQueue)this.brainQs.get(mes.getGame())) != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    @Override
    protected void handleSITDOWN(SOCSitDown mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            ga.addPlayer(mes.getNickname(), mes.getPlayerNumber());
            ga.getPlayer(mes.getPlayerNumber()).setRobotFlag(mes.isRobot());
            if (this.nickname.equals(mes.getNickname())) {
                SOCRobotBrain brain = (SOCRobotBrain)this.robotBrains.get(mes.getGame());
                brain.setOurPlayerData();
                brain.start();
                this.put(SOCChangeFace.toCmd(ga.getName(), mes.getPlayerNumber(), 0));
            }
        }
    }

    @Override
    protected void handleBOARDLAYOUT(SOCBoardLayout mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCBoard bd = ga.getBoard();
            bd.setHexLayout(mes.getHexLayout());
            bd.setNumberLayout(mes.getNumberLayout());
            bd.setRobberHex(mes.getRobberHex());
        }
    }

    @Override
    protected void handleSTARTGAME(SOCStartGame mes) {
    }

    @Override
    protected void handleDELETEGAME(SOCDeleteGame mes) {
        SOCGame ga;
        SOCRobotBrain brain = (SOCRobotBrain)this.robotBrains.get(mes.getGame());
        if (brain != null && (ga = (SOCGame)this.games.get(mes.getGame())) != null) {
            if (ga.getGameState() == 1000) {
                ++this.gamesFinished;
                if (ga.getPlayer(this.nickname).getTotalVP() >= 10) {
                    ++this.gamesWon;
                }
            }
            brain.kill();
            this.robotBrains.remove(mes.getGame());
            this.brainQs.remove(mes.getGame());
            this.games.remove(mes.getGame());
        }
    }

    @Override
    protected void handleGAMESTATE(SOCGameState mes) {
        CappedQueue brainQ;
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null && (brainQ = (CappedQueue)this.brainQs.get(mes.getGame())) != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    @Override
    protected void handleSETTURN(SOCSetTurn mes) {
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    @Override
    protected void handleFIRSTPLAYER(SOCFirstPlayer mes) {
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    @Override
    protected void handleTURN(SOCTurn mes) {
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    @Override
    protected void handlePLAYERELEMENT(SOCPlayerElement mes) {
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    @Override
    protected void handleRESOURCECOUNT(SOCResourceCount mes) {
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    @Override
    protected void handleDICERESULT(SOCDiceResult mes) {
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    @Override
    protected void handlePUTPIECE(SOCPutPiece mes) {
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
            SOCGame ga = (SOCGame)this.games.get(mes.getGame());
            if (ga != null) {
                SOCPlayer pl = ga.getPlayer(mes.getPlayerNumber());
            }
        }
    }

    @Override
    protected void handleMOVEROBBER(SOCMoveRobber mes) {
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    @Override
    protected void handleDISCARDREQUEST(SOCDiscardRequest mes) {
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    @Override
    protected void handleCHOOSEPLAYERREQUEST(SOCChoosePlayerRequest mes) {
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    @Override
    protected void handleMAKEOFFER(SOCMakeOffer mes) {
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    @Override
    protected void handleCLEAROFFER(SOCClearOffer mes) {
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    @Override
    protected void handleREJECTOFFER(SOCRejectOffer mes) {
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    protected void handleACCEPTOFFER(SOCAcceptOffer mes) {
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    @Override
    protected void handleCLEARTRADEMSG(SOCClearTradeMsg mes) {
    }

    @Override
    protected void handleDEVCARDCOUNT(SOCDevCardCount mes) {
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    @Override
    protected void handleDEVCARD(SOCDevCard mes) {
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    @Override
    protected void handleSETPLAYEDDEVCARD(SOCSetPlayedDevCard mes) {
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    protected void handleROBOTDISMISS(SOCRobotDismiss mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (ga != null && brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
            SOCRobotBrain brain = (SOCRobotBrain)this.robotBrains.get(mes.getGame());
            if (brain == null || !brain.isAlive()) {
                this.leaveGame((SOCGame)this.games.get(mes.getGame()));
            }
        }
    }

    @Override
    protected void handlePOTENTIALSETTLEMENTS(SOCPotentialSettlements mes) {
        CappedQueue brainQ = (CappedQueue)this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintln("CutoffExceededException" + exc);
            }
        }
    }

    @Override
    protected void handleCHANGEFACE(SOCChangeFace mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayer player = ga.getPlayer(mes.getPlayerNumber());
            player.setFaceId(mes.getFaceId());
        }
    }

    @Override
    protected void handleLONGESTROAD(SOCLongestRoad mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            if (mes.getPlayerNumber() == -1) {
                ga.setPlayerWithLongestRoad(null);
            } else {
                ga.setPlayerWithLongestRoad(ga.getPlayer(mes.getPlayerNumber()));
            }
        }
    }

    @Override
    protected void handleLARGESTARMY(SOCLargestArmy mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            if (mes.getPlayerNumber() == -1) {
                ga.setPlayerWithLargestArmy(null);
            } else {
                ga.setPlayerWithLargestArmy(ga.getPlayer(mes.getPlayerNumber()));
            }
        }
    }

    @Override
    public void leaveGame(SOCGame ga) {
        if (ga != null) {
            this.robotBrains.remove(ga.getName());
            this.brainQs.remove(ga.getName());
            this.games.remove(ga.getName());
            this.put(SOCLeaveGame.toCmd(this.nickname, this.host, ga.getName()));
        }
    }

    public void addCleanKill() {
        ++this.cleanBrainKills;
    }

    @Override
    public void destroy() {
        SOCLeaveAll leaveAllMes = new SOCLeaveAll();
        this.put(leaveAllMes.toCmd());
        this.disconnectReconnect();
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.err.println("usage: java soc.robot.SOCRobotClient host port_number userid password");
            return;
        }
        SOCRobotClient ex1 = new SOCRobotClient(args[0], Integer.parseInt(args[1]), args[2], args[3]);
        ex1.init();
    }
}

