/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import soc.disableDebug.D;
import soc.game.SOCCity;
import soc.game.SOCGame;
import soc.game.SOCLRPathData;
import soc.game.SOCPlayer;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCSettlement;
import soc.robot.SOCBuildingSpeedEstimate;
import soc.robot.SOCPlayerTracker;
import soc.robot.SOCPossibleCard;
import soc.robot.SOCPossibleCity;
import soc.robot.SOCPossiblePiece;
import soc.robot.SOCPossibleRoad;
import soc.robot.SOCPossibleSettlement;
import soc.robot.SOCResSetBuildTimePair;
import soc.robot.SOCRobotBrain;
import soc.util.CutoffExceededException;
import soc.util.NodeLenVis;
import soc.util.Pair;
import soc.util.Queue;
import soc.util.SOCRobotParameters;

public class SOCRobotDM {
    protected static final DecimalFormat df1 = new DecimalFormat("###0.00");
    protected int maxGameLength = 300;
    protected int maxETA = 99;
    protected float etaBonusFactor = 0.8f;
    protected float adversarialFactor = 1.5f;
    protected float leaderAdversarialFactor = 3.0f;
    protected float devCardMultiplier = 2.0f;
    protected float threatMultiplier = 1.1f;
    protected static final int LA_CHOICE = 0;
    protected static final int LR_CHOICE = 1;
    protected static final int CITY_CHOICE = 2;
    protected static final int SETTLEMENT_CHOICE = 3;
    protected static final int TWO_SETTLEMENTS = 11;
    protected static final int TWO_CITIES = 12;
    protected static final int ONE_OF_EACH = 13;
    protected static final int WIN_LA = 14;
    protected static final int WIN_LR = 15;
    public static final int SMART_STRATEGY = 0;
    public static final int FAST_STRATEGY = 1;
    protected SOCRobotBrain brain;
    protected HashMap playerTrackers;
    protected SOCPlayerTracker ourPlayerTracker;
    protected SOCPlayer ourPlayerData;
    protected Stack buildingPlan;
    protected SOCGame game;
    protected Vector threatenedRoads;
    protected Vector goodRoads;
    protected SOCPossibleRoad favoriteRoad;
    protected Vector threatenedSettlements;
    protected Vector goodSettlements;
    protected SOCPossibleSettlement favoriteSettlement;
    protected SOCPossibleCity favoriteCity;
    protected SOCPossibleCard possibleCard;

    public SOCRobotDM(SOCRobotBrain br) {
        this.brain = br;
        this.playerTrackers = this.brain.getPlayerTrackers();
        this.ourPlayerTracker = this.brain.getOurPlayerTracker();
        this.ourPlayerData = this.brain.getOurPlayerData();
        this.buildingPlan = this.brain.getBuildingPlan();
        this.game = this.brain.getGame();
        this.threatenedRoads = new Vector();
        this.goodRoads = new Vector();
        this.threatenedSettlements = new Vector();
        this.goodSettlements = new Vector();
        SOCRobotParameters params = this.brain.getRobotParameters();
        this.maxGameLength = params.getMaxGameLength();
        this.maxETA = params.getMaxETA();
        this.etaBonusFactor = params.getETABonusFactor();
        this.adversarialFactor = params.getAdversarialFactor();
        this.leaderAdversarialFactor = params.getLeaderAdversarialFactor();
        this.devCardMultiplier = params.getDevCardMultiplier();
        this.threatMultiplier = params.getThreatMultiplier();
    }

    public SOCRobotDM(SOCRobotParameters params, HashMap pt, SOCPlayerTracker opt, SOCPlayer opd, Stack bp) {
        this.brain = null;
        this.playerTrackers = pt;
        this.ourPlayerTracker = opt;
        this.ourPlayerData = opd;
        this.buildingPlan = bp;
        this.game = this.ourPlayerData.getGame();
        this.maxGameLength = params.getMaxGameLength();
        this.maxETA = params.getMaxETA();
        this.etaBonusFactor = params.getETABonusFactor();
        this.adversarialFactor = params.getAdversarialFactor();
        this.leaderAdversarialFactor = params.getLeaderAdversarialFactor();
        this.devCardMultiplier = params.getDevCardMultiplier();
        this.threatMultiplier = params.getThreatMultiplier();
        this.threatenedRoads = new Vector();
        this.goodRoads = new Vector();
        this.threatenedSettlements = new Vector();
        this.goodSettlements = new Vector();
    }

    public SOCPossibleSettlement getFavoriteSettlement() {
        return this.favoriteSettlement;
    }

    public SOCPossibleCity getFavoriteCity() {
        return this.favoriteCity;
    }

    public SOCPossibleRoad getFavoriteRoad() {
        return this.favoriteRoad;
    }

    public SOCPossibleCard getPossibleCard() {
        return this.possibleCard;
    }

    public void planStuff(int strategy) {
        D.ebugPrintln("PLANSTUFF");
        SOCBuildingSpeedEstimate currentBSE = new SOCBuildingSpeedEstimate(this.ourPlayerData.getNumbers());
        int[] currentBuildingETAs = currentBSE.getEstimatesFromNowFast(this.ourPlayerData.getResources(), this.ourPlayerData.getPortFlags());
        this.threatenedSettlements.removeAllElements();
        this.goodSettlements.removeAllElements();
        this.threatenedRoads.removeAllElements();
        this.goodRoads.removeAllElements();
        this.favoriteRoad = null;
        this.favoriteSettlement = null;
        this.favoriteCity = null;
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().eraseAllRecords();
            this.brain.getDRecorder().startRecording("RESOURCES");
            this.brain.getDRecorder().record(this.ourPlayerData.getResources().toShortString());
            this.brain.getDRecorder().stopRecording();
            this.brain.getDRecorder().startRecording("CURRENT_PLANS");
        }
        if (strategy == 0) {
            SOCPlayerTracker.updateWinGameETAs(this.playerTrackers);
        }
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().stopRecording();
        }
        int leadersCurrentWGETA = this.ourPlayerTracker.getWinGameETA();
        for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
            int wgeta = tracker.getWinGameETA();
            if (wgeta >= leadersCurrentWGETA) continue;
            leadersCurrentWGETA = wgeta;
        }
        for (SOCPossiblePiece posPiece : this.ourPlayerTracker.getPossibleCities().values()) {
            posPiece.resetScore();
            posPiece.clearBiggestThreats();
        }
        for (SOCPossiblePiece posPiece : this.ourPlayerTracker.getPossibleSettlements().values()) {
            posPiece.resetScore();
            posPiece.clearBiggestThreats();
        }
        for (SOCPossiblePiece posPiece : this.ourPlayerTracker.getPossibleRoads().values()) {
            posPiece.resetScore();
            posPiece.clearBiggestThreats();
        }
        switch (strategy) {
            case 0: {
                this.smartGameStrategy(currentBuildingETAs);
                break;
            }
            case 1: {
                this.dumbFastGameStrategy(currentBuildingETAs);
            }
        }
        if (strategy == 0 && !this.ourPlayerData.hasPlayedDevCard() && this.ourPlayerData.getNumPieces(0) >= 2 && this.ourPlayerData.getDevCards().getAmount(0, 1) > 0) {
            SOCPossiblePiece secondFavoriteRoad = null;
            D.ebugPrintln("*** making a plan for road building");
            if (this.favoriteRoad != null) {
                float wgetaScore;
                SOCRoad tmpRoad = new SOCRoad(this.ourPlayerData, this.favoriteRoad.getCoordinates());
                HashMap trackersCopy = SOCPlayerTracker.tryPutPiece(tmpRoad, this.game, this.playerTrackers);
                SOCPlayerTracker.updateWinGameETAs(trackersCopy);
                SOCPlayerTracker ourPlayerTrackerCopy = (SOCPlayerTracker)trackersCopy.get(new Integer(this.ourPlayerData.getPlayerNumber()));
                int ourCurrentWGETACopy = ourPlayerTrackerCopy.getWinGameETA();
                D.ebugPrintln("ourCurrentWGETACopy = " + ourCurrentWGETACopy);
                int leadersCurrentWGETACopy = ourCurrentWGETACopy;
                for (SOCPlayerTracker tracker : trackersCopy.values()) {
                    int wgeta = tracker.getWinGameETA();
                    if (wgeta >= leadersCurrentWGETACopy) continue;
                    leadersCurrentWGETACopy = wgeta;
                }
                Enumeration newPosEnum = this.favoriteRoad.getNewPossibilities().elements();
                while (newPosEnum.hasMoreElements()) {
                    SOCPossiblePiece newPos = (SOCPossiblePiece)newPosEnum.nextElement();
                    if (newPos.getType() != 0) continue;
                    newPos.resetScore();
                    wgetaScore = this.getWinGameETABonusForRoad((SOCPossibleRoad)newPos, currentBuildingETAs[0], leadersCurrentWGETACopy, trackersCopy);
                    D.ebugPrintln("$$$ new pos road at " + Integer.toHexString(newPos.getCoordinates()) + " has a score of " + newPos.getScore());
                    if (this.favoriteRoad.getCoordinates() == newPos.getCoordinates()) continue;
                    if (secondFavoriteRoad == null) {
                        secondFavoriteRoad = (SOCPossibleRoad)newPos;
                        continue;
                    }
                    if (!(newPos.getScore() > secondFavoriteRoad.getScore())) continue;
                    secondFavoriteRoad = (SOCPossibleRoad)newPos;
                }
                Enumeration threatenedRoadEnum = this.threatenedRoads.elements();
                while (threatenedRoadEnum.hasMoreElements()) {
                    SOCPossibleRoad threatenedRoad = (SOCPossibleRoad)threatenedRoadEnum.nextElement();
                    D.ebugPrintln("$$$ threatened road at " + Integer.toHexString(threatenedRoad.getCoordinates()));
                    threatenedRoad.resetScore();
                    wgetaScore = this.getWinGameETABonusForRoad(threatenedRoad, currentBuildingETAs[0], leadersCurrentWGETA, this.playerTrackers);
                    D.ebugPrintln("$$$  final score = " + threatenedRoad.getScore());
                    if (this.favoriteRoad.getCoordinates() == threatenedRoad.getCoordinates()) continue;
                    if (secondFavoriteRoad == null) {
                        secondFavoriteRoad = threatenedRoad;
                        continue;
                    }
                    if (!(threatenedRoad.getScore() > secondFavoriteRoad.getScore())) continue;
                    secondFavoriteRoad = threatenedRoad;
                }
                Enumeration goodRoadEnum = this.goodRoads.elements();
                while (goodRoadEnum.hasMoreElements()) {
                    SOCPossibleRoad goodRoad = (SOCPossibleRoad)goodRoadEnum.nextElement();
                    D.ebugPrintln("$$$ good road at " + Integer.toHexString(goodRoad.getCoordinates()));
                    goodRoad.resetScore();
                    wgetaScore = this.getWinGameETABonusForRoad(goodRoad, currentBuildingETAs[0], leadersCurrentWGETA, this.playerTrackers);
                    D.ebugPrintln("$$$  final score = " + goodRoad.getScore());
                    if (this.favoriteRoad.getCoordinates() == goodRoad.getCoordinates()) continue;
                    if (secondFavoriteRoad == null) {
                        secondFavoriteRoad = goodRoad;
                        continue;
                    }
                    if (!(goodRoad.getScore() > secondFavoriteRoad.getScore())) continue;
                    secondFavoriteRoad = goodRoad;
                }
                SOCPlayerTracker.undoTryPutPiece(tmpRoad, this.game);
                if (!this.buildingPlan.empty()) {
                    SOCPossiblePiece planPeek = (SOCPossiblePiece)this.buildingPlan.peek();
                    if (planPeek == null || planPeek.getType() != 0) {
                        if (secondFavoriteRoad != null) {
                            D.ebugPrintln("### SECOND FAVORITE ROAD IS AT " + Integer.toHexString(secondFavoriteRoad.getCoordinates()));
                            D.ebugPrintln("###   WITH A SCORE OF " + secondFavoriteRoad.getScore());
                            D.ebugPrintln("$ PUSHING " + secondFavoriteRoad);
                            this.buildingPlan.push(secondFavoriteRoad);
                            D.ebugPrintln("$ PUSHING " + this.favoriteRoad);
                            this.buildingPlan.push(this.favoriteRoad);
                        }
                    } else if (secondFavoriteRoad != null) {
                        SOCPossiblePiece tmp = (SOCPossiblePiece)this.buildingPlan.pop();
                        D.ebugPrintln("$ POPPED OFF");
                        D.ebugPrintln("### SECOND FAVORITE ROAD IS AT " + Integer.toHexString(secondFavoriteRoad.getCoordinates()));
                        D.ebugPrintln("###   WITH A SCORE OF " + secondFavoriteRoad.getScore());
                        D.ebugPrintln("$ PUSHING " + secondFavoriteRoad);
                        this.buildingPlan.push(secondFavoriteRoad);
                        D.ebugPrintln("$ PUSHING " + tmp);
                        this.buildingPlan.push(tmp);
                    }
                }
            }
        }
    }

    protected void dumbFastGameStrategy(int[] buildingETAs) {
        D.ebugPrintln("***** dumbFastGameStrategy *****");
        int bestETA = 500;
        SOCBuildingSpeedEstimate ourBSE = new SOCBuildingSpeedEstimate(this.ourPlayerData.getNumbers());
        if (this.ourPlayerData.getTotalVP() < 5) {
            if (this.ourPlayerData.getNumPieces(2) > 0) {
                for (SOCPossibleCity posCity : this.ourPlayerTracker.getPossibleCities().values()) {
                    D.ebugPrintln("Estimate speedup of city at " + this.game.getBoard().nodeCoordToString(posCity.getCoordinates()));
                    D.ebugPrintln("Speedup = " + posCity.getSpeedupTotal());
                    D.ebugPrintln("ETA = " + buildingETAs[2]);
                    if (this.brain != null && this.brain.getDRecorder().isOn()) {
                        this.brain.getDRecorder().startRecording("CITY" + posCity.getCoordinates());
                        this.brain.getDRecorder().record("Estimate speedup of city at " + this.game.getBoard().nodeCoordToString(posCity.getCoordinates()));
                        this.brain.getDRecorder().record("Speedup = " + posCity.getSpeedupTotal());
                        this.brain.getDRecorder().record("ETA = " + buildingETAs[2]);
                        this.brain.getDRecorder().stopRecording();
                    }
                    if (this.favoriteCity != null && posCity.getSpeedupTotal() <= this.favoriteCity.getSpeedupTotal()) continue;
                    this.favoriteCity = posCity;
                    bestETA = buildingETAs[2];
                }
            }
            this.scoreSettlementsForDumb(buildingETAs[1], ourBSE);
            for (SOCPossibleSettlement posSet : this.ourPlayerTracker.getPossibleSettlements().values()) {
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().startRecording("SETTLEMENT" + posSet.getCoordinates());
                    this.brain.getDRecorder().record("Estimate speedup of stlmt at " + this.game.getBoard().nodeCoordToString(posSet.getCoordinates()));
                    this.brain.getDRecorder().record("Speedup = " + posSet.getSpeedupTotal());
                    this.brain.getDRecorder().record("ETA = " + posSet.getETA());
                    Stack roadPath = posSet.getRoadPath();
                    if (roadPath != null) {
                        this.brain.getDRecorder().record("Path:");
                        for (SOCPossibleRoad posRoad : roadPath) {
                            this.brain.getDRecorder().record("Road at " + this.game.getBoard().edgeCoordToString(posRoad.getCoordinates()));
                        }
                    }
                    this.brain.getDRecorder().stopRecording();
                }
                if (posSet.getETA() < bestETA) {
                    bestETA = posSet.getETA();
                    this.favoriteSettlement = posSet;
                    continue;
                }
                if (posSet.getETA() != bestETA) continue;
                if (this.favoriteSettlement == null) {
                    if (this.favoriteCity != null && posSet.getSpeedupTotal() <= this.favoriteCity.getSpeedupTotal()) continue;
                    this.favoriteSettlement = posSet;
                    continue;
                }
                if (posSet.getSpeedupTotal() <= this.favoriteSettlement.getSpeedupTotal()) continue;
                this.favoriteSettlement = posSet;
            }
            if (this.favoriteSettlement != null) {
                D.ebugPrintln("Picked favorite settlement at " + this.game.getBoard().nodeCoordToString(this.favoriteSettlement.getCoordinates()));
                this.buildingPlan.push(this.favoriteSettlement);
                if (!this.favoriteSettlement.getNecessaryRoads().isEmpty()) {
                    Stack roadPath = this.favoriteSettlement.getRoadPath();
                    while (!roadPath.empty()) {
                        this.buildingPlan.push(roadPath.pop());
                    }
                }
            } else if (this.favoriteCity != null) {
                D.ebugPrintln("Picked favorite city at " + this.game.getBoard().nodeCoordToString(this.favoriteCity.getCoordinates()));
                this.buildingPlan.push(this.favoriteCity);
            } else if (this.game.getNumDevCards() > 0) {
                D.ebugPrintln("Buy a card");
                SOCPossibleCard posCard = new SOCPossibleCard(this.ourPlayerData, buildingETAs[3]);
                this.buildingPlan.push(posCard);
            }
        } else {
            int choice = -1;
            D.ebugPrintln("Calculating Largest Army ETA");
            int laETA = 500;
            int laSize = 0;
            SOCPlayer laPlayer = this.game.getPlayerWithLargestArmy();
            if (laPlayer == null) {
                laSize = 3;
            } else if (laPlayer.getPlayerNumber() == this.ourPlayerData.getPlayerNumber()) {
                D.ebugPrintln("We have largest army");
            } else {
                laSize = laPlayer.getNumKnights() + 1;
            }
            int knightsToBuy = 0;
            if (this.ourPlayerData.getNumKnights() + this.ourPlayerData.getDevCards().getAmount(0, 0) + this.ourPlayerData.getDevCards().getAmount(1, 0) < laSize) {
                knightsToBuy = laSize - (this.ourPlayerData.getNumKnights() + this.ourPlayerData.getDevCards().getAmount(0, 0));
            }
            D.ebugPrintln("knightsToBuy = " + knightsToBuy);
            if (this.ourPlayerData.getGame().getNumDevCards() >= knightsToBuy) {
                SOCResourceSet targetResources = new SOCResourceSet();
                for (int i = 0; i < knightsToBuy; ++i) {
                    targetResources.add(SOCGame.CARD_SET);
                }
                try {
                    SOCResSetBuildTimePair timePair = ourBSE.calculateRollsFast(this.ourPlayerData.getResources(), targetResources, 100, this.ourPlayerData.getPortFlags());
                    laETA = timePair.getRolls();
                }
                catch (CutoffExceededException ex) {
                    laETA = 100;
                }
            }
            if (laETA < bestETA) {
                bestETA = laETA;
                choice = 0;
            }
            D.ebugPrintln("laETA = " + laETA);
            D.ebugPrintln("Calculating Longest Road ETA");
            int lrETA = 500;
            Vector bestLRPath = null;
            SOCPlayer lrPlayer = this.game.getPlayerWithLongestRoad();
            if (lrPlayer != null && lrPlayer.getPlayerNumber() == this.ourPlayerData.getPlayerNumber()) {
                D.ebugPrintln("We have longest road");
            } else {
                int lrLength = lrPlayer == null ? Math.max(4, this.ourPlayerData.getLongestRoadLength()) : lrPlayer.getLongestRoadLength();
                for (SOCLRPathData pathData : this.ourPlayerData.getLRPaths()) {
                    int depth = Math.min(lrLength + 1 - pathData.getLength(), this.ourPlayerData.getNumPieces(0));
                    Stack path = this.recalcLongestRoadETAAux(pathData.getBeginning(), pathData.getLength(), lrLength, depth);
                    if (path != null && (bestLRPath == null || path.size() < bestLRPath.size())) {
                        bestLRPath = path;
                    }
                    if ((path = this.recalcLongestRoadETAAux(pathData.getEnd(), pathData.getLength(), lrLength, depth)) == null || bestLRPath != null && path.size() >= bestLRPath.size()) continue;
                    bestLRPath = path;
                }
                if (bestLRPath != null) {
                    D.ebugPrintln("Number of roads: " + bestLRPath.size());
                    SOCResourceSet targetResources = new SOCResourceSet();
                    for (int i = 0; i < bestLRPath.size(); ++i) {
                        targetResources.add(SOCGame.ROAD_SET);
                    }
                    try {
                        SOCResSetBuildTimePair timePair = ourBSE.calculateRollsFast(this.ourPlayerData.getResources(), targetResources, 100, this.ourPlayerData.getPortFlags());
                        lrETA = timePair.getRolls();
                    }
                    catch (CutoffExceededException ex) {
                        lrETA = 100;
                    }
                }
            }
            if (lrETA < bestETA) {
                bestETA = lrETA;
                choice = 1;
            }
            D.ebugPrintln("lrETA = " + lrETA);
            if (this.ourPlayerData.getNumPieces(2) > 0 && buildingETAs[2] <= bestETA) {
                for (SOCPossibleCity posCity : this.ourPlayerTracker.getPossibleCities().values()) {
                    if (this.brain != null && this.brain.getDRecorder().isOn()) {
                        this.brain.getDRecorder().startRecording("CITY" + posCity.getCoordinates());
                        this.brain.getDRecorder().record("Estimate speedup of city at " + this.game.getBoard().nodeCoordToString(posCity.getCoordinates()));
                        this.brain.getDRecorder().record("Speedup = " + posCity.getSpeedupTotal());
                        this.brain.getDRecorder().record("ETA = " + buildingETAs[2]);
                        this.brain.getDRecorder().stopRecording();
                    }
                    if (this.favoriteCity != null && posCity.getSpeedupTotal() <= this.favoriteCity.getSpeedupTotal()) continue;
                    this.favoriteCity = posCity;
                    bestETA = buildingETAs[2];
                    choice = 2;
                }
            }
            if (this.ourPlayerData.getNumPieces(1) > 0) {
                this.scoreSettlementsForDumb(buildingETAs[1], ourBSE);
                for (SOCPossibleSettlement posSet : this.ourPlayerTracker.getPossibleSettlements().values()) {
                    if (this.brain != null && this.brain.getDRecorder().isOn()) {
                        this.brain.getDRecorder().startRecording("SETTLEMENT" + posSet.getCoordinates());
                        this.brain.getDRecorder().record("Estimate speedup of stlmt at " + this.game.getBoard().nodeCoordToString(posSet.getCoordinates()));
                        this.brain.getDRecorder().record("Speedup = " + posSet.getSpeedupTotal());
                        this.brain.getDRecorder().record("ETA = " + posSet.getETA());
                        Stack roadPath = posSet.getRoadPath();
                        if (roadPath != null) {
                            this.brain.getDRecorder().record("Path:");
                            for (SOCPossibleRoad posRoad : roadPath) {
                                this.brain.getDRecorder().record("Road at " + this.game.getBoard().edgeCoordToString(posRoad.getCoordinates()));
                            }
                        }
                        this.brain.getDRecorder().stopRecording();
                    }
                    if (posSet.getRoadPath() != null && this.ourPlayerData.getNumPieces(0) < posSet.getRoadPath().size()) continue;
                    if (posSet.getETA() < bestETA) {
                        bestETA = posSet.getETA();
                        this.favoriteSettlement = posSet;
                        choice = 3;
                        continue;
                    }
                    if (posSet.getETA() != bestETA) continue;
                    if (this.favoriteSettlement == null) {
                        if (this.favoriteCity != null && posSet.getSpeedupTotal() <= this.favoriteCity.getSpeedupTotal()) continue;
                        this.favoriteSettlement = posSet;
                        choice = 3;
                        continue;
                    }
                    if (posSet.getSpeedupTotal() <= this.favoriteSettlement.getSpeedupTotal()) continue;
                    this.favoriteSettlement = posSet;
                }
            }
            switch (choice) {
                case 0: {
                    D.ebugPrintln("Picked LA");
                    for (int i = 0; i < knightsToBuy; ++i) {
                        SOCPossibleCard posCard = new SOCPossibleCard(this.ourPlayerData, 1);
                        this.buildingPlan.push(posCard);
                    }
                    break;
                }
                case 1: {
                    D.ebugPrintln("Picked LR");
                    while (!((Stack)bestLRPath).empty()) {
                        SOCPossibleRoad pr = (SOCPossibleRoad)((Stack)bestLRPath).pop();
                        D.ebugPrintln("LR road at " + this.game.getBoard().edgeCoordToString(pr.getCoordinates()));
                        this.buildingPlan.push(pr);
                    }
                    break;
                }
                case 2: {
                    D.ebugPrintln("Picked favorite city at " + this.game.getBoard().nodeCoordToString(this.favoriteCity.getCoordinates()));
                    this.buildingPlan.push(this.favoriteCity);
                    break;
                }
                case 3: {
                    D.ebugPrintln("Picked favorite settlement at " + this.game.getBoard().nodeCoordToString(this.favoriteSettlement.getCoordinates()));
                    this.buildingPlan.push(this.favoriteSettlement);
                    if (this.favoriteSettlement.getNecessaryRoads().isEmpty()) break;
                    Stack roadPath = this.favoriteSettlement.getRoadPath();
                    while (!roadPath.empty()) {
                        SOCPossibleRoad pr = (SOCPossibleRoad)roadPath.pop();
                        D.ebugPrintln("Nec road at " + this.game.getBoard().edgeCoordToString(pr.getCoordinates()));
                        this.buildingPlan.push(pr);
                    }
                    break;
                }
            }
        }
    }

    protected void scoreSettlementsForDumb(int settlementETA, SOCBuildingSpeedEstimate ourBSE) {
        D.ebugPrintln("-- scoreSettlementsForDumb --");
        Queue queue = new Queue();
        for (SOCPossibleSettlement posSet : this.ourPlayerTracker.getPossibleSettlements().values()) {
            D.ebugPrintln("Estimate speedup of stlmt at " + this.game.getBoard().nodeCoordToString(posSet.getCoordinates()));
            D.ebugPrintln("***    speedup total = " + posSet.getSpeedupTotal());
            Vector necRoadVec = posSet.getNecessaryRoads();
            if (!necRoadVec.isEmpty()) {
                queue.clear();
                for (SOCPossibleRoad necRoad : necRoadVec) {
                    D.ebugPrintln("-- queuing necessary road at " + this.game.getBoard().edgeCoordToString(necRoad.getCoordinates()));
                    queue.put(new Pair(necRoad, null));
                }
                while (!queue.empty()) {
                    Pair dataPair = (Pair)queue.get();
                    SOCPossibleRoad curRoad = (SOCPossibleRoad)dataPair.getA();
                    D.ebugPrintln("-- current road at " + this.game.getBoard().edgeCoordToString(curRoad.getCoordinates()));
                    Vector necRoads = curRoad.getNecessaryRoads();
                    if (necRoads.isEmpty()) {
                        Pair curPair;
                        D.ebugPrintln("Found a path!");
                        Stack<Object> path = new Stack<Object>();
                        path.push(curRoad);
                        D.ebugPrintln("curPair = " + curPair);
                        for (curPair = (Pair)dataPair.getB(); curPair != null; curPair = (Pair)curPair.getB()) {
                            path.push(curPair.getA());
                        }
                        posSet.setRoadPath(path);
                        queue.clear();
                        D.ebugPrintln("Done setting path.");
                        continue;
                    }
                    for (SOCPossibleRoad necRoad2 : necRoads) {
                        D.ebugPrintln("-- queuing necessary road at " + this.game.getBoard().edgeCoordToString(necRoad2.getCoordinates()));
                        queue.put(new Pair(necRoad2, dataPair));
                    }
                }
                D.ebugPrintln("Done searching for path.");
                SOCResourceSet targetResources = new SOCResourceSet();
                targetResources.add(SOCGame.SETTLEMENT_SET);
                int pathLength = 0;
                Stack path = posSet.getRoadPath();
                if (path != null) {
                    pathLength = path.size();
                }
                for (int i = 0; i < pathLength; ++i) {
                    targetResources.add(SOCGame.ROAD_SET);
                }
                try {
                    SOCResSetBuildTimePair timePair = ourBSE.calculateRollsFast(this.ourPlayerData.getResources(), targetResources, 100, this.ourPlayerData.getPortFlags());
                    posSet.setETA(timePair.getRolls());
                }
                catch (CutoffExceededException ex) {
                    posSet.setETA(100);
                }
            } else {
                posSet.setRoadPath(null);
                posSet.setETA(settlementETA);
            }
            D.ebugPrintln("Settlement ETA = " + posSet.getETA());
        }
    }

    private Stack recalcLongestRoadETAAux(int startNode, int pathLength, int lrLength, int searchDepth) {
        D.ebugPrintln("=== recalcLongestRoadETAAux(" + Integer.toHexString(startNode) + "," + pathLength + "," + lrLength + "," + searchDepth + ")");
        int longest = 0;
        int numRoads = 500;
        Pair bestPathNode = null;
        Stack<Pair> pending = new Stack<Pair>();
        pending.push(new Pair(new NodeLenVis(startNode, pathLength, new Vector()), null));
        while (!pending.empty()) {
            Pair dataPair = (Pair)pending.pop();
            NodeLenVis curNode = (NodeLenVis)dataPair.getA();
            D.ebugPrintln("curNode = " + curNode);
            int coord = curNode.node;
            int len = curNode.len;
            Vector visited = curNode.vis;
            boolean pathEnd = false;
            Enumeration pEnum = this.game.getBoard().getPieces().elements();
            while (pEnum.hasMoreElements()) {
                SOCPlayingPiece p = (SOCPlayingPiece)pEnum.nextElement();
                if (len <= 0 || p.getPlayer().getPlayerNumber() == this.ourPlayerData.getPlayerNumber() || p.getType() != 1 && p.getType() != 2 || p.getCoordinates() != coord) continue;
                pathEnd = true;
                D.ebugPrintln("^^^ path end at " + Integer.toHexString(coord));
                break;
            }
            if (!pathEnd) {
                for (SOCLRPathData pathData : this.ourPlayerData.getLRPaths()) {
                    if (startNode == pathData.getBeginning() || startNode == pathData.getEnd() || coord != pathData.getBeginning() && coord != pathData.getEnd()) continue;
                    pathEnd = true;
                    D.ebugPrintln("connecting to another path: " + pathData);
                    D.ebugPrintln("len = " + (len += pathData.getLength()));
                    break;
                }
            }
            if (!pathEnd) {
                if (len - pathLength >= searchDepth) {
                    pathEnd = true;
                }
                D.ebugPrintln("Reached search depth");
            }
            if (!pathEnd) {
                Vector newVis;
                Integer vis;
                Enumeration ev;
                pathEnd = true;
                int j = coord - 17;
                Integer edge = new Integer(j);
                boolean match = false;
                if (j >= 34 && j <= 204 && this.ourPlayerData.isLegalRoad(j)) {
                    ev = visited.elements();
                    while (ev.hasMoreElements()) {
                        vis = (Integer)ev.nextElement();
                        if (!vis.equals(edge)) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        newVis = (Vector)visited.clone();
                        newVis.addElement(edge);
                        pending.push(new Pair(new NodeLenVis(j, len + 1, newVis), dataPair));
                        pathEnd = false;
                    }
                }
                j = coord;
                edge = new Integer(j);
                match = false;
                if (j >= 34 && j <= 204 && this.ourPlayerData.isLegalRoad(j)) {
                    ev = visited.elements();
                    while (ev.hasMoreElements()) {
                        vis = (Integer)ev.nextElement();
                        if (!vis.equals(edge)) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        newVis = (Vector)visited.clone();
                        newVis.addElement(edge);
                        pending.push(new Pair(new NodeLenVis(j += 17, len + 1, newVis), dataPair));
                        pathEnd = false;
                    }
                }
                j = coord - 1;
                edge = new Integer(j);
                match = false;
                if (j >= 34 && j <= 204 && this.ourPlayerData.isLegalRoad(j)) {
                    ev = visited.elements();
                    while (ev.hasMoreElements()) {
                        vis = (Integer)ev.nextElement();
                        if (!vis.equals(edge)) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        newVis = (Vector)visited.clone();
                        newVis.addElement(edge);
                        pending.push(new Pair(new NodeLenVis(j += 16, len + 1, newVis), dataPair));
                        pathEnd = false;
                    }
                }
                j = coord - 16;
                edge = new Integer(j);
                match = false;
                if (j >= 34 && j <= 204 && this.ourPlayerData.isLegalRoad(j)) {
                    ev = visited.elements();
                    while (ev.hasMoreElements()) {
                        vis = (Integer)ev.nextElement();
                        if (!vis.equals(edge)) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        newVis = (Vector)visited.clone();
                        newVis.addElement(edge);
                        pending.push(new Pair(new NodeLenVis(++j, len + 1, newVis), dataPair));
                        pathEnd = false;
                    }
                }
            }
            if (!pathEnd) continue;
            if (len > longest) {
                longest = len;
                numRoads = curNode.len - pathLength;
                bestPathNode = dataPair;
                continue;
            }
            if (len != longest || curNode.len >= numRoads) continue;
            numRoads = curNode.len - pathLength;
            bestPathNode = dataPair;
        }
        if (longest > lrLength && bestPathNode != null) {
            D.ebugPrintln("Converting nodes to road coords.");
            Stack<SOCPossibleRoad> temp = new Stack<SOCPossibleRoad>();
            Pair cur = bestPathNode;
            for (Pair parent = (Pair)bestPathNode.getB(); parent != null; parent = (Pair)parent.getB()) {
                SOCPossibleRoad posRoad;
                int coordA = ((NodeLenVis)cur.getA()).node;
                int coordB = ((NodeLenVis)parent.getA()).node;
                int test = coordA - coordB;
                if (test == 17) {
                    D.ebugPrintln(this.game.getBoard().nodeCoordToString(coordB));
                    posRoad = new SOCPossibleRoad(this.ourPlayerData, coordB, new Vector());
                } else if (test == -17) {
                    D.ebugPrintln(this.game.getBoard().nodeCoordToString(coordA));
                    posRoad = new SOCPossibleRoad(this.ourPlayerData, coordA, new Vector());
                } else if (test == 15) {
                    D.ebugPrintln(this.game.getBoard().nodeCoordToString(coordA - 16));
                    posRoad = new SOCPossibleRoad(this.ourPlayerData, coordA - 16, new Vector());
                } else {
                    D.ebugPrintln(this.game.getBoard().nodeCoordToString(coordA - 1));
                    posRoad = new SOCPossibleRoad(this.ourPlayerData, coordA - 1, new Vector());
                }
                temp.push(posRoad);
                cur = parent;
            }
            Stack path = new Stack();
            while (!temp.empty()) {
                path.push(temp.pop());
            }
            return path;
        }
        return null;
    }

    protected void smartGameStrategy(int[] buildingETAs) {
        D.ebugPrintln("***** smartGameStrategy *****");
        Vector[] savedLRPaths = new Vector[4];
        for (int pn = 0; pn < 4; ++pn) {
            savedLRPaths[pn] = (Vector)this.game.getPlayer(pn).getLRPaths().clone();
        }
        int ourCurrentWGETA = this.ourPlayerTracker.getWinGameETA();
        D.ebugPrintln("ourCurrentWGETA = " + ourCurrentWGETA);
        int leadersCurrentWGETA = ourCurrentWGETA;
        for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
            int wgeta = tracker.getWinGameETA();
            if (wgeta >= leadersCurrentWGETA) continue;
            leadersCurrentWGETA = wgeta;
        }
        boolean goingToPlayRB = false;
        if (!this.ourPlayerData.hasPlayedDevCard() && this.ourPlayerData.getNumPieces(0) >= 2 && this.ourPlayerData.getDevCards().getAmount(0, 1) > 0) {
            goingToPlayRB = true;
        }
        if (this.ourPlayerData.getNumPieces(1) > 0) {
            this.scorePossibleSettlements(buildingETAs[1], leadersCurrentWGETA);
        }
        if (this.ourPlayerData.getNumPieces(0) > 0) {
            for (SOCPossibleRoad posRoad : this.ourPlayerTracker.getPossibleRoads().values()) {
                if (!posRoad.getNecessaryRoads().isEmpty() || this.threatenedRoads.contains(posRoad) || this.goodRoads.contains(posRoad)) continue;
                this.goodRoads.addElement(posRoad);
            }
        }
        D.ebugPrintln("PICKING WHAT TO BUILD");
        if (this.ourPlayerData.getNumPieces(1) > 0) {
            for (SOCPossibleSettlement threatenedSet : this.threatenedSettlements) {
                if (!threatenedSet.getNecessaryRoads().isEmpty()) continue;
                D.ebugPrintln("$$$$$ threatened settlement at " + Integer.toHexString(threatenedSet.getCoordinates()) + " has a score of " + threatenedSet.getScore());
                if (this.favoriteSettlement != null && !(threatenedSet.getScore() > this.favoriteSettlement.getScore())) continue;
                this.favoriteSettlement = threatenedSet;
            }
            for (SOCPossibleSettlement goodSet : this.goodSettlements) {
                if (!goodSet.getNecessaryRoads().isEmpty()) continue;
                D.ebugPrintln("$$$$$ good settlement at " + Integer.toHexString(goodSet.getCoordinates()) + " has a score of " + goodSet.getScore());
                if (this.favoriteSettlement != null && !(goodSet.getScore() > this.favoriteSettlement.getScore())) continue;
                this.favoriteSettlement = goodSet;
            }
        }
        D.ebugPrintln("%%% RESTORING LRPATH LIST %%%");
        for (int pn = 0; pn < 4; ++pn) {
            this.game.getPlayer(pn).setLRPaths(savedLRPaths[pn]);
        }
        if (this.ourPlayerData.getNumPieces(0) > 0) {
            for (SOCPossibleRoad threatenedRoad : this.threatenedRoads) {
                D.ebugPrintln("$$$$$ threatened road at " + Integer.toHexString(threatenedRoad.getCoordinates()));
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().startRecording("ROAD" + threatenedRoad.getCoordinates());
                    this.brain.getDRecorder().record("Estimate value of road at " + this.game.getBoard().edgeCoordToString(threatenedRoad.getCoordinates()));
                }
                threatenedRoad.resetScore();
                float wgetaScore = this.getWinGameETABonusForRoad(threatenedRoad, buildingETAs[0], leadersCurrentWGETA, this.playerTrackers);
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().stopRecording();
                }
                D.ebugPrintln("wgetaScore = " + wgetaScore);
                if (this.favoriteRoad == null) {
                    this.favoriteRoad = threatenedRoad;
                    continue;
                }
                if (!(threatenedRoad.getScore() > this.favoriteRoad.getScore())) continue;
                this.favoriteRoad = threatenedRoad;
            }
            for (SOCPossibleRoad goodRoad : this.goodRoads) {
                D.ebugPrintln("$$$$$ good road at " + Integer.toHexString(goodRoad.getCoordinates()));
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().startRecording("ROAD" + goodRoad.getCoordinates());
                    this.brain.getDRecorder().record("Estimate value of road at " + this.game.getBoard().edgeCoordToString(goodRoad.getCoordinates()));
                }
                goodRoad.resetScore();
                float wgetaScore = this.getWinGameETABonusForRoad(goodRoad, buildingETAs[0], leadersCurrentWGETA, this.playerTrackers);
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().stopRecording();
                }
                D.ebugPrintln("wgetaScore = " + wgetaScore);
                if (this.favoriteRoad == null) {
                    this.favoriteRoad = goodRoad;
                    continue;
                }
                if (!(goodRoad.getScore() > this.favoriteRoad.getScore())) continue;
                this.favoriteRoad = goodRoad;
            }
        }
        D.ebugPrintln("%%% RESTORING LRPATH LIST %%%");
        for (int pn = 0; pn < 4; ++pn) {
            this.game.getPlayer(pn).setLRPaths(savedLRPaths[pn]);
        }
        if (this.ourPlayerData.getNumPieces(2) > 0) {
            HashMap trackersCopy = SOCPlayerTracker.copyPlayerTrackers(this.playerTrackers);
            SOCPlayerTracker ourTrackerCopy = (SOCPlayerTracker)trackersCopy.get(new Integer(this.ourPlayerData.getPlayerNumber()));
            int[] originalWGETAs = new int[4];
            int[] WGETAdiffs = new int[4];
            Vector<SOCPlayerTracker> leaders = new Vector<SOCPlayerTracker>();
            int bestWGETA = 1000;
            boolean bonus = false;
            for (SOCPossibleCity posCity : this.ourPlayerTracker.getPossibleCities().values()) {
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().startRecording("CITY" + posCity.getCoordinates());
                    this.brain.getDRecorder().record("Estimate value of city at " + this.game.getBoard().nodeCoordToString(posCity.getCoordinates()));
                }
                leaders.clear();
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().suspend();
                }
                SOCPlayerTracker.updateWinGameETAs(trackersCopy);
                for (SOCPlayerTracker trackerBefore : trackersCopy.values()) {
                    D.ebugPrintln("$$$ win game ETA for player " + trackerBefore.getPlayer().getPlayerNumber() + " = " + trackerBefore.getWinGameETA());
                    originalWGETAs[trackerBefore.getPlayer().getPlayerNumber()] = trackerBefore.getWinGameETA();
                    WGETAdiffs[trackerBefore.getPlayer().getPlayerNumber()] = trackerBefore.getWinGameETA();
                    if (trackerBefore.getWinGameETA() < bestWGETA) {
                        bestWGETA = trackerBefore.getWinGameETA();
                        leaders.removeAllElements();
                        leaders.addElement(trackerBefore);
                        continue;
                    }
                    if (trackerBefore.getWinGameETA() != bestWGETA) continue;
                    leaders.addElement(trackerBefore);
                }
                D.ebugPrintln("^^^^ bestWGETA = " + bestWGETA);
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().resume();
                }
                SOCCity tmpCity = new SOCCity(this.ourPlayerData, posCity.getCoordinates());
                this.game.putTempPiece(tmpCity);
                ourTrackerCopy.addOurNewCity(tmpCity);
                SOCPlayerTracker.updateWinGameETAs(trackersCopy);
                float wgetaScore = this.calcWGETABonusAux(originalWGETAs, trackersCopy, leaders);
                ourTrackerCopy.undoAddOurNewCity(posCity);
                this.game.undoPutTempPiece(tmpCity);
                D.ebugPrintln("*** ETA for city = " + buildingETAs[2]);
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().record("ETA = " + buildingETAs[2]);
                }
                float etaBonus = this.getETABonus(buildingETAs[2], leadersCurrentWGETA, wgetaScore);
                D.ebugPrintln("etaBonus = " + etaBonus);
                posCity.addToScore(etaBonus);
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().record("WGETA score = " + df1.format(wgetaScore));
                    this.brain.getDRecorder().record("Total city score = " + df1.format(etaBonus));
                    this.brain.getDRecorder().stopRecording();
                }
                D.ebugPrintln("$$$  final score = " + posCity.getScore());
                D.ebugPrintln("$$$$$ possible city at " + Integer.toHexString(posCity.getCoordinates()) + " has a score of " + posCity.getScore());
                if (this.favoriteCity != null && !(posCity.getScore() > this.favoriteCity.getScore())) continue;
                this.favoriteCity = posCity;
            }
        }
        if (this.favoriteSettlement != null) {
            D.ebugPrintln("### FAVORITE SETTLEMENT IS AT " + Integer.toHexString(this.favoriteSettlement.getCoordinates()));
            D.ebugPrintln("###   WITH A SCORE OF " + this.favoriteSettlement.getScore());
            D.ebugPrintln("###   WITH AN ETA OF " + buildingETAs[1]);
            D.ebugPrintln("###   WITH A TOTAL SPEEDUP OF " + this.favoriteSettlement.getSpeedupTotal());
        }
        if (this.favoriteCity != null) {
            D.ebugPrintln("### FAVORITE CITY IS AT " + Integer.toHexString(this.favoriteCity.getCoordinates()));
            D.ebugPrintln("###   WITH A SCORE OF " + this.favoriteCity.getScore());
            D.ebugPrintln("###   WITH AN ETA OF " + buildingETAs[2]);
            D.ebugPrintln("###   WITH A TOTAL SPEEDUP OF " + this.favoriteCity.getSpeedupTotal());
        }
        if (this.favoriteRoad != null) {
            D.ebugPrintln("### FAVORITE ROAD IS AT " + Integer.toHexString(this.favoriteRoad.getCoordinates()));
            D.ebugPrintln("###   WITH AN ETA OF " + buildingETAs[0]);
            D.ebugPrintln("###   WITH A SCORE OF " + this.favoriteRoad.getScore());
        }
        int pick = -1;
        if (this.favoriteCity != null && this.ourPlayerData.getNumPieces(2) > 0 && this.favoriteCity.getScore() > 0.0f && (this.favoriteSettlement == null || this.ourPlayerData.getNumPieces(1) == 0 || this.favoriteCity.getScore() > this.favoriteSettlement.getScore() || this.favoriteCity.getScore() == this.favoriteSettlement.getScore() && buildingETAs[2] < buildingETAs[1]) && (this.favoriteRoad == null || this.ourPlayerData.getNumPieces(0) == 0 || this.favoriteCity.getScore() > this.favoriteRoad.getScore() || this.favoriteCity.getScore() == this.favoriteRoad.getScore() && buildingETAs[2] < buildingETAs[0])) {
            D.ebugPrintln("### PICKED FAVORITE CITY");
            pick = 2;
            D.ebugPrintln("$ PUSHING " + this.favoriteCity);
            this.buildingPlan.push(this.favoriteCity);
        } else if (this.favoriteRoad != null && this.ourPlayerData.getNumPieces(0) > 0 && this.favoriteRoad.getScore() > 0.0f && (this.favoriteSettlement == null || this.ourPlayerData.getNumPieces(1) == 0 || this.favoriteSettlement.getScore() < this.favoriteRoad.getScore())) {
            D.ebugPrintln("### PICKED FAVORITE ROAD");
            pick = 0;
            D.ebugPrintln("$ PUSHING " + this.favoriteRoad);
            this.buildingPlan.push(this.favoriteRoad);
        } else if (this.favoriteSettlement != null && this.ourPlayerData.getNumPieces(1) > 0) {
            D.ebugPrintln("### PICKED FAVORITE SETTLEMENT");
            pick = 1;
            D.ebugPrintln("$ PUSHING " + this.favoriteSettlement);
            this.buildingPlan.push(this.favoriteSettlement);
        }
        if (this.game.getNumDevCards() > 0) {
            if (this.brain != null && this.brain.getDRecorder().isOn()) {
                this.brain.getDRecorder().startRecording("DEVCARD");
                this.brain.getDRecorder().record("Estimate value of a dev card");
            }
            this.possibleCard = this.getDevCardScore(buildingETAs[3], leadersCurrentWGETA);
            float devCardScore = this.possibleCard.getScore();
            D.ebugPrintln("### DEV CARD SCORE: " + devCardScore);
            if (this.brain != null && this.brain.getDRecorder().isOn()) {
                this.brain.getDRecorder().stopRecording();
            }
            if (pick == -1 || pick == 2 && devCardScore > this.favoriteCity.getScore() || pick == 0 && devCardScore > this.favoriteRoad.getScore() || pick == 1 && devCardScore > this.favoriteSettlement.getScore()) {
                D.ebugPrintln("### BUY DEV CARD");
                if (pick != -1) {
                    this.buildingPlan.pop();
                    D.ebugPrintln("$ POPPED OFF SOMETHING");
                }
                D.ebugPrintln("$ PUSHING " + this.possibleCard);
                this.buildingPlan.push(this.possibleCard);
            }
        }
    }

    protected void scorePossibleSettlements(int settlementETA, int leadersCurrentWGETA) {
        D.ebugPrintln("****** scorePossibleSettlements");
        int ourCurrentWGETA = this.ourPlayerTracker.getWinGameETA();
        boolean goingToPlayRB = false;
        if (!this.ourPlayerData.hasPlayedDevCard() && this.ourPlayerData.getNumPieces(0) >= 2 && this.ourPlayerData.getDevCards().getAmount(0, 1) > 0) {
            goingToPlayRB = true;
        }
        for (SOCPossibleSettlement posSet : this.ourPlayerTracker.getPossibleSettlements().values()) {
            Vector necRoadVec;
            D.ebugPrintln("*** scoring possible settlement at " + Integer.toHexString(posSet.getCoordinates()));
            if (!this.threatenedSettlements.contains(posSet)) {
                this.threatenedSettlements.addElement(posSet);
            } else if (!this.goodSettlements.contains(posSet)) {
                this.goodSettlements.addElement(posSet);
            }
            if (!(necRoadVec = posSet.getNecessaryRoads()).isEmpty()) continue;
            D.ebugPrintln("*** no roads needed");
            SOCSettlement tmpSet = new SOCSettlement(this.ourPlayerData, posSet.getCoordinates());
            if (this.brain != null && this.brain.getDRecorder().isOn()) {
                this.brain.getDRecorder().startRecording("SETTLEMENT" + posSet.getCoordinates());
                this.brain.getDRecorder().record("Estimate value of settlement at " + this.game.getBoard().nodeCoordToString(posSet.getCoordinates()));
            }
            HashMap trackersCopy = SOCPlayerTracker.tryPutPiece(tmpSet, this.game, this.playerTrackers);
            SOCPlayerTracker.updateWinGameETAs(trackersCopy);
            float wgetaScore = this.calcWGETABonus(this.playerTrackers, trackersCopy);
            D.ebugPrintln("***  wgetaScore = " + wgetaScore);
            D.ebugPrintln("*** ETA for settlement = " + settlementETA);
            if (this.brain != null && this.brain.getDRecorder().isOn()) {
                this.brain.getDRecorder().record("ETA = " + settlementETA);
            }
            float etaBonus = this.getETABonus(settlementETA, leadersCurrentWGETA, wgetaScore);
            D.ebugPrintln("etaBonus = " + etaBonus);
            posSet.addToScore(etaBonus);
            if (this.brain != null && this.brain.getDRecorder().isOn()) {
                this.brain.getDRecorder().record("WGETA score = " + df1.format(wgetaScore));
                this.brain.getDRecorder().record("Total settlement score = " + df1.format(etaBonus));
                this.brain.getDRecorder().stopRecording();
            }
            SOCPlayerTracker.undoTryPutPiece(tmpSet, this.game);
        }
    }

    protected float getWinGameETABonus(SOCPossiblePiece posPiece) {
        HashMap trackersCopy = null;
        SOCSettlement tmpSet = null;
        SOCCity tmpCity = null;
        SOCRoad tmpRoad = null;
        float bonus = 0.0f;
        D.ebugPrintln("--- before [start] ---");
        D.ebugPrintln("our player numbers = " + this.ourPlayerData.getNumbers());
        D.ebugPrintln("--- before [end] ---");
        switch (posPiece.getType()) {
            case 1: {
                tmpSet = new SOCSettlement(this.ourPlayerData, posPiece.getCoordinates());
                trackersCopy = SOCPlayerTracker.tryPutPiece(tmpSet, this.game, this.playerTrackers);
                break;
            }
            case 2: {
                trackersCopy = SOCPlayerTracker.copyPlayerTrackers(this.playerTrackers);
                tmpCity = new SOCCity(this.ourPlayerData, posPiece.getCoordinates());
                this.game.putTempPiece(tmpCity);
                SOCPlayerTracker trackerCopy = (SOCPlayerTracker)trackersCopy.get(new Integer(this.ourPlayerData.getPlayerNumber()));
                if (trackerCopy == null) break;
                trackerCopy.addOurNewCity(tmpCity);
                break;
            }
            case 0: {
                tmpRoad = new SOCRoad(this.ourPlayerData, posPiece.getCoordinates());
                trackersCopy = SOCPlayerTracker.tryPutPiece(tmpRoad, this.game, this.playerTrackers);
            }
        }
        D.ebugPrintln("--- after [start] ---");
        SOCPlayerTracker.updateWinGameETAs(trackersCopy);
        float WGETABonus = this.calcWGETABonus(this.playerTrackers, trackersCopy);
        D.ebugPrintln("$$$ win game ETA bonus : +" + WGETABonus);
        bonus = WGETABonus;
        D.ebugPrintln("our player numbers = " + this.ourPlayerData.getNumbers());
        D.ebugPrintln("--- after [end] ---");
        switch (posPiece.getType()) {
            case 1: {
                SOCPlayerTracker.undoTryPutPiece(tmpSet, this.game);
                break;
            }
            case 2: {
                this.game.undoPutTempPiece(tmpCity);
                break;
            }
            case 0: {
                SOCPlayerTracker.undoTryPutPiece(tmpRoad, this.game);
            }
        }
        D.ebugPrintln("our player numbers = " + this.ourPlayerData.getNumbers());
        D.ebugPrintln("--- cleanup done ---");
        return bonus;
    }

    protected float getWinGameETABonusForRoad(SOCPossibleRoad posRoad, int roadETA, int leadersCurrentWGETA, HashMap playerTrackers) {
        D.ebugPrintln("--- addWinGameETABonusForRoad");
        int ourCurrentWGETA = this.ourPlayerTracker.getWinGameETA();
        D.ebugPrintln("ourCurrentWGETA = " + ourCurrentWGETA);
        HashMap trackersCopy = null;
        SOCRoad tmpRoad1 = null;
        D.ebugPrintln("--- before [start] ---");
        SOCResourceSet originalResources = this.ourPlayerData.getResources().copy();
        SOCBuildingSpeedEstimate estimate = new SOCBuildingSpeedEstimate(this.ourPlayerData.getNumbers());
        D.ebugPrintln("--- before [end] ---");
        try {
            SOCResSetBuildTimePair btp = estimate.calculateRollsFast(this.ourPlayerData.getResources(), SOCGame.ROAD_SET, 50, this.ourPlayerData.getPortFlags());
            btp.getResources().subtract(SOCGame.ROAD_SET);
            this.ourPlayerData.getResources().setAmounts(btp.getResources());
        }
        catch (CutoffExceededException e) {
            D.ebugPrintln("crap in getWinGameETABonusForRoad - " + e);
        }
        tmpRoad1 = new SOCRoad(this.ourPlayerData, posRoad.getCoordinates());
        trackersCopy = SOCPlayerTracker.tryPutPiece(tmpRoad1, this.game, playerTrackers);
        SOCPlayerTracker.updateWinGameETAs(trackersCopy);
        float score = this.calcWGETABonus(playerTrackers, trackersCopy);
        if (!posRoad.getThreats().isEmpty()) {
            D.ebugPrintln("***  (THREAT MULTIPLIER) score * " + this.threatMultiplier + " = " + (score *= this.threatMultiplier));
        }
        D.ebugPrintln("*** ETA for road = " + roadETA);
        float etaBonus = this.getETABonus(roadETA, leadersCurrentWGETA, score);
        D.ebugPrintln("$$$ score = " + score);
        D.ebugPrintln("etaBonus = " + etaBonus);
        posRoad.addToScore(etaBonus);
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("ETA = " + roadETA);
            this.brain.getDRecorder().record("WGETA Score = " + df1.format(score));
            this.brain.getDRecorder().record("Total road score = " + df1.format(etaBonus));
        }
        D.ebugPrintln("--- after [end] ---");
        SOCPlayerTracker.undoTryPutPiece(tmpRoad1, this.game);
        this.ourPlayerData.getResources().clear();
        this.ourPlayerData.getResources().add(originalResources);
        D.ebugPrintln("--- cleanup done ---");
        return etaBonus;
    }

    protected float calcWGETABonus(HashMap trackersBefore, HashMap trackersAfter) {
        D.ebugPrintln("^^^^^ calcWGETABonus");
        int[] originalWGETAs = new int[4];
        int[] WGETAdiffs = new int[4];
        Vector<SOCPlayerTracker> leaders = new Vector<SOCPlayerTracker>();
        int bestWGETA = 1000;
        float bonus = 0.0f;
        for (SOCPlayerTracker trackerBefore : trackersBefore.values()) {
            D.ebugPrintln("$$$ win game ETA for player " + trackerBefore.getPlayer().getPlayerNumber() + " = " + trackerBefore.getWinGameETA());
            originalWGETAs[trackerBefore.getPlayer().getPlayerNumber()] = trackerBefore.getWinGameETA();
            WGETAdiffs[trackerBefore.getPlayer().getPlayerNumber()] = trackerBefore.getWinGameETA();
            if (trackerBefore.getWinGameETA() < bestWGETA) {
                bestWGETA = trackerBefore.getWinGameETA();
                leaders.removeAllElements();
                leaders.addElement(trackerBefore);
                continue;
            }
            if (trackerBefore.getWinGameETA() != bestWGETA) continue;
            leaders.addElement(trackerBefore);
        }
        D.ebugPrintln("^^^^ bestWGETA = " + bestWGETA);
        bonus = this.calcWGETABonusAux(originalWGETAs, trackersAfter, leaders);
        D.ebugPrintln("^^^^ final bonus = " + bonus);
        return bonus;
    }

    public float calcWGETABonusAux(int[] originalWGETAs, HashMap trackersAfter, Vector leaders) {
        int[] WGETAdiffs = new int[4];
        int bestWGETA = 1000;
        float bonus = 0.0f;
        for (int i = 0; i < 4; ++i) {
            WGETAdiffs[i] = originalWGETAs[i];
            if (originalWGETAs[i] >= bestWGETA) continue;
            bestWGETA = originalWGETAs[i];
        }
        for (SOCPlayerTracker trackerAfter : trackersAfter.values()) {
            int n = trackerAfter.getPlayer().getPlayerNumber();
            WGETAdiffs[n] = WGETAdiffs[n] - trackerAfter.getWinGameETA();
            D.ebugPrintln("$$$ win game ETA diff for player " + trackerAfter.getPlayer().getPlayerNumber() + " = " + WGETAdiffs[trackerAfter.getPlayer().getPlayerNumber()]);
            if (trackerAfter.getPlayer().getPlayerNumber() != this.ourPlayerData.getPlayerNumber() || trackerAfter.getWinGameETA() != 0) continue;
            D.ebugPrintln("$$$$ adding win game bonus : +25");
            bonus += 25.0f;
            if (this.brain == null || !this.brain.getDRecorder().isOn()) continue;
            this.brain.getDRecorder().record("Adding Win Game bonus :" + df1.format(bonus));
        }
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("WGETA Diffs: " + WGETAdiffs[0] + " " + WGETAdiffs[1] + " " + WGETAdiffs[2] + " " + WGETAdiffs[3]);
        }
        if (originalWGETAs[this.ourPlayerData.getPlayerNumber()] > 0 && bonus == 0.0f) {
            bonus += 25.0f * ((float)WGETAdiffs[this.ourPlayerData.getPlayerNumber()] / (float)originalWGETAs[this.ourPlayerData.getPlayerNumber()]);
        }
        D.ebugPrintln("^^^^ our current bonus = " + bonus);
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("WGETA bonus for only myself = " + df1.format(bonus));
        }
        for (int pn = 0; pn < 4; ++pn) {
            Enumeration leadersEnum = leaders.elements();
            while (leadersEnum.hasMoreElements()) {
                float takedownBonus;
                SOCPlayerTracker leader = (SOCPlayerTracker)leadersEnum.nextElement();
                if (pn == this.ourPlayerData.getPlayerNumber() || pn == leader.getPlayer().getPlayerNumber()) continue;
                if (originalWGETAs[pn] > 0) {
                    takedownBonus = -25.0f * this.adversarialFactor * ((float)WGETAdiffs[pn] / (float)originalWGETAs[pn]) * ((float)bestWGETA / (float)originalWGETAs[pn]);
                    bonus += takedownBonus;
                    D.ebugPrintln("^^^^ added takedown bonus for player " + pn + " : " + takedownBonus);
                    if (this.brain == null || !this.brain.getDRecorder().isOn() || takedownBonus == 0.0f) continue;
                    this.brain.getDRecorder().record("Bonus for AI with " + pn + " : " + df1.format(takedownBonus));
                    continue;
                }
                if (WGETAdiffs[pn] >= 0) continue;
                takedownBonus = 25.0f * this.adversarialFactor;
                bonus += takedownBonus;
                D.ebugPrintln("^^^^ added takedown bonus for player " + pn + " : " + takedownBonus);
                if (this.brain == null || !this.brain.getDRecorder().isOn() || takedownBonus == 0.0f) continue;
                this.brain.getDRecorder().record("Bonus for AI with " + pn + " : " + df1.format(takedownBonus));
            }
        }
        Enumeration leadersEnum = leaders.elements();
        while (leadersEnum.hasMoreElements()) {
            float takedownBonus;
            SOCPlayerTracker leader = (SOCPlayerTracker)leadersEnum.nextElement();
            if (leader.getPlayer().getPlayerNumber() == this.ourPlayerData.getPlayerNumber()) continue;
            if (originalWGETAs[leader.getPlayer().getPlayerNumber()] > 0) {
                takedownBonus = -25.0f * this.leaderAdversarialFactor * ((float)WGETAdiffs[leader.getPlayer().getPlayerNumber()] / (float)originalWGETAs[leader.getPlayer().getPlayerNumber()]);
                bonus += takedownBonus;
                D.ebugPrintln("^^^^ added takedown bonus for leader " + leader.getPlayer().getPlayerNumber() + " : +" + takedownBonus);
                if (this.brain == null || !this.brain.getDRecorder().isOn() || takedownBonus == 0.0f) continue;
                this.brain.getDRecorder().record("Bonus for LI with " + leader.getPlayer().getName() + " : +" + df1.format(takedownBonus));
                continue;
            }
            if (WGETAdiffs[leader.getPlayer().getPlayerNumber()] >= 0) continue;
            takedownBonus = 25.0f * this.leaderAdversarialFactor;
            bonus += takedownBonus;
            D.ebugPrintln("^^^^ added takedown bonus for leader " + leader.getPlayer().getPlayerNumber() + " : +" + takedownBonus);
            if (this.brain == null || !this.brain.getDRecorder().isOn() || takedownBonus == 0.0f) continue;
            this.brain.getDRecorder().record("Bonus for LI with " + leader.getPlayer().getName() + " : +" + df1.format(takedownBonus));
        }
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("WGETA bonus = " + df1.format(bonus));
        }
        return bonus;
    }

    public SOCPossibleCard getDevCardScore(int cardETA, int leadersCurrentWGETA) {
        float devCardScore = 0.0f;
        D.ebugPrintln("$$$ devCardScore = +" + devCardScore);
        D.ebugPrintln("--- before [start] ---");
        int ourCurrentWGETA = this.ourPlayerTracker.getWinGameETA();
        int[] WGETAdiffs = new int[4];
        int[] originalWGETAs = new int[4];
        int bestWGETA = 1000;
        Vector<SOCPlayerTracker> leaders = new Vector<SOCPlayerTracker>();
        for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
            originalWGETAs[tracker.getPlayer().getPlayerNumber()] = tracker.getWinGameETA();
            WGETAdiffs[tracker.getPlayer().getPlayerNumber()] = tracker.getWinGameETA();
            D.ebugPrintln("$$$$ win game ETA for player " + tracker.getPlayer().getPlayerNumber() + " = " + tracker.getWinGameETA());
            if (tracker.getWinGameETA() < bestWGETA) {
                bestWGETA = tracker.getWinGameETA();
                leaders.removeAllElements();
                leaders.addElement(tracker);
                continue;
            }
            if (tracker.getWinGameETA() != bestWGETA) continue;
            leaders.addElement(tracker);
        }
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("Estimating Knight card value ...");
        }
        this.ourPlayerData.getGame().saveLargestArmyState();
        D.ebugPrintln("--- before [end] ---");
        this.ourPlayerData.setNumKnights(this.ourPlayerData.getNumKnights() + 1);
        this.ourPlayerData.getGame().updateLargestArmy();
        D.ebugPrintln("--- after [start] ---");
        SOCPlayerTracker.updateWinGameETAs(this.playerTrackers);
        float bonus = this.calcWGETABonusAux(originalWGETAs, this.playerTrackers, leaders);
        D.ebugPrintln("^^^^ raw bonus = " + bonus);
        D.ebugPrintln("^^^^ adjusted bonus = " + (bonus *= 0.58f));
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("Bonus * 0.58 = " + df1.format(bonus));
        }
        D.ebugPrintln("^^^^ bonus for +1 knight = " + bonus);
        devCardScore += bonus;
        D.ebugPrintln("--- after [end] ---");
        this.ourPlayerData.setNumKnights(this.ourPlayerData.getNumKnights() - 1);
        this.ourPlayerData.getGame().restoreLargestArmyState();
        D.ebugPrintln("--- cleanup done ---");
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("Estimating vp card value ...");
        }
        D.ebugPrintln("--- before [start] ---");
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().suspend();
        }
        SOCPlayerTracker.updateWinGameETAs(this.playerTrackers);
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().resume();
        }
        D.ebugPrintln("--- before [end] ---");
        this.ourPlayerData.getDevCards().add(1, 1, 4);
        D.ebugPrintln("--- after [start] ---");
        SOCPlayerTracker.updateWinGameETAs(this.playerTrackers);
        bonus = this.calcWGETABonusAux(originalWGETAs, this.playerTrackers, leaders);
        D.ebugPrintln("^^^^ our current bonus = " + bonus);
        D.ebugPrintln("^^^^ adjusted bonus = " + (bonus *= 0.21f));
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("Bonus * 0.21 = " + df1.format(bonus));
        }
        D.ebugPrintln("$$$ win game ETA bonus for +1 vp: " + bonus);
        devCardScore += bonus;
        D.ebugPrintln("--- after [end] ---");
        this.ourPlayerData.getDevCards().subtract(1, 1, 4);
        D.ebugPrintln("--- cleanup done ---");
        devCardScore += this.devCardMultiplier;
        D.ebugPrintln("^^^^ misc bonus = " + this.devCardMultiplier);
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("Misc bonus = " + df1.format(this.devCardMultiplier));
        }
        float score = this.getETABonus(cardETA, leadersCurrentWGETA, devCardScore);
        D.ebugPrintln("$$$$$ devCardScore = " + devCardScore);
        D.ebugPrintln("$$$$$ devCardETA = " + cardETA);
        D.ebugPrintln("$$$$$ final score = " + score);
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("ETA = " + cardETA);
            this.brain.getDRecorder().record("dev card score = " + df1.format(devCardScore));
            this.brain.getDRecorder().record("Total dev card score = " + df1.format(score));
        }
        SOCPossibleCard posCard = new SOCPossibleCard(this.ourPlayerData, cardETA);
        posCard.addToScore(score);
        return posCard;
    }

    public float getETABonus(int eta, int leadWGETA, float bonus) {
        D.ebugPrintln("**** getETABonus ****");
        return bonus / (float)Math.pow(1.0f + this.etaBonusFactor, eta);
    }
}

