/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import soc.disableDebug.D;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCResourceSet;
import soc.game.SOCTradeOffer;
import soc.robot.SOCBuildingSpeedEstimate;
import soc.robot.SOCPlayerTracker;
import soc.robot.SOCPossiblePiece;
import soc.robot.SOCPossibleSettlement;
import soc.robot.SOCResSetBuildTimePair;
import soc.robot.SOCRobotBrain;
import soc.robot.SOCRobotDM;
import soc.util.CutoffExceededException;

public class SOCRobotNegotiator {
    protected static final int WIN_GAME_CUTOFF = 25;
    public static final int REJECT_OFFER = 0;
    public static final int ACCEPT_OFFER = 1;
    public static final int COUNTER_OFFER = 2;
    protected SOCRobotBrain brain;
    protected int strategyType;
    protected SOCGame game;
    protected Stack buildingPlan;
    protected HashMap playerTrackers;
    protected SOCPlayerTracker ourPlayerTracker;
    protected SOCPlayer ourPlayerData;
    protected SOCRobotDM decisionMaker;
    protected boolean[][] isSellingResource;
    protected boolean[][] wantsAnotherOffer;
    protected Vector offersMade;
    protected SOCPossiblePiece[] targetPieces;

    public SOCRobotNegotiator(SOCRobotBrain br) {
        this.brain = br;
        this.strategyType = br.getRobotParameters().getStrategyType();
        this.playerTrackers = this.brain.getPlayerTrackers();
        this.ourPlayerTracker = this.brain.getOurPlayerTracker();
        this.ourPlayerData = this.brain.getOurPlayerData();
        this.buildingPlan = this.brain.getBuildingPlan();
        this.decisionMaker = this.brain.getDecisionMaker();
        this.game = this.brain.getGame();
        this.isSellingResource = new boolean[4][7];
        this.resetIsSelling();
        this.wantsAnotherOffer = new boolean[4][7];
        this.resetWantsAnotherOffer();
        this.offersMade = new Vector();
        this.targetPieces = new SOCPossiblePiece[4];
        this.resetTargetPieces();
    }

    public void resetTargetPieces() {
        D.ebugPrintln("*** resetTargetPieces ***");
        for (int pn = 0; pn < 4; ++pn) {
            this.targetPieces[pn] = null;
        }
    }

    public void setTargetPiece(int pn, SOCPossiblePiece piece) {
        this.targetPieces[pn] = piece;
    }

    public void resetOffersMade() {
        this.offersMade.clear();
    }

    public void addToOffersMade(SOCTradeOffer offer) {
        if (offer != null) {
            this.offersMade.add(offer);
        }
    }

    public void resetIsSelling() {
        D.ebugPrintln("*** resetIsSelling (true for every resource the player has) ***");
        for (int rsrcType = 1; rsrcType <= 5; ++rsrcType) {
            for (int pn = 0; pn < 4; ++pn) {
                if (this.game.getPlayer(pn).getResources().getAmount(rsrcType) <= 0) continue;
                this.isSellingResource[pn][rsrcType] = true;
            }
        }
    }

    public void resetWantsAnotherOffer() {
        D.ebugPrintln("*** resetWantsAnotherOffer (all false) ***");
        for (int rsrcType = 1; rsrcType <= 5; ++rsrcType) {
            for (int pn = 0; pn < 4; ++pn) {
                this.wantsAnotherOffer[pn][rsrcType] = false;
            }
        }
    }

    public void markAsNotSelling(int pn, int rsrcType) {
        D.ebugPrintln("*** markAsNotSelling pn=" + pn + " rsrcType=" + rsrcType);
        this.isSellingResource[pn][rsrcType] = false;
    }

    public void markAsSelling(int pn, int rsrcType) {
        D.ebugPrintln("*** markAsSelling pn=" + pn + " rsrcType=" + rsrcType);
        this.isSellingResource[pn][rsrcType] = true;
    }

    public void markAsNotWantingAnotherOffer(int pn, int rsrcType) {
        D.ebugPrintln("*** markAsNotWantingAnotherOffer pn=" + pn + " rsrcType=" + rsrcType);
        this.wantsAnotherOffer[pn][rsrcType] = false;
    }

    public void markAsWantsAnotherOffer(int pn, int rsrcType) {
        D.ebugPrintln("*** markAsWantsAnotherOffer pn=" + pn + " rsrcType=" + rsrcType);
        this.wantsAnotherOffer[pn][rsrcType] = true;
    }

    public boolean wantsAnotherOffer(int pn, int rsrcType) {
        return this.wantsAnotherOffer[pn][rsrcType];
    }

    public SOCTradeOffer makeOffer(SOCPossiblePiece targetPiece) {
        int giveRsrcIdx1;
        int getRsrcIdx;
        int tmp;
        int i;
        int j;
        D.ebugPrintln("***** MAKE OFFER *****");
        if (targetPiece == null) {
            return null;
        }
        SOCTradeOffer offer = null;
        SOCResourceSet targetResources = null;
        switch (targetPiece.getType()) {
            case 4: {
                targetResources = SOCGame.CARD_SET;
                break;
            }
            case 0: {
                targetResources = SOCGame.ROAD_SET;
                break;
            }
            case 1: {
                targetResources = SOCGame.SETTLEMENT_SET;
                break;
            }
            case 2: {
                targetResources = SOCGame.CITY_SET;
            }
        }
        SOCResourceSet ourResources = this.ourPlayerData.getResources();
        D.ebugPrintln("*** targetResources = " + targetResources);
        D.ebugPrintln("*** ourResources = " + ourResources);
        if (ourResources.contains(targetResources)) {
            return offer;
        }
        if (ourResources.getAmount(6) > 0) {
            D.ebugPrintln("AGG WE HAVE UNKNOWN RESOURCES !!!! %%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            return offer;
        }
        SOCTradeOffer batna = this.getOfferToBank(targetResources);
        D.ebugPrintln("*** BATNA = " + batna);
        SOCBuildingSpeedEstimate estimate = new SOCBuildingSpeedEstimate(this.ourPlayerData.getNumbers());
        SOCResourceSet giveResourceSet = new SOCResourceSet();
        SOCResourceSet getResourceSet = new SOCResourceSet();
        int batnaBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
        D.ebugPrintln("*** batnaBuildingTime = " + batnaBuildingTime);
        if (batna != null) {
            batnaBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, batna.getGiveSet(), batna.getGetSet(), estimate);
        }
        D.ebugPrintln("*** batnaBuildingTime = " + batnaBuildingTime);
        int[] rollsPerResource = estimate.getRollsPerResource();
        int[] neededRsrc = new int[5];
        int[] notNeededRsrc = new int[5];
        int neededRsrcCount = 0;
        int notNeededRsrcCount = 0;
        for (int rsrcType = 1; rsrcType <= 5; ++rsrcType) {
            if (targetResources.getAmount(rsrcType) > 0) {
                neededRsrc[neededRsrcCount] = rsrcType;
                ++neededRsrcCount;
                continue;
            }
            notNeededRsrc[notNeededRsrcCount] = rsrcType;
            ++notNeededRsrcCount;
        }
        for (j = neededRsrcCount - 1; j >= 0; --j) {
            for (i = 0; i < j; ++i) {
                if (rollsPerResource[neededRsrc[i]] <= rollsPerResource[neededRsrc[i + 1]]) continue;
                tmp = neededRsrc[i];
                neededRsrc[i] = neededRsrc[i + 1];
                neededRsrc[i + 1] = tmp;
            }
        }
        for (j = notNeededRsrcCount - 1; j >= 0; --j) {
            for (i = 0; i < j; ++i) {
                if (rollsPerResource[notNeededRsrc[i]] <= rollsPerResource[notNeededRsrc[i + 1]]) continue;
                tmp = notNeededRsrc[i];
                notNeededRsrc[i] = notNeededRsrc[i + 1];
                notNeededRsrc[i + 1] = tmp;
            }
        }
        boolean[] someoneIsSellingResource = new boolean[7];
        block11: for (int rsrcType = 1; rsrcType <= 5; ++rsrcType) {
            someoneIsSellingResource[rsrcType] = false;
            for (int pn = 0; pn < 4; ++pn) {
                if (pn == this.ourPlayerData.getPlayerNumber() || !this.isSellingResource[pn][rsrcType]) continue;
                someoneIsSellingResource[rsrcType] = true;
                D.ebugPrintln("*** player " + pn + " is selling " + rsrcType);
                continue block11;
            }
        }
        for (getRsrcIdx = neededRsrcCount - 1; !(getRsrcIdx < 0 || ourResources.getAmount(neededRsrc[getRsrcIdx]) < targetResources.getAmount(neededRsrc[getRsrcIdx]) && someoneIsSellingResource[neededRsrc[getRsrcIdx]]); --getRsrcIdx) {
        }
        if (getRsrcIdx >= 0) {
            D.ebugPrintln("*** getRsrc = " + neededRsrc[getRsrcIdx]);
            getResourceSet.add(1, neededRsrc[getRsrcIdx]);
            D.ebugPrintln("*** offer should be null : offer = " + offer);
            for (int giveRsrcIdx = 0; giveRsrcIdx < notNeededRsrcCount && offer == null; ++giveRsrcIdx) {
                D.ebugPrintln("*** ourResources.getAmount(" + notNeededRsrc[giveRsrcIdx] + ") = " + ourResources.getAmount(notNeededRsrc[giveRsrcIdx]));
                if (ourResources.getAmount(notNeededRsrc[giveRsrcIdx]) <= 0) continue;
                giveResourceSet.clear();
                giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx]);
                offer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                D.ebugPrintln("*** offer = " + offer);
                int offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                D.ebugPrintln("*** offerBuildingTime = " + offerBuildingTime);
            }
            D.ebugPrintln("*** ourResources = " + ourResources);
            if (offer == null) {
                for (int giveRsrcIdx12 = 0; giveRsrcIdx12 < neededRsrcCount && offer == null; ++giveRsrcIdx12) {
                    D.ebugPrintln("*** ourResources.getAmount(" + neededRsrc[giveRsrcIdx12] + ") = " + ourResources.getAmount(neededRsrc[giveRsrcIdx12]));
                    D.ebugPrintln("*** targetResources.getAmount(" + neededRsrc[giveRsrcIdx12] + ") = " + targetResources.getAmount(neededRsrc[giveRsrcIdx12]));
                    if (ourResources.getAmount(neededRsrc[giveRsrcIdx12]) <= targetResources.getAmount(neededRsrc[giveRsrcIdx12]) || neededRsrc[giveRsrcIdx12] == neededRsrc[getRsrcIdx]) continue;
                    giveResourceSet.clear();
                    giveResourceSet.add(1, neededRsrc[giveRsrcIdx12]);
                    int offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                    if (offerBuildingTime >= batnaBuildingTime && (batna == null || offerBuildingTime != batnaBuildingTime || giveResourceSet.getTotal() >= batna.getGiveSet().getTotal())) continue;
                    offer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                    D.ebugPrintln("*** offer = " + offer);
                    D.ebugPrintln("*** offerBuildingTime = " + offerBuildingTime);
                }
            }
            D.ebugPrintln("*** ourResources = " + ourResources);
            SOCResourceSet leftovers = ourResources.copy();
            leftovers.subtract(targetResources);
            D.ebugPrintln("*** leftovers = " + leftovers);
            if (offer == null) {
                int offerBuildingTime;
                int giveRsrcIdx2 = 0;
                for (giveRsrcIdx1 = 0; giveRsrcIdx1 < notNeededRsrcCount && offer == null; ++giveRsrcIdx1) {
                    if (ourResources.getAmount(notNeededRsrc[giveRsrcIdx1]) <= 0) continue;
                    while (giveRsrcIdx2 < notNeededRsrcCount && offer == null) {
                        giveResourceSet.clear();
                        giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx1]);
                        giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx2]);
                        if (ourResources.contains(giveResourceSet) && ((offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate)) < batnaBuildingTime || batna != null && offerBuildingTime == batnaBuildingTime && giveResourceSet.getTotal() < batna.getGiveSet().getTotal())) {
                            offer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                            D.ebugPrintln("*** offer = " + offer);
                            D.ebugPrintln("*** offerBuildingTime = " + offerBuildingTime);
                        }
                        ++giveRsrcIdx2;
                    }
                    for (giveRsrcIdx2 = 0; giveRsrcIdx2 < neededRsrcCount && offer == null; ++giveRsrcIdx2) {
                        if (neededRsrc[giveRsrcIdx2] == neededRsrc[getRsrcIdx]) continue;
                        giveResourceSet.clear();
                        giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx1]);
                        giveResourceSet.add(1, neededRsrc[giveRsrcIdx2]);
                        if (!leftovers.contains(giveResourceSet) || (offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate)) >= batnaBuildingTime && (batna == null || offerBuildingTime != batnaBuildingTime || giveResourceSet.getTotal() >= batna.getGiveSet().getTotal())) continue;
                        offer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                        D.ebugPrintln("*** offer = " + offer);
                        D.ebugPrintln("*** offerBuildingTime = " + offerBuildingTime);
                    }
                }
                giveRsrcIdx2 = 0;
                for (giveRsrcIdx1 = 0; giveRsrcIdx1 < neededRsrcCount && offer == null; ++giveRsrcIdx1) {
                    if (leftovers.getAmount(neededRsrc[giveRsrcIdx1]) <= 0 || neededRsrc[giveRsrcIdx1] == neededRsrc[getRsrcIdx]) continue;
                    while (giveRsrcIdx2 < notNeededRsrcCount && offer == null) {
                        giveResourceSet.clear();
                        giveResourceSet.add(1, neededRsrc[giveRsrcIdx1]);
                        giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx2]);
                        if (leftovers.contains(giveResourceSet) && ((offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate)) < batnaBuildingTime || batna != null && offerBuildingTime == batnaBuildingTime && giveResourceSet.getTotal() < batna.getGiveSet().getTotal())) {
                            offer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                            D.ebugPrintln("*** offer = " + offer);
                            D.ebugPrintln("*** offerBuildingTime = " + offerBuildingTime);
                        }
                        ++giveRsrcIdx2;
                    }
                    for (giveRsrcIdx2 = 0; giveRsrcIdx2 < neededRsrcCount && offer == null; ++giveRsrcIdx2) {
                        if (neededRsrc[giveRsrcIdx2] == neededRsrc[getRsrcIdx]) continue;
                        giveResourceSet.clear();
                        giveResourceSet.add(1, neededRsrc[giveRsrcIdx1]);
                        giveResourceSet.add(1, neededRsrc[giveRsrcIdx2]);
                        if (!leftovers.contains(giveResourceSet) || (offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate)) >= batnaBuildingTime && (batna == null || offerBuildingTime != batnaBuildingTime || giveResourceSet.getTotal() >= batna.getGiveSet().getTotal())) continue;
                        offer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                        D.ebugPrintln("*** offer = " + offer);
                        D.ebugPrintln("*** offerBuildingTime = " + offerBuildingTime);
                    }
                }
            }
        }
        if (offer == null) {
            int getRsrcIdx2;
            SOCResourceSet leftovers = ourResources.copy();
            leftovers.subtract(targetResources);
            D.ebugPrintln("*** leftovers = " + leftovers);
            for (getRsrcIdx2 = notNeededRsrcCount - 1; getRsrcIdx2 >= 0 && !someoneIsSellingResource[neededRsrc[getRsrcIdx2]]; --getRsrcIdx2) {
            }
            while (getRsrcIdx2 >= 0 && offer == null) {
                int offerBuildingTime;
                getResourceSet.clear();
                getResourceSet.add(1, notNeededRsrc[getRsrcIdx2]);
                leftovers.add(1, notNeededRsrc[getRsrcIdx2]);
                if (offer == null) {
                    for (giveRsrcIdx1 = 0; giveRsrcIdx1 < notNeededRsrcCount && offer == null; ++giveRsrcIdx1) {
                        if (leftovers.getAmount(notNeededRsrc[giveRsrcIdx1]) <= 0 || notNeededRsrc[giveRsrcIdx1] == notNeededRsrc[getRsrcIdx2]) continue;
                        leftovers.subtract(1, notNeededRsrc[giveRsrcIdx1]);
                        if (this.getOfferToBank(targetResources, leftovers) != null) {
                            giveResourceSet.clear();
                            giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx1]);
                            offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                            if (offerBuildingTime < batnaBuildingTime) {
                                offer = this.makeOfferAux(giveResourceSet, getResourceSet, notNeededRsrc[getRsrcIdx2]);
                                D.ebugPrintln("*** offer = " + offer);
                                D.ebugPrintln("*** offerBuildingTime = " + offerBuildingTime);
                            }
                        }
                        leftovers.add(1, notNeededRsrc[giveRsrcIdx1]);
                    }
                }
                if (offer == null) {
                    for (giveRsrcIdx1 = 0; giveRsrcIdx1 < neededRsrcCount && offer == null; ++giveRsrcIdx1) {
                        if (leftovers.getAmount(neededRsrc[giveRsrcIdx1]) <= 0) continue;
                        leftovers.subtract(1, neededRsrc[giveRsrcIdx1]);
                        if (this.getOfferToBank(targetResources, leftovers) != null) {
                            giveResourceSet.clear();
                            giveResourceSet.add(1, neededRsrc[giveRsrcIdx1]);
                            offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                            if (offerBuildingTime < batnaBuildingTime) {
                                offer = this.makeOfferAux(giveResourceSet, getResourceSet, notNeededRsrc[getRsrcIdx2]);
                                D.ebugPrintln("*** offer = " + offer);
                                D.ebugPrintln("*** offerBuildingTime = " + offerBuildingTime);
                            }
                        }
                        leftovers.add(1, neededRsrc[giveRsrcIdx1]);
                    }
                }
                leftovers.subtract(1, notNeededRsrc[getRsrcIdx2]);
                --getRsrcIdx2;
            }
        }
        return offer;
    }

    protected SOCTradeOffer makeOfferAux(SOCResourceSet giveResourceSet, SOCResourceSet getResourceSet, int neededResource) {
        D.ebugPrintln("**** makeOfferAux ****");
        D.ebugPrintln("giveResourceSet = " + giveResourceSet);
        D.ebugPrintln("getResourceSet = " + getResourceSet);
        SOCTradeOffer offer = null;
        boolean match = false;
        Iterator offersMadeIter = this.offersMade.iterator();
        while (offersMadeIter.hasNext() && !match) {
            SOCTradeOffer pastOffer = (SOCTradeOffer)offersMadeIter.next();
            if (pastOffer == null || !pastOffer.getGiveSet().equals(giveResourceSet) || !pastOffer.getGetSet().equals(getResourceSet)) continue;
            match = true;
        }
        if (!match) {
            for (int i = 0; i < 4; ++i) {
                SOCTradeOffer outsideOffer;
                if (i == this.ourPlayerData.getPlayerNumber() || (outsideOffer = this.game.getPlayer(i).getCurrentOffer()) == null || !outsideOffer.getGetSet().equals(giveResourceSet) || !outsideOffer.getGiveSet().equals(getResourceSet)) continue;
                match = true;
                break;
            }
        }
        D.ebugPrintln("*** match = " + match);
        if (!match) {
            SOCPlayerTracker tracker;
            D.ebugPrintln("* this is a new offer");
            int numOfferedTo = 0;
            boolean[] offeredTo = new boolean[4];
            if (this.game.getCurrentPlayerNumber() == this.ourPlayerData.getPlayerNumber()) {
                for (int i = 0; i < 4; ++i) {
                    D.ebugPrintln("** isSellingResource[" + i + "][" + neededResource + "] = " + this.isSellingResource[i][neededResource]);
                    if (i == this.ourPlayerData.getPlayerNumber() || !this.isSellingResource[i][neededResource] || this.game.getPlayer(i).getResources().getTotal() < getResourceSet.getTotal()) continue;
                    tracker = (SOCPlayerTracker)this.playerTrackers.get(new Integer(i));
                    if (tracker != null && tracker.getWinGameETA() >= 25) {
                        ++numOfferedTo;
                        offeredTo[i] = true;
                        continue;
                    }
                    offeredTo[i] = false;
                }
            } else {
                int curpn = this.game.getCurrentPlayerNumber();
                if (this.isSellingResource[curpn][neededResource] && this.game.getPlayer(curpn).getResources().getTotal() >= getResourceSet.getTotal()) {
                    D.ebugPrintln("** isSellingResource[" + curpn + "][" + neededResource + "] = " + this.isSellingResource[curpn][neededResource]);
                    tracker = (SOCPlayerTracker)this.playerTrackers.get(new Integer(curpn));
                    if (tracker != null && tracker.getWinGameETA() >= 25) {
                        ++numOfferedTo;
                        offeredTo[curpn] = true;
                    }
                }
            }
            D.ebugPrintln("** numOfferedTo = " + numOfferedTo);
            if (numOfferedTo > 0) {
                offer = new SOCTradeOffer(this.game.getName(), this.ourPlayerData.getPlayerNumber(), offeredTo, giveResourceSet, getResourceSet);
                boolean acceptable = false;
                for (int pn = 0; pn < 4; ++pn) {
                    if (!offeredTo[pn]) continue;
                    int offerResponse = this.considerOffer2(offer, pn);
                    D.ebugPrintln("* considerOffer2(offer, " + pn + ") = " + offerResponse);
                    if (offerResponse != 1) continue;
                    acceptable = true;
                    break;
                }
                if (!acceptable) {
                    offer = null;
                }
            }
        }
        return offer;
    }

    protected int getETAToTargetResources(SOCPlayer player, SOCResourceSet targetResources, SOCResourceSet giveSet, SOCResourceSet getSet, SOCBuildingSpeedEstimate estimate) {
        SOCResourceSet ourResourcesCopy = player.getResources().copy();
        D.ebugPrintln("*** giveSet = " + giveSet);
        D.ebugPrintln("*** getSet = " + getSet);
        ourResourcesCopy.subtract(giveSet);
        ourResourcesCopy.add(getSet);
        int offerBuildingTime = 1000;
        try {
            SOCResSetBuildTimePair offerBuildingTimePair = estimate.calculateRollsFast(ourResourcesCopy, targetResources, 1000, player.getPortFlags());
            offerBuildingTime = offerBuildingTimePair.getRolls();
        }
        catch (CutoffExceededException e) {
            // empty catch block
        }
        D.ebugPrintln("*** offerBuildingTime = " + offerBuildingTime);
        D.ebugPrintln("*** ourResourcesCopy = " + ourResourcesCopy);
        return offerBuildingTime;
    }

    public int considerOffer2(SOCTradeOffer offer, int receiverNum) {
        SOCRobotDM simulator;
        D.ebugPrintln("***** CONSIDER OFFER 2 *****");
        int response = 0;
        SOCPlayer receiverPlayerData = this.game.getPlayer(receiverNum);
        SOCResourceSet receiverResources = receiverPlayerData.getResources();
        SOCResourceSet rsrcsOut = offer.getGetSet();
        SOCResourceSet rsrcsIn = offer.getGiveSet();
        if (receiverResources.getAmount(6) == 0 && !receiverResources.contains(rsrcsOut)) {
            return response;
        }
        int senderNum = offer.getFrom();
        D.ebugPrintln("senderNum = " + senderNum);
        D.ebugPrintln("receiverNum = " + receiverNum);
        D.ebugPrintln("rsrcs from receiver = " + rsrcsOut);
        D.ebugPrintln("rsrcs to receiver = " + rsrcsIn);
        SOCPossiblePiece receiverTargetPiece = this.targetPieces[receiverNum];
        D.ebugPrintln("targetPieces[" + receiverNum + "] = " + receiverTargetPiece);
        SOCPlayerTracker receiverPlayerTracker = (SOCPlayerTracker)this.playerTrackers.get(new Integer(receiverNum));
        if (receiverPlayerTracker == null) {
            return response;
        }
        SOCPlayerTracker senderPlayerTracker = (SOCPlayerTracker)this.playerTrackers.get(new Integer(senderNum));
        if (senderPlayerTracker == null) {
            return response;
        }
        if (receiverTargetPiece == null) {
            Stack receiverBuildingPlan = new Stack();
            simulator = new SOCRobotDM(this.brain.getRobotParameters(), this.playerTrackers, receiverPlayerTracker, receiverPlayerData, receiverBuildingPlan);
            if (receiverNum == this.ourPlayerData.getPlayerNumber()) {
                simulator.planStuff(this.strategyType);
            } else {
                simulator.planStuff(this.strategyType);
            }
            if (receiverBuildingPlan.empty()) {
                return response;
            }
            this.targetPieces[receiverNum] = receiverTargetPiece = (SOCPossiblePiece)receiverBuildingPlan.peek();
        }
        D.ebugPrintln("receiverTargetPiece = " + receiverTargetPiece);
        SOCPossiblePiece senderTargetPiece = this.targetPieces[senderNum];
        D.ebugPrintln("targetPieces[" + senderNum + "] = " + senderTargetPiece);
        SOCPlayer senderPlayerData = this.game.getPlayer(senderNum);
        if (senderTargetPiece == null) {
            Stack senderBuildingPlan = new Stack();
            simulator = new SOCRobotDM(this.brain.getRobotParameters(), this.playerTrackers, senderPlayerTracker, senderPlayerData, senderBuildingPlan);
            if (senderNum == this.ourPlayerData.getPlayerNumber()) {
                simulator.planStuff(this.strategyType);
            } else {
                simulator.planStuff(this.strategyType);
            }
            if (senderBuildingPlan.empty()) {
                return response;
            }
            this.targetPieces[senderNum] = senderTargetPiece = (SOCPossiblePiece)senderBuildingPlan.peek();
        }
        D.ebugPrintln("senderTargetPiece = " + senderTargetPiece);
        int senderWGETA = senderPlayerTracker.getWinGameETA();
        if (senderWGETA > 25) {
            boolean inARace = false;
            if (receiverTargetPiece.getType() == 1 || receiverTargetPiece.getType() == 0) {
                Enumeration threatsEnum = receiverTargetPiece.getThreats().elements();
                while (threatsEnum.hasMoreElements()) {
                    SOCPossiblePiece threat = (SOCPossiblePiece)threatsEnum.nextElement();
                    if (threat.getType() != senderTargetPiece.getType() || threat.getCoordinates() != senderTargetPiece.getCoordinates()) continue;
                    inARace = true;
                    break;
                }
                if (inARace) {
                    D.ebugPrintln("inARace == true (threat from sender)");
                } else if (receiverTargetPiece.getType() == 1) {
                    Enumeration conflictsEnum = ((SOCPossibleSettlement)receiverTargetPiece).getConflicts().elements();
                    while (conflictsEnum.hasMoreElements()) {
                        SOCPossibleSettlement conflict = (SOCPossibleSettlement)conflictsEnum.nextElement();
                        if (senderTargetPiece.getType() != 1 || conflict.getCoordinates() != senderTargetPiece.getCoordinates()) continue;
                        inARace = true;
                        break;
                    }
                    if (inARace) {
                        D.ebugPrintln("inARace == true (conflict with sender)");
                    }
                }
            }
            if (!inARace) {
                SOCResourceSet targetResources = null;
                switch (receiverTargetPiece.getType()) {
                    case 4: {
                        targetResources = SOCGame.CARD_SET;
                        break;
                    }
                    case 0: {
                        targetResources = SOCGame.ROAD_SET;
                        break;
                    }
                    case 1: {
                        targetResources = SOCGame.SETTLEMENT_SET;
                        break;
                    }
                    case 2: {
                        targetResources = SOCGame.CITY_SET;
                    }
                }
                SOCBuildingSpeedEstimate estimate = new SOCBuildingSpeedEstimate(receiverPlayerData.getNumbers());
                SOCTradeOffer receiverBatna = this.getOfferToBank(targetResources);
                D.ebugPrintln("*** receiverBatna = " + receiverBatna);
                int batnaBuildingTime = this.getETAToTargetResources(receiverPlayerData, targetResources, SOCResourceSet.EMPTY_SET, SOCResourceSet.EMPTY_SET, estimate);
                D.ebugPrintln("*** batnaBuildingTime = " + batnaBuildingTime);
                int offerBuildingTime = this.getETAToTargetResources(receiverPlayerData, targetResources, rsrcsOut, rsrcsIn, estimate);
                D.ebugPrintln("*** offerBuildingTime = " + offerBuildingTime);
                response = offerBuildingTime < batnaBuildingTime ? 1 : 2;
            }
        }
        return response;
    }

    public SOCTradeOffer makeCounterOffer(SOCTradeOffer originalOffer) {
        int offerBuildingTime;
        int giveRsrcIdx1;
        int getRsrcIdx;
        int tmp;
        int i;
        int j;
        D.ebugPrintln("***** MAKE COUNTER OFFER *****");
        SOCTradeOffer counterOffer = null;
        SOCPossiblePiece targetPiece = this.targetPieces[this.ourPlayerData.getPlayerNumber()];
        if (targetPiece == null) {
            Stack ourBuildingPlan = this.buildingPlan;
            if (ourBuildingPlan.empty()) {
                D.ebugPrintln("**** our building plan is empty ****");
                SOCRobotDM simulator = new SOCRobotDM(this.brain.getRobotParameters(), this.playerTrackers, this.ourPlayerTracker, this.ourPlayerData, ourBuildingPlan);
                simulator.planStuff(this.strategyType);
            }
            if (ourBuildingPlan.empty()) {
                return counterOffer;
            }
            this.targetPieces[this.ourPlayerData.getPlayerNumber()] = targetPiece = (SOCPossiblePiece)ourBuildingPlan.peek();
        }
        SOCResourceSet targetResources = null;
        switch (targetPiece.getType()) {
            case 4: {
                targetResources = SOCGame.CARD_SET;
                break;
            }
            case 0: {
                targetResources = SOCGame.ROAD_SET;
                break;
            }
            case 1: {
                targetResources = SOCGame.SETTLEMENT_SET;
                break;
            }
            case 2: {
                targetResources = SOCGame.CITY_SET;
            }
        }
        SOCResourceSet ourResources = this.ourPlayerData.getResources();
        D.ebugPrintln("*** targetResources = " + targetResources);
        D.ebugPrintln("*** ourResources = " + ourResources);
        if (ourResources.contains(targetResources)) {
            return counterOffer;
        }
        if (ourResources.getAmount(6) > 0) {
            D.ebugPrintln("AGG WE HAVE UNKNOWN RESOURCES !!!! %%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            return counterOffer;
        }
        SOCTradeOffer batna = this.getOfferToBank(targetResources);
        D.ebugPrintln("*** BATNA = " + batna);
        SOCBuildingSpeedEstimate estimate = new SOCBuildingSpeedEstimate(this.ourPlayerData.getNumbers());
        SOCResourceSet giveResourceSet = new SOCResourceSet();
        SOCResourceSet getResourceSet = new SOCResourceSet();
        int batnaBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
        if (batna != null) {
            batnaBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, batna.getGiveSet(), batna.getGetSet(), estimate);
        }
        D.ebugPrintln("*** batnaBuildingTime = " + batnaBuildingTime);
        int[] rollsPerResource = estimate.getRollsPerResource();
        int[] neededRsrc = new int[5];
        int[] notNeededRsrc = new int[5];
        int neededRsrcCount = 0;
        int notNeededRsrcCount = 0;
        for (int rsrcType = 1; rsrcType <= 5; ++rsrcType) {
            if (targetResources.getAmount(rsrcType) > 0) {
                neededRsrc[neededRsrcCount] = rsrcType;
                ++neededRsrcCount;
                continue;
            }
            notNeededRsrc[notNeededRsrcCount] = rsrcType;
            ++notNeededRsrcCount;
        }
        for (j = neededRsrcCount - 1; j >= 0; --j) {
            for (i = 0; i < j; ++i) {
                if (rollsPerResource[neededRsrc[i]] <= rollsPerResource[neededRsrc[i + 1]]) continue;
                tmp = neededRsrc[i];
                neededRsrc[i] = neededRsrc[i + 1];
                neededRsrc[i + 1] = tmp;
            }
        }
        for (j = notNeededRsrcCount - 1; j >= 0; --j) {
            for (i = 0; i < j; ++i) {
                if (rollsPerResource[notNeededRsrc[i]] <= rollsPerResource[notNeededRsrc[i + 1]]) continue;
                tmp = notNeededRsrc[i];
                notNeededRsrc[i] = notNeededRsrc[i + 1];
                notNeededRsrc[i + 1] = tmp;
            }
        }
        for (getRsrcIdx = neededRsrcCount - 1; getRsrcIdx >= 0 && (ourResources.getAmount(neededRsrc[getRsrcIdx]) >= targetResources.getAmount(neededRsrc[getRsrcIdx]) || originalOffer.getGiveSet().getAmount(neededRsrc[getRsrcIdx]) == 0); --getRsrcIdx) {
        }
        if (getRsrcIdx >= 0) {
            D.ebugPrintln("*** getRsrc = " + neededRsrc[getRsrcIdx]);
            getResourceSet.add(1, neededRsrc[getRsrcIdx]);
            D.ebugPrintln("*** counterOffer should be null : counterOffer = " + counterOffer);
            for (int giveRsrcIdx = 0; giveRsrcIdx < notNeededRsrcCount && counterOffer == null; ++giveRsrcIdx) {
                D.ebugPrintln("*** ourResources.getAmount(" + notNeededRsrc[giveRsrcIdx] + ") = " + ourResources.getAmount(notNeededRsrc[giveRsrcIdx]));
                if (ourResources.getAmount(notNeededRsrc[giveRsrcIdx]) <= 0) continue;
                giveResourceSet.clear();
                giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx]);
                counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                D.ebugPrintln("*** counterOffer = " + counterOffer);
            }
            D.ebugPrintln("*** ourResources = " + ourResources);
            if (counterOffer == null) {
                for (int giveRsrcIdx12 = 0; giveRsrcIdx12 < neededRsrcCount && counterOffer == null; ++giveRsrcIdx12) {
                    D.ebugPrintln("*** ourResources.getAmount(" + neededRsrc[giveRsrcIdx12] + ") = " + ourResources.getAmount(neededRsrc[giveRsrcIdx12]));
                    D.ebugPrintln("*** targetResources.getAmount(" + neededRsrc[giveRsrcIdx12] + ") = " + targetResources.getAmount(neededRsrc[giveRsrcIdx12]));
                    if (ourResources.getAmount(neededRsrc[giveRsrcIdx12]) <= targetResources.getAmount(neededRsrc[giveRsrcIdx12]) || neededRsrc[giveRsrcIdx12] == neededRsrc[getRsrcIdx]) continue;
                    giveResourceSet.clear();
                    giveResourceSet.add(1, neededRsrc[giveRsrcIdx12]);
                    int offerBuildingTime2 = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                    if (offerBuildingTime2 >= batnaBuildingTime && (batna == null || offerBuildingTime2 != batnaBuildingTime || giveResourceSet.getTotal() >= batna.getGiveSet().getTotal())) continue;
                    counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                    D.ebugPrintln("*** counterOffer = " + counterOffer);
                    D.ebugPrintln("*** offerBuildingTime = " + offerBuildingTime2);
                }
            }
            D.ebugPrintln("*** ourResources = " + ourResources);
            SOCResourceSet leftovers = ourResources.copy();
            leftovers.subtract(targetResources);
            D.ebugPrintln("*** leftovers = " + leftovers);
            if (counterOffer == null) {
                int offerBuildingTime3;
                int giveRsrcIdx2 = 0;
                for (giveRsrcIdx1 = 0; giveRsrcIdx1 < notNeededRsrcCount && counterOffer == null; ++giveRsrcIdx1) {
                    if (ourResources.getAmount(notNeededRsrc[giveRsrcIdx1]) <= 0) continue;
                    while (giveRsrcIdx2 < notNeededRsrcCount && counterOffer == null) {
                        giveResourceSet.clear();
                        giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx1]);
                        giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx2]);
                        if (ourResources.contains(giveResourceSet) && ((offerBuildingTime3 = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate)) < batnaBuildingTime || batna != null && offerBuildingTime3 == batnaBuildingTime && giveResourceSet.getTotal() < batna.getGiveSet().getTotal())) {
                            counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                            D.ebugPrintln("*** counterOffer = " + counterOffer);
                            D.ebugPrintln("*** offerBuildingTime = " + offerBuildingTime3);
                        }
                        ++giveRsrcIdx2;
                    }
                    for (giveRsrcIdx2 = 0; giveRsrcIdx2 < neededRsrcCount && counterOffer == null; ++giveRsrcIdx2) {
                        if (neededRsrc[giveRsrcIdx2] == neededRsrc[getRsrcIdx]) continue;
                        giveResourceSet.clear();
                        giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx1]);
                        giveResourceSet.add(1, neededRsrc[giveRsrcIdx2]);
                        if (!leftovers.contains(giveResourceSet) || (offerBuildingTime3 = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate)) >= batnaBuildingTime && (batna == null || offerBuildingTime3 != batnaBuildingTime || giveResourceSet.getTotal() >= batna.getGiveSet().getTotal())) continue;
                        counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                        D.ebugPrintln("*** counterOffer = " + counterOffer);
                        D.ebugPrintln("*** offerBuildingTime = " + offerBuildingTime3);
                    }
                }
                giveRsrcIdx2 = 0;
                for (giveRsrcIdx1 = 0; giveRsrcIdx1 < neededRsrcCount && counterOffer == null; ++giveRsrcIdx1) {
                    if (leftovers.getAmount(neededRsrc[giveRsrcIdx1]) <= 0 || neededRsrc[giveRsrcIdx1] == neededRsrc[getRsrcIdx]) continue;
                    while (giveRsrcIdx2 < notNeededRsrcCount && counterOffer == null) {
                        giveResourceSet.clear();
                        giveResourceSet.add(1, neededRsrc[giveRsrcIdx1]);
                        giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx2]);
                        if (leftovers.contains(giveResourceSet) && ((offerBuildingTime3 = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate)) < batnaBuildingTime || batna != null && offerBuildingTime3 == batnaBuildingTime && giveResourceSet.getTotal() < batna.getGiveSet().getTotal())) {
                            counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                            D.ebugPrintln("*** counterOffer = " + counterOffer);
                            D.ebugPrintln("*** offerBuildingTime = " + offerBuildingTime3);
                        }
                        ++giveRsrcIdx2;
                    }
                    for (giveRsrcIdx2 = 0; giveRsrcIdx2 < neededRsrcCount && counterOffer == null; ++giveRsrcIdx2) {
                        if (neededRsrc[giveRsrcIdx2] == neededRsrc[getRsrcIdx]) continue;
                        giveResourceSet.clear();
                        giveResourceSet.add(1, neededRsrc[giveRsrcIdx1]);
                        giveResourceSet.add(1, neededRsrc[giveRsrcIdx2]);
                        if (!leftovers.contains(giveResourceSet) || (offerBuildingTime3 = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate)) >= batnaBuildingTime && (batna == null || offerBuildingTime3 != batnaBuildingTime || giveResourceSet.getTotal() >= batna.getGiveSet().getTotal())) continue;
                        counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                        D.ebugPrintln("*** counterOffer = " + counterOffer);
                        D.ebugPrintln("*** offerBuildingTime = " + offerBuildingTime3);
                    }
                }
            }
        }
        if (counterOffer == null) {
            int getRsrcIdx2;
            SOCResourceSet leftovers = ourResources.copy();
            leftovers.subtract(targetResources);
            D.ebugPrintln("*** leftovers = " + leftovers);
            for (getRsrcIdx2 = notNeededRsrcCount - 1; getRsrcIdx2 >= 0 && originalOffer.getGiveSet().getAmount(notNeededRsrc[getRsrcIdx2]) == 0; --getRsrcIdx2) {
            }
            while (getRsrcIdx2 >= 0 && counterOffer == null) {
                getResourceSet.clear();
                getResourceSet.add(1, notNeededRsrc[getRsrcIdx2]);
                leftovers.add(1, notNeededRsrc[getRsrcIdx2]);
                if (counterOffer == null) {
                    for (giveRsrcIdx1 = 0; giveRsrcIdx1 < notNeededRsrcCount && counterOffer == null; ++giveRsrcIdx1) {
                        if (leftovers.getAmount(notNeededRsrc[giveRsrcIdx1]) <= 0 || notNeededRsrc[giveRsrcIdx1] == notNeededRsrc[getRsrcIdx2]) continue;
                        leftovers.subtract(1, notNeededRsrc[giveRsrcIdx1]);
                        if (this.getOfferToBank(targetResources, leftovers) != null) {
                            giveResourceSet.clear();
                            giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx1]);
                            offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                            if (offerBuildingTime < batnaBuildingTime) {
                                counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, notNeededRsrc[getRsrcIdx2]);
                                D.ebugPrintln("*** counterOffer = " + counterOffer);
                                D.ebugPrintln("*** offerBuildingTime = " + offerBuildingTime);
                            }
                        }
                        leftovers.add(1, notNeededRsrc[giveRsrcIdx1]);
                    }
                }
                if (counterOffer == null) {
                    for (giveRsrcIdx1 = 0; giveRsrcIdx1 < neededRsrcCount && counterOffer == null; ++giveRsrcIdx1) {
                        if (leftovers.getAmount(neededRsrc[giveRsrcIdx1]) <= 0) continue;
                        leftovers.subtract(1, neededRsrc[giveRsrcIdx1]);
                        if (this.getOfferToBank(targetResources, leftovers) != null) {
                            giveResourceSet.clear();
                            giveResourceSet.add(1, neededRsrc[giveRsrcIdx1]);
                            offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                            if (offerBuildingTime < batnaBuildingTime) {
                                counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, notNeededRsrc[getRsrcIdx2]);
                                D.ebugPrintln("*** counterOffer = " + counterOffer);
                            }
                        }
                        leftovers.add(1, neededRsrc[giveRsrcIdx1]);
                    }
                }
                leftovers.subtract(1, notNeededRsrc[getRsrcIdx2]);
                --getRsrcIdx2;
            }
        }
        if (counterOffer == null) {
            int getRsrcIdx2;
            SOCResourceSet leftovers = ourResources.copy();
            leftovers.subtract(targetResources);
            D.ebugPrintln("*** leftovers = " + leftovers);
            for (getRsrcIdx2 = notNeededRsrcCount - 1; getRsrcIdx2 >= 0 && originalOffer.getGiveSet().getAmount(notNeededRsrc[getRsrcIdx2]) == 0; --getRsrcIdx2) {
            }
            while (getRsrcIdx2 >= 0 && counterOffer == null) {
                getResourceSet.clear();
                getResourceSet.add(2, notNeededRsrc[getRsrcIdx2]);
                leftovers.add(2, notNeededRsrc[getRsrcIdx2]);
                if (counterOffer == null) {
                    for (giveRsrcIdx1 = 0; giveRsrcIdx1 < notNeededRsrcCount && counterOffer == null; ++giveRsrcIdx1) {
                        if (leftovers.getAmount(notNeededRsrc[giveRsrcIdx1]) <= 0 || notNeededRsrc[giveRsrcIdx1] == notNeededRsrc[getRsrcIdx2]) continue;
                        leftovers.subtract(1, notNeededRsrc[giveRsrcIdx1]);
                        if (this.getOfferToBank(targetResources, leftovers) != null) {
                            giveResourceSet.clear();
                            giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx1]);
                            offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                            if (offerBuildingTime < batnaBuildingTime) {
                                counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, notNeededRsrc[getRsrcIdx2]);
                                D.ebugPrintln("*** counterOffer = " + counterOffer);
                                D.ebugPrintln("*** offerBuildingTime = " + offerBuildingTime);
                            }
                        }
                        leftovers.add(1, notNeededRsrc[giveRsrcIdx1]);
                    }
                }
                if (counterOffer == null) {
                    for (giveRsrcIdx1 = 0; giveRsrcIdx1 < neededRsrcCount && counterOffer == null; ++giveRsrcIdx1) {
                        if (leftovers.getAmount(neededRsrc[giveRsrcIdx1]) <= 0) continue;
                        leftovers.subtract(1, neededRsrc[giveRsrcIdx1]);
                        if (this.getOfferToBank(targetResources, leftovers) != null) {
                            giveResourceSet.clear();
                            giveResourceSet.add(1, neededRsrc[giveRsrcIdx1]);
                            offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                            if (offerBuildingTime < batnaBuildingTime) {
                                counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, notNeededRsrc[getRsrcIdx2]);
                                D.ebugPrintln("*** counterOffer = " + counterOffer);
                            }
                        }
                        leftovers.add(1, neededRsrc[giveRsrcIdx1]);
                    }
                }
                leftovers.subtract(2, notNeededRsrc[getRsrcIdx2]);
                --getRsrcIdx2;
            }
        }
        if (counterOffer == null) {
            int getRsrcIdx2;
            SOCResourceSet leftovers = ourResources.copy();
            leftovers.subtract(targetResources);
            D.ebugPrintln("*** leftovers = " + leftovers);
            for (getRsrcIdx2 = notNeededRsrcCount - 1; getRsrcIdx2 >= 0 && originalOffer.getGiveSet().getAmount(notNeededRsrc[getRsrcIdx2]) == 0; --getRsrcIdx2) {
            }
            while (getRsrcIdx2 >= 0 && counterOffer == null) {
                getResourceSet.clear();
                getResourceSet.add(3, notNeededRsrc[getRsrcIdx2]);
                leftovers.add(3, notNeededRsrc[getRsrcIdx2]);
                if (counterOffer == null) {
                    for (giveRsrcIdx1 = 0; giveRsrcIdx1 < notNeededRsrcCount && counterOffer == null; ++giveRsrcIdx1) {
                        if (leftovers.getAmount(notNeededRsrc[giveRsrcIdx1]) <= 0 || notNeededRsrc[giveRsrcIdx1] == notNeededRsrc[getRsrcIdx2]) continue;
                        leftovers.subtract(1, notNeededRsrc[giveRsrcIdx1]);
                        if (this.getOfferToBank(targetResources, leftovers) != null) {
                            giveResourceSet.clear();
                            giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx1]);
                            offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                            if (offerBuildingTime < batnaBuildingTime) {
                                counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, notNeededRsrc[getRsrcIdx2]);
                                D.ebugPrintln("*** counterOffer = " + counterOffer);
                                D.ebugPrintln("*** offerBuildingTime = " + offerBuildingTime);
                            }
                        }
                        leftovers.add(1, notNeededRsrc[giveRsrcIdx1]);
                    }
                }
                if (counterOffer == null) {
                    for (giveRsrcIdx1 = 0; giveRsrcIdx1 < neededRsrcCount && counterOffer == null; ++giveRsrcIdx1) {
                        if (leftovers.getAmount(neededRsrc[giveRsrcIdx1]) <= 0) continue;
                        leftovers.subtract(1, neededRsrc[giveRsrcIdx1]);
                        if (this.getOfferToBank(targetResources, leftovers) != null) {
                            giveResourceSet.clear();
                            giveResourceSet.add(1, neededRsrc[giveRsrcIdx1]);
                            offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                            if (offerBuildingTime < batnaBuildingTime) {
                                counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, notNeededRsrc[getRsrcIdx2]);
                                D.ebugPrintln("*** counterOffer = " + counterOffer);
                            }
                        }
                        leftovers.add(1, neededRsrc[giveRsrcIdx1]);
                    }
                }
                leftovers.subtract(3, notNeededRsrc[getRsrcIdx2]);
                --getRsrcIdx2;
            }
        }
        return counterOffer;
    }

    public SOCTradeOffer getOfferToBank(SOCResourceSet targetResources, SOCResourceSet ourResources) {
        int tradeRatio;
        int giveRsrcIdx;
        int tmp;
        int i;
        int j;
        SOCTradeOffer bankTrade = null;
        if (ourResources.contains(targetResources)) {
            return bankTrade;
        }
        SOCBuildingSpeedEstimate estimate = new SOCBuildingSpeedEstimate(this.ourPlayerData.getNumbers());
        int[] rollsPerResource = estimate.getRollsPerResource();
        boolean[] ports = this.ourPlayerData.getPortFlags();
        int[] neededRsrc = new int[5];
        int[] notNeededRsrc = new int[5];
        int neededRsrcCount = 0;
        int notNeededRsrcCount = 0;
        for (int rsrcType = 1; rsrcType <= 5; ++rsrcType) {
            if (targetResources.getAmount(rsrcType) > 0) {
                neededRsrc[neededRsrcCount] = rsrcType;
                ++neededRsrcCount;
                continue;
            }
            notNeededRsrc[notNeededRsrcCount] = rsrcType;
            ++notNeededRsrcCount;
        }
        for (j = neededRsrcCount - 1; j >= 0; --j) {
            for (i = 0; i < j; ++i) {
                if (rollsPerResource[neededRsrc[i]] <= rollsPerResource[neededRsrc[i + 1]]) continue;
                tmp = neededRsrc[i];
                neededRsrc[i] = neededRsrc[i + 1];
                neededRsrc[i + 1] = tmp;
            }
        }
        for (j = notNeededRsrcCount - 1; j >= 0; --j) {
            for (i = 0; i < j; ++i) {
                if (rollsPerResource[notNeededRsrc[i]] <= rollsPerResource[notNeededRsrc[i + 1]]) continue;
                tmp = notNeededRsrc[i];
                notNeededRsrc[i] = notNeededRsrc[i + 1];
                notNeededRsrc[i + 1] = tmp;
            }
        }
        int getRsrcIdx = neededRsrcCount - 1;
        while (ourResources.getAmount(neededRsrc[getRsrcIdx]) >= targetResources.getAmount(neededRsrc[getRsrcIdx])) {
            --getRsrcIdx;
        }
        for (giveRsrcIdx = 0; giveRsrcIdx < notNeededRsrcCount; ++giveRsrcIdx) {
            tradeRatio = ports[notNeededRsrc[giveRsrcIdx]] ? 2 : (ports[0] ? 3 : 4);
            if (ourResources.getAmount(notNeededRsrc[giveRsrcIdx]) < tradeRatio) continue;
            SOCResourceSet give = new SOCResourceSet();
            SOCResourceSet get = new SOCResourceSet();
            give.add(tradeRatio, notNeededRsrc[giveRsrcIdx]);
            get.add(1, neededRsrc[getRsrcIdx]);
            boolean[] to = new boolean[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                to[i2] = false;
            }
            bankTrade = new SOCTradeOffer(this.game.getName(), this.ourPlayerData.getPlayerNumber(), to, give, get);
            return bankTrade;
        }
        for (giveRsrcIdx = 0; giveRsrcIdx < neededRsrcCount; ++giveRsrcIdx) {
            tradeRatio = ports[neededRsrc[giveRsrcIdx]] ? 2 : (ports[0] ? 3 : 4);
            if (rollsPerResource[neededRsrc[giveRsrcIdx]] >= rollsPerResource[neededRsrc[getRsrcIdx]]) {
                if (ourResources.getAmount(neededRsrc[giveRsrcIdx]) - targetResources.getAmount(neededRsrc[giveRsrcIdx]) < tradeRatio) continue;
                SOCResourceSet give = new SOCResourceSet();
                SOCResourceSet get = new SOCResourceSet();
                give.add(tradeRatio, neededRsrc[giveRsrcIdx]);
                get.add(1, neededRsrc[getRsrcIdx]);
                boolean[] to = new boolean[4];
                for (int i3 = 0; i3 < 4; ++i3) {
                    to[i3] = false;
                }
                bankTrade = new SOCTradeOffer(this.game.getName(), this.ourPlayerData.getPlayerNumber(), to, give, get);
                return bankTrade;
            }
            if (ourResources.getAmount(neededRsrc[giveRsrcIdx]) < tradeRatio) continue;
            SOCResourceSet give = new SOCResourceSet();
            SOCResourceSet get = new SOCResourceSet();
            give.add(tradeRatio, neededRsrc[giveRsrcIdx]);
            get.add(1, neededRsrc[getRsrcIdx]);
            boolean[] to = new boolean[4];
            for (int i4 = 0; i4 < 4; ++i4) {
                to[i4] = false;
            }
            bankTrade = new SOCTradeOffer(this.game.getName(), this.ourPlayerData.getPlayerNumber(), to, give, get);
            return bankTrade;
        }
        return bankTrade;
    }

    public SOCTradeOffer getOfferToBank(SOCResourceSet targetResources) {
        return this.getOfferToBank(targetResources, this.ourPlayerData.getResources());
    }
}

