/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.Vector;
import soc.game.SOCResourceSet;

public class SOCTradeTree {
    SOCResourceSet resourceSet;
    SOCTradeTree parent;
    Vector children;
    boolean needsToBeExpanded;

    public SOCTradeTree(SOCResourceSet set, SOCTradeTree par) {
        this.resourceSet = set;
        this.needsToBeExpanded = true;
        this.children = new Vector();
        if (par != null) {
            par.addChild(this);
        } else {
            this.parent = null;
        }
    }

    public SOCTradeTree(SOCResourceSet set) {
        this.resourceSet = set;
        this.parent = null;
        this.needsToBeExpanded = false;
        this.children = new Vector();
    }

    public SOCResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public SOCTradeTree getParent() {
        return this.parent;
    }

    public boolean needsToBeExpanded() {
        return this.needsToBeExpanded;
    }

    public Vector getChildren() {
        return this.children;
    }

    public void setParent(SOCTradeTree p) {
        this.parent = p;
    }

    public void setNeedsToBeExpanded(boolean value) {
        this.needsToBeExpanded = value;
    }

    public void addChild(SOCTradeTree child) {
        this.children.addElement(child);
        child.setParent(this);
    }
}

