/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import smartsettlers.boardlayout.GameStateConstants;
import smartsettlers.player.Player;
import soc.debug.D;
import soc.game.SOCBoard;
import soc.game.SOCCity;
import soc.game.SOCDevCardSet;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCSettlement;
import soc.game.SOCTradeOffer;
import soc.message.SOCAcceptOffer;
import soc.message.SOCChoosePlayerRequest;
import soc.message.SOCClearOffer;
import soc.message.SOCDevCard;
import soc.message.SOCDevCardCount;
import soc.message.SOCDiceResult;
import soc.message.SOCDiscardRequest;
import soc.message.SOCFirstPlayer;
import soc.message.SOCGameState;
import soc.message.SOCGameTextMsg;
import soc.message.SOCMakeOffer;
import soc.message.SOCMessage;
import soc.message.SOCMoveRobber;
import soc.message.SOCPlayerElement;
import soc.message.SOCPotentialSettlements;
import soc.message.SOCPutPiece;
import soc.message.SOCRejectOffer;
import soc.message.SOCResourceCount;
import soc.message.SOCSetPlayedDevCard;
import soc.message.SOCSetTurn;
import soc.message.SOCTurn;
import soc.robot.SOCPlayerTracker;
import soc.robot.SOCPossibleCard;
import soc.robot.SOCPossibleCity;
import soc.robot.SOCPossibleRoad;
import soc.robot.SOCPossibleSettlement;
import soc.robot.SOCRobotBrain;
import soc.robot.SOCRobotClient;
import soc.robot.SSRobotClient;
import soc.util.CappedQueue;
import soc.util.SOCRobotParameters;

public class SSRobotBrain
extends SOCRobotBrain
implements GameStateConstants {
    int robberVictim = -1;

    public SSRobotBrain(SOCRobotClient rc, SOCRobotParameters params, SOCGame ga, CappedQueue mq) {
        super(rc, params, ga, mq);
    }

    @Override
    protected void placeFirstSettlement() {
        SSRobotClient rc = (SSRobotClient)this.client;
        rc.sendStateToSmartSettlers(this.game, 2);
        Player p = rc.bl.player[this.game.getCurrentPlayerNumber()];
        rc.bl.possibilities.Clear();
        p.listInitSettlementPossibilities(rc.bl.state);
        p.selectAction(rc.bl.state, rc.bl.action);
        p.performAction(rc.bl.state, rc.bl.action);
        System.out.printf("Performing action: [%d %d %d %d %d]", rc.bl.action[0], rc.bl.action[1], rc.bl.action[2], rc.bl.action[3], rc.bl.action[4]);
        this.firstSettlement = rc.translateVertexToJSettlers(rc.bl.action[1]);
        System.out.println("BUILD REQUEST FOR SETTLEMENT AT " + Integer.toHexString(this.firstSettlement));
        this.pause(2000);
        this.client.putPiece(this.game, new SOCSettlement(this.ourPlayerData, this.firstSettlement));
        this.pause(1000);
    }

    @Override
    protected void placeSecondSettlement() {
        SSRobotClient rc = (SSRobotClient)this.client;
        rc.sendStateToSmartSettlers(this.game, 4);
        Player p = rc.bl.player[this.game.getCurrentPlayerNumber()];
        rc.bl.possibilities.Clear();
        p.listInitSettlementPossibilities(rc.bl.state);
        p.selectAction(rc.bl.state, rc.bl.action);
        p.performAction(rc.bl.state, rc.bl.action);
        System.out.printf("Performing action: [%d %d %d %d %d]", rc.bl.action[0], rc.bl.action[1], rc.bl.action[2], rc.bl.action[3], rc.bl.action[4]);
        this.secondSettlement = rc.translateVertexToJSettlers(rc.bl.action[1]);
        System.out.println("BUILD REQUEST FOR SETTLEMENT AT " + Integer.toHexString(this.secondSettlement));
        this.pause(2000);
        this.client.putPiece(this.game, new SOCSettlement(this.ourPlayerData, this.secondSettlement));
        this.pause(1000);
    }

    @Override
    public void placeInitRoad() {
        SSRobotClient rc = (SSRobotClient)this.client;
        rc.sendStateToSmartSettlers(this.game, 3);
        Player p = rc.bl.player[this.game.getCurrentPlayerNumber()];
        rc.bl.possibilities.Clear();
        p.listInitRoadPossibilities(rc.bl.state);
        p.selectAction(rc.bl.state, rc.bl.action);
        p.performAction(rc.bl.state, rc.bl.action);
        System.out.printf("Performing action: [%d %d %d %d %d]", rc.bl.action[0], rc.bl.action[1], rc.bl.action[2], rc.bl.action[3], rc.bl.action[4]);
        int roadEdge = rc.translateEdgeToJSettlers(rc.bl.action[1]);
        System.out.println("!!! PUTTING INIT ROAD !!!");
        this.pause(2000);
        System.out.println("Trying to build a road at " + Integer.toHexString(roadEdge));
        this.client.putPiece(this.game, new SOCRoad(this.ourPlayerData, roadEdge));
        this.pause(1000);
    }

    @Override
    protected int considerOffer(SOCTradeOffer offer) {
        int response = 0;
        return response;
    }

    @Override
    protected void moveRobber() {
        System.out.printf("move robber.\n", new Object[0]);
        this.pause(1000);
        SSRobotClient rc = (SSRobotClient)this.client;
        rc.sendStateToSmartSettlers(this.game, 15);
        System.out.printf("move robber.\n", new Object[0]);
        Player p = rc.bl.player[this.game.getCurrentPlayerNumber()];
        rc.bl.possibilities.Clear();
        p.listRobberPossibilities(rc.bl.state, 13);
        System.out.printf("move robber.\n", new Object[0]);
        p.selectAction(rc.bl.state, rc.bl.action);
        System.out.printf("move robber.\n", new Object[0]);
        p.performAction(rc.bl.state, rc.bl.action);
        System.out.printf("Performing action: [%d %d %d %d %d]", rc.bl.action[0], rc.bl.action[1], rc.bl.action[2], rc.bl.action[3], rc.bl.action[4]);
        int bestHex = rc.translateHexToJSettlers(rc.bl.action[1]);
        System.out.printf(" besthex: %X\n", bestHex);
        this.robberVictim = rc.bl.action[2];
        D.ebugPrintln("!!! MOVING ROBBER !!!");
        this.client.moveRobber(this.game, this.ourPlayerData, bestHex);
        int xn = (int)rc.bl.hextiles[rc.bl.action[1]].pos.x;
        int yn = (int)rc.bl.hextiles[rc.bl.action[1]].pos.y;
        System.out.printf("MOVE robber to hex %x (hex %d, coord: %d,%d), steal from %d \n", bestHex, rc.bl.action[1], xn, yn, this.robberVictim);
        this.pause(2000);
    }

    @Override
    protected void chooseRobberVictim(boolean[] choices) {
        this.pause(1000);
        this.client.choosePlayer(this.game, this.robberVictim);
        this.pause(1000);
    }

    public void getActionForPLAY() {
        SSRobotClient rc = (SSRobotClient)this.client;
        rc.sendStateToSmartSettlers(this.game, 6);
        this.printCardState();
        Player p = rc.bl.player[this.game.getCurrentPlayerNumber()];
        rc.bl.possibilities.Clear();
        p.listPossibilities(rc.bl.state);
        p.selectAction(rc.bl.state, rc.bl.action);
        p.performAction(rc.bl.state, rc.bl.action);
        System.out.printf("Performing action: [%d %d %d %d %d]", rc.bl.action[0], rc.bl.action[1], rc.bl.action[2], rc.bl.action[3], rc.bl.action[4]);
        switch (rc.bl.action[0]) {
            case 8: {
                this.expectPLACING_ROBBER = true;
                this.waitingForGameState = true;
                this.counter = 0;
                this.client.playDevCard(this.game, 0);
                this.pause(1500);
                break;
            }
            case 4: {
                this.expectDICERESULT = true;
                this.counter = 0;
                System.out.println("!!! ROLLING DICE !!!");
                this.client.rollDice(this.game);
            }
        }
    }

    public void printCardState() {
        SSRobotClient rc = (SSRobotClient)this.client;
        int[] st = rc.bl.state;
        int fsmlevel = st[1];
        int pl = st[5 + fsmlevel];
        Player p = rc.bl.player[pl];
        String s = String.format("--- Card state according to SmartSettlers:\npl:%d  cardplayed: %d,  new: %d %d %d %d %d,   old: %d %d %d %d %d \n", pl, st[OFS_PLAYERDATA[pl] + 5], st[OFS_PLAYERDATA[pl] + 27 + 0], st[OFS_PLAYERDATA[pl] + 27 + 2], st[OFS_PLAYERDATA[pl] + 27 + 3], st[OFS_PLAYERDATA[pl] + 27 + 4], st[OFS_PLAYERDATA[pl] + 27 + 1], st[OFS_PLAYERDATA[pl] + 22 + 0], st[OFS_PLAYERDATA[pl] + 22 + 2], st[OFS_PLAYERDATA[pl] + 22 + 3], st[OFS_PLAYERDATA[pl] + 22 + 4], st[OFS_PLAYERDATA[pl] + 22 + 1]);
        System.out.print(s);
        int spl = this.game.getCurrentPlayerNumber();
        SOCPlayer sp = this.game.getPlayer(spl);
        SOCDevCardSet ds = sp.getDevCards();
        s = String.format("--- Card state according to JSettlers:\npl:%d  cardplayed: %d,  new: %d %d %d %d %d,   old: %d %d %d %d %d \n", spl, sp.hasPlayedDevCard() ? 1 : 0, ds.getAmount(1, 0), ds.getAmount(1, 1), ds.getAmount(1, 2), ds.getAmount(1, 3), 0, ds.getAmount(0, 0), ds.getAmount(0, 1), ds.getAmount(0, 2), ds.getAmount(0, 3), ds.getNumVPCards());
        System.out.print(s);
    }

    public void getActionForPLAY1() {
        SSRobotClient rc = (SSRobotClient)this.client;
        rc.sendStateToSmartSettlers(this.game, 100);
        this.printCardState();
        Player p = rc.bl.player[this.game.getCurrentPlayerNumber()];
        rc.bl.possibilities.Clear();
        p.listNormalPossibilities(rc.bl.state);
        p.selectAction(rc.bl.state, rc.bl.action);
        p.performAction(rc.bl.state, rc.bl.action);
        switch (rc.bl.action[0]) {
            case 2: {
                int coord = rc.translateEdgeToJSettlers(rc.bl.action[1]);
                SOCPossibleRoad targetPiece = new SOCPossibleRoad(this.ourPlayerData, coord, new Vector());
                this.lastMove = targetPiece;
                this.waitingForGameState = true;
                this.counter = 0;
                this.expectPLACING_ROAD = true;
                this.whatWeWantToBuild = new SOCRoad(this.ourPlayerData, targetPiece.getCoordinates());
                D.ebugPrintln("!!! BUILD REQUEST FOR A ROAD AT " + Integer.toHexString(targetPiece.getCoordinates()) + " !!!");
                this.client.buildRequest(this.game, 0);
                System.out.println("ROAD built ");
                break;
            }
            case 1: {
                int coord = rc.translateVertexToJSettlers(rc.bl.action[1]);
                SOCPossibleSettlement targetPiece = new SOCPossibleSettlement(this.ourPlayerData, coord, new Vector());
                this.lastMove = targetPiece;
                this.waitingForGameState = true;
                this.counter = 0;
                this.expectPLACING_SETTLEMENT = true;
                this.whatWeWantToBuild = new SOCSettlement(this.ourPlayerData, targetPiece.getCoordinates());
                D.ebugPrintln("!!! BUILD REQUEST FOR A SETTLEMENT " + Integer.toHexString(targetPiece.getCoordinates()) + " !!!");
                this.client.buildRequest(this.game, 1);
                System.out.println("SETTLEMENT built ");
                break;
            }
            case 3: {
                int coord = rc.translateVertexToJSettlers(rc.bl.action[1]);
                SOCPossibleCity targetPiece = new SOCPossibleCity(this.ourPlayerData, coord);
                this.lastMove = targetPiece;
                this.waitingForGameState = true;
                this.counter = 0;
                this.expectPLACING_CITY = true;
                this.whatWeWantToBuild = new SOCCity(this.ourPlayerData, targetPiece.getCoordinates());
                D.ebugPrintln("!!! BUILD REQUEST FOR A CITY " + Integer.toHexString(targetPiece.getCoordinates()) + " !!!");
                this.client.buildRequest(this.game, 2);
                System.out.println("CITY built ");
                break;
            }
            case 7: {
                SOCPossibleCard targetPiece = new SOCPossibleCard(this.ourPlayerData, 1);
                this.lastMove = targetPiece;
                this.client.buyDevCard(this.game);
                this.printCardState();
                this.waitingForDevCard = true;
                System.out.println("CARD bought ");
                break;
            }
            case 11: {
                this.monopolyChoice = rc.translateResToJSettlers(rc.bl.action[1]);
                this.expectWAITING_FOR_MONOPOLY = true;
                this.waitingForGameState = true;
                this.counter = 0;
                this.client.playDevCard(this.game, 3);
                System.out.println("MONOPOLY played on " + rc.bl.action[1]);
                break;
            }
            case 10: {
                int a1 = rc.bl.action[1];
                int a2 = rc.bl.action[2];
                int cl = (a1 == 2 ? 1 : 0) + (a2 == 2 ? 1 : 0);
                int or = (a1 == 4 ? 1 : 0) + (a2 == 4 ? 1 : 0);
                int sh = (a1 == 0 ? 1 : 0) + (a2 == 0 ? 1 : 0);
                int wh = (a1 == 3 ? 1 : 0) + (a2 == 3 ? 1 : 0);
                int wo = (a1 == 1 ? 1 : 0) + (a2 == 1 ? 1 : 0);
                this.resourceChoices = new SOCResourceSet(cl, or, sh, wh, wo, 0);
                this.expectWAITING_FOR_DISCOVERY = true;
                this.waitingForGameState = true;
                this.counter = 0;
                this.client.playDevCard(this.game, 2);
                System.out.printf("FREE RESOURCE to get %d,%d \n", rc.bl.action[1], rc.bl.action[2]);
                break;
            }
            case 9: {
                this.waitingForGameState = true;
                this.counter = 0;
                this.expectPLACING_FREE_ROAD1 = true;
                System.out.println("!! PLAYING ROAD BUILDING CARD");
                this.client.playDevCard(this.game, 1);
                System.out.printf("FREE ROADS played \n", new Object[0]);
                break;
            }
            case 8: {
                this.expectPLACING_ROBBER = true;
                this.waitingForGameState = true;
                this.counter = 0;
                this.client.playDevCard(this.game, 0);
                this.pause(1500);
                break;
            }
            case 6: {
                this.counter = 0;
                this.waitingForTradeMsg = true;
                boolean[] to = new boolean[4];
                for (int i = 0; i < 4; ++i) {
                    to[i] = false;
                }
                SOCResourceSet give = new SOCResourceSet();
                SOCResourceSet get = new SOCResourceSet();
                give.add(rc.bl.action[1], rc.translateResToJSettlers(rc.bl.action[2]));
                get.add(rc.bl.action[3], rc.translateResToJSettlers(rc.bl.action[4]));
                SOCTradeOffer bankTrade = new SOCTradeOffer(this.game.getName(), this.ourPlayerData.getPlayerNumber(), to, give, get);
                this.client.bankTrade(this.game, bankTrade.getGiveSet(), bankTrade.getGetSet());
                this.pause(2000);
                break;
            }
            case 5: {
                this.waitingForGameState = true;
                this.counter = 0;
                this.expectPLAY = true;
                this.waitingForOurTurn = true;
                this.doneTrading = this.robotParameters.getTradeFlag() != 1;
                System.out.println("!!! ENDING TURN !!!");
                this.negotiator.resetIsSelling();
                this.negotiator.resetOffersMade();
                this.buildingPlan.clear();
                this.negotiator.resetTargetPieces();
                this.pause(1500);
                this.client.endTurn(this.game);
                break;
            }
        }
    }

    public void getActionForFREEROAD() {
        SSRobotClient rc = (SSRobotClient)this.client;
        rc.sendStateToSmartSettlers(this.game, 13);
        Player p = rc.bl.player[this.game.getCurrentPlayerNumber()];
        rc.bl.possibilities.Clear();
        p.listRoadPossibilities(rc.bl.state);
        p.selectAction(rc.bl.state, rc.bl.action);
        p.performAction(rc.bl.state, rc.bl.action);
        System.out.printf("Performing action: [%d %d %d %d %d]", rc.bl.action[0], rc.bl.action[1], rc.bl.action[2], rc.bl.action[3], rc.bl.action[4]);
        int coord = rc.translateEdgeToJSettlers(rc.bl.action[1]);
        SOCPossibleRoad targetPiece = new SOCPossibleRoad(this.ourPlayerData, coord, new Vector());
        this.whatWeWantToBuild = new SOCRoad(this.ourPlayerData, targetPiece.getCoordinates());
        D.ebugPrintln("!!! FREE ROAD ROAD AT " + Integer.toHexString(targetPiece.getCoordinates()) + " !!!");
        System.out.println("FREE ROAD built ");
        this.pause(500);
        this.client.putPiece(this.game, this.whatWeWantToBuild);
        this.pause(1000);
    }

    @Override
    public void run() {
        if (this.pinger != null) {
            this.pinger.start();
            try {
                while (this.alive) {
                    SOCPlayer player;
                    SOCPlayer pl;
                    int rsrcType;
                    SOCResourceSet getSet;
                    int mesType;
                    SOCMessage mes = (SOCMessage)this.gameEventQ.get();
                    ((SSRobotClient)this.client).sendStateToSmartSettlers(this.game, 0);
                    if (mes != null) {
                        mesType = mes.getType();
                        D.ebugPrintln("mes - " + mes);
                    } else {
                        mesType = -1;
                    }
                    if (this.waitingForTradeResponse && this.counter > 100) {
                        System.out.println("NOT WAITING ANY MORE FOR TRADE RESPONSE");
                        SOCTradeOffer ourCurrentOffer = this.ourPlayerData.getCurrentOffer();
                        if (ourCurrentOffer != null) {
                            boolean[] offeredTo = ourCurrentOffer.getTo();
                            getSet = ourCurrentOffer.getGetSet();
                            for (rsrcType = 1; rsrcType <= 5; ++rsrcType) {
                                if (getSet.getAmount(rsrcType) <= 0) continue;
                                for (int pn = 0; pn < 4; ++pn) {
                                    if (!offeredTo[pn]) continue;
                                    this.negotiator.markAsNotSelling(pn, rsrcType);
                                    this.negotiator.markAsNotWantingAnotherOffer(pn, rsrcType);
                                }
                            }
                            this.pause(1500);
                            this.client.clearOffer(this.game);
                            this.pause(500);
                        }
                        this.counter = 0;
                        this.waitingForTradeResponse = false;
                    }
                    if (this.waitingForGameState && this.counter > 10000) {
                        System.out.println("counter = " + this.counter);
                        System.out.println("RESEND");
                        this.counter = 0;
                        this.client.resend();
                    }
                    if (mesType == 1025) {
                        this.waitingForGameState = false;
                        this.oldGameState = this.game.getGameState();
                        this.game.setGameState(((SOCGameState)mes).getState());
                    } else if (mesType == 1054) {
                        this.game.setFirstPlayer(((SOCFirstPlayer)mes).getPlayerNumber());
                    } else if (mesType == 1055) {
                        this.game.setCurrentPlayerNumber(((SOCSetTurn)mes).getPlayerNumber());
                    } else if (mesType == 1026) {
                        if (this.game.getFirstPlayer() == -1) {
                            this.game.setFirstPlayer(((SOCTurn)mes).getPlayerNumber());
                        }
                        this.game.setCurrentPlayerNumber(((SOCTurn)mes).getPlayerNumber());
                        this.game.getPlayer(((SOCTurn)mes).getPlayerNumber()).getDevCards().newToOld();
                        this.expectPLAY = false;
                        this.expectPLAY1 = false;
                        this.expectPLACING_ROAD = false;
                        this.expectPLACING_SETTLEMENT = false;
                        this.expectPLACING_CITY = false;
                        this.expectPLACING_ROBBER = false;
                        this.expectPLACING_FREE_ROAD1 = false;
                        this.expectPLACING_FREE_ROAD2 = false;
                        this.expectDICERESULT = false;
                        this.expectDISCARD = false;
                        this.expectMOVEROBBER = false;
                        this.expectWAITING_FOR_DISCOVERY = false;
                        this.expectWAITING_FOR_MONOPOLY = false;
                        this.doneTrading = this.robotParameters.getTradeFlag() != 1;
                        this.waitingForTradeMsg = false;
                        this.waitingForTradeResponse = false;
                        this.negotiator.resetIsSelling();
                        this.negotiator.resetOffersMade();
                        this.buildingPlan.clear();
                        this.negotiator.resetTargetPieces();
                    }
                    this.ourTurn = this.game.getCurrentPlayerNumber() == this.ourPlayerData.getPlayerNumber();
                    if (mesType == 1026 && this.ourTurn) {
                        this.waitingForOurTurn = false;
                    }
                    if (mesType == 1024) {
                        pl = this.game.getPlayer(((SOCPlayerElement)mes).getPlayerNumber());
                        block4 : switch (((SOCPlayerElement)mes).getElementType()) {
                            case 10: {
                                switch (((SOCPlayerElement)mes).getAction()) {
                                    case 100: {
                                        pl.setNumPieces(0, ((SOCPlayerElement)mes).getValue());
                                        break;
                                    }
                                    case 101: {
                                        pl.setNumPieces(0, pl.getNumPieces(0) + ((SOCPlayerElement)mes).getValue());
                                        break;
                                    }
                                    case 102: {
                                        pl.setNumPieces(0, pl.getNumPieces(0) - ((SOCPlayerElement)mes).getValue());
                                    }
                                }
                                break;
                            }
                            case 11: {
                                switch (((SOCPlayerElement)mes).getAction()) {
                                    case 100: {
                                        pl.setNumPieces(1, ((SOCPlayerElement)mes).getValue());
                                        break;
                                    }
                                    case 101: {
                                        pl.setNumPieces(1, pl.getNumPieces(1) + ((SOCPlayerElement)mes).getValue());
                                        break;
                                    }
                                    case 102: {
                                        pl.setNumPieces(1, pl.getNumPieces(1) - ((SOCPlayerElement)mes).getValue());
                                    }
                                }
                                break;
                            }
                            case 12: {
                                switch (((SOCPlayerElement)mes).getAction()) {
                                    case 100: {
                                        pl.setNumPieces(2, ((SOCPlayerElement)mes).getValue());
                                        break;
                                    }
                                    case 101: {
                                        pl.setNumPieces(2, pl.getNumPieces(2) + ((SOCPlayerElement)mes).getValue());
                                        break;
                                    }
                                    case 102: {
                                        pl.setNumPieces(2, pl.getNumPieces(2) - ((SOCPlayerElement)mes).getValue());
                                    }
                                }
                                break;
                            }
                            case 15: {
                                switch (((SOCPlayerElement)mes).getAction()) {
                                    case 100: {
                                        pl.setNumKnights(((SOCPlayerElement)mes).getValue());
                                        break;
                                    }
                                    case 101: {
                                        pl.setNumKnights(pl.getNumKnights() + ((SOCPlayerElement)mes).getValue());
                                        break;
                                    }
                                    case 102: {
                                        pl.setNumKnights(pl.getNumKnights() - ((SOCPlayerElement)mes).getValue());
                                    }
                                }
                                this.game.updateLargestArmy();
                                break;
                            }
                            case 1: {
                                switch (((SOCPlayerElement)mes).getAction()) {
                                    case 100: {
                                        if (((SOCPlayerElement)mes).getValue() != this.ourPlayerData.getResources().getAmount(1)) {
                                            this.client.sendText(this.game, ">>> RSRC ERROR FOR CLAY: " + ((SOCPlayerElement)mes).getValue() + " != " + this.ourPlayerData.getResources().getAmount(1));
                                        }
                                        pl.getResources().setAmount(((SOCPlayerElement)mes).getValue(), 1);
                                        break;
                                    }
                                    case 101: {
                                        pl.getResources().add(((SOCPlayerElement)mes).getValue(), 1);
                                        break;
                                    }
                                    case 102: {
                                        pl.getResources().subtract(((SOCPlayerElement)mes).getValue(), 1);
                                    }
                                }
                                break;
                            }
                            case 2: {
                                switch (((SOCPlayerElement)mes).getAction()) {
                                    case 100: {
                                        if (((SOCPlayerElement)mes).getValue() != this.ourPlayerData.getResources().getAmount(2)) {
                                            this.client.sendText(this.game, ">>> RSRC ERROR FOR ORE: " + ((SOCPlayerElement)mes).getValue() + " != " + this.ourPlayerData.getResources().getAmount(2));
                                        }
                                        pl.getResources().setAmount(((SOCPlayerElement)mes).getValue(), 2);
                                        break;
                                    }
                                    case 101: {
                                        pl.getResources().add(((SOCPlayerElement)mes).getValue(), 2);
                                        break;
                                    }
                                    case 102: {
                                        pl.getResources().subtract(((SOCPlayerElement)mes).getValue(), 2);
                                    }
                                }
                                break;
                            }
                            case 3: {
                                switch (((SOCPlayerElement)mes).getAction()) {
                                    case 100: {
                                        if (((SOCPlayerElement)mes).getValue() != this.ourPlayerData.getResources().getAmount(3)) {
                                            this.client.sendText(this.game, ">>> RSRC ERROR FOR SHEEP: " + ((SOCPlayerElement)mes).getValue() + " != " + this.ourPlayerData.getResources().getAmount(3));
                                        }
                                        pl.getResources().setAmount(((SOCPlayerElement)mes).getValue(), 3);
                                        break;
                                    }
                                    case 101: {
                                        pl.getResources().add(((SOCPlayerElement)mes).getValue(), 3);
                                        break;
                                    }
                                    case 102: {
                                        pl.getResources().subtract(((SOCPlayerElement)mes).getValue(), 3);
                                    }
                                }
                                break;
                            }
                            case 4: {
                                switch (((SOCPlayerElement)mes).getAction()) {
                                    case 100: {
                                        if (((SOCPlayerElement)mes).getValue() != this.ourPlayerData.getResources().getAmount(4)) {
                                            this.client.sendText(this.game, ">>> RSRC ERROR FOR WHEAT: " + ((SOCPlayerElement)mes).getValue() + " != " + this.ourPlayerData.getResources().getAmount(4));
                                        }
                                        pl.getResources().setAmount(((SOCPlayerElement)mes).getValue(), 4);
                                        break;
                                    }
                                    case 101: {
                                        pl.getResources().add(((SOCPlayerElement)mes).getValue(), 4);
                                        break;
                                    }
                                    case 102: {
                                        pl.getResources().subtract(((SOCPlayerElement)mes).getValue(), 4);
                                    }
                                }
                                break;
                            }
                            case 5: {
                                switch (((SOCPlayerElement)mes).getAction()) {
                                    case 100: {
                                        if (((SOCPlayerElement)mes).getValue() != this.ourPlayerData.getResources().getAmount(5)) {
                                            this.client.sendText(this.game, ">>> RSRC ERROR FOR WOOD: " + ((SOCPlayerElement)mes).getValue() + " != " + this.ourPlayerData.getResources().getAmount(5));
                                        }
                                        pl.getResources().setAmount(((SOCPlayerElement)mes).getValue(), 5);
                                        break;
                                    }
                                    case 101: {
                                        pl.getResources().add(((SOCPlayerElement)mes).getValue(), 5);
                                        break;
                                    }
                                    case 102: {
                                        pl.getResources().subtract(((SOCPlayerElement)mes).getValue(), 5);
                                    }
                                }
                                break;
                            }
                            case 6: {
                                switch (((SOCPlayerElement)mes).getAction()) {
                                    case 100: {
                                        if (((SOCPlayerElement)mes).getValue() != this.ourPlayerData.getResources().getAmount(6)) {
                                            this.client.sendText(this.game, ">>> RSRC ERROR FOR UNKNOWN: " + ((SOCPlayerElement)mes).getValue() + " != " + this.ourPlayerData.getResources().getAmount(6));
                                        }
                                        pl.getResources().setAmount(((SOCPlayerElement)mes).getValue(), 6);
                                        break block4;
                                    }
                                    case 101: {
                                        pl.getResources().add(((SOCPlayerElement)mes).getValue(), 6);
                                        break block4;
                                    }
                                    case 102: {
                                        SOCResourceSet rs = pl.getResources();
                                        rs.add(rs.getAmount(1), 6);
                                        rs.setAmount(0, 1);
                                        rs.add(rs.getAmount(2), 6);
                                        rs.setAmount(0, 2);
                                        rs.add(rs.getAmount(3), 6);
                                        rs.setAmount(0, 3);
                                        rs.add(rs.getAmount(4), 6);
                                        rs.setAmount(0, 4);
                                        rs.add(rs.getAmount(5), 6);
                                        rs.setAmount(0, 5);
                                        pl.getResources().subtract(((SOCPlayerElement)mes).getValue(), 6);
                                    }
                                }
                            }
                        }
                        if (this.game.getGameState() == 15) {
                            this.negotiator.resetIsSelling();
                        }
                    } else if (mesType == 1063) {
                        pl = this.game.getPlayer(((SOCResourceCount)mes).getPlayerNumber());
                        if (((SOCResourceCount)mes).getCount() != pl.getResources().getTotal()) {
                            SOCResourceSet rsrcs = pl.getResources();
                            this.client.sendText(this.game, ">>> RESOURCE COUNT ERROR FOR PLAYER " + pl.getPlayerNumber() + ": " + ((SOCResourceCount)mes).getCount() + " != " + rsrcs.getTotal());
                            if (pl.getPlayerNumber() != this.ourPlayerData.getPlayerNumber()) {
                                rsrcs.clear();
                                rsrcs.setAmount(((SOCResourceCount)mes).getCount(), 6);
                            }
                        }
                    } else if (mesType == 1028) {
                        this.game.setCurrentDice(((SOCDiceResult)mes).getResult());
                    } else if (mesType == 1009) {
                        D.ebugPrintln("*** PUTPIECE for game ***");
                        pl = this.game.getPlayer(((SOCPutPiece)mes).getPlayerNumber());
                        switch (((SOCPutPiece)mes).getPieceType()) {
                            case 0: {
                                SOCRoad rd = new SOCRoad(pl, ((SOCPutPiece)mes).getCoordinates());
                                this.game.putPiece(rd);
                                break;
                            }
                            case 1: {
                                SOCSettlement se = new SOCSettlement(pl, ((SOCPutPiece)mes).getCoordinates());
                                this.game.putPiece(se);
                                break;
                            }
                            case 2: {
                                SOCCity ci = new SOCCity(pl, ((SOCPutPiece)mes).getCoordinates());
                                this.game.putPiece(ci);
                            }
                        }
                    } else if (mesType == 1034) {
                        this.moveRobberOnSeven = false;
                        this.game.getBoard().setRobberHex(((SOCMoveRobber)mes).getCoordinates());
                    } else if (this.robotParameters.getTradeFlag() == 1 && mesType == 1041) {
                        SOCTradeOffer offer = ((SOCMakeOffer)mes).getOffer();
                        this.game.getPlayer(offer.getFrom()).setCurrentOffer(offer);
                        if (offer.getFrom() != this.ourPlayerData.getPlayerNumber()) {
                            SOCResourceSet giveSet = offer.getGiveSet();
                            for (int rsrcType2 = 1; rsrcType2 <= 5; ++rsrcType2) {
                                if (giveSet.getAmount(rsrcType2) <= 0) continue;
                                D.ebugPrintln("%%% player " + offer.getFrom() + " wants to sell " + rsrcType2);
                                this.negotiator.markAsWantsAnotherOffer(offer.getFrom(), rsrcType2);
                            }
                            getSet = offer.getGetSet();
                            for (rsrcType = 1; rsrcType <= 5; ++rsrcType) {
                                if (getSet.getAmount(rsrcType) <= 0) continue;
                                D.ebugPrintln("%%% player " + offer.getFrom() + " wants to buy " + rsrcType + " and therefore does not want to sell it");
                                this.negotiator.markAsNotSelling(offer.getFrom(), rsrcType);
                            }
                            if (this.waitingForTradeResponse) {
                                this.offerRejections[offer.getFrom()] = true;
                                boolean everyoneRejected = true;
                                D.ebugPrintln("ourPlayerData.getCurrentOffer() = " + this.ourPlayerData.getCurrentOffer());
                                if (this.ourPlayerData.getCurrentOffer() != null) {
                                    boolean[] offeredTo = this.ourPlayerData.getCurrentOffer().getTo();
                                    for (int i = 0; i < 4; ++i) {
                                        D.ebugPrintln("offerRejections[" + i + "]=" + this.offerRejections[i]);
                                        if (!offeredTo[i] || this.offerRejections[i]) continue;
                                        everyoneRejected = false;
                                    }
                                }
                                D.ebugPrintln("everyoneRejected=" + everyoneRejected);
                                if (everyoneRejected) {
                                    this.negotiator.addToOffersMade(this.ourPlayerData.getCurrentOffer());
                                    this.client.clearOffer(this.game);
                                    this.waitingForTradeResponse = false;
                                }
                            }
                            int ourResponseToOffer = this.considerOffer(offer);
                            D.ebugPrintln("%%% ourResponseToOffer = " + ourResponseToOffer);
                            if (ourResponseToOffer >= 0) {
                                int delayLength = Math.abs(this.rand.nextInt() % 500) + 3500;
                                this.pause(delayLength);
                                switch (ourResponseToOffer) {
                                    case 1: {
                                        this.client.acceptOffer(this.game, offer.getFrom());
                                        this.buildingPlan.clear();
                                        this.negotiator.setTargetPiece(this.ourPlayerData.getPlayerNumber(), null);
                                        break;
                                    }
                                    case 0: {
                                        if (this.waitingForTradeResponse) break;
                                        this.client.rejectOffer(this.game);
                                        break;
                                    }
                                    case 2: {
                                        if (this.makeCounterOffer(offer)) break;
                                        this.client.rejectOffer(this.game);
                                    }
                                }
                            }
                        }
                    } else if (this.robotParameters.getTradeFlag() == 1 && mesType == 1038) {
                        this.game.getPlayer(((SOCClearOffer)mes).getPlayerNumber()).setCurrentOffer(null);
                    } else if (this.robotParameters.getTradeFlag() == 1 && mesType == 1039) {
                        if ((((SOCAcceptOffer)mes).getOfferingNumber() == this.ourPlayerData.getPlayerNumber() || ((SOCAcceptOffer)mes).getAcceptingNumber() == this.ourPlayerData.getPlayerNumber()) && this.waitingForTradeResponse) {
                            this.waitingForTradeResponse = false;
                        }
                    } else if (this.robotParameters.getTradeFlag() == 1 && mesType == 1037) {
                        int rejector = ((SOCRejectOffer)mes).getPlayerNumber();
                        if (this.ourPlayerData.getCurrentOffer() != null && this.waitingForTradeResponse) {
                            D.ebugPrintln("%%%%%%%%% REJECT OFFER %%%%%%%%%%%%%");
                            SOCResourceSet getSet2 = this.ourPlayerData.getCurrentOffer().getGetSet();
                            for (int rsrcType3 = 1; rsrcType3 <= 5; ++rsrcType3) {
                                if (getSet2.getAmount(rsrcType3) <= 0 || this.negotiator.wantsAnotherOffer(rejector, rsrcType3)) continue;
                                this.negotiator.markAsNotSelling(rejector, rsrcType3);
                            }
                            this.offerRejections[((SOCRejectOffer)mes).getPlayerNumber()] = true;
                            boolean everyoneRejected = true;
                            D.ebugPrintln("ourPlayerData.getCurrentOffer() = " + this.ourPlayerData.getCurrentOffer());
                            boolean[] offeredTo = this.ourPlayerData.getCurrentOffer().getTo();
                            for (int i = 0; i < 4; ++i) {
                                D.ebugPrintln("offerRejections[" + i + "]=" + this.offerRejections[i]);
                                if (!offeredTo[i] || this.offerRejections[i]) continue;
                                everyoneRejected = false;
                            }
                            D.ebugPrintln("everyoneRejected=" + everyoneRejected);
                            if (everyoneRejected) {
                                this.negotiator.addToOffersMade(this.ourPlayerData.getCurrentOffer());
                                this.client.clearOffer(this.game);
                                this.waitingForTradeResponse = false;
                            }
                        } else {
                            D.ebugPrintln("%%%% ALT REJECT OFFER %%%%");
                            for (int pn = 0; pn < 4; ++pn) {
                                boolean[] offeredTo;
                                SOCTradeOffer offer = this.game.getPlayer(pn).getCurrentOffer();
                                if (offer == null || !(offeredTo = offer.getTo())[rejector]) continue;
                                SOCResourceSet getSet3 = offer.getGetSet();
                                for (int rsrcType4 = 1; rsrcType4 <= 5; ++rsrcType4) {
                                    if (getSet3.getAmount(rsrcType4) <= 0 || this.negotiator.wantsAnotherOffer(rejector, rsrcType4)) continue;
                                    this.negotiator.markAsNotSelling(rejector, rsrcType4);
                                }
                            }
                        }
                    } else if (mesType == 1047) {
                        this.game.setNumDevCards(((SOCDevCardCount)mes).getNumDevCards());
                    } else if (mesType == 1046) {
                        player = this.game.getPlayer(((SOCDevCard)mes).getPlayerNumber());
                        switch (((SOCDevCard)mes).getAction()) {
                            case 0: {
                                player.getDevCards().add(1, 1, ((SOCDevCard)mes).getCardType());
                                break;
                            }
                            case 1: {
                                player.getDevCards().subtract(1, 0, ((SOCDevCard)mes).getCardType());
                                break;
                            }
                            case 3: {
                                player.getDevCards().add(1, 0, ((SOCDevCard)mes).getCardType());
                                break;
                            }
                            case 2: {
                                player.getDevCards().add(1, 1, ((SOCDevCard)mes).getCardType());
                            }
                        }
                    } else if (mesType == 1048) {
                        player = this.game.getPlayer(((SOCSetPlayedDevCard)mes).getPlayerNumber());
                        player.setPlayedDevCard(((SOCSetPlayedDevCard)mes).hasPlayedDevCard());
                    } else if (mesType == 1057) {
                        player = this.game.getPlayer(((SOCPotentialSettlements)mes).getPlayerNumber());
                        player.setPotentialSettlements(((SOCPotentialSettlements)mes).getPotentialSettlements());
                    }
                    this.debugInfo();
                    if (this.game.getGameState() == 15 && !this.waitingForGameState) {
                        this.expectPLAY = false;
                        if (!this.waitingForOurTurn && this.ourTurn) {
                            if (!(this.expectPLAY1 || this.expectDISCARD || this.expectPLACING_ROBBER || this.expectDICERESULT && this.counter < 4000)) {
                                this.getActionForPLAY();
                            }
                        } else {
                            this.expectDICERESULT = true;
                        }
                    }
                    if (this.game.getGameState() == 33 && !this.waitingForGameState) {
                        this.expectPLACING_ROBBER = false;
                        if (!this.waitingForOurTurn && this.ourTurn && (!this.expectPLAY && !this.expectPLAY1 || this.counter >= 4000)) {
                            if (this.moveRobberOnSeven) {
                                this.moveRobberOnSeven = false;
                                this.waitingForGameState = true;
                                this.counter = 0;
                                this.expectPLAY1 = true;
                            } else {
                                this.waitingForGameState = true;
                                this.counter = 0;
                                if (this.oldGameState == 15) {
                                    this.expectPLAY = true;
                                } else if (this.oldGameState == 20) {
                                    this.expectPLAY1 = true;
                                }
                            }
                            this.counter = 0;
                            this.moveRobber();
                        }
                    }
                    if (this.game.getGameState() == 52 && !this.waitingForGameState) {
                        this.expectWAITING_FOR_DISCOVERY = false;
                        if (!this.waitingForOurTurn && this.ourTurn && !this.expectPLAY1 && this.counter < 4000) {
                            this.waitingForGameState = true;
                            this.expectPLAY1 = true;
                            this.counter = 0;
                            this.client.discoveryPick(this.game, this.resourceChoices);
                            this.pause(1500);
                        }
                    }
                    if (this.game.getGameState() == 53 && !this.waitingForGameState) {
                        this.expectWAITING_FOR_MONOPOLY = false;
                        if (!this.waitingForOurTurn && this.ourTurn && !this.expectPLAY1 && this.counter < 4000) {
                            this.waitingForGameState = true;
                            this.expectPLAY1 = true;
                            this.counter = 0;
                            this.client.monopolyPick(this.game, this.monopolyChoice);
                            this.pause(1500);
                        }
                    }
                    if (this.waitingForTradeMsg && mesType == 1010 && ((SOCGameTextMsg)mes).getNickname().equals("Server") && ((SOCGameTextMsg)mes).getText().startsWith(this.client.getNickname() + " traded")) {
                        this.waitingForTradeMsg = false;
                    }
                    if (this.waitingForDevCard && mesType == 1010 && ((SOCGameTextMsg)mes).getNickname().equals("Server") && ((SOCGameTextMsg)mes).getText().equals(this.client.getNickname() + " bought a development card.")) {
                        this.waitingForDevCard = false;
                    }
                    if (!(this.game.getGameState() != 20 || this.waitingForGameState || this.waitingForTradeMsg || this.waitingForTradeResponse || this.waitingForDevCard || this.expectPLACING_ROAD || this.expectPLACING_SETTLEMENT || this.expectPLACING_CITY || this.expectPLACING_ROBBER || this.expectPLACING_FREE_ROAD1 || this.expectPLACING_FREE_ROAD2 || this.expectWAITING_FOR_DISCOVERY || this.expectWAITING_FOR_MONOPOLY)) {
                        this.expectPLAY1 = false;
                        if (!(this.waitingForOurTurn || !this.ourTurn || this.expectPLAY && this.counter < 4000)) {
                            this.counter = 0;
                            System.out.println("DOING PLAY1");
                            this.client.sendText(this.game, "================================");
                            for (int i = 0; i < 4; ++i) {
                                SOCResourceSet rsrcs = this.game.getPlayer(i).getResources();
                                String resourceMessage = "PLAYER " + i + " RESOURCES: ";
                                resourceMessage = resourceMessage + rsrcs.getAmount(1) + " ";
                                resourceMessage = resourceMessage + rsrcs.getAmount(2) + " ";
                                resourceMessage = resourceMessage + rsrcs.getAmount(3) + " ";
                                resourceMessage = resourceMessage + rsrcs.getAmount(4) + " ";
                                resourceMessage = resourceMessage + rsrcs.getAmount(5) + " ";
                                resourceMessage = resourceMessage + rsrcs.getAmount(6) + " ";
                                this.client.sendText(this.game, resourceMessage);
                                D.ebugPrintln(resourceMessage);
                            }
                            this.getActionForPLAY1();
                        }
                    }
                    if (this.game.getGameState() == 31 && !this.waitingForGameState && this.ourTurn && !this.waitingForOurTurn && this.expectPLACING_SETTLEMENT) {
                        this.expectPLACING_SETTLEMENT = false;
                        this.waitingForGameState = true;
                        this.counter = 0;
                        this.expectPLAY1 = true;
                        System.out.println("!!! PUTTING PIECE " + this.whatWeWantToBuild + " !!!");
                        this.pause(500);
                        this.client.putPiece(this.game, this.whatWeWantToBuild);
                        this.pause(1000);
                    }
                    if (this.game.getGameState() == 30 && !this.waitingForGameState && this.ourTurn && !this.waitingForOurTurn && this.expectPLACING_ROAD) {
                        this.expectPLACING_ROAD = false;
                        this.waitingForGameState = true;
                        this.counter = 0;
                        this.expectPLAY1 = true;
                        System.out.println("!!! PUTTING PIECE " + this.whatWeWantToBuild + " !!!");
                        this.pause(500);
                        this.client.putPiece(this.game, this.whatWeWantToBuild);
                        this.pause(1000);
                    }
                    if (this.game.getGameState() == 32 && !this.waitingForGameState && this.ourTurn && !this.waitingForOurTurn && this.expectPLACING_CITY) {
                        this.expectPLACING_CITY = false;
                        this.waitingForGameState = true;
                        this.counter = 0;
                        this.expectPLAY1 = true;
                        System.out.println("!!! PUTTING PIECE " + this.whatWeWantToBuild + " !!!");
                        this.pause(500);
                        this.client.putPiece(this.game, this.whatWeWantToBuild);
                        this.pause(1000);
                    }
                    if (this.game.getGameState() == 40 && !this.waitingForGameState && this.ourTurn && !this.waitingForOurTurn && this.expectPLACING_FREE_ROAD1) {
                        this.expectPLACING_FREE_ROAD1 = false;
                        this.waitingForGameState = true;
                        this.counter = 0;
                        this.expectPLACING_FREE_ROAD2 = true;
                        this.getActionForFREEROAD();
                    }
                    if (this.game.getGameState() == 41 && !this.waitingForGameState && this.ourTurn && !this.waitingForOurTurn && this.expectPLACING_FREE_ROAD2) {
                        this.expectPLACING_FREE_ROAD2 = false;
                        this.waitingForGameState = true;
                        this.counter = 0;
                        this.expectPLAY1 = true;
                        this.getActionForFREEROAD();
                    }
                    if (this.game.getGameState() == 5 && !this.waitingForGameState) {
                        this.expectSTART1A = false;
                        if (!(this.waitingForOurTurn || !this.ourTurn || this.expectPUTPIECE_FROM_START1A && this.counter < 4000)) {
                            this.expectPUTPIECE_FROM_START1A = true;
                            this.counter = 0;
                            this.waitingForGameState = true;
                            this.planInitialSettlements();
                            this.placeFirstSettlement();
                        }
                    }
                    if (this.game.getGameState() == 6 && !this.waitingForGameState) {
                        this.expectSTART1B = false;
                        if (!(this.waitingForOurTurn || !this.ourTurn || this.expectPUTPIECE_FROM_START1B && this.counter < 4000)) {
                            this.expectPUTPIECE_FROM_START1B = true;
                            this.counter = 0;
                            this.waitingForGameState = true;
                            this.placeInitRoad();
                            this.pause(1500);
                        }
                    }
                    if (this.game.getGameState() == 10 && !this.waitingForGameState) {
                        this.expectSTART2A = false;
                        if (!(this.waitingForOurTurn || !this.ourTurn || this.expectPUTPIECE_FROM_START2A && this.counter < 4000)) {
                            this.expectPUTPIECE_FROM_START2A = true;
                            this.counter = 0;
                            this.waitingForGameState = true;
                            this.planSecondSettlement();
                            this.placeSecondSettlement();
                        }
                    }
                    if (this.game.getGameState() == 11 && !this.waitingForGameState) {
                        this.expectSTART2B = false;
                        if (!(this.waitingForOurTurn || !this.ourTurn || this.expectPUTPIECE_FROM_START2B && this.counter < 4000)) {
                            this.expectPUTPIECE_FROM_START2B = true;
                            this.counter = 0;
                            this.waitingForGameState = true;
                            this.placeInitRoad();
                            this.pause(1500);
                        }
                    }
                    if (mesType == 1055) {
                        this.game.setCurrentPlayerNumber(((SOCSetTurn)mes).getPlayerNumber());
                    }
                    if (mesType == 1009) {
                        D.ebugPrintln("*** PUTPIECE for playerTrackers ***");
                        block82 : switch (((SOCPutPiece)mes).getPieceType()) {
                            case 0: {
                                SOCRoad newRoad = new SOCRoad(this.game.getPlayer(((SOCPutPiece)mes).getPlayerNumber()), ((SOCPutPiece)mes).getCoordinates());
                                for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                    tracker.takeMonitor();
                                    try {
                                        tracker.addNewRoad(newRoad, this.playerTrackers);
                                    }
                                    catch (Exception e) {
                                        tracker.releaseMonitor();
                                        System.out.println("Exception caught - " + e);
                                        e.printStackTrace();
                                    }
                                    tracker.releaseMonitor();
                                }
                                for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                    tracker.takeMonitor();
                                    try {
                                        Iterator posRoadsIter = tracker.getPossibleRoads().values().iterator();
                                        while (posRoadsIter.hasNext()) {
                                            ((SOCPossibleRoad)posRoadsIter.next()).clearThreats();
                                        }
                                        Iterator posSetsIter = tracker.getPossibleSettlements().values().iterator();
                                        while (posSetsIter.hasNext()) {
                                            ((SOCPossibleSettlement)posSetsIter.next()).clearThreats();
                                        }
                                    }
                                    catch (Exception e) {
                                        tracker.releaseMonitor();
                                        System.out.println("Exception caught - " + e);
                                        e.printStackTrace();
                                    }
                                    tracker.releaseMonitor();
                                }
                                for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                    tracker.updateThreats(this.playerTrackers);
                                    tracker.takeMonitor();
                                    try {
                                        if (tracker.getPlayer().getPlayerNumber() == ((SOCPutPiece)mes).getPlayerNumber()) {
                                            System.out.println("$$ updating LR Value for player " + tracker.getPlayer().getPlayerNumber());
                                        }
                                    }
                                    catch (Exception e) {
                                        tracker.releaseMonitor();
                                        System.out.println("Exception caught - " + e);
                                        e.printStackTrace();
                                    }
                                    tracker.releaseMonitor();
                                }
                                break;
                            }
                            case 1: {
                                SOCSettlement newSettlement = new SOCSettlement(this.game.getPlayer(((SOCPutPiece)mes).getPlayerNumber()), ((SOCPutPiece)mes).getCoordinates());
                                for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                    tracker.addNewSettlement(newSettlement, this.playerTrackers);
                                }
                                for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                    Iterator posRoadsIter = tracker.getPossibleRoads().values().iterator();
                                    while (posRoadsIter.hasNext()) {
                                        ((SOCPossibleRoad)posRoadsIter.next()).clearThreats();
                                    }
                                    Iterator posSetsIter = tracker.getPossibleSettlements().values().iterator();
                                    while (posSetsIter.hasNext()) {
                                        ((SOCPossibleSettlement)posSetsIter.next()).clearThreats();
                                    }
                                }
                                for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                    tracker.updateThreats(this.playerTrackers);
                                }
                                int[] roadCount = new int[]{0, 0, 0, 0};
                                Enumeration adjEdgeEnum = SOCBoard.getAdjacentEdgesToNode(((SOCPutPiece)mes).getCoordinates()).elements();
                                block112: while (adjEdgeEnum.hasMoreElements()) {
                                    Integer adjEdge = (Integer)adjEdgeEnum.nextElement();
                                    Enumeration roadEnum = this.game.getBoard().getRoads().elements();
                                    while (roadEnum.hasMoreElements()) {
                                        SOCRoad road = (SOCRoad)roadEnum.nextElement();
                                        if (road.getCoordinates() != adjEdge.intValue()) continue;
                                        int n = road.getPlayer().getPlayerNumber();
                                        roadCount[n] = roadCount[n] + 1;
                                        if (roadCount[road.getPlayer().getPlayerNumber()] != 2) continue;
                                        if (road.getPlayer().getPlayerNumber() == this.ourPlayerData.getPlayerNumber()) continue block112;
                                        for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                            if (tracker.getPlayer().getPlayerNumber() != road.getPlayer().getPlayerNumber()) continue;
                                            System.out.println("$$ updating LR Value for player " + tracker.getPlayer().getPlayerNumber());
                                        }
                                        continue block112;
                                    }
                                }
                                for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                    if (tracker.getPlayer().getPlayerNumber() != ((SOCPutPiece)mes).getPlayerNumber()) continue;
                                    Iterator posSetsIter = tracker.getPossibleSettlements().values().iterator();
                                    while (posSetsIter.hasNext()) {
                                        ((SOCPossibleSettlement)posSetsIter.next()).updateSpeedup();
                                    }
                                    break block115;
                                }
                                for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                    if (tracker.getPlayer().getPlayerNumber() != ((SOCPutPiece)mes).getPlayerNumber()) continue;
                                    Iterator posCitiesIter = tracker.getPossibleCities().values().iterator();
                                    while (posCitiesIter.hasNext()) {
                                        ((SOCPossibleCity)posCitiesIter.next()).updateSpeedup();
                                    }
                                    break block82;
                                }
                                break;
                            }
                            case 2: {
                                SOCCity newCity = new SOCCity(this.game.getPlayer(((SOCPutPiece)mes).getPlayerNumber()), ((SOCPutPiece)mes).getCoordinates());
                                for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                    if (tracker.getPlayer().getPlayerNumber() != ((SOCPutPiece)mes).getPlayerNumber()) continue;
                                    tracker.addOurNewCity(newCity);
                                    break;
                                }
                                for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                    if (tracker.getPlayer().getPlayerNumber() != ((SOCPutPiece)mes).getPlayerNumber()) continue;
                                    Iterator posSetsIter = tracker.getPossibleSettlements().values().iterator();
                                    while (posSetsIter.hasNext()) {
                                        ((SOCPossibleSettlement)posSetsIter.next()).updateSpeedup();
                                    }
                                    break block120;
                                }
                                for (SOCPlayerTracker tracker : this.playerTrackers.values()) {
                                    if (tracker.getPlayer().getPlayerNumber() != ((SOCPutPiece)mes).getPlayerNumber()) continue;
                                    Iterator posCitiesIter = tracker.getPossibleCities().values().iterator();
                                    while (posCitiesIter.hasNext()) {
                                        ((SOCPossibleCity)posCitiesIter.next()).updateSpeedup();
                                    }
                                    break block82;
                                }
                                break;
                            }
                        }
                        SOCPlayerTracker.playerTrackersDebug(this.playerTrackers);
                    }
                    if (this.expectPUTPIECE_FROM_START1A && mesType == 1009 && ((SOCPutPiece)mes).getPlayerNumber() == this.ourPlayerData.getPlayerNumber() && ((SOCPutPiece)mes).getPieceType() == 1 && ((SOCPutPiece)mes).getCoordinates() == this.ourPlayerData.getLastSettlementCoord()) {
                        this.expectPUTPIECE_FROM_START1A = false;
                        this.expectSTART1B = true;
                    }
                    if (this.expectPUTPIECE_FROM_START1B && mesType == 1009 && ((SOCPutPiece)mes).getPlayerNumber() == this.ourPlayerData.getPlayerNumber() && ((SOCPutPiece)mes).getPieceType() == 0 && ((SOCPutPiece)mes).getCoordinates() == this.ourPlayerData.getLastRoadCoord()) {
                        this.expectPUTPIECE_FROM_START1B = false;
                        this.expectSTART2A = true;
                    }
                    if (this.expectPUTPIECE_FROM_START2A && mesType == 1009 && ((SOCPutPiece)mes).getPlayerNumber() == this.ourPlayerData.getPlayerNumber() && ((SOCPutPiece)mes).getPieceType() == 1 && ((SOCPutPiece)mes).getCoordinates() == this.ourPlayerData.getLastSettlementCoord()) {
                        this.expectPUTPIECE_FROM_START2A = false;
                        this.expectSTART2B = true;
                    }
                    if (this.expectPUTPIECE_FROM_START2B && mesType == 1009 && ((SOCPutPiece)mes).getPlayerNumber() == this.ourPlayerData.getPlayerNumber() && ((SOCPutPiece)mes).getPieceType() == 0 && ((SOCPutPiece)mes).getCoordinates() == this.ourPlayerData.getLastRoadCoord()) {
                        this.expectPUTPIECE_FROM_START2B = false;
                        this.expectPLAY = true;
                    }
                    if (this.expectDICERESULT && mesType == 1028) {
                        this.expectDICERESULT = false;
                        if (((SOCDiceResult)mes).getResult() == 7) {
                            this.moveRobberOnSeven = true;
                            if (this.ourPlayerData.getResources().getTotal() > 7) {
                                this.expectDISCARD = true;
                            } else if (this.ourTurn) {
                                this.expectPLACING_ROBBER = true;
                            }
                        } else {
                            this.expectPLAY1 = true;
                        }
                    }
                    if (mesType == 1029) {
                        this.expectDISCARD = false;
                        if (this.game.getCurrentDice() == 7 && this.ourTurn) {
                            this.expectPLACING_ROBBER = true;
                        } else {
                            this.expectPLAY1 = true;
                        }
                        this.counter = 0;
                        this.discard(((SOCDiscardRequest)mes).getNumberOfDiscards());
                    }
                    if (mesType == 1036) {
                        this.chooseRobberVictim(((SOCChoosePlayerRequest)mes).getChoices());
                    }
                    if (mesType == 1056 && !this.expectDISCARD && !this.expectPLACING_ROBBER) {
                        this.client.leaveGame(this.game);
                        this.alive = false;
                    }
                    if (mesType == 1010 && ((SOCGameTextMsg)mes).getText().equals("*PING*")) {
                        ++this.counter;
                    }
                    if (this.counter > 1500000) {
                        System.out.println("Suicide.");
                        this.client.leaveGame(this.game);
                        this.alive = false;
                    }
                    SSRobotBrain.yield();
                }
            }
            catch (Exception e) {
                D.ebugPrintln("*** Caught an exception - " + e);
                System.out.println("*** Caught an exception - " + e);
                e.printStackTrace();
            }
        } else {
            System.out.println("AGG! NO PINGER!");
        }
        System.out.println("STOPPING AND DEALLOCATING");
        this.gameEventQ = null;
        this.client.addCleanKill();
        this.client = null;
        this.game = null;
        this.ourPlayerData = null;
        this.whatWeWantToBuild = null;
        this.resourceChoices = null;
        this.ourPlayerTracker = null;
        this.playerTrackers = null;
        this.pinger.stopPinger();
        this.pinger = null;
    }

    @Override
    protected void debugInfo() {
        if (this.ourTurn) {
            if (this.expectSTART1A) {
                System.out.println("expectSTART1A");
            }
            if (this.expectSTART1B) {
                System.out.println("expectSTART1B");
            }
            if (this.expectSTART2A) {
                System.out.println("expectSTART2A");
            }
            if (this.expectSTART2B) {
                System.out.println("expectSTART2B");
            }
            if (this.expectPLAY) {
                System.out.println("expectPLAY");
            }
            if (this.expectPLAY1) {
                System.out.println("expectPLAY1");
            }
            if (this.expectPLACING_ROAD) {
                System.out.println("expectPLACING_ROAD");
            }
            if (this.expectPLACING_SETTLEMENT) {
                System.out.println("expectPLACING_SETTLEMENT");
            }
            if (this.expectPLACING_CITY) {
                System.out.println("expectPLACING_CITY");
            }
            if (this.expectPLACING_ROBBER) {
                System.out.println("expectPLACING_ROBBER");
            }
            if (this.expectPLACING_FREE_ROAD1) {
                System.out.println("expectPLACING_FREE_ROAD1");
            }
            if (this.expectPLACING_FREE_ROAD2) {
                System.out.println("expectPLACING_FREE_ROAD2");
            }
            if (this.expectPUTPIECE_FROM_START1A) {
                System.out.println("expectPUTPIECE_FROM_START1A");
            }
            if (this.expectPUTPIECE_FROM_START1B) {
                System.out.println("expectPUTPIECE_FROM_START1B");
            }
            if (this.expectPUTPIECE_FROM_START2A) {
                System.out.println("expectPUTPIECE_FROM_START2A");
            }
            if (this.expectPUTPIECE_FROM_START2B) {
                System.out.println("expectPUTPIECE_FROM_START2B");
            }
            if (this.expectDICERESULT) {
                System.out.println("expectDICERESULT");
            }
            if (this.expectDISCARD) {
                System.out.println("expectDISCARD");
            }
            if (this.expectMOVEROBBER) {
                System.out.println("expectMOVEROBBER");
            }
            if (this.expectWAITING_FOR_DISCOVERY) {
                System.out.println("expectWAITING_FOR_DISCOVERY");
            }
            if (this.waitingForGameState) {
                System.out.println("waitingForGameState");
            }
            if (this.waitingForTradeMsg) {
                System.out.println("waitingForTradeMsg");
            }
            if (this.waitingForDevCard) {
                System.out.println("waitingForDevCard");
            }
            if (this.moveRobberOnSeven) {
                System.out.println("moveRobberOnSeven");
            }
            if (this.waitingForTradeResponse) {
                System.out.println("waitingForTradeResponse");
            }
            if (this.doneTrading) {
                System.out.println("doneTrading");
            }
        }
    }
}

