/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import smartsettlers.DebugFrame;
import smartsettlers.boardlayout.BoardLayout;
import smartsettlers.boardlayout.GameStateConstants;
import smartsettlers.boardlayout.HexTypeConstants;
import soc.game.SOCBoard;
import soc.game.SOCCity;
import soc.game.SOCDevCardSet;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCSettlement;
import soc.message.SOCBankTrade;
import soc.message.SOCBoardLayout;
import soc.message.SOCChoosePlayer;
import soc.message.SOCDeleteGame;
import soc.message.SOCDiceResult;
import soc.message.SOCDiscard;
import soc.message.SOCDiscoveryPick;
import soc.message.SOCGameState;
import soc.message.SOCJoinGameAuth;
import soc.message.SOCMessage;
import soc.message.SOCMonopolyPick;
import soc.message.SOCMoveRobber;
import soc.message.SOCPlayDevCardRequest;
import soc.message.SOCPutPiece;
import soc.message.SOCStartGame;
import soc.robot.SOCRobotBrain;
import soc.robot.SOCRobotClient;
import soc.robot.SSRobotBrain;
import soc.util.CappedQueue;

public class SSRobotClient
extends SOCRobotClient
implements GameStateConstants,
HexTypeConstants {
    public BoardLayout bl;
    private DebugFrame debugframe;
    private int lastSettlement;
    public int[] vertexToSS;
    public int[] edgeToSS;
    public int[] vertexToJS;
    public int[] edgeToJS;
    int logRobberPlace = 0;

    public SSRobotClient(String h, int p, String nn, String pw) {
        super(h, p, nn, pw);
    }

    @Override
    public void init() {
        super.init();
        this.debugframe = new DebugFrame();
        this.debugframe.setVisible(true);
        this.bl = this.debugframe.boardlayout;
    }

    @Override
    protected void handleDELETEGAME(SOCDeleteGame mes) {
        SOCRobotBrain brain = (SOCRobotBrain)this.robotBrains.get(mes.getGame());
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        this.sendStateToSmartSettlers(ga, 101);
        String fname = "settlerslog.txt";
        try {
            int i;
            String s = "";
            PrintStream f = new PrintStream(new FileOutputStream(fname, true));
            int pn = brain.getOurPlayerData().getPlayerNumber();
            for (i = 0; i < 4; ++i) {
                s = String.format("%s%d ", s, i == pn ? 1 : 0);
            }
            for (i = 0; i < 4; ++i) {
                s = String.format("%s%d ", s, this.bl.state[OFS_PLAYERDATA[i] + 0]);
            }
            s = s + "\t";
            for (i = 0; i < 269; ++i) {
                s = String.format("%s%d ", s, this.bl.state[i]);
            }
            f.println(s);
            System.out.println(s);
            f.close();
        }
        catch (FileNotFoundException ex1) {
            Logger.getLogger(SSRobotClient.class.getName()).log(Level.SEVERE, null, ex1);
        }
        super.handleDELETEGAME(mes);
    }

    public void sendGameToSmartSettlers(SOCGame ga) {
        SOCBoard bo = ga.getBoard();
        for (int xn = 0; xn < 7; ++xn) {
            for (int yn = 0; yn < 7; ++yn) {
                int tn;
                if (xn + yn < 3 || xn + yn > 9) continue;
                int indn = this.bl.hexatcoord[xn][yn];
                int xo = 2 * xn + 1;
                int yo = 2 * (xn + yn) - 5;
                int coordo = 16 * xo + yo;
                int to = bo.getHexTypeFromCoord(coordo);
                if (to >= 0 && to <= 5) {
                    switch (to) {
                        case 0: {
                            tn = 12;
                            break;
                        }
                        case 1: {
                            tn = 9;
                            break;
                        }
                        case 2: {
                            tn = 11;
                            break;
                        }
                        case 3: {
                            tn = 7;
                            break;
                        }
                        case 4: {
                            tn = 10;
                            break;
                        }
                        case 5: {
                            tn = 8;
                            break;
                        }
                        default: {
                            tn = -1;
                        }
                    }
                    this.bl.hextiles[indn].subtype = tn;
                    this.bl.hextiles[indn].type = 2;
                    if (tn != 12) {
                        this.bl.hextiles[indn].productionNumber = bo.getNumberOnHexFromCoord(coordo);
                        continue;
                    }
                    this.bl.hextiles[indn].productionNumber = bo.getNumberOnHexFromCoord(coordo);
                    continue;
                }
                if (to >= 7 && to <= 12) {
                    switch (to) {
                        case 7: {
                            tn = 6;
                            break;
                        }
                        case 8: {
                            tn = 3;
                            break;
                        }
                        case 9: {
                            tn = 5;
                            break;
                        }
                        case 10: {
                            tn = 1;
                            break;
                        }
                        case 11: {
                            tn = 4;
                            break;
                        }
                        case 12: {
                            tn = 2;
                            break;
                        }
                        default: {
                            tn = 6;
                        }
                    }
                    this.bl.hextiles[indn].subtype = tn;
                    this.bl.hextiles[indn].type = 1;
                    continue;
                }
                this.bl.hextiles[indn].type = 0;
                this.bl.hextiles[indn].subtype = 0;
                this.bl.hextiles[indn].orientation = -1;
            }
        }
        this.initTranslationTables(ga.getBoard());
        this.debugframe.repaint();
    }

    public int translateHexToSmartSettlers(int indo) {
        if (indo == -1) {
            return -1;
        }
        int xo = indo / 16;
        int yo = indo % 16;
        int xn = (xo - 1) / 2;
        int yn = (yo + 5) / 2 - xn;
        return this.bl.hexatcoord[xn][yn];
    }

    public int translateHexToJSettlers(int indn) {
        if (indn == -1) {
            return -1;
        }
        int xn = (int)this.bl.hextiles[indn].pos.x;
        int yn = (int)this.bl.hextiles[indn].pos.y;
        int xo = 2 * xn + 1;
        int yo = 2 * (xn + yn) - 5;
        return xo * 16 + yo;
    }

    public int translateVertexToSmartSettlers(int indo) {
        if (this.vertexToSS == null) {
            return 0;
        }
        return this.vertexToSS[indo];
    }

    public int translateEdgeToSmartSettlers(int indo) {
        return this.edgeToSS[indo];
    }

    public int translateVertexToJSettlers(int indo) {
        return this.vertexToJS[indo];
    }

    public int translateEdgeToJSettlers(int indo) {
        return this.edgeToJS[indo];
    }

    public int translateResToJSettlers(int ind) {
        switch (ind) {
            case 1: {
                return 5;
            }
            case 2: {
                return 1;
            }
            case 0: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 2;
            }
        }
        return -1;
    }

    public int translateResToSmartSettlers(int ind) {
        switch (ind) {
            case 5: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 3;
            }
            case 2: {
                return 4;
            }
        }
        return -1;
    }

    public void initTranslationTables(SOCBoard bo) {
        this.vertexToSS = new int[221];
        this.edgeToSS = new int[205];
        this.vertexToJS = new int[54];
        this.edgeToJS = new int[72];
        int[] numToHexID = new int[]{23, 57, 91, 125, 21, 55, 89, 123, 157, 19, 53, 87, 121, 155, 189, 17, 51, 85, 119, 153, 187, 221, 49, 83, 117, 151, 185, 219, 81, 115, 149, 183, 217, 113, 147, 181, 215};
        for (int j = 0; j < numToHexID.length; ++j) {
            int ho = numToHexID[j];
            if (bo.getHexTypeFromCoord(ho) >= 6) continue;
            int hn = this.translateHexToSmartSettlers(ho);
            int i = 0;
            Vector vlist = SOCBoard.getAdjacentNodesToHex(ho);
            Vector elist = SOCBoard.getAdjacentEdgesToHex(ho);
            for (i = 0; i < 6; ++i) {
                int en;
                int vn;
                int vo = (Integer)vlist.get(i);
                this.vertexToSS[vo] = vn = this.bl.neighborHexVertex[hn][i];
                this.vertexToJS[vn] = vo;
                int eo = (Integer)elist.get(i);
                this.edgeToSS[eo] = en = this.bl.neighborHexEdge[hn][i];
                this.edgeToJS[en] = eo;
            }
        }
    }

    @Override
    public void putPiece(SOCGame ga, SOCPlayingPiece pp) {
        super.put(SOCPutPiece.toCmd(ga.getName(), pp.getPlayer().getPlayerNumber(), pp.getType(), pp.getCoordinates()));
        if (pp.getType() == 1) {
            this.lastSettlement = pp.getCoordinates();
        }
    }

    public int[] sendStateToSmartSettlers(SOCGame ga, int GAMESTATE) {
        int indn;
        SOCPlayingPiece p;
        int[] st = new int[269];
        st[0] = 0;
        int fsmlevel = 0;
        if (GAMESTATE == 15) {
            fsmlevel = 1;
        }
        st[1] = fsmlevel;
        st[5 + fsmlevel] = ga.getCurrentPlayerNumber();
        st[2 + fsmlevel] = GAMESTATE;
        int val = ga.getBoard().getRobberHex();
        st[11] = this.translateHexToSmartSettlers(val);
        if (this.lastSettlement != -1) {
            st[14] = this.translateVertexToSmartSettlers(this.lastSettlement);
        }
        if ((val = ga.getCurrentDice()) == -1) {
            st[9] = 0;
            st[10] = 0;
        } else if (val < 7) {
            st[9] = 1;
            st[10] = val - 1;
        } else {
            st[9] = 6;
            st[10] = val - 6;
        }
        Vector v = ga.getBoard().getSettlements();
        Enumeration pEnum = v.elements();
        while (pEnum.hasMoreElements()) {
            p = (SOCSettlement)pEnum.nextElement();
            indn = this.translateVertexToSmartSettlers(p.getCoordinates());
            val = p.getPlayer().getPlayerNumber();
            st[87 + indn] = 2 + val;
        }
        v = ga.getBoard().getCities();
        pEnum = v.elements();
        while (pEnum.hasMoreElements()) {
            p = (SOCCity)pEnum.nextElement();
            indn = this.translateVertexToSmartSettlers(p.getCoordinates());
            val = p.getPlayer().getPlayerNumber();
            st[87 + indn] = 6 + val;
        }
        for (int i = 0; i < 54; ++i) {
            boolean islegal = true;
            if (st[87 + i] >= 2) continue;
            for (int j = 0; j < 6; ++j) {
                indn = this.bl.neighborVertexVertex[i][j];
                if (indn == -1 || st[87 + indn] < 2) continue;
                islegal = false;
                break;
            }
            if (islegal) continue;
            st[87 + i] = 1;
        }
        v = ga.getBoard().getRoads();
        pEnum = v.elements();
        while (pEnum.hasMoreElements()) {
            SOCRoad p2 = (SOCRoad)pEnum.nextElement();
            indn = this.translateEdgeToSmartSettlers(p2.getCoordinates());
            val = p2.getPlayer().getPlayerNumber();
            st[15 + indn] = 1 + val;
        }
        val = ga.getPlayerWithLargestArmy() == null ? -1 : ga.getPlayerWithLargestArmy().getPlayerNumber();
        st[13] = val;
        val = ga.getPlayerWithLongestRoad() == null ? -1 : ga.getPlayerWithLongestRoad().getPlayerNumber();
        st[12] = val;
        st[8] = 25 - ga.getNumDevCards();
        for (int pl = 0; pl < 4; ++pl) {
            SOCPlayer p3 = ga.getPlayer(pl);
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 1] = 5 - p3.getNumPieces(1);
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 2] = 4 - p3.getNumPieces(2);
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 3] = 15 - p3.getNumPieces(0);
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 4] = p3.getLongestRoadLength();
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 5] = p3.hasPlayedDevCard() ? 1 : 0;
            boolean[] hasports = p3.getPortFlags();
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 11 + 3 - 1] = hasports[1] ? 1 : 0;
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 11 + 2 - 1] = hasports[5] ? 1 : 0;
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 11 + 5 - 1] = hasports[2] ? 1 : 0;
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 11 + 1 - 1] = hasports[3] ? 1 : 0;
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 11 + 4 - 1] = hasports[4] ? 1 : 0;
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 11 + 6 - 1] = hasports[0] ? 1 : 0;
            SOCResourceSet rs = p3.getResources();
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 6 + 2] = rs.getAmount(1);
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 6 + 1] = rs.getAmount(5);
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 6 + 4] = rs.getAmount(2);
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 6 + 0] = rs.getAmount(3);
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 6 + 3] = rs.getAmount(4);
            SOCDevCardSet ds = p3.getDevCards();
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 27 + 0] = ds.getAmount(1, 0);
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 27 + 2] = ds.getAmount(1, 1);
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 27 + 3] = ds.getAmount(1, 2);
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 27 + 4] = ds.getAmount(1, 3);
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 27 + 1] = 0;
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 22 + 0] = ds.getAmount(0, 0);
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 22 + 2] = ds.getAmount(0, 1);
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 22 + 3] = ds.getAmount(0, 2);
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 22 + 4] = ds.getAmount(0, 3);
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 22 + 1] = ds.getNumVPCards();
            st[SSRobotClient.OFS_PLAYERDATA[pl] + 17 + 0] = p3.getNumKnights();
        }
        this.bl.setState(st);
        this.bl.recalcScores();
        this.debugframe.repaint();
        return st;
    }

    public void recordGameEvent(SOCMessage mes, String gameName, String event) {
        int ssState;
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        int socState = ga.getGameState();
        int pl = ga.getCurrentPlayerNumber();
        switch (socState) {
            case 5: {
                ssState = 2;
                break;
            }
            case 6: {
                ssState = 3;
                break;
            }
            case 10: {
                ssState = 4;
                break;
            }
            case 11: {
                ssState = 5;
                break;
            }
            case 15: {
                ssState = 6;
                break;
            }
            case 20: {
                ssState = 100;
                break;
            }
            case 40: {
                ssState = 13;
                break;
            }
            case 41: {
                ssState = 14;
                break;
            }
            case 33: {
                ssState = 15;
                break;
            }
            case 50: {
                ssState = 11;
                break;
            }
            case 1000: {
                ssState = 101;
                break;
            }
            default: {
                ssState = 100;
            }
        }
        int[] st = this.sendStateToSmartSettlers(ga, ssState);
        int[] a = new int[5];
        for (int i = 0; i < a.length; ++i) {
            a[i] = 0;
        }
        a[0] = -1;
        switch (mes.getType()) {
            case 1040: {
                SOCResourceSet get = ((SOCBankTrade)mes).getGetSet();
                SOCResourceSet give = ((SOCBankTrade)mes).getGiveSet();
                a[0] = 6;
                System.out.println("get:  " + get.toString());
                System.out.println("give: " + give.toString());
                int r1 = give.pickResource();
                a[1] = give.getAmount(r1);
                a[2] = this.translateResToSmartSettlers(r1);
                int r2 = get.pickResource();
                a[3] = get.getAmount(r2);
                a[4] = this.translateResToSmartSettlers(r2);
                break;
            }
            case 1043: {
                break;
            }
            case 1045: {
                a[0] = 7;
                break;
            }
            case 1036: 
            case 1046: {
                break;
            }
            case 1033: {
                SOCResourceSet ds = ((SOCDiscard)mes).getResources();
                a[0] = 12;
                a[1] = ds.getTotal();
                break;
            }
            case 1029: {
                break;
            }
            case 1052: {
                SOCResourceSet rs = ((SOCDiscoveryPick)mes).getResources();
                int r1 = rs.pickResource();
                rs.subtract(1, r1);
                int r2 = rs.pickResource();
                a[0] = 10;
                a[1] = this.translateResToSmartSettlers(r1);
                a[2] = this.translateResToSmartSettlers(r2);
                break;
            }
            case 1032: {
                a[0] = 5;
                break;
            }
            case 1053: {
                a[0] = 11;
                a[1] = this.translateResToSmartSettlers(((SOCMonopolyPick)mes).getResource());
                break;
            }
            case 1049: {
                int dc = ((SOCPlayDevCardRequest)mes).getDevCard();
                switch (dc) {
                    case 0: {
                        a[0] = 8;
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 1: {
                        a[0] = 9;
                    }
                }
                break;
            }
            case 1009: {
                int pos = ((SOCPutPiece)mes).getCoordinates();
                switch (((SOCPutPiece)mes).getPieceType()) {
                    case 0: {
                        a[0] = 2;
                        a[1] = this.translateEdgeToSmartSettlers(pos);
                        break;
                    }
                    case 1: {
                        a[0] = 1;
                        a[1] = this.translateVertexToSmartSettlers(pos);
                        break;
                    }
                    case 2: {
                        a[0] = 3;
                        a[1] = this.translateVertexToSmartSettlers(pos);
                    }
                }
                break;
            }
            case 1034: {
                this.logRobberPlace = ((SOCMoveRobber)mes).getCoordinates();
                break;
            }
            case 1035: {
                a[0] = 13;
                a[1] = this.translateEdgeToSmartSettlers(this.logRobberPlace);
                a[2] = ((SOCChoosePlayer)mes).getChoice();
                break;
            }
            case 1031: {
                a[0] = 4;
                break;
            }
        }
        if (a[0] != -1) {
            this.bl.writeLog(st, a, ga.getCurrentPlayerNumber(), gameName, event);
        }
    }

    @Override
    protected void handleJOINGAMEAUTH(SOCJoinGameAuth mes) {
        ++this.gamesPlayed;
        SOCGame ga = new SOCGame(mes.getGame(), true);
        this.games.put(mes.getGame(), ga);
        CappedQueue brainQ = new CappedQueue();
        this.brainQs.put(mes.getGame(), brainQ);
        SSRobotBrain rb = new SSRobotBrain(this, this.currentRobotParameters, ga, brainQ);
        this.robotBrains.put(mes.getGame(), rb);
    }

    @Override
    protected void handleBOARDLAYOUT(SOCBoardLayout mes) {
        super.handleBOARDLAYOUT(mes);
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCBoard bd = ga.getBoard();
            bd.setHexLayout(mes.getHexLayout());
            bd.setNumberLayout(mes.getNumberLayout());
            bd.setRobberHex(mes.getRobberHex());
        }
    }

    @Override
    protected void handleSTARTGAME(SOCStartGame mes) {
        super.handleSTARTGAME(mes);
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        this.sendGameToSmartSettlers(ga);
    }

    @Override
    protected void handleGAMESTATE(SOCGameState mes) {
        super.handleGAMESTATE(mes);
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            this.sendStateToSmartSettlers(ga, 0);
        }
    }

    @Override
    protected void handleDICERESULT(SOCDiceResult mes) {
        super.handleDICERESULT(mes);
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        this.sendStateToSmartSettlers(ga, 100);
    }

    @Override
    public boolean isSmartSettlersAgent() {
        return true;
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.err.println("usage: java soc.robot.SOCRobotClient host port_number userid password");
            return;
        }
        SSRobotClient ex1 = new SSRobotClient(args[0], Integer.parseInt(args[1]), args[2], args[3]);
        ex1.init();
    }
}

