/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import soc.disableDebug.D;
import soc.server.genericServer.Connection;
import soc.util.MutexFlag;

public class SOCChannelList {
    protected Hashtable channelMutexes = new Hashtable();
    protected Hashtable channelMembers = new Hashtable();
    protected boolean inUse = false;

    public synchronized void takeMonitor() {
        D.ebugPrintln("SOCChannelList : TAKE MONITOR");
        while (this.inUse) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                System.out.println("EXCEPTION IN takeMonitor() -- " + e);
            }
        }
        this.inUse = true;
    }

    public synchronized void releaseMonitor() {
        D.ebugPrintln("SOCChannelList : RELEASE MONITOR");
        this.inUse = false;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean takeMonitorForChannel(String channel) {
        D.ebugPrintln("SOCChannelList : TAKE MONITOR FOR " + channel);
        MutexFlag mutex = (MutexFlag)this.channelMutexes.get(channel);
        if (mutex == null) {
            return false;
        }
        boolean done = false;
        while (!done) {
            mutex = (MutexFlag)this.channelMutexes.get(channel);
            if (mutex == null) {
                return false;
            }
            MutexFlag mutexFlag = mutex;
            synchronized (mutexFlag) {
                if (mutex.getState()) {
                    try {
                        mutex.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        System.out.println("EXCEPTION IN takeMonitor() -- " + e);
                    }
                } else {
                    done = true;
                }
            }
        }
        mutex.setState(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseMonitorForChannel(String channel) {
        D.ebugPrintln("SOCChannelList : RELEASE MONITOR FOR " + channel);
        MutexFlag mutex = (MutexFlag)this.channelMutexes.get(channel);
        if (mutex == null) {
            return false;
        }
        MutexFlag mutexFlag = mutex;
        synchronized (mutexFlag) {
            mutex.setState(false);
            mutex.notify();
        }
        return true;
    }

    public Enumeration getChannels() {
        return this.channelMembers.keys();
    }

    public synchronized Vector getMembers(String chName) {
        Vector result = (Vector)this.channelMembers.get(chName);
        if (result == null) {
            result = new Vector();
        }
        return result;
    }

    public synchronized boolean isMember(Connection conn, String chName) {
        Vector members = this.getMembers(chName);
        return members != null && members.contains(conn);
    }

    public synchronized void addMember(Connection conn, String chName) {
        Vector members = this.getMembers(chName);
        if (members != null && !members.contains(conn)) {
            members.addElement(conn);
        }
    }

    public synchronized void removeMember(Connection conn, String chName) {
        Vector members = this.getMembers(chName);
        if (members != null) {
            members.removeElement(conn);
        }
    }

    public boolean isChannel(String chName) {
        return this.channelMembers.get(chName) != null;
    }

    public synchronized boolean isChannelEmpty(String chName) {
        Vector members = (Vector)this.channelMembers.get(chName);
        boolean result = members != null && members.isEmpty();
        return result;
    }

    public synchronized void createChannel(String chName) {
        if (!this.isChannel(chName)) {
            MutexFlag mutex = new MutexFlag();
            this.channelMutexes.put(chName, mutex);
            Vector members = new Vector();
            this.channelMembers.put(chName, members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteChannel(String chName) {
        D.ebugPrintln("SOCChannelList : deleteChannel(" + chName + ")");
        this.channelMembers.remove(chName);
        MutexFlag mutex = (MutexFlag)this.channelMutexes.get(chName);
        this.channelMutexes.remove(chName);
        if (mutex != null) {
            MutexFlag mutexFlag = mutex;
            synchronized (mutexFlag) {
                mutex.notifyAll();
            }
        }
    }
}

