/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import soc.disableDebug.D;
import soc.game.SOCGame;
import soc.server.genericServer.Connection;
import soc.util.MutexFlag;

public class SOCGameList {
    protected Hashtable gameMutexes = new Hashtable();
    protected Hashtable gameMembers = new Hashtable();
    protected Hashtable gameData = new Hashtable();
    protected boolean inUse = false;

    public synchronized void takeMonitor() {
        D.ebugPrintln("SOCGameList : TAKE MONITOR");
        while (this.inUse) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                System.out.println("EXCEPTION IN takeMonitor() -- " + e);
            }
        }
        this.inUse = true;
    }

    public synchronized void releaseMonitor() {
        D.ebugPrintln("SOCGameList : RELEASE MONITOR");
        this.inUse = false;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean takeMonitorForGame(String game) {
        D.ebugPrintln("SOCGameList : TAKE MONITOR FOR " + game);
        MutexFlag mutex = (MutexFlag)this.gameMutexes.get(game);
        if (mutex == null) {
            return false;
        }
        boolean done = false;
        while (!done) {
            mutex = (MutexFlag)this.gameMutexes.get(game);
            if (mutex == null) {
                return false;
            }
            MutexFlag mutexFlag = mutex;
            synchronized (mutexFlag) {
                if (mutex.getState()) {
                    try {
                        mutex.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        System.out.println("EXCEPTION IN takeMonitor() -- " + e);
                    }
                } else {
                    done = true;
                }
            }
        }
        mutex.setState(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseMonitorForGame(String game) {
        D.ebugPrintln("SOCGameList : RELEASE MONITOR FOR " + game);
        MutexFlag mutex = (MutexFlag)this.gameMutexes.get(game);
        if (mutex == null) {
            return false;
        }
        MutexFlag mutexFlag = mutex;
        synchronized (mutexFlag) {
            mutex.setState(false);
            mutex.notify();
        }
        return true;
    }

    public Enumeration getGames() {
        return this.gameMembers.keys();
    }

    public synchronized boolean isGameEmpty(String gaName) {
        Vector members = (Vector)this.gameMembers.get(gaName);
        boolean result = members != null && members.isEmpty();
        return result;
    }

    public synchronized Vector getMembers(String gaName) {
        return (Vector)this.gameMembers.get(gaName);
    }

    public SOCGame getGameData(String gaName) {
        return (SOCGame)this.gameData.get(gaName);
    }

    public synchronized boolean isMember(Connection conn, String gaName) {
        Vector members = this.getMembers(gaName);
        return members != null && members.contains(conn);
    }

    public synchronized void addMember(Connection conn, String gaName) {
        Vector members = this.getMembers(gaName);
        if (members != null && !members.contains(conn)) {
            members.addElement(conn);
        }
    }

    public synchronized void removeMember(Connection conn, String gaName) {
        Vector members = this.getMembers(gaName);
        if (members != null) {
            members.removeElement(conn);
        }
    }

    public boolean isGame(String gaName) {
        return this.gameMembers.get(gaName) != null;
    }

    public synchronized void createGame(String gaName) {
        if (!this.isGame(gaName)) {
            MutexFlag mutex = new MutexFlag();
            this.gameMutexes.put(gaName, mutex);
            Vector members = new Vector();
            this.gameMembers.put(gaName, members);
            SOCGame game = new SOCGame(gaName);
            game.setExpiration(game.getStartTime().getTime() + 5400000L);
            this.gameData.put(gaName, game);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteGame(String gaName) {
        Vector members;
        D.ebugPrintln("SOCGameList : deleteGame(" + gaName + ")");
        SOCGame game = (SOCGame)this.gameData.get(gaName);
        if (game != null) {
            game.destroyGame();
        }
        if ((members = (Vector)this.gameMembers.get(gaName)) != null) {
            members.removeAllElements();
        }
        MutexFlag mutex = (MutexFlag)this.gameMutexes.get(gaName);
        this.gameMutexes.remove(gaName);
        this.gameMembers.remove(gaName);
        this.gameData.remove(gaName);
        if (mutex != null) {
            MutexFlag mutexFlag = mutex;
            synchronized (mutexFlag) {
                mutex.notifyAll();
            }
        }
    }
}

