/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import soc.disableDebug.D;
import soc.game.SOCBoard;
import soc.game.SOCCity;
import soc.game.SOCDevCardSet;
import soc.game.SOCGame;
import soc.game.SOCMoveRobberResult;
import soc.game.SOCPlayer;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCSettlement;
import soc.game.SOCTradeOffer;
import soc.message.SOCAcceptOffer;
import soc.message.SOCAdminPing;
import soc.message.SOCAdminReset;
import soc.message.SOCBCastTextMsg;
import soc.message.SOCBankTrade;
import soc.message.SOCBoardLayout;
import soc.message.SOCBuildRequest;
import soc.message.SOCBuyCardRequest;
import soc.message.SOCCancelBuildRequest;
import soc.message.SOCChangeFace;
import soc.message.SOCChannels;
import soc.message.SOCChoosePlayer;
import soc.message.SOCChoosePlayerRequest;
import soc.message.SOCClearOffer;
import soc.message.SOCClearTradeMsg;
import soc.message.SOCCreateAccount;
import soc.message.SOCDeleteChannel;
import soc.message.SOCDeleteGame;
import soc.message.SOCDevCard;
import soc.message.SOCDevCardCount;
import soc.message.SOCDiceResult;
import soc.message.SOCDiscard;
import soc.message.SOCDiscardRequest;
import soc.message.SOCDiscoveryPick;
import soc.message.SOCEndTurn;
import soc.message.SOCFirstPlayer;
import soc.message.SOCGameMembers;
import soc.message.SOCGameState;
import soc.message.SOCGameTextMsg;
import soc.message.SOCGames;
import soc.message.SOCImARobot;
import soc.message.SOCJoin;
import soc.message.SOCJoinAuth;
import soc.message.SOCJoinGame;
import soc.message.SOCJoinGameAuth;
import soc.message.SOCJoinGameRequest;
import soc.message.SOCLargestArmy;
import soc.message.SOCLastSettlement;
import soc.message.SOCLeave;
import soc.message.SOCLeaveGame;
import soc.message.SOCLongestRoad;
import soc.message.SOCMakeOffer;
import soc.message.SOCMembers;
import soc.message.SOCMessage;
import soc.message.SOCMonopolyPick;
import soc.message.SOCMoveRobber;
import soc.message.SOCNewChannel;
import soc.message.SOCNewGame;
import soc.message.SOCPlayDevCardRequest;
import soc.message.SOCPlayerElement;
import soc.message.SOCPotentialSettlements;
import soc.message.SOCPutPiece;
import soc.message.SOCRejectConnection;
import soc.message.SOCRejectOffer;
import soc.message.SOCResourceCount;
import soc.message.SOCRobotDismiss;
import soc.message.SOCRollDice;
import soc.message.SOCSetPlayedDevCard;
import soc.message.SOCSetSeatLock;
import soc.message.SOCSetTurn;
import soc.message.SOCSitDown;
import soc.message.SOCStartGame;
import soc.message.SOCStatusMessage;
import soc.message.SOCTextMsg;
import soc.message.SOCTurn;
import soc.message.SOCUpdateRobotParams;
import soc.robot.SSRobotClient;
import soc.server.SOCChannelList;
import soc.server.SOCGameList;
import soc.server.SOCGameTimeoutChecker;
import soc.server.SOCReplaceRequest;
import soc.server.SOCServerRobotPinger;
import soc.server.database.SOCDBHelper;
import soc.server.genericServer.Connection;
import soc.server.genericServer.Server;
import soc.util.IntPair;
import soc.util.SOCRobotParameters;
import soc.util.Version;

public class SOCServer
extends Server {
    public static final String SERVERNAME = "Server";
    private Random rand = new Random();
    public int port;
    protected int maxConnections;
    protected Vector robots = new Vector();
    protected SOCChannelList channelList = new SOCChannelList();
    protected SOCGameList gameList = new SOCGameList();
    protected Hashtable robotJoinRequests = new Hashtable();
    protected Hashtable robotDismissRequests = new Hashtable();
    protected Hashtable gameDataFiles = new Hashtable();
    protected long startTime;
    protected int numberOfGamesStarted;
    protected int numberOfGamesFinished;
    protected int numberOfUsers;
    SOCServerRobotPinger serverRobotPinger;
    SOCGameTimeoutChecker gameTimeoutChecker;
    String databaseUserName;
    String databasePassword;
    SSRobotClient loggerClient;

    public SOCServer(int p, int mc, String databaseUserName, String databasePassword) {
        super(p);
        this.maxConnections = mc;
        System.err.println("Java Settlers Server " + Version.version() + ", " + Version.copyright());
        System.err.println("Network layer based on code by Cristian Bogdan.");
        try {
            SOCDBHelper.initialize(databaseUserName, databasePassword);
            System.err.println("User database initialized.");
        }
        catch (SQLException x) {
            System.err.println("No user database available: " + x.getMessage());
            System.err.println("Users will not be authenticated.");
        }
        this.port = p;
        this.startTime = System.currentTimeMillis();
        this.numberOfGamesStarted = 0;
        this.numberOfGamesFinished = 0;
        this.numberOfUsers = 0;
        this.serverRobotPinger = new SOCServerRobotPinger(this.robots);
        this.serverRobotPinger.start();
        this.gameTimeoutChecker = new SOCGameTimeoutChecker(this);
        this.gameTimeoutChecker.start();
        this.databaseUserName = databaseUserName;
        this.databasePassword = databasePassword;
    }

    public void connectToChannel(Connection c, String ch) {
        if (c != null && this.channelList.isChannel(ch) && !this.channelList.isMember(c, ch)) {
            c.put(SOCMembers.toCmd(ch, this.channelList.getMembers(ch)));
            D.ebugPrintln("*** " + c.data + " joined the channel " + ch);
            this.channelList.addMember(c, ch);
        }
    }

    public boolean leaveChannel(Connection c, String ch, boolean channelListLock) {
        D.ebugPrintln("leaveChannel: " + c.data + " " + ch + " " + channelListLock);
        boolean result = false;
        if (c != null) {
            if (this.channelList.isMember(c, ch)) {
                this.channelList.removeMember(c, ch);
                SOCLeave leaveMessage = new SOCLeave((String)c.data, c.host(), ch);
                this.messageToChannelWithMon(ch, leaveMessage);
                D.ebugPrintln("*** " + (String)c.data + " left the channel " + ch);
            }
            if (this.channelList.isChannelEmpty(ch)) {
                if (channelListLock) {
                    this.channelList.deleteChannel(ch);
                } else {
                    this.channelList.takeMonitor();
                    try {
                        this.channelList.deleteChannel(ch);
                    }
                    catch (Exception e) {
                        D.ebugPrintln("Exception in leaveChannel - " + e);
                    }
                    this.channelList.releaseMonitor();
                }
                result = true;
            }
        }
        return result;
    }

    public boolean connectToGame(Connection c, String ga) {
        boolean result = false;
        if (c != null) {
            boolean gameExists = false;
            this.gameList.takeMonitor();
            try {
                gameExists = this.gameList.isGame(ga);
            }
            catch (Exception e) {
                D.ebugPrintln("Excepetion in connectToGame - " + e);
            }
            this.gameList.releaseMonitor();
            if (gameExists) {
                this.gameList.takeMonitorForGame(ga);
                try {
                    if (this.gameList.isMember(c, ga)) {
                        result = false;
                    } else {
                        this.gameList.addMember(c, ga);
                        result = true;
                    }
                }
                catch (Exception e) {
                    D.ebugPrintln("Excepetion in connectToGame (isMember) - " + e);
                }
                this.gameList.releaseMonitorForGame(ga);
            } else {
                this.gameList.takeMonitor();
                boolean monitorReleased = false;
                try {
                    this.gameList.createGame(ga);
                    this.gameList.addMember(c, ga);
                    this.gameList.releaseMonitor();
                    monitorReleased = true;
                    this.broadcast(SOCNewGame.toCmd(ga));
                    result = true;
                }
                catch (Exception e) {
                    D.ebugPrintln("Excepetion in connectToGame - " + e);
                }
                if (!monitorReleased) {
                    this.gameList.releaseMonitor();
                }
            }
            return result;
        }
        return false;
    }

    public boolean leaveGame(Connection c, String gm, boolean gameListLock) {
        boolean gameDestroyed = false;
        if (c != null) {
            this.gameList.removeMember(c, gm);
            boolean isPlayer = false;
            int playerNumber = 0;
            SOCGame cg = this.gameList.getGameData(gm);
            boolean gameHasHumanPlayer = false;
            boolean gameHasObserver = true;
            if (cg != null) {
                for (playerNumber = 0; playerNumber < 4; ++playerNumber) {
                    SOCPlayer player = cg.getPlayer(playerNumber);
                    if (player == null || player.getName() == null || !player.getName().equals((String)c.data)) continue;
                    isPlayer = true;
                    cg.removePlayer((String)c.data);
                    break;
                }
                SOCLeaveGame leaveMessage = new SOCLeaveGame((String)c.data, c.host(), gm);
                this.messageToGameWithMon(gm, leaveMessage);
                D.ebugPrintln("*** " + (String)c.data + " left the game " + gm);
                this.messageToGameWithMon(gm, new SOCGameTextMsg(gm, SERVERNAME, (String)c.data + " left the game"));
                for (int pn = 0; pn < 4; ++pn) {
                    SOCPlayer player;
                    if (cg == null || (player = cg.getPlayer(pn)) == null || player.getName() == null || cg.isSeatVacant(pn) || player.isRobot()) continue;
                    gameHasHumanPlayer = true;
                    break;
                }
                if (cg != null && !gameHasHumanPlayer && !this.gameList.isGameEmpty(gm)) {
                    Enumeration membersEnum = this.gameList.getMembers(gm).elements();
                    while (membersEnum.hasMoreElements()) {
                        Connection member = (Connection)membersEnum.nextElement();
                        boolean nameMatch = false;
                        for (int pn = 0; pn < 4; ++pn) {
                            SOCPlayer player = cg.getPlayer(pn);
                            if (player == null || player.getName() == null || !player.getName().equals((String)member.data)) continue;
                            nameMatch = true;
                            break;
                        }
                        if (nameMatch) continue;
                        gameHasObserver = true;
                        break;
                    }
                }
                if (isPlayer && (gameHasHumanPlayer || gameHasObserver) && cg != null && !cg.getPlayer(playerNumber).isRobot() && cg.getGameState() != 1000 && cg.getGameState() >= 5) {
                    this.messageToGameWithMon(gm, new SOCGameTextMsg(gm, SERVERNAME, "Fetching a robot player..."));
                    if (this.robots.isEmpty()) {
                        this.messageToGameWithMon(gm, new SOCGameTextMsg(gm, SERVERNAME, "Sorry, no robots on this server."));
                    } else {
                        boolean nameMatch = false;
                        Connection robotConn = null;
                        int[] robotIndexes = new int[this.robots.size()];
                        for (int i = 0; i < this.robots.size(); ++i) {
                            robotIndexes[i] = i;
                        }
                        for (int j = 0; j < 3; ++j) {
                            for (int i = 0; i < robotIndexes.length; ++i) {
                                int idx = Math.abs(this.rand.nextInt() % (robotIndexes.length - i));
                                int tmp = robotIndexes[idx];
                                robotIndexes[idx] = robotIndexes[i];
                                robotIndexes[i] = tmp;
                            }
                        }
                        Vector<Connection> requests = (Vector<Connection>)this.robotJoinRequests.get(gm);
                        for (int idx = 0; idx < this.robots.size(); ++idx) {
                            Enumeration requestsEnum;
                            robotConn = (Connection)this.robots.get(robotIndexes[idx]);
                            nameMatch = false;
                            for (int i = 0; i < 4; ++i) {
                                SOCPlayer pl;
                                if (cg == null || (pl = cg.getPlayer(i)) == null) continue;
                                String pname = pl.getName();
                                D.ebugPrintln("CHECKING " + (String)robotConn.data + " == " + pname);
                                if (pname == null || !pname.equals((String)robotConn.data)) continue;
                                nameMatch = true;
                                break;
                            }
                            if (!nameMatch && requests != null && (requestsEnum = requests.elements()).hasMoreElements()) {
                                Connection tempCon = (Connection)requestsEnum.nextElement();
                                D.ebugPrintln("CHECKING " + robotConn + " == " + tempCon);
                                if (tempCon == robotConn) {
                                    nameMatch = true;
                                }
                            }
                            if (!nameMatch) break;
                        }
                        if (!nameMatch && cg != null) {
                            D.ebugPrintln("@@@ JOIN GAME REQUEST for " + (String)robotConn.data);
                            if (robotConn.put(SOCJoinGameRequest.toCmd(gm, playerNumber))) {
                                if (requests == null) {
                                    requests = new Vector<Connection>();
                                    requests.addElement(robotConn);
                                    this.robotJoinRequests.put(gm, requests);
                                } else {
                                    requests.addElement(robotConn);
                                }
                            } else {
                                this.messageToGameWithMon(gm, new SOCGameTextMsg(gm, SERVERNAME, "*** Error on robot request! ***"));
                            }
                        } else {
                            this.messageToGameWithMon(gm, new SOCGameTextMsg(gm, SERVERNAME, "*** Can't find a robot! ***"));
                        }
                    }
                }
            }
            boolean emptyGame = false;
            emptyGame = this.gameList.isGameEmpty(gm);
            if (emptyGame || !gameHasHumanPlayer && !gameHasObserver) {
                if (gameListLock) {
                    this.destroyGame(gm);
                } else {
                    this.gameList.takeMonitor();
                    try {
                        this.destroyGame(gm);
                    }
                    catch (Exception e) {
                        D.ebugPrintln("Exception in leaveGame (destroyGame) - " + e);
                    }
                    this.gameList.releaseMonitor();
                }
                gameDestroyed = true;
            }
        }
        return gameDestroyed;
    }

    public void destroyGame(String gm) {
        SOCGame cg = null;
        cg = this.gameList.getGameData(gm);
        if (cg != null) {
            if (cg.getGameState() == 1000) {
                ++this.numberOfGamesFinished;
            }
            this.gameList.deleteGame(gm);
        }
    }

    public Vector leaveAllChannels(Connection c) {
        if (c != null) {
            Vector ret = new Vector();
            Vector<String> destroyed = new Vector<String>();
            this.channelList.takeMonitor();
            try {
                Enumeration k = this.channelList.getChannels();
                while (k.hasMoreElements()) {
                    String ch = (String)k.nextElement();
                    if (!this.channelList.isMember(c, ch)) continue;
                    boolean thisChannelDestroyed = false;
                    this.channelList.takeMonitorForChannel(ch);
                    try {
                        thisChannelDestroyed = this.leaveChannel(c, ch, true);
                    }
                    catch (Exception e) {
                        D.ebugPrintln("Exception in leaveAllChannels (leaveChannel) - " + e);
                    }
                    this.channelList.releaseMonitorForChannel(ch);
                    if (!thisChannelDestroyed) continue;
                    destroyed.addElement(ch);
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception in leaveAllChannels - " + e);
            }
            this.channelList.releaseMonitor();
            Enumeration de = destroyed.elements();
            while (de.hasMoreElements()) {
                String ga = (String)de.nextElement();
                this.broadcast(SOCDeleteChannel.toCmd(ga));
            }
            return ret;
        }
        return null;
    }

    public Vector leaveAllGames(Connection c) {
        if (c != null) {
            String ga;
            Vector<String> ret = new Vector<String>();
            Vector<String> destroyed = new Vector<String>();
            this.gameList.takeMonitor();
            try {
                Enumeration k = this.gameList.getGames();
                while (k.hasMoreElements()) {
                    ga = (String)k.nextElement();
                    Vector v = this.gameList.getMembers(ga);
                    if (!v.contains(c)) continue;
                    boolean thisGameDestroyed = false;
                    this.gameList.takeMonitorForGame(ga);
                    try {
                        thisGameDestroyed = this.leaveGame(c, ga, true);
                    }
                    catch (Exception e) {
                        D.ebugPrintln("Exception in leaveAllGames (leaveGame) - " + e);
                    }
                    this.gameList.releaseMonitorForGame(ga);
                    if (thisGameDestroyed) {
                        destroyed.addElement(ga);
                    }
                    ret.addElement(ga);
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception in leaveAllGames - " + e);
            }
            this.gameList.releaseMonitor();
            Enumeration de = destroyed.elements();
            while (de.hasMoreElements()) {
                ga = (String)de.nextElement();
                D.ebugPrintln("** Broadcasting SOCDeleteGame " + ga);
                this.broadcast(SOCDeleteGame.toCmd(ga));
            }
            return ret;
        }
        return null;
    }

    public void messageToChannel(String ch, SOCMessage mes) {
        this.channelList.takeMonitorForChannel(ch);
        try {
            Vector v = this.channelList.getMembers(ch);
            if (v != null) {
                Enumeration enum1 = v.elements();
                while (enum1.hasMoreElements()) {
                    Connection c = (Connection)enum1.nextElement();
                    if (c == null) continue;
                    c.put(mes.toCmd());
                }
            }
        }
        catch (Exception e) {
            D.ebugPrintln("Exception in messageToChannel - " + e);
        }
        this.channelList.releaseMonitorForChannel(ch);
    }

    public void messageToChannelWithMon(String ch, SOCMessage mes) {
        Vector v = this.channelList.getMembers(ch);
        if (v != null) {
            Enumeration enum1 = v.elements();
            while (enum1.hasMoreElements()) {
                Connection c = (Connection)enum1.nextElement();
                if (c == null) continue;
                c.put(mes.toCmd());
            }
        }
    }

    public void messageToPlayer(Connection c, SOCMessage mes) {
        if (c != null && mes != null) {
            c.put(mes.toCmd());
        }
    }

    public void messageToGame(String ga, SOCMessage mes) {
        this.gameList.takeMonitorForGame(ga);
        try {
            Vector v = this.gameList.getMembers(ga);
            if (v != null) {
                Enumeration enum1 = v.elements();
                while (enum1.hasMoreElements()) {
                    Connection c = (Connection)enum1.nextElement();
                    if (c == null) continue;
                    c.put(mes.toCmd());
                }
            }
        }
        catch (Exception e) {
            D.ebugPrintln("Exception in messageToGame - " + e);
        }
        this.gameList.releaseMonitorForGame(ga);
    }

    public void messageToGameWithMon(String ga, SOCMessage mes) {
        Vector v = this.gameList.getMembers(ga);
        if (v != null) {
            Enumeration enum1 = v.elements();
            while (enum1.hasMoreElements()) {
                Connection c = (Connection)enum1.nextElement();
                if (c == null) continue;
                c.put(mes.toCmd());
            }
        }
    }

    public void messageToGameExcept(String gn, Vector ex, SOCMessage mes) {
        this.gameList.takeMonitorForGame(gn);
        try {
            Vector v = this.gameList.getMembers(gn);
            if (v != null) {
                Enumeration enum1 = v.elements();
                while (enum1.hasMoreElements()) {
                    Connection con = (Connection)enum1.nextElement();
                    if (con == null || ex.contains(con)) continue;
                    con.put(mes.toCmd());
                }
            }
        }
        catch (Exception e) {
            D.ebugPrintln("Exception in messageToGameExcept - " + e);
        }
        this.gameList.releaseMonitorForGame(gn);
    }

    @Override
    public void leaveConnection(Connection c) {
        if (c != null) {
            this.leaveAllChannels(c);
            this.leaveAllGames(c);
            this.robots.removeElement(c);
        }
    }

    @Override
    public void newConnection(Connection c) {
        block13: {
            if (c != null) {
                try {
                    if (this.connectionCount() >= this.maxConnections) {
                        SOCRejectConnection rcCommand = new SOCRejectConnection("Too many connections, please try another server.");
                        c.put(rcCommand.toCmd());
                        return;
                    }
                }
                catch (Exception e) {
                    D.ebugPrintln("Caught exception in SOCServer.newConnection(Connection) - " + e);
                    e.printStackTrace(System.out);
                    return;
                }
                try {
                    boolean hostMatch = false;
                    Enumeration allConnections = this.getConnections();
                    if (hostMatch) {
                        SOCRejectConnection rcCommand = new SOCRejectConnection("Can't connect to the server more than once from one machine.");
                        c.put(rcCommand.toCmd());
                        break block13;
                    }
                    Vector cl = new Vector();
                    this.channelList.takeMonitor();
                    try {
                        Enumeration clEnum = this.channelList.getChannels();
                        while (clEnum.hasMoreElements()) {
                            cl.addElement(clEnum.nextElement());
                        }
                    }
                    catch (Exception e) {
                        D.ebugPrintln("Exception in newConnection (channelList) - " + e);
                    }
                    this.channelList.releaseMonitor();
                    c.put(SOCChannels.toCmd(cl));
                    Vector gl = new Vector();
                    this.gameList.takeMonitor();
                    try {
                        Enumeration gaEnum = this.gameList.getGames();
                        while (gaEnum.hasMoreElements()) {
                            gl.addElement(gaEnum.nextElement());
                        }
                    }
                    catch (Exception e) {
                        D.ebugPrintln("Exception in newConnection (gameList) - " + e);
                    }
                    this.gameList.releaseMonitor();
                    c.put(SOCGames.toCmd(gl));
                }
                catch (Exception e) {
                    D.ebugPrintln("Caught exception in SOCServer.newConnection(Connection) - " + e);
                    e.printStackTrace(System.out);
                }
            }
        }
    }

    private boolean checkNickname(String n) {
        if (n.equals(SERVERNAME)) {
            return false;
        }
        Enumeration connsEnum = this.getConnections();
        while (connsEnum.hasMoreElements()) {
            Connection con = (Connection)connsEnum.nextElement();
            if (con == null || !n.equals((String)con.data)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void processCommand(String s, Connection c) {
        block64: {
            try {
                SOCMessage mes = SOCMessage.toMsg(s);
                if (mes == null) break block64;
                block5 : switch (mes.getType()) {
                    case 1004: {
                        this.handleJOIN(c, (SOCJoin)mes);
                        break;
                    }
                    case 1006: {
                        this.handleLEAVE(c, (SOCLeave)mes);
                        break;
                    }
                    case 1008: {
                        this.removeConnection(c);
                        this.removeConnectionCleanup(c);
                        break;
                    }
                    case 1005: {
                        SOCTextMsg textMsgMes = (SOCTextMsg)mes;
                        if (c.data.equals("debug")) {
                            if (textMsgMes.getText().startsWith("*KILLCHANNEL*")) {
                                this.messageToChannel(textMsgMes.getChannel(), new SOCTextMsg(textMsgMes.getChannel(), SERVERNAME, "********** " + (String)c.data + " KILLED THE CHANNEL **********"));
                                this.channelList.takeMonitor();
                                try {
                                    this.channelList.deleteChannel(textMsgMes.getChannel());
                                }
                                catch (Exception e) {
                                    D.ebugPrintln("Exception in KILLCHANNEL - " + e);
                                }
                                this.channelList.releaseMonitor();
                                this.broadcast(SOCDeleteChannel.toCmd(textMsgMes.getChannel()));
                                break;
                            }
                            this.messageToChannel(textMsgMes.getChannel(), mes);
                            break;
                        }
                        this.messageToChannel(textMsgMes.getChannel(), mes);
                        break;
                    }
                    case 1022: {
                        this.handleIMAROBOT(c, (SOCImARobot)mes);
                        break;
                    }
                    case 1010: {
                        SOCGame gameData;
                        SOCGameTextMsg gameTextMsgMes = (SOCGameTextMsg)mes;
                        SOCGame ga = this.gameList.getGameData(gameTextMsgMes.getGame());
                        if ((gameTextMsgMes.getText().startsWith("*ADDTIME*") || gameTextMsgMes.getText().startsWith("*addtime*") || gameTextMsgMes.getText().startsWith("ADDTIME") || gameTextMsgMes.getText().startsWith("addtime")) && (gameData = this.gameList.getGameData(gameTextMsgMes.getGame())) != null) {
                            gameData.setExpiration(gameData.getExpiration() + 1800000L);
                            this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "> This game will expire in " + (gameData.getExpiration() - System.currentTimeMillis()) / 60000L + " minutes."));
                        }
                        if (gameTextMsgMes.getText().startsWith("*CHECKTIME*")) {
                            gameData = this.gameList.getGameData(gameTextMsgMes.getGame());
                            this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "> This game will expire in " + (gameData.getExpiration() - System.currentTimeMillis()) / 60000L + " minutes."));
                        } else if (gameTextMsgMes.getText().startsWith("*WHO*")) {
                            Vector gameMembers = null;
                            this.gameList.takeMonitorForGame(gameTextMsgMes.getGame());
                            try {
                                gameMembers = this.gameList.getMembers(gameTextMsgMes.getGame());
                            }
                            catch (Exception e) {
                                D.ebugPrintln("Exception in *WHO* (gameMembers) - " + e);
                            }
                            this.gameList.releaseMonitorForGame(gameTextMsgMes.getGame());
                            if (gameMembers != null) {
                                Enumeration membersEnum = gameMembers.elements();
                                while (membersEnum.hasMoreElements()) {
                                    Connection conn = (Connection)membersEnum.nextElement();
                                    this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "> " + conn.data));
                                }
                            }
                        }
                        if (c.data.equals("debug")) {
                            Connection robotConn;
                            Enumeration robotsEnum;
                            String botName;
                            if (gameTextMsgMes.getText().startsWith("rsrcs:")) {
                                this.giveResources(gameTextMsgMes.getText(), ga);
                                break;
                            }
                            if (gameTextMsgMes.getText().startsWith("dev:")) {
                                this.giveDevCard(gameTextMsgMes.getText(), ga);
                                break;
                            }
                            if (gameTextMsgMes.getText().startsWith("*KILLGAME*")) {
                                this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "********** " + (String)c.data + " KILLED THE GAME!!! **********"));
                                this.gameList.takeMonitor();
                                try {
                                    this.destroyGame(gameTextMsgMes.getGame());
                                }
                                catch (Exception e) {
                                    D.ebugPrintln("Exception in KILLGAME - " + e);
                                }
                                this.gameList.releaseMonitor();
                                this.broadcast(SOCDeleteGame.toCmd(gameTextMsgMes.getGame()));
                                break;
                            }
                            if (gameTextMsgMes.getText().startsWith("*STATS*")) {
                                long diff = System.currentTimeMillis() - this.startTime;
                                long hours = diff / 3600000L;
                                long minutes = (diff - hours * 60L * 60L * 1000L) / 60000L;
                                long seconds = (diff - hours * 60L * 60L * 1000L - minutes * 60L * 1000L) / 1000L;
                                Runtime rt = Runtime.getRuntime();
                                this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "> Uptime: " + hours + ":" + minutes + ":" + seconds));
                                this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "> Total connections: " + this.numberOfConnections));
                                this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "> Current connections: " + this.connectionCount()));
                                this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "> Total Users: " + this.numberOfUsers));
                                this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "> Games started: " + this.numberOfGamesStarted));
                                this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "> Games finished: " + this.numberOfGamesFinished));
                                this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "> Total Memory: " + rt.totalMemory()));
                                this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "> Free Memory: " + rt.freeMemory()));
                                break;
                            }
                            if (gameTextMsgMes.getText().startsWith("*GC*")) {
                                Runtime rt = Runtime.getRuntime();
                                rt.gc();
                                this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "> GARBAGE COLLECTING DONE"));
                                this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "> Free Memory: " + rt.freeMemory()));
                                break;
                            }
                            if (gameTextMsgMes.getText().startsWith("*STOP*")) {
                                try {
                                    SOCDBHelper.cleanup();
                                }
                                catch (SQLException x) {
                                    // empty catch block
                                }
                                this.stopServer();
                                System.exit(0);
                                break;
                            }
                            if (gameTextMsgMes.getText().startsWith("*BCAST* ")) {
                                this.broadcast(SOCBCastTextMsg.toCmd(gameTextMsgMes.getText().substring(8)));
                                break;
                            }
                            if (gameTextMsgMes.getText().startsWith("*BOTLIST*")) {
                                Enumeration robotsEnum2 = this.robots.elements();
                                while (robotsEnum2.hasMoreElements()) {
                                    Connection robotConn2 = (Connection)robotsEnum2.nextElement();
                                    this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "> Robot: " + robotConn2.data));
                                    robotConn2.put(SOCAdminPing.toCmd(gameTextMsgMes.getGame()));
                                }
                                break;
                            }
                            if (gameTextMsgMes.getText().startsWith("*RESETBOT* ")) {
                                botName = gameTextMsgMes.getText().substring(11).trim();
                                this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "> botName = '" + botName + "'"));
                                robotsEnum = this.robots.elements();
                                while (robotsEnum.hasMoreElements()) {
                                    robotConn = (Connection)robotsEnum.nextElement();
                                    D.ebugPrintln("&&& '" + botName + "' == '" + robotConn.data + "' is " + botName.equals((String)robotConn.data));
                                    if (!botName.equals((String)robotConn.data)) continue;
                                    this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "> SENDING RESET COMMAND TO " + botName));
                                    SOCAdminReset resetCmd = new SOCAdminReset();
                                    robotConn.put(resetCmd.toCmd());
                                    break block5;
                                }
                                break;
                            }
                            if (gameTextMsgMes.getText().startsWith("*KILLBOT* ")) {
                                botName = gameTextMsgMes.getText().substring(10).trim();
                                this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "> botName = '" + botName + "'"));
                                robotsEnum = this.robots.elements();
                                while (robotsEnum.hasMoreElements()) {
                                    robotConn = (Connection)robotsEnum.nextElement();
                                    D.ebugPrintln("&&& '" + botName + "' == '" + robotConn.data + "' is " + botName.equals((String)robotConn.data));
                                    if (!botName.equals((String)robotConn.data)) continue;
                                    this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), SERVERNAME, "> DISCONNECTING " + botName));
                                    this.removeConnection(robotConn);
                                    this.removeConnectionCleanup(robotConn);
                                    break block5;
                                }
                                break;
                            }
                            this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), (String)c.data, gameTextMsgMes.getText()));
                            break;
                        }
                        this.messageToGame(gameTextMsgMes.getGame(), new SOCGameTextMsg(gameTextMsgMes.getGame(), (String)c.data, gameTextMsgMes.getText()));
                        break;
                    }
                    case 1013: {
                        this.handleJOINGAME(c, (SOCJoinGame)mes);
                        break;
                    }
                    case 1011: {
                        this.handleLEAVEGAME(c, (SOCLeaveGame)mes);
                        break;
                    }
                    case 1012: {
                        this.handleSITDOWN(c, (SOCSitDown)mes);
                        break;
                    }
                    case 1009: {
                        this.handlePUTPIECE(c, (SOCPutPiece)mes);
                        break;
                    }
                    case 1034: {
                        this.handleMOVEROBBER(c, (SOCMoveRobber)mes);
                        break;
                    }
                    case 1018: {
                        this.handleSTARTGAME(c, (SOCStartGame)mes);
                        break;
                    }
                    case 1031: {
                        this.handleROLLDICE(c, (SOCRollDice)mes);
                        break;
                    }
                    case 1033: {
                        this.handleDISCARD(c, (SOCDiscard)mes);
                        break;
                    }
                    case 1032: {
                        this.handleENDTURN(c, (SOCEndTurn)mes);
                        break;
                    }
                    case 1035: {
                        this.handleCHOOSEPLAYER(c, (SOCChoosePlayer)mes);
                        break;
                    }
                    case 1041: {
                        this.handleMAKEOFFER(c, (SOCMakeOffer)mes);
                        break;
                    }
                    case 1038: {
                        this.handleCLEAROFFER(c, (SOCClearOffer)mes);
                        break;
                    }
                    case 1037: {
                        this.handleREJECTOFFER(c, (SOCRejectOffer)mes);
                        break;
                    }
                    case 1039: {
                        this.handleACCEPTOFFER(c, (SOCAcceptOffer)mes);
                        break;
                    }
                    case 1040: {
                        this.handleBANKTRADE(c, (SOCBankTrade)mes);
                        break;
                    }
                    case 1043: {
                        this.handleBUILDREQUEST(c, (SOCBuildRequest)mes);
                        break;
                    }
                    case 1044: {
                        this.handleCANCELBUILDREQUEST(c, (SOCCancelBuildRequest)mes);
                        break;
                    }
                    case 1045: {
                        this.handleBUYCARDREQUEST(c, (SOCBuyCardRequest)mes);
                        break;
                    }
                    case 1049: {
                        this.handlePLAYDEVCARDREQUEST(c, (SOCPlayDevCardRequest)mes);
                        break;
                    }
                    case 1052: {
                        this.handleDISCOVERYPICK(c, (SOCDiscoveryPick)mes);
                        break;
                    }
                    case 1053: {
                        this.handleMONOPOLYPICK(c, (SOCMonopolyPick)mes);
                        break;
                    }
                    case 1058: {
                        this.handleCHANGEFACE(c, (SOCChangeFace)mes);
                        break;
                    }
                    case 1068: {
                        this.handleSETSEATLOCK(c, (SOCSetSeatLock)mes);
                        break;
                    }
                    case 1070: {
                        this.handleCREATEACCOUNT(c, (SOCCreateAccount)mes);
                    }
                }
            }
            catch (Exception e) {
                D.ebugPrintln("ERROR -> " + e);
                e.printStackTrace();
            }
        }
    }

    private boolean authenticateUser(Connection c, String userName, String password) {
        String userPassword = null;
        try {
            userPassword = SOCDBHelper.getUserPassword(userName);
        }
        catch (SQLException sqle) {
            c.put(SOCStatusMessage.toCmd("Problem connecting to database, please try again later."));
            return false;
        }
        if (userPassword != null) {
            if (!userPassword.equals(password)) {
                c.put(SOCStatusMessage.toCmd("Incorrect password for '" + userName + "'."));
                return false;
            }
        } else if (!password.equals("")) {
            c.put(SOCStatusMessage.toCmd("No user with the nickname '" + userName + "' is registered with the system."));
            return false;
        }
        Date currentTime = new Date();
        return true;
    }

    private void handleJOIN(Connection c, SOCJoin mes) {
        if (c != null) {
            D.ebugPrintln("handleJOIN: " + mes);
            if (c.data == null && !this.checkNickname(mes.getNickname())) {
                c.put(SOCStatusMessage.toCmd("Someone with that nickname is already logged into the system."));
                return;
            }
            if (c.data == null && !this.authenticateUser(c, mes.getNickname(), mes.getPassword())) {
                return;
            }
            if (c.data == null) {
                c.data = mes.getNickname();
                ++this.numberOfUsers;
            }
            c.put(SOCJoinAuth.toCmd(mes.getNickname(), mes.getChannel()));
            c.put(SOCStatusMessage.toCmd("Welcome to Java Settlers of Catan!"));
            String ch = mes.getChannel();
            if (this.channelList.takeMonitorForChannel(ch)) {
                try {
                    this.connectToChannel(c, ch);
                }
                catch (Exception e) {
                    D.ebugPrintln("Exception in handleJOIN (connectToChannel) - " + e);
                }
                this.channelList.releaseMonitorForChannel(ch);
            } else {
                this.channelList.takeMonitor();
                try {
                    this.channelList.createChannel(ch);
                }
                catch (Exception e) {
                    D.ebugPrintln("Exception in handleJOIN (createChannel) - " + e);
                }
                this.channelList.releaseMonitor();
                this.broadcast(SOCNewChannel.toCmd(ch));
                c.put(SOCMembers.toCmd(ch, this.channelList.getMembers(ch)));
                D.ebugPrintln("*** " + c.data + " joined the channel " + ch);
                this.channelList.takeMonitorForChannel(ch);
                try {
                    this.channelList.addMember(c, ch);
                }
                catch (Exception e) {
                    D.ebugPrintln("Exception in handleJOIN (addMember) - " + e);
                }
                this.channelList.releaseMonitorForChannel(ch);
            }
            this.messageToChannel(ch, new SOCJoin(mes.getNickname(), "", "dummyhost", ch));
        }
    }

    private void handleLEAVE(Connection c, SOCLeave mes) {
        D.ebugPrintln("handleLEAVE: " + mes);
        if (c != null) {
            boolean destroyedChannel = false;
            this.channelList.takeMonitorForChannel(mes.getChannel());
            try {
                destroyedChannel = this.leaveChannel(c, mes.getChannel(), false);
            }
            catch (Exception e) {
                D.ebugPrintln("Exception in handleLEAVE - " + e);
            }
            this.channelList.releaseMonitorForChannel(mes.getChannel());
            if (destroyedChannel) {
                this.broadcast(SOCDeleteChannel.toCmd(mes.getChannel()));
            }
        }
    }

    private void handleIMAROBOT(Connection c, SOCImARobot mes) {
        if (c != null) {
            SOCRobotParameters params = null;
            try {
                params = SOCDBHelper.retrieveRobotParams(mes.getNickname());
                D.ebugPrintln("*** Robot Parameters for " + mes.getNickname() + " = " + params);
            }
            catch (SQLException sqle) {
                System.err.println("Error retrieving robot parameters from db: Using defaults.");
            }
            if (params == null) {
                params = new SOCRobotParameters(120, 35, 0.13f, 1.0f, 1.0f, 3.0f, 1.0f, 1, 1);
            }
            c.put(SOCUpdateRobotParams.toCmd(params));
            c.data = mes.getNickname();
            this.robots.addElement(c);
        }
    }

    private void handleJOINGAME(Connection c, SOCJoinGame mes) {
        if (c != null) {
            String gameName;
            SOCGame gameData;
            D.ebugPrintln("handleJOINGAME: " + mes);
            if (c.data == null && !this.checkNickname(mes.getNickname())) {
                c.put(SOCStatusMessage.toCmd("Someone with that nickname is already logged into the system."));
                return;
            }
            if (c.data == null && !this.authenticateUser(c, mes.getNickname(), mes.getPassword())) {
                return;
            }
            if (c != null && c.data == null) {
                c.data = mes.getNickname();
                ++this.numberOfUsers;
            }
            if (this.connectToGame(c, mes.getGame()) && (gameData = this.gameList.getGameData(gameName = mes.getGame())) != null) {
                c.put(SOCJoinGameAuth.toCmd(mes.getGame()));
                c.put(SOCStatusMessage.toCmd("Welcome to Java Settlers of Catan!"));
                for (int i = 0; i < 4; ++i) {
                    SOCPlayer pl = gameData.getPlayer(i);
                    if (pl.getName() != null && !gameData.isSeatVacant(i)) {
                        c.put(SOCSitDown.toCmd(gameName, pl.getName(), i, pl.isRobot()));
                    }
                    this.messageToPlayer(c, new SOCSetSeatLock(gameName, i, gameData.isSeatLocked(i)));
                }
                SOCBoardLayout bl = this.getBoardLayoutMessage(gameData);
                c.put(bl.toCmd());
                for (int i = 0; i < 4; ++i) {
                    SOCPlayer pl = gameData.getPlayer(i);
                    if (pl.getName() == null) continue;
                    Enumeration piecesEnum = pl.getPieces().elements();
                    while (piecesEnum.hasMoreElements()) {
                        SOCPlayingPiece piece = (SOCPlayingPiece)piecesEnum.nextElement();
                        if (piece.getType() == 2) {
                            c.put(SOCPutPiece.toCmd(gameName, i, 1, piece.getCoordinates()));
                        }
                        c.put(SOCPutPiece.toCmd(gameName, i, piece.getType(), piece.getCoordinates()));
                    }
                    Vector<Integer> psList = new Vector<Integer>();
                    for (int j = 35; j <= 220; ++j) {
                        if (!pl.isPotentialSettlement(j)) continue;
                        psList.addElement(new Integer(j));
                    }
                    c.put(SOCPotentialSettlements.toCmd(gameName, i, psList));
                    c.put(SOCLastSettlement.toCmd(gameName, i, pl.getLastSettlementCoord()));
                    c.put(SOCPlayerElement.toCmd(gameName, i, 100, 10, pl.getNumPieces(0)));
                    c.put(SOCPlayerElement.toCmd(gameName, i, 100, 11, pl.getNumPieces(1)));
                    c.put(SOCPlayerElement.toCmd(gameName, i, 100, 12, pl.getNumPieces(2)));
                    c.put(SOCPlayerElement.toCmd(gameName, i, 100, 6, pl.getResources().getTotal()));
                    c.put(SOCPlayerElement.toCmd(gameName, i, 100, 15, pl.getNumKnights()));
                    int numDevCards = pl.getDevCards().getTotal();
                    for (int j = 0; j < numDevCards; ++j) {
                        c.put(SOCDevCard.toCmd(gameName, i, 3, 9));
                    }
                    c.put(SOCFirstPlayer.toCmd(gameName, gameData.getFirstPlayer()));
                    c.put(SOCDevCardCount.toCmd(gameName, gameData.getNumDevCards()));
                    c.put(SOCChangeFace.toCmd(gameName, i, pl.getFaceId()));
                    c.put(SOCDiceResult.toCmd(gameName, gameData.getCurrentDice()));
                }
                SOCPlayer lrPlayer = gameData.getPlayerWithLongestRoad();
                int lrPlayerNum = -1;
                if (lrPlayer != null) {
                    lrPlayerNum = lrPlayer.getPlayerNumber();
                }
                c.put(SOCLongestRoad.toCmd(gameName, lrPlayerNum));
                SOCPlayer laPlayer = gameData.getPlayerWithLargestArmy();
                int laPlayerNum = -1;
                if (laPlayer != null) {
                    laPlayerNum = laPlayer.getPlayerNumber();
                }
                c.put(SOCLargestArmy.toCmd(gameName, laPlayerNum));
                String membersCommand = null;
                this.gameList.takeMonitorForGame(gameName);
                try {
                    Vector gameMembers = this.gameList.getMembers(gameName);
                    membersCommand = SOCGameMembers.toCmd(gameName, gameMembers);
                }
                catch (Exception e) {
                    D.ebugPrintln("Exception in handleJOINGAME (gameMembers) - " + e);
                }
                this.gameList.releaseMonitorForGame(gameName);
                c.put(membersCommand);
                c.put(SOCSetTurn.toCmd(gameName, gameData.getCurrentPlayerNumber()));
                c.put(SOCGameState.toCmd(gameName, gameData.getGameState()));
                D.ebugPrintln("*** " + c.data + " joined the game " + gameName);
                this.messageToGame(mes.getGame(), new SOCJoinGame(mes.getNickname(), "", "dummyhost", mes.getGame()));
            }
        }
    }

    private void handleLEAVEGAME(Connection c, SOCLeaveGame mes) {
        if (c != null) {
            this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
            boolean isMember = false;
            this.gameList.takeMonitorForGame(mes.getGame());
            try {
                isMember = this.gameList.isMember(c, mes.getGame());
            }
            catch (Exception e) {
                D.ebugPrintln("Exception in handleLEAVEGAME (isMember) - " + e);
            }
            this.gameList.releaseMonitorForGame(mes.getGame());
            if (isMember) {
                Vector requests;
                boolean gameDestroyed = false;
                this.gameList.takeMonitorForGame(mes.getGame());
                try {
                    gameDestroyed = this.leaveGame(c, mes.getGame(), false);
                }
                catch (Exception e) {
                    D.ebugPrintln("Exception in handleLEAVEGAME (leaveGame) - " + e);
                }
                this.gameList.releaseMonitorForGame(mes.getGame());
                if (gameDestroyed) {
                    this.broadcast(SOCDeleteGame.toCmd(mes.getGame()));
                }
                if ((requests = (Vector)this.robotDismissRequests.get(mes.getGame())) != null) {
                    Enumeration reqEnum = requests.elements();
                    SOCReplaceRequest req = null;
                    while (reqEnum.hasMoreElements()) {
                        SOCReplaceRequest tempReq = (SOCReplaceRequest)reqEnum.nextElement();
                        if (tempReq.getLeaving() != c) continue;
                        req = tempReq;
                        break;
                    }
                    if (req != null) {
                        requests.removeElement(req);
                        SOCGame ga = this.gameList.getGameData(mes.getGame());
                        this.sitDown(ga, req.getArriving(), req.getSitDownMessage().getPlayerNumber(), req.getSitDownMessage().isRobot());
                    }
                }
            }
        }
    }

    private void handleSITDOWN(Connection c, SOCSitDown mes) {
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(mes.getGame())) != null) {
            boolean canSit = true;
            ga.takeMonitor();
            try {
                if (!ga.isSeatVacant(mes.getPlayerNumber())) {
                    SOCPlayer seatedPlayer = ga.getPlayer(mes.getPlayerNumber());
                    if (seatedPlayer.isRobot() && !ga.isSeatLocked(mes.getPlayerNumber()) && ga.getCurrentPlayerNumber() != mes.getPlayerNumber()) {
                        Connection robotCon = null;
                        Enumeration conEnum = this.conns.elements();
                        while (conEnum.hasMoreElements()) {
                            Connection con = (Connection)conEnum.nextElement();
                            if (!seatedPlayer.getName().equals((String)con.data)) continue;
                            robotCon = con;
                            break;
                        }
                        robotCon.put(SOCRobotDismiss.toCmd(mes.getGame()));
                        Vector<SOCReplaceRequest> disRequests = (Vector<SOCReplaceRequest>)this.robotDismissRequests.get(mes.getGame());
                        SOCReplaceRequest req = new SOCReplaceRequest(c, robotCon, mes);
                        if (disRequests == null) {
                            disRequests = new Vector<SOCReplaceRequest>();
                            disRequests.addElement(req);
                            this.robotDismissRequests.put(mes.getGame(), disRequests);
                        } else {
                            disRequests.addElement(req);
                        }
                    }
                    canSit = false;
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception in handleSITDOWN - " + e);
            }
            ga.releaseMonitor();
            Vector joinRequests = (Vector)this.robotJoinRequests.get(mes.getGame());
            if (joinRequests != null) {
                joinRequests.removeElement(c);
            }
            if (canSit) {
                this.sitDown(ga, c, mes.getPlayerNumber(), mes.isRobot());
            } else if (mes.isRobot()) {
                c.put(SOCRobotDismiss.toCmd(mes.getGame()));
            }
        }
    }

    private void handlePUTPIECE(Connection c, SOCPutPiece mes) {
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(mes.getGame())) != null) {
            ga.takeMonitor();
            try {
                SOCPlayer player = ga.getPlayer((String)c.data);
                if (this.checkTurn(c, ga)) {
                    switch (mes.getPieceType()) {
                        case 0: {
                            SOCRoad rd = new SOCRoad(player, mes.getCoordinates());
                            if (ga.getGameState() == 6 || ga.getGameState() == 11 || ga.getGameState() == 30 || ga.getGameState() == 40 || ga.getGameState() == 41) {
                                if (player.isPotentialRoad(mes.getCoordinates())) {
                                    ga.putPiece(rd);
                                    this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, (String)c.data + " built a road."));
                                    this.messageToGame(ga.getName(), new SOCPutPiece(mes.getGame(), player.getPlayerNumber(), 0, mes.getCoordinates()));
                                    this.broadcastGameStats(ga);
                                    this.sendGameState(ga);
                                    this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                                    if (this.checkTurn(c, ga)) break;
                                    this.sendTurn(ga);
                                    break;
                                }
                                D.ebugPrintln("ILLEGAL ROAD");
                                c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't build a road there."));
                                break;
                            }
                            c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't build a road right now."));
                            break;
                        }
                        case 1: {
                            SOCSettlement se = new SOCSettlement(player, mes.getCoordinates());
                            if (ga.getGameState() == 5 || ga.getGameState() == 10 || ga.getGameState() == 31) {
                                if (player.isPotentialSettlement(mes.getCoordinates())) {
                                    ga.putPiece(se);
                                    this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                                    this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, (String)c.data + " built a settlement."));
                                    this.messageToGame(ga.getName(), new SOCPutPiece(mes.getGame(), player.getPlayerNumber(), 1, mes.getCoordinates()));
                                    this.broadcastGameStats(ga);
                                    this.sendGameState(ga);
                                    if (this.checkTurn(c, ga)) break;
                                    this.sendTurn(ga);
                                    break;
                                }
                                c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't build a settlement there."));
                                break;
                            }
                            c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't build a settlement right now."));
                            break;
                        }
                        case 2: {
                            SOCCity ci = new SOCCity(player, mes.getCoordinates());
                            if (ga.getGameState() == 32) {
                                if (player.isPotentialCity(mes.getCoordinates())) {
                                    ga.putPiece(ci);
                                    this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                                    this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, (String)c.data + " built a city."));
                                    this.messageToGame(ga.getName(), new SOCPutPiece(mes.getGame(), player.getPlayerNumber(), 2, mes.getCoordinates()));
                                    this.broadcastGameStats(ga);
                                    this.sendGameState(ga);
                                    if (this.checkTurn(c, ga)) break;
                                    this.sendTurn(ga);
                                    break;
                                }
                                c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't build a city there."));
                                break;
                            }
                            c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't build a city right now."));
                        }
                    }
                } else {
                    c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "It's not your turn."));
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
        }
    }

    private void handleMOVEROBBER(Connection c, SOCMoveRobber mes) {
        String gn;
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(gn = mes.getGame())) != null) {
            ga.takeMonitor();
            try {
                SOCPlayer player = ga.getPlayer((String)c.data);
                if (ga.canMoveRobber(player.getPlayerNumber(), mes.getCoordinates())) {
                    SOCMoveRobberResult result = ga.moveRobber(player.getPlayerNumber(), mes.getCoordinates());
                    this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                    this.messageToGame(ga.getName(), new SOCMoveRobber(ga.getName(), player.getPlayerNumber(), mes.getCoordinates()));
                    this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, (String)c.data + " moved the robber."));
                    Vector victims = result.getVictims();
                    if (victims.size() == 1) {
                        SOCPlayer victim = (SOCPlayer)victims.firstElement();
                        this.reportRobbery(ga, player, victim, result.getLoot());
                        SOCChoosePlayer robmes = new SOCChoosePlayer(gn, victim.getPlayerNumber());
                        this.recordGameEvent(robmes, robmes.getGame(), robmes.toCmd());
                    }
                    this.sendGameState(ga);
                } else {
                    c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't move the robber."));
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
        }
    }

    private void handleSTARTGAME(Connection c, SOCStartGame mes) {
        String gn;
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(gn = mes.getGame())) != null) {
            ga.takeMonitor();
            try {
                if (ga.getGameState() == 0) {
                    Vector<Connection> requests = new Vector<Connection>();
                    boolean seatsFull = true;
                    for (int i = 0; i < 4; ++i) {
                        if (!ga.isSeatVacant(i)) continue;
                        seatsFull = false;
                        break;
                    }
                    if (!seatsFull) {
                        if (this.robots.isEmpty()) {
                            this.messageToGame(gn, new SOCGameTextMsg(gn, SERVERNAME, "No robots on this server, please fill all seats before starting."));
                        } else {
                            int numEmpty = 0;
                            for (int i = 0; i < 4; ++i) {
                                if (!ga.isSeatVacant(i)) continue;
                                ++numEmpty;
                            }
                            if (numEmpty > this.robots.size()) {
                                String m = "Sorry, not enough robots to fill all the seats.  Only " + this.robots.size() + " robots are available.";
                                this.messageToGame(gn, new SOCGameTextMsg(gn, SERVERNAME, m));
                            } else {
                                int i;
                                ga.setGameState(1);
                                int[] robotIndexes = new int[this.robots.size()];
                                for (int i2 = 0; i2 < this.robots.size(); ++i2) {
                                    robotIndexes[i2] = i2;
                                }
                                for (int j = 0; j < 3; ++j) {
                                    for (i = 0; i < robotIndexes.length; ++i) {
                                        int idx = Math.abs(this.rand.nextInt() % (robotIndexes.length - i));
                                        int tmp = robotIndexes[idx];
                                        robotIndexes[idx] = robotIndexes[i];
                                        robotIndexes[i] = tmp;
                                    }
                                }
                                int idx = 0;
                                for (i = 0; i < 4; ++i) {
                                    if (!ga.isSeatVacant(i) || idx >= this.robots.size()) continue;
                                    this.messageToGame(gn, new SOCGameTextMsg(gn, SERVERNAME, "Fetching a robot player..."));
                                    Connection robotConn = (Connection)this.robots.get(robotIndexes[idx]);
                                    ++idx;
                                    if (robotConn.put(SOCJoinGameRequest.toCmd(gn, i))) {
                                        D.ebugPrintln("@@@ JOIN GAME REQUEST for " + (String)robotConn.data);
                                        requests.addElement(robotConn);
                                        continue;
                                    }
                                    this.messageToGame(gn, new SOCGameTextMsg(gn, SERVERNAME, "*** Error on robot request! ***"));
                                }
                            }
                        }
                    }
                    if (seatsFull) {
                        this.startGame(ga);
                    } else if (!requests.isEmpty()) {
                        this.robotJoinRequests.put(gn, requests);
                    }
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
        }
    }

    private void handleROLLDICE(Connection c, SOCRollDice mes) {
        String gn;
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(gn = mes.getGame())) != null) {
            block21: {
                ga.takeMonitor();
                try {
                    if (ga.canRollDice(ga.getPlayer((String)c.data).getPlayerNumber())) {
                        IntPair dice = ga.rollDice();
                        this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                        this.messageToGame(gn, new SOCGameTextMsg(gn, SERVERNAME, (String)c.data + " rolled a " + dice.getA() + " and a " + dice.getB() + "."));
                        this.messageToGame(gn, new SOCDiceResult(gn, ga.getCurrentDice()));
                        if (ga.getCurrentDice() != 7) {
                            for (int i = 0; i < 4; ++i) {
                                SOCResourceSet rsrcs = ga.getResourcesGainedFromRoll(ga.getPlayer(i), ga.getCurrentDice());
                                if (rsrcs.getTotal() == 0) {
                                    this.messageToGame(gn, new SOCGameTextMsg(gn, SERVERNAME, ga.getPlayer(i).getName() + " got nothing."));
                                } else {
                                    String message = ga.getPlayer(i).getName() + " got ";
                                    int cl = rsrcs.getAmount(1);
                                    int or = rsrcs.getAmount(2);
                                    int sh = rsrcs.getAmount(3);
                                    int wh = rsrcs.getAmount(4);
                                    int wo = rsrcs.getAmount(5);
                                    if (cl > 0) {
                                        this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), i, 101, 1, cl));
                                        message = message + cl + " clay";
                                        if (or + sh + wh + wo > 0) {
                                            message = message + ", ";
                                        }
                                    }
                                    if (or > 0) {
                                        this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), i, 101, 2, or));
                                        message = message + or + " ore";
                                        if (sh + wh + wo > 0) {
                                            message = message + ", ";
                                        }
                                    }
                                    if (sh > 0) {
                                        this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), i, 101, 3, sh));
                                        message = message + sh + " sheep";
                                        if (wh + wo > 0) {
                                            message = message + ", ";
                                        }
                                    }
                                    if (wh > 0) {
                                        this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), i, 101, 4, wh));
                                        message = message + wh + " wheat";
                                        if (wo > 0) {
                                            message = message + ", ";
                                        }
                                    }
                                    if (wo > 0) {
                                        this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), i, 101, 5, wo));
                                        message = message + wo + " wood";
                                    }
                                    message = message + ".";
                                    this.messageToGame(gn, new SOCGameTextMsg(gn, SERVERNAME, message));
                                }
                                Connection playerCon = null;
                                Enumeration conEnum = this.conns.elements();
                                while (conEnum.hasMoreElements()) {
                                    Connection con = (Connection)conEnum.nextElement();
                                    if (!ga.getPlayer(i).getName().equals((String)con.data)) continue;
                                    playerCon = con;
                                    break;
                                }
                                if (playerCon == null) continue;
                                SOCResourceSet resources = ga.getPlayer(i).getResources();
                                this.messageToPlayer(playerCon, new SOCPlayerElement(ga.getName(), i, 100, 1, resources.getAmount(1)));
                                this.messageToPlayer(playerCon, new SOCPlayerElement(ga.getName(), i, 100, 2, resources.getAmount(2)));
                                this.messageToPlayer(playerCon, new SOCPlayerElement(ga.getName(), i, 100, 3, resources.getAmount(3)));
                                this.messageToPlayer(playerCon, new SOCPlayerElement(ga.getName(), i, 100, 4, resources.getAmount(4)));
                                this.messageToPlayer(playerCon, new SOCPlayerElement(ga.getName(), i, 100, 5, resources.getAmount(5)));
                                this.messageToGame(ga.getName(), new SOCResourceCount(ga.getName(), i, resources.getTotal()));
                            }
                        } else {
                            block4: for (int i = 0; i < 4; ++i) {
                                if (ga.getPlayer(i).getResources().getTotal() <= 7) continue;
                                Enumeration coEnum = this.getConnections();
                                while (coEnum.hasMoreElements()) {
                                    Connection con = (Connection)coEnum.nextElement();
                                    if (!ga.getPlayer(i).getName().equals((String)con.data)) continue;
                                    con.put(SOCDiscardRequest.toCmd(ga.getName(), ga.getPlayer(i).getResources().getTotal() / 2));
                                    continue block4;
                                }
                            }
                        }
                        this.sendGameState(ga);
                        break block21;
                    }
                    c.put(SOCGameTextMsg.toCmd(gn, SERVERNAME, "You can't roll right now."));
                }
                catch (Exception e) {
                    D.ebugPrintln("Exception in handleROLLDICE - " + e);
                }
            }
            ga.releaseMonitor();
        }
    }

    private void handleDISCARD(Connection c, SOCDiscard mes) {
        String gn;
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(gn = mes.getGame())) != null) {
            ga.takeMonitor();
            try {
                SOCPlayer player = ga.getPlayer((String)c.data);
                if (ga.canDiscard(player.getPlayerNumber(), mes.getResources())) {
                    ga.discard(player.getPlayerNumber(), mes.getResources());
                    this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                    int cl = mes.getResources().getAmount(1);
                    int or = mes.getResources().getAmount(2);
                    int sh = mes.getResources().getAmount(3);
                    int wh = mes.getResources().getAmount(4);
                    int wo = mes.getResources().getAmount(5);
                    if (cl > 0) {
                        this.messageToPlayer(c, new SOCPlayerElement(gn, player.getPlayerNumber(), 102, 1, cl));
                    }
                    if (or > 0) {
                        this.messageToPlayer(c, new SOCPlayerElement(gn, player.getPlayerNumber(), 102, 2, or));
                    }
                    if (sh > 0) {
                        this.messageToPlayer(c, new SOCPlayerElement(gn, player.getPlayerNumber(), 102, 3, sh));
                    }
                    if (wh > 0) {
                        this.messageToPlayer(c, new SOCPlayerElement(gn, player.getPlayerNumber(), 102, 4, wh));
                    }
                    if (wo > 0) {
                        this.messageToPlayer(c, new SOCPlayerElement(gn, player.getPlayerNumber(), 102, 5, wo));
                    }
                    Vector<Connection> exceptions = new Vector<Connection>(1);
                    exceptions.addElement(c);
                    this.messageToGameExcept(gn, exceptions, new SOCPlayerElement(gn, player.getPlayerNumber(), 102, 6, mes.getResources().getTotal()));
                    this.messageToGame(gn, new SOCGameTextMsg(ga.getName(), SERVERNAME, (String)c.data + " discarded " + mes.getResources().getTotal() + " resources."));
                    this.sendGameState(ga);
                } else {
                    c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't discard that many cards."));
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
        }
    }

    private void handleENDTURN(Connection c, SOCEndTurn mes) {
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(mes.getGame())) != null) {
            ga.takeMonitor();
            try {
                if (this.checkTurn(c, ga)) {
                    if (ga.canEndTurn(ga.getPlayer((String)c.data).getPlayerNumber())) {
                        ga.endTurn();
                        this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                        this.sendGameState(ga);
                        for (int i = 0; i < 4; ++i) {
                            this.messageToGame(ga.getName(), new SOCClearOffer(ga.getName(), i));
                        }
                        this.sendTurn(ga);
                    } else {
                        c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't end your turn yet."));
                    }
                } else {
                    c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "It's not your turn."));
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
        }
    }

    private void handleCHOOSEPLAYER(Connection c, SOCChoosePlayer mes) {
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(mes.getGame())) != null) {
            ga.takeMonitor();
            try {
                if (this.checkTurn(c, ga)) {
                    if (ga.canChoosePlayer(mes.getChoice())) {
                        int rsrc = ga.stealFromPlayer(mes.getChoice());
                        this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                        this.reportRobbery(ga, ga.getPlayer((String)c.data), ga.getPlayer(mes.getChoice()), rsrc);
                        this.sendGameState(ga);
                    } else {
                        c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't steal from that player."));
                    }
                } else {
                    c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "It's not your turn."));
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
        }
    }

    private void handleMAKEOFFER(Connection c, SOCMakeOffer mes) {
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(mes.getGame())) != null) {
            ga.takeMonitor();
            try {
                SOCTradeOffer offer = mes.getOffer();
                SOCPlayer player = ga.getPlayer((String)c.data);
                if (player != null) {
                    SOCTradeOffer remadeOffer = new SOCTradeOffer(ga.getName(), player.getPlayerNumber(), offer.getTo(), offer.getGiveSet(), offer.getGetSet());
                    player.setCurrentOffer(remadeOffer);
                    this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, (String)c.data + " made an offer to trade."));
                    SOCMakeOffer makeOfferMessage = new SOCMakeOffer(ga.getName(), remadeOffer);
                    this.messageToGame(ga.getName(), makeOfferMessage);
                    this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                    for (int i = 0; i < 4; ++i) {
                        this.messageToGame(ga.getName(), new SOCClearTradeMsg(ga.getName(), i));
                    }
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
        }
    }

    private void handleCLEAROFFER(Connection c, SOCClearOffer mes) {
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(mes.getGame())) != null) {
            ga.takeMonitor();
            try {
                ga.getPlayer((String)c.data).setCurrentOffer(null);
                this.messageToGame(ga.getName(), new SOCClearOffer(ga.getName(), ga.getPlayer((String)c.data).getPlayerNumber()));
                this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                for (int i = 0; i < 4; ++i) {
                    this.messageToGame(ga.getName(), new SOCClearTradeMsg(ga.getName(), i));
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
        }
    }

    private void handleREJECTOFFER(Connection c, SOCRejectOffer mes) {
        SOCPlayer player;
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(mes.getGame())) != null && (player = ga.getPlayer((String)c.data)) != null) {
            SOCRejectOffer rejectMessage = new SOCRejectOffer(ga.getName(), player.getPlayerNumber());
            this.messageToGame(ga.getName(), rejectMessage);
            this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
        }
    }

    private void handleACCEPTOFFER(Connection c, SOCAcceptOffer mes) {
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(mes.getGame())) != null) {
            ga.takeMonitor();
            try {
                SOCPlayer player = ga.getPlayer((String)c.data);
                if (player != null) {
                    int acceptingNumber = player.getPlayerNumber();
                    if (ga.canMakeTrade(mes.getOfferingNumber(), acceptingNumber)) {
                        ga.makeTrade(mes.getOfferingNumber(), acceptingNumber);
                        this.reportTrade(ga, mes.getOfferingNumber(), acceptingNumber);
                        this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                        for (int i = 0; i < 4; ++i) {
                            ga.getPlayer(i).setCurrentOffer(null);
                            this.messageToGame(ga.getName(), new SOCClearOffer(ga.getName(), i));
                        }
                        this.messageToGame(ga.getName(), mes);
                    } else {
                        c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't make that trade."));
                    }
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
        }
    }

    private void handleBANKTRADE(Connection c, SOCBankTrade mes) {
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(mes.getGame())) != null) {
            ga.takeMonitor();
            try {
                if (this.checkTurn(c, ga)) {
                    if (ga.canMakeBankTrade(mes.getGiveSet(), mes.getGetSet())) {
                        ga.makeBankTrade(mes.getGiveSet(), mes.getGetSet());
                        this.reportBankTrade(ga, mes.getGiveSet(), mes.getGetSet());
                        this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                    } else {
                        c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't make that trade."));
                    }
                } else {
                    c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "It's not your turn."));
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
        }
    }

    private void handleBUILDREQUEST(Connection c, SOCBuildRequest mes) {
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(mes.getGame())) != null) {
            ga.takeMonitor();
            try {
                if (this.checkTurn(c, ga)) {
                    if (ga.getGameState() == 20) {
                        SOCPlayer player = ga.getPlayer((String)c.data);
                        switch (mes.getPieceType()) {
                            case 0: {
                                if (ga.couldBuildRoad(player.getPlayerNumber())) {
                                    ga.buyRoad(player.getPlayerNumber());
                                    this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 102, 1, 1));
                                    this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 102, 5, 1));
                                    this.sendGameState(ga);
                                    break;
                                }
                                c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't build a road."));
                                break;
                            }
                            case 1: {
                                if (ga.couldBuildSettlement(player.getPlayerNumber())) {
                                    ga.buySettlement(player.getPlayerNumber());
                                    this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 102, 1, 1));
                                    this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 102, 3, 1));
                                    this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 102, 4, 1));
                                    this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 102, 5, 1));
                                    this.sendGameState(ga);
                                    break;
                                }
                                c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't build a settlement."));
                                break;
                            }
                            case 2: {
                                if (ga.couldBuildCity(player.getPlayerNumber())) {
                                    ga.buyCity(player.getPlayerNumber());
                                    this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 102, 2, 3));
                                    this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 102, 4, 2));
                                    this.sendGameState(ga);
                                    break;
                                }
                                c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't build a city."));
                            }
                        }
                    } else {
                        c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't build now."));
                    }
                } else {
                    c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "It's not your turn."));
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
        }
    }

    private void handleCANCELBUILDREQUEST(Connection c, SOCCancelBuildRequest mes) {
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(mes.getGame())) != null) {
            ga.takeMonitor();
            try {
                if (this.checkTurn(c, ga)) {
                    SOCPlayer player = ga.getPlayer((String)c.data);
                    switch (mes.getPieceType()) {
                        case 0: {
                            if (ga.getGameState() == 30) {
                                ga.cancelBuildRoad(player.getPlayerNumber());
                                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 101, 1, 1));
                                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 101, 5, 1));
                                this.sendGameState(ga);
                                break;
                            }
                            c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You didn't buy a road."));
                            break;
                        }
                        case 1: {
                            if (ga.getGameState() == 31) {
                                ga.cancelBuildSettlement(player.getPlayerNumber());
                                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 101, 1, 1));
                                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 101, 3, 1));
                                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 101, 4, 1));
                                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 101, 5, 1));
                                this.sendGameState(ga);
                                break;
                            }
                            c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You didn't buy a settlement."));
                            break;
                        }
                        case 2: {
                            if (ga.getGameState() == 32) {
                                ga.cancelBuildCity(player.getPlayerNumber());
                                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 101, 2, 3));
                                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 101, 4, 2));
                                this.sendGameState(ga);
                                break;
                            }
                            c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You didn't buy a city."));
                        }
                    }
                } else {
                    c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "It's not your turn."));
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
        }
    }

    private void handleBUYCARDREQUEST(Connection c, SOCBuyCardRequest mes) {
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(mes.getGame())) != null) {
            ga.takeMonitor();
            try {
                if (this.checkTurn(c, ga)) {
                    SOCPlayer player = ga.getPlayer((String)c.data);
                    if (ga.getGameState() == 20 && ga.couldBuyDevCard(player.getPlayerNumber())) {
                        int card = ga.buyDevCard();
                        this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                        this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 102, 2, 1));
                        this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 102, 3, 1));
                        this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 102, 4, 1));
                        this.messageToGame(ga.getName(), new SOCDevCardCount(ga.getName(), ga.getNumDevCards()));
                        this.messageToPlayer(c, new SOCDevCard(ga.getName(), player.getPlayerNumber(), 0, card));
                        Vector<Connection> ex = new Vector<Connection>(1);
                        ex.addElement(c);
                        this.messageToGameExcept(ga.getName(), ex, new SOCDevCard(ga.getName(), player.getPlayerNumber(), 0, 9));
                        this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, (String)c.data + " bought a development card."));
                        if (ga.getNumDevCards() > 1) {
                            this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, "There are " + ga.getNumDevCards() + " cards left."));
                        } else if (ga.getNumDevCards() == 1) {
                            this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, "There is 1 card left."));
                        } else {
                            this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, "There are no more Development cards."));
                        }
                        this.sendGameState(ga);
                    } else if (ga.getNumDevCards() == 0) {
                        c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "There are no more Development cards."));
                    } else {
                        c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't buy a development card now."));
                    }
                } else {
                    c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "It's not your turn."));
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
        }
    }

    private void handlePLAYDEVCARDREQUEST(Connection c, SOCPlayDevCardRequest mes) {
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(mes.getGame())) != null) {
            ga.takeMonitor();
            try {
                if (this.checkTurn(c, ga)) {
                    SOCPlayer player = ga.getPlayer((String)c.data);
                    switch (mes.getDevCard()) {
                        case 0: {
                            if (ga.canPlayKnight(player.getPlayerNumber())) {
                                ga.playKnight();
                                this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                                this.messageToGame(ga.getName(), new SOCDevCard(ga.getName(), player.getPlayerNumber(), 1, 0));
                                this.messageToGame(ga.getName(), new SOCSetPlayedDevCard(ga.getName(), player.getPlayerNumber(), true));
                                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 101, 15, 1));
                                this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, player.getName() + " played a Knight card."));
                                this.broadcastGameStats(ga);
                                this.sendGameState(ga);
                                break;
                            }
                            c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't play a Knight card now."));
                            break;
                        }
                        case 1: {
                            if (ga.canPlayRoadBuilding(player.getPlayerNumber())) {
                                ga.playRoadBuilding();
                                this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                                this.messageToGame(ga.getName(), new SOCDevCard(ga.getName(), player.getPlayerNumber(), 1, 1));
                                this.messageToGame(ga.getName(), new SOCSetPlayedDevCard(ga.getName(), player.getPlayerNumber(), true));
                                this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, player.getName() + " played a Road Building card."));
                                this.sendGameState(ga);
                                break;
                            }
                            c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't play a Road Building card now."));
                            break;
                        }
                        case 2: {
                            if (ga.canPlayDiscovery(player.getPlayerNumber())) {
                                ga.playDiscovery();
                                this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                                this.messageToGame(ga.getName(), new SOCDevCard(ga.getName(), player.getPlayerNumber(), 1, 2));
                                this.messageToGame(ga.getName(), new SOCSetPlayedDevCard(ga.getName(), player.getPlayerNumber(), true));
                                this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, player.getName() + " played a Discovery card."));
                                this.sendGameState(ga);
                                break;
                            }
                            c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't play a Discovery card now."));
                            break;
                        }
                        case 3: {
                            if (ga.canPlayMonopoly(player.getPlayerNumber())) {
                                ga.playMonopoly();
                                this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                                this.messageToGame(ga.getName(), new SOCDevCard(ga.getName(), player.getPlayerNumber(), 1, 3));
                                this.messageToGame(ga.getName(), new SOCSetPlayedDevCard(ga.getName(), player.getPlayerNumber(), true));
                                this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, player.getName() + " played a Monopoly card."));
                                this.sendGameState(ga);
                                break;
                            }
                            c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't play a Monopoly card now."));
                        }
                    }
                } else {
                    c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "It's not your turn."));
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
        }
    }

    private void handleDISCOVERYPICK(Connection c, SOCDiscoveryPick mes) {
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(mes.getGame())) != null) {
            ga.takeMonitor();
            try {
                if (this.checkTurn(c, ga)) {
                    SOCPlayer player = ga.getPlayer((String)c.data);
                    if (ga.canDoDiscoveryAction(mes.getResources())) {
                        ga.doDiscoveryAction(mes.getResources());
                        this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                        String message = (String)c.data + " received ";
                        int cl = mes.getResources().getAmount(1);
                        int or = mes.getResources().getAmount(2);
                        int sh = mes.getResources().getAmount(3);
                        int wh = mes.getResources().getAmount(4);
                        int wo = mes.getResources().getAmount(5);
                        if (cl > 0) {
                            this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 101, 1, cl));
                            message = message + cl + " clay";
                            if (or + sh + wh + wo > 0) {
                                message = message + " and ";
                            }
                        }
                        if (or > 0) {
                            this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 101, 2, or));
                            message = message + or + " ore";
                            if (sh + wh + wo > 0) {
                                message = message + " and ";
                            }
                        }
                        if (sh > 0) {
                            this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 101, 3, sh));
                            message = message + sh + " sheep";
                            if (wh + wo > 0) {
                                message = message + " and ";
                            }
                        }
                        if (wh > 0) {
                            this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 101, 4, wh));
                            message = message + wh + " wheat";
                            if (wo > 0) {
                                message = message + " and ";
                            }
                        }
                        if (wo > 0) {
                            this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), player.getPlayerNumber(), 101, 5, wo));
                            message = message + wo + " wood";
                        }
                        message = message + " from the bank.";
                        this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, message));
                        this.sendGameState(ga);
                    } else {
                        c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "That is not a legal Discovery pick."));
                    }
                } else {
                    c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "It's not your turn."));
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
        }
    }

    private void handleMONOPOLYPICK(Connection c, SOCMonopolyPick mes) {
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(mes.getGame())) != null) {
            ga.takeMonitor();
            try {
                if (this.checkTurn(c, ga)) {
                    if (ga.canDoMonopolyAction()) {
                        ga.doMonopolyAction(mes.getResource());
                        this.recordGameEvent(mes, mes.getGame(), mes.toCmd());
                        String message = (String)c.data + " monopolized ";
                        switch (mes.getResource()) {
                            case 1: {
                                message = message + "clay.";
                                break;
                            }
                            case 2: {
                                message = message + "ore.";
                                break;
                            }
                            case 3: {
                                message = message + "sheep.";
                                break;
                            }
                            case 4: {
                                message = message + "wheat.";
                                break;
                            }
                            case 5: {
                                message = message + "wood.";
                            }
                        }
                        this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, message));
                        for (int i = 0; i < 4; ++i) {
                            this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), i, 100, mes.getResource(), ga.getPlayer(i).getResources().getAmount(mes.getResource())));
                        }
                        this.sendGameState(ga);
                    } else {
                        c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "You can't do a Monopoly pick now."));
                    }
                } else {
                    c.put(SOCGameTextMsg.toCmd(ga.getName(), SERVERNAME, "It's not your turn."));
                }
            }
            catch (Exception e) {
                D.ebugPrintln("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
        }
    }

    private void handleCHANGEFACE(Connection c, SOCChangeFace mes) {
        SOCPlayer player;
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(mes.getGame())) != null && (player = ga.getPlayer((String)c.data)) != null) {
            player.setFaceId(mes.getFaceId());
            this.messageToGame(mes.getGame(), new SOCChangeFace(mes.getGame(), player.getPlayerNumber(), mes.getFaceId()));
        }
    }

    private void handleSETSEATLOCK(Connection c, SOCSetSeatLock mes) {
        SOCPlayer player;
        SOCGame ga;
        if (c != null && (ga = this.gameList.getGameData(mes.getGame())) != null && (player = ga.getPlayer((String)c.data)) != null) {
            if (mes.getLockState()) {
                ga.lockSeat(mes.getPlayerNumber());
            } else {
                ga.unlockSeat(mes.getPlayerNumber());
            }
            this.messageToGame(mes.getGame(), mes);
        }
    }

    private void handleCREATEACCOUNT(Connection c, SOCCreateAccount mes) {
        String userPassword = null;
        try {
            userPassword = SOCDBHelper.getUserPassword(mes.getNickname());
        }
        catch (SQLException sqle) {
            c.put(SOCStatusMessage.toCmd("Problem connecting to database, please try again later."));
            return;
        }
        if (userPassword != null) {
            c.put(SOCStatusMessage.toCmd("The nickname '" + mes.getNickname() + "' is already in use."));
            return;
        }
        Date currentTime = new Date();
        boolean success = false;
        try {
            success = SOCDBHelper.createAccount(mes.getNickname(), c.host(), mes.getPassword(), mes.getEmail(), currentTime.getTime());
        }
        catch (SQLException sqle) {
            System.err.println("Error creating account in db.");
        }
        if (success) {
            c.put(SOCStatusMessage.toCmd("Account created for '" + mes.getNickname() + "'."));
        } else {
            c.put(SOCStatusMessage.toCmd("Account not created due to error."));
        }
    }

    private void sitDown(SOCGame ga, Connection c, int pn, boolean robot) {
        if (c != null && ga != null) {
            ga.takeMonitor();
            try {
                int i;
                ga.addPlayer((String)c.data, pn);
                ga.getPlayer(pn).setRobotFlag(robot);
                SOCSitDown sitMessage = new SOCSitDown(ga.getName(), (String)c.data, pn, robot);
                this.messageToGame(ga.getName(), sitMessage);
                D.ebugPrintln("*** sent SOCSitDown message to game ***");
                Vector requests = (Vector)this.robotJoinRequests.get(ga.getName());
                if (requests != null) {
                    if (requests.isEmpty() && ga.getGameState() < 5) {
                        this.startGame(ga);
                    }
                    if (requests.isEmpty()) {
                        this.robotJoinRequests.remove(ga.getName());
                    }
                }
                this.broadcastGameStats(ga);
                SOCResourceSet resources = ga.getPlayer(pn).getResources();
                this.messageToPlayer(c, new SOCPlayerElement(ga.getName(), pn, 100, 1, resources.getAmount(1)));
                this.messageToPlayer(c, new SOCPlayerElement(ga.getName(), pn, 100, 2, resources.getAmount(2)));
                this.messageToPlayer(c, new SOCPlayerElement(ga.getName(), pn, 100, 3, resources.getAmount(3)));
                this.messageToPlayer(c, new SOCPlayerElement(ga.getName(), pn, 100, 4, resources.getAmount(4)));
                this.messageToPlayer(c, new SOCPlayerElement(ga.getName(), pn, 100, 5, resources.getAmount(5)));
                this.messageToPlayer(c, new SOCPlayerElement(ga.getName(), pn, 100, 6, resources.getAmount(6)));
                SOCDevCardSet devCards = ga.getPlayer(pn).getDevCards();
                for (i = 0; i < devCards.getTotal(); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 1, 9));
                }
                for (i = 0; i < devCards.getAmount(1, 0); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 2, 0));
                }
                for (i = 0; i < devCards.getAmount(1, 1); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 2, 1));
                }
                for (i = 0; i < devCards.getAmount(1, 2); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 2, 2));
                }
                for (i = 0; i < devCards.getAmount(1, 3); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 2, 3));
                }
                for (i = 0; i < devCards.getAmount(1, 4); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 2, 4));
                }
                for (i = 0; i < devCards.getAmount(1, 5); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 2, 5));
                }
                for (i = 0; i < devCards.getAmount(1, 6); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 2, 6));
                }
                for (i = 0; i < devCards.getAmount(1, 7); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 2, 7));
                }
                for (i = 0; i < devCards.getAmount(1, 8); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 2, 8));
                }
                for (i = 0; i < devCards.getAmount(0, 0); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 3, 0));
                }
                for (i = 0; i < devCards.getAmount(0, 1); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 3, 1));
                }
                for (i = 0; i < devCards.getAmount(0, 2); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 3, 2));
                }
                for (i = 0; i < devCards.getAmount(0, 3); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 3, 3));
                }
                for (i = 0; i < devCards.getAmount(0, 4); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 3, 4));
                }
                for (i = 0; i < devCards.getAmount(0, 5); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 3, 5));
                }
                for (i = 0; i < devCards.getAmount(0, 6); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 3, 6));
                }
                for (i = 0; i < devCards.getAmount(0, 7); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 3, 7));
                }
                for (i = 0; i < devCards.getAmount(0, 8); ++i) {
                    this.messageToPlayer(c, new SOCDevCard(ga.getName(), pn, 3, 8));
                }
                this.sendGameState(ga);
                if (ga.getCurrentDice() == 7 && ga.getPlayer(pn).getResources().getTotal() > 7) {
                    this.messageToPlayer(c, new SOCDiscardRequest(ga.getName(), ga.getPlayer(pn).getResources().getTotal() / 2));
                }
                this.messageToGame(ga.getName(), new SOCChangeFace(ga.getName(), pn, ga.getPlayer(pn).getFaceId()));
            }
            catch (Exception e) {
                D.ebugPrintln("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
        }
    }

    protected void reportRobbery(SOCGame ga, SOCPlayer pe, SOCPlayer vi, int rsrc) {
        if (ga != null) {
            String mes1 = "You stole ";
            String mes2 = pe.getName() + " stole ";
            SOCPlayerElement gainRsrc = null;
            SOCPlayerElement loseRsrc = null;
            switch (rsrc) {
                case 1: {
                    mes1 = mes1 + "a clay ";
                    mes2 = mes2 + "a clay ";
                    gainRsrc = new SOCPlayerElement(ga.getName(), pe.getPlayerNumber(), 101, 1, 1);
                    loseRsrc = new SOCPlayerElement(ga.getName(), vi.getPlayerNumber(), 102, 1, 1);
                    break;
                }
                case 2: {
                    mes1 = mes1 + "an ore ";
                    mes2 = mes2 + "an ore ";
                    gainRsrc = new SOCPlayerElement(ga.getName(), pe.getPlayerNumber(), 101, 2, 1);
                    loseRsrc = new SOCPlayerElement(ga.getName(), vi.getPlayerNumber(), 102, 2, 1);
                    break;
                }
                case 3: {
                    mes1 = mes1 + "a sheep ";
                    mes2 = mes2 + "a sheep ";
                    gainRsrc = new SOCPlayerElement(ga.getName(), pe.getPlayerNumber(), 101, 3, 1);
                    loseRsrc = new SOCPlayerElement(ga.getName(), vi.getPlayerNumber(), 102, 3, 1);
                    break;
                }
                case 4: {
                    mes1 = mes1 + "a wheat ";
                    mes2 = mes2 + "a wheat ";
                    gainRsrc = new SOCPlayerElement(ga.getName(), pe.getPlayerNumber(), 101, 4, 1);
                    loseRsrc = new SOCPlayerElement(ga.getName(), vi.getPlayerNumber(), 102, 4, 1);
                    break;
                }
                case 5: {
                    mes1 = mes1 + "a wood ";
                    mes2 = mes2 + "a wood ";
                    gainRsrc = new SOCPlayerElement(ga.getName(), pe.getPlayerNumber(), 101, 5, 1);
                    loseRsrc = new SOCPlayerElement(ga.getName(), vi.getPlayerNumber(), 102, 5, 1);
                }
            }
            mes1 = mes1 + "resource from " + vi.getName() + ".";
            mes2 = mes2 + "resource from you.";
            Connection peCon = null;
            Connection viCon = null;
            Enumeration conEnum = this.conns.elements();
            while (conEnum.hasMoreElements()) {
                Connection con = (Connection)conEnum.nextElement();
                if (pe.getName().equals((String)con.data)) {
                    peCon = con;
                    continue;
                }
                if (!vi.getName().equals((String)con.data)) continue;
                viCon = con;
            }
            Vector<Connection> exceptions = new Vector<Connection>(2);
            exceptions.addElement(peCon);
            exceptions.addElement(viCon);
            this.messageToPlayer(peCon, gainRsrc);
            this.messageToPlayer(peCon, loseRsrc);
            this.messageToPlayer(viCon, gainRsrc);
            this.messageToPlayer(viCon, loseRsrc);
            SOCPlayerElement gainUnknown = new SOCPlayerElement(ga.getName(), pe.getPlayerNumber(), 101, 6, 1);
            SOCPlayerElement loseUnknown = new SOCPlayerElement(ga.getName(), vi.getPlayerNumber(), 102, 6, 1);
            this.messageToGameExcept(ga.getName(), exceptions, gainUnknown);
            this.messageToGameExcept(ga.getName(), exceptions, loseUnknown);
            this.messageToPlayer(peCon, new SOCGameTextMsg(ga.getName(), SERVERNAME, mes1));
            this.messageToPlayer(viCon, new SOCGameTextMsg(ga.getName(), SERVERNAME, mes2));
            this.messageToGameExcept(ga.getName(), exceptions, new SOCGameTextMsg(ga.getName(), SERVERNAME, pe.getName() + " stole a resource from " + vi.getName()));
        }
    }

    protected void sendGameState(SOCGame ga) throws InterruptedException {
        if (ga != null) {
            this.messageToGame(ga.getName(), new SOCGameState(ga.getName(), ga.getGameState()));
            SOCPlayer player = null;
            if (ga.getCurrentPlayerNumber() != -1) {
                player = ga.getPlayer(ga.getCurrentPlayerNumber());
            }
            block0 : switch (ga.getGameState()) {
                case 5: 
                case 10: {
                    this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, "It's " + player.getName() + "'s turn to build a settlement."));
                    break;
                }
                case 6: 
                case 11: {
                    this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, "It's " + player.getName() + "'s turn to build a road."));
                    break;
                }
                case 15: {
                    this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, "It's " + player.getName() + "'s turn to roll the dice."));
                    break;
                }
                case 50: {
                    int i;
                    int count = 0;
                    String message = "error at sendGameState()";
                    String[] names = new String[4];
                    for (i = 0; i < 4; ++i) {
                        if (!ga.getPlayer(i).getNeedToDiscard()) continue;
                        names[count] = ga.getPlayer(i).getName();
                        ++count;
                    }
                    if (count == 1) {
                        message = names[0] + " needs to discard.";
                    } else if (count == 2) {
                        message = names[0] + " and " + names[1] + " need to discard.";
                    } else if (count > 2) {
                        message = names[0];
                        for (i = 1; i < count - 1; ++i) {
                            message = message + ", " + names[i];
                        }
                        message = message + " and " + names[count - 1] + " need to discard.";
                    }
                    this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, message));
                    break;
                }
                case 33: {
                    this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, player.getName() + " will move the robber."));
                    break;
                }
                case 51: {
                    boolean[] choices = new boolean[4];
                    for (int i = 0; i < 4; ++i) {
                        choices[i] = false;
                    }
                    Enumeration plEnum = ga.getPossibleVictims().elements();
                    while (plEnum.hasMoreElements()) {
                        SOCPlayer pl = (SOCPlayer)plEnum.nextElement();
                        choices[pl.getPlayerNumber()] = true;
                    }
                    String n = ga.getPlayer(ga.getCurrentPlayerNumber()).getName();
                    Enumeration connsEnum = this.getConnections();
                    while (connsEnum.hasMoreElements()) {
                        Connection con = (Connection)connsEnum.nextElement();
                        if (!n.equals((String)con.data)) continue;
                        con.put(SOCChoosePlayerRequest.toCmd(ga.getName(), choices));
                        break block0;
                    }
                    break;
                }
                case 1000: {
                    for (int i = 0; i < 4; ++i) {
                        SOCPlayer pl = ga.getPlayer(i);
                        if (pl.getTotalVP() < 10) continue;
                        String msg = pl.getName() + " has won the game with " + pl.getTotalVP() + " points.";
                        this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, msg));
                        SOCDevCardSet devCards = pl.getDevCards();
                        if (devCards.getNumVPCards() <= 0) break;
                        msg = pl.getName() + " has";
                        int vpCardCount = 0;
                        block22: for (int devCardType = 4; devCardType < 9; ++devCardType) {
                            if (devCards.getAmount(0, devCardType) <= 0 && devCards.getAmount(1, devCardType) <= 0) continue;
                            if (vpCardCount > 0) {
                                if (devCards.getNumVPCards() - vpCardCount == 1) {
                                    msg = msg + " and";
                                } else if (devCards.getNumVPCards() - vpCardCount > 0) {
                                    msg = msg + ",";
                                }
                            }
                            ++vpCardCount;
                            switch (devCardType) {
                                case 4: {
                                    msg = msg + " a Capitol (+1VP)";
                                    continue block22;
                                }
                                case 5: {
                                    msg = msg + " a Library (+1VP)";
                                    continue block22;
                                }
                                case 6: {
                                    msg = msg + " a University (+1VP)";
                                    continue block22;
                                }
                                case 7: {
                                    msg = msg + " a Temple (+1VP)";
                                    continue block22;
                                }
                                case 8: {
                                    msg = msg + " a Tower (+1VP)";
                                }
                            }
                        }
                        this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, msg));
                        break;
                    }
                    SOCServer.sleep(2000L);
                    this.messageToGame(ga.getName(), new SOCDeleteGame(ga.getName()));
                    SOCServer.sleep(8000L);
                    System.out.println("Clean exit.");
                    System.exit(0);
                }
            }
        }
    }

    protected void reportTrade(SOCGame ga, int offering, int accepting) {
        if (ga != null) {
            SOCTradeOffer offer = ga.getPlayer(offering).getCurrentOffer();
            String message = ga.getPlayer(offering).getName() + " traded ";
            SOCResourceSet rsrcs = offer.getGiveSet();
            int cl = rsrcs.getAmount(1);
            int or = rsrcs.getAmount(2);
            int sh = rsrcs.getAmount(3);
            int wh = rsrcs.getAmount(4);
            int wo = rsrcs.getAmount(5);
            if (cl > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), accepting, 101, 1, cl));
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), offering, 102, 1, cl));
                message = message + cl + " clay";
                if (or + sh + wh + wo > 0) {
                    message = message + ",";
                }
            }
            if (or > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), accepting, 101, 2, or));
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), offering, 102, 2, or));
                message = message + or + " ore";
                if (sh + wh + wo > 0) {
                    message = message + ",";
                }
            }
            if (sh > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), accepting, 101, 3, sh));
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), offering, 102, 3, sh));
                message = message + sh + " sheep";
                if (wh + wo > 0) {
                    message = message + ",";
                }
            }
            if (wh > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), accepting, 101, 4, wh));
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), offering, 102, 4, wh));
                message = message + wh + " wheat";
                if (wo > 0) {
                    message = message + ",";
                }
            }
            if (wo > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), accepting, 101, 5, wo));
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), offering, 102, 5, wo));
                message = message + wo + " wood";
            }
            message = message + " for ";
            rsrcs = offer.getGetSet();
            cl = rsrcs.getAmount(1);
            or = rsrcs.getAmount(2);
            sh = rsrcs.getAmount(3);
            wh = rsrcs.getAmount(4);
            wo = rsrcs.getAmount(5);
            if (cl > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), accepting, 102, 1, cl));
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), offering, 101, 1, cl));
                message = message + cl + " clay";
                if (or + sh + wh + wo > 0) {
                    message = message + ",";
                }
            }
            if (or > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), accepting, 102, 2, or));
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), offering, 101, 2, or));
                message = message + or + " ore";
                if (sh + wh + wo > 0) {
                    message = message + ",";
                }
            }
            if (sh > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), accepting, 102, 3, sh));
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), offering, 101, 3, sh));
                message = message + sh + " sheep";
                if (wh + wo > 0) {
                    message = message + ",";
                }
            }
            if (wh > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), accepting, 102, 4, wh));
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), offering, 101, 4, wh));
                message = message + wh + " wheat";
                if (wo > 0) {
                    message = message + ",";
                }
            }
            if (wo > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), accepting, 102, 5, wo));
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), offering, 101, 5, wo));
                message = message + wo + " wood";
            }
            message = message + " from " + ga.getPlayer(accepting).getName() + ".";
            this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, message));
        }
    }

    protected void reportBankTrade(SOCGame ga, SOCResourceSet give, SOCResourceSet get) {
        if (ga != null) {
            String message = ga.getPlayer(ga.getCurrentPlayerNumber()).getName() + " traded ";
            int cl = give.getAmount(1);
            int or = give.getAmount(2);
            int sh = give.getAmount(3);
            int wh = give.getAmount(4);
            int wo = give.getAmount(5);
            if (cl > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), ga.getCurrentPlayerNumber(), 102, 1, cl));
                message = message + cl + " clay";
                if (or + sh + wh + wo > 0) {
                    message = message + ",";
                }
            }
            if (or > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), ga.getCurrentPlayerNumber(), 102, 2, or));
                message = message + or + " ore";
                if (sh + wh + wo > 0) {
                    message = message + ",";
                }
            }
            if (sh > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), ga.getCurrentPlayerNumber(), 102, 3, sh));
                message = message + sh + " sheep";
                if (wh + wo > 0) {
                    message = message + ",";
                }
            }
            if (wh > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), ga.getCurrentPlayerNumber(), 102, 4, wh));
                message = message + wh + " wheat";
                if (wo > 0) {
                    message = message + ",";
                }
            }
            if (wo > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), ga.getCurrentPlayerNumber(), 102, 5, wo));
                message = message + wo + " wood";
            }
            message = message + " for ";
            cl = get.getAmount(1);
            or = get.getAmount(2);
            sh = get.getAmount(3);
            wh = get.getAmount(4);
            wo = get.getAmount(5);
            if (cl > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), ga.getCurrentPlayerNumber(), 101, 1, cl));
                message = message + cl + " clay";
                if (or + sh + wh + wo > 0) {
                    message = message + ",";
                }
            }
            if (or > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), ga.getCurrentPlayerNumber(), 101, 2, or));
                message = message + or + " ore";
                if (sh + wh + wo > 0) {
                    message = message + ",";
                }
            }
            if (sh > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), ga.getCurrentPlayerNumber(), 101, 3, sh));
                message = message + sh + " sheep";
                if (wh + wo > 0) {
                    message = message + ",";
                }
            }
            if (wh > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), ga.getCurrentPlayerNumber(), 101, 4, wh));
                message = message + wh + " wheat";
                if (wo > 0) {
                    message = message + ",";
                }
            }
            if (wo > 0) {
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), ga.getCurrentPlayerNumber(), 101, 5, wo));
                message = message + wo + " wood";
            }
            message = give.getTotal() / get.getTotal() == 4 ? message + " from the bank." : message + " from a port.";
            this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, message));
        }
    }

    protected boolean checkTurn(Connection c, SOCGame ga) {
        if (c != null && ga != null) {
            try {
                return ga.getCurrentPlayerNumber() == ga.getPlayer((String)c.data).getPlayerNumber();
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    protected void startGame(SOCGame ga) throws InterruptedException {
        if (ga != null) {
            ++this.numberOfGamesStarted;
            ga.startGame();
            SOCBoardLayout bl = this.getBoardLayoutMessage(ga);
            this.messageToGame(ga.getName(), bl);
            for (int i = 0; i < 4; ++i) {
                SOCPlayer pl = ga.getPlayer(i);
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), i, 100, 10, pl.getNumPieces(0)));
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), i, 100, 11, pl.getNumPieces(1)));
                this.messageToGame(ga.getName(), new SOCPlayerElement(ga.getName(), i, 100, 12, pl.getNumPieces(2)));
                this.messageToGame(ga.getName(), new SOCSetPlayedDevCard(ga.getName(), i, false));
            }
            this.messageToGame(ga.getName(), new SOCDevCardCount(ga.getName(), ga.getNumDevCards()));
            this.messageToGame(ga.getName(), new SOCGameTextMsg(ga.getName(), SERVERNAME, "Randomly picking a starting player..."));
            this.sendGameState(ga);
            this.messageToGame(ga.getName(), new SOCStartGame(ga.getName()));
            this.sendTurn(ga);
        }
    }

    private void sendTurn(SOCGame ga) {
        if (ga != null) {
            this.messageToGame(ga.getName(), new SOCSetPlayedDevCard(ga.getName(), ga.getCurrentPlayerNumber(), false));
            SOCTurn turnMessage = new SOCTurn(ga.getName(), ga.getCurrentPlayerNumber());
            this.messageToGame(ga.getName(), turnMessage);
        }
    }

    private SOCBoardLayout getBoardLayoutMessage(SOCGame ga) {
        SOCBoard board = ga.getBoard();
        int[] hexes = board.getHexLayout();
        int[] numbers = board.getNumberLayout();
        int robber = board.getRobberHex();
        return new SOCBoardLayout(ga.getName(), hexes, numbers, robber);
    }

    private void createNewGameEventRecord() {
    }

    private void saveCurrentGameEventRecord(String gn) {
    }

    protected void storeGameScores(SOCGame ga) {
        if (ga != null && ga.getGameState() == 1000 && ga.allOriginalPlayers()) {
            try {
                SOCDBHelper.saveGameScores(ga.getName(), ga.getPlayer(0).getName(), ga.getPlayer(1).getName(), ga.getPlayer(2).getName(), ga.getPlayer(3).getName(), (short)ga.getPlayer(0).getTotalVP(), (short)ga.getPlayer(1).getTotalVP(), (short)ga.getPlayer(2).getTotalVP(), (short)ga.getPlayer(3).getTotalVP(), ga.getStartTime());
            }
            catch (SQLException sqle) {
                System.err.println("Error saving game scores in db.");
            }
        }
    }

    protected void recordGameEvent(SOCMessage mes, String gameName, String event) {
        System.out.println("log:  " + event);
        if (this.loggerClient != null) {
            this.loggerClient.recordGameEvent(mes, gameName, event);
        }
    }

    protected void giveResources(String mes, SOCGame game) {
        StringTokenizer st = new StringTokenizer(mes.substring(6));
        int[] resources = new int[6];
        int resourceType = 1;
        String name = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (resourceType <= 5) {
                resources[resourceType] = Integer.parseInt(token);
                ++resourceType;
                continue;
            }
            name = token;
            break;
        }
        SOCResourceSet rset = game.getPlayer(name).getResources();
        int pnum = game.getPlayer(name).getPlayerNumber();
        String outMes = "### " + name + " got";
        block8: for (resourceType = 1; resourceType <= 5; ++resourceType) {
            rset.add(resources[resourceType], resourceType);
            outMes = outMes + " " + resources[resourceType];
            switch (resourceType) {
                case 1: {
                    this.messageToGame(game.getName(), new SOCPlayerElement(game.getName(), pnum, 101, 1, resources[resourceType]));
                    continue block8;
                }
                case 2: {
                    this.messageToGame(game.getName(), new SOCPlayerElement(game.getName(), pnum, 101, 2, resources[resourceType]));
                    continue block8;
                }
                case 3: {
                    this.messageToGame(game.getName(), new SOCPlayerElement(game.getName(), pnum, 101, 3, resources[resourceType]));
                    continue block8;
                }
                case 4: {
                    this.messageToGame(game.getName(), new SOCPlayerElement(game.getName(), pnum, 101, 4, resources[resourceType]));
                    continue block8;
                }
                case 5: {
                    this.messageToGame(game.getName(), new SOCPlayerElement(game.getName(), pnum, 101, 5, resources[resourceType]));
                }
            }
        }
        this.messageToGame(game.getName(), new SOCGameTextMsg(game.getName(), SERVERNAME, outMes));
    }

    protected void broadcastGameStats(SOCGame ga) {
    }

    public void checkForExpiredGames() {
        Vector<String> expired = new Vector<String>();
        this.gameList.takeMonitor();
        try {
            Enumeration k = this.gameList.getGames();
            while (k.hasMoreElements()) {
                String gameName = (String)k.nextElement();
                SOCGame gameData = this.gameList.getGameData(gameName);
                if (gameData.getExpiration() <= System.currentTimeMillis()) {
                    expired.addElement(gameName);
                    this.messageToGame(gameName, new SOCGameTextMsg(gameName, SERVERNAME, ">>> The time limit on this game has expired and will now be destroyed."));
                    continue;
                }
                if (gameData.getExpiration() - 300000L > System.currentTimeMillis()) continue;
                gameData.setExpiration(System.currentTimeMillis() + 300000L);
                this.messageToGame(gameName, new SOCGameTextMsg(gameName, SERVERNAME, ">>> Less than 5 minutes remaining.  Type *ADDTIME* to extend this game another 30 minutes."));
            }
        }
        catch (Exception e) {
            D.ebugPrintln("Exception in checkForExpiredGames - " + e);
        }
        this.gameList.releaseMonitor();
        Enumeration ex = expired.elements();
        while (ex.hasMoreElements()) {
            String ga = (String)ex.nextElement();
            this.gameList.takeMonitor();
            try {
                this.destroyGame(ga);
            }
            catch (Exception e) {
                D.ebugPrintln("Exception in checkForExpired - " + e);
            }
            this.gameList.releaseMonitor();
            this.broadcast(SOCDeleteGame.toCmd(ga));
        }
    }

    protected void giveDevCard(String mes, SOCGame game) {
        StringTokenizer st = new StringTokenizer(mes.substring(5));
        String name = "";
        int cardType = -1;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (cardType < 0) {
                cardType = Integer.parseInt(token);
                continue;
            }
            name = token;
            break;
        }
        SOCDevCardSet dcSet = game.getPlayer(name).getDevCards();
        dcSet.add(1, 1, cardType);
        int pnum = game.getPlayer(name).getPlayerNumber();
        String outMes = "### " + name + " got a " + cardType + " card.";
        this.messageToGame(game.getName(), new SOCDevCard(game.getName(), pnum, 0, cardType));
        this.messageToGame(game.getName(), new SOCGameTextMsg(game.getName(), SERVERNAME, outMes));
    }

    public void setLoggerClient(SSRobotClient cl) {
        this.loggerClient = cl;
    }

    public static void main(String[] args) {
        int mc;
        int port;
        if (args.length < 4) {
            System.err.println("usage: java soc.server.SOCServer port_number max_connections dbUser dbPass");
            return;
        }
        try {
            port = Integer.parseInt(args[0]);
            mc = Integer.parseInt(args[1]);
        }
        catch (Exception e) {
            System.err.println("usage: java soc.server.SOCServer port_number max_connections dbUser dbPass");
            return;
        }
        SOCServer server = new SOCServer(port, mc, args[2], args[3]);
        server.setPriority(5);
        server.start();
    }
}

