/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import java.util.Enumeration;
import java.util.Vector;
import soc.disableDebug.D;
import soc.message.SOCServerPing;
import soc.server.genericServer.Connection;

public class SOCServerRobotPinger
extends Thread {
    Vector robotConnections;
    int sleepTime = 150000;
    SOCServerPing ping;
    boolean alive;

    public SOCServerRobotPinger(Vector robots) {
        this.robotConnections = robots;
        this.ping = new SOCServerPing(this.sleepTime);
        this.alive = true;
    }

    @Override
    public void run() {
        while (this.alive) {
            if (!this.robotConnections.isEmpty()) {
                Enumeration robotConnectionsEnum = this.robotConnections.elements();
                while (robotConnectionsEnum.hasMoreElements()) {
                    Connection robotConnection = (Connection)robotConnectionsEnum.nextElement();
                    D.ebugPrintln("(*)(*)(*)(*) PINGING " + robotConnection.data);
                    robotConnection.put(this.ping.toCmd());
                }
            }
            SOCServerRobotPinger.yield();
            try {
                SOCServerRobotPinger.sleep(this.sleepTime - 60000);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.robotConnections = null;
        this.ping = null;
    }

    public void stopPinger() {
        this.alive = false;
    }
}

