/*
 * Decompiled with CFR 0.152.
 */
package soc.server.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import soc.util.SOCRobotParameters;

public class SOCDBHelper {
    private static Connection connection = null;
    private static boolean errorCondition = false;
    private static String userName;
    private static String password;
    private static String CREATE_ACCOUNT_COMMAND;
    private static String RECORD_LOGIN_COMMAND;
    private static String USER_PASSWORD_QUERY;
    private static String HOST_QUERY;
    private static String LASTLOGIN_UPDATE;
    private static String SAVE_GAME_COMMAND;
    private static String ROBOT_PARAMS_QUERY;
    private static PreparedStatement createAccountCommand;
    private static PreparedStatement recordLoginCommand;
    private static PreparedStatement userPasswordQuery;
    private static PreparedStatement hostQuery;
    private static PreparedStatement lastloginUpdate;
    private static PreparedStatement saveGameCommand;
    private static PreparedStatement robotParamsQuery;

    public static void initialize(String user, String pswd) throws SQLException {
        try {
            Class.forName("org.gjt.mm.mysql.Driver").newInstance();
            SOCDBHelper.connect(user, pswd);
        }
        catch (ClassNotFoundException x) {
            SQLException sx = new SQLException("MySQL driver is unavailable");
            sx.initCause(x);
            throw sx;
        }
        catch (Exception x) {
            SQLException sx = new SQLException("Unable to initialize user database");
            sx.initCause(x);
            throw sx;
        }
    }

    private static boolean checkConnection() throws SQLException {
        if (connection != null) {
            return !errorCondition || SOCDBHelper.connect(userName, password);
        }
        return false;
    }

    private static boolean connect(String user, String pswd) throws SQLException {
        String url = "jdbc:mysql://localhost/socdata";
        connection = DriverManager.getConnection(url, user, pswd);
        errorCondition = false;
        userName = user;
        password = pswd;
        createAccountCommand = connection.prepareStatement(CREATE_ACCOUNT_COMMAND);
        recordLoginCommand = connection.prepareStatement(RECORD_LOGIN_COMMAND);
        userPasswordQuery = connection.prepareStatement(USER_PASSWORD_QUERY);
        hostQuery = connection.prepareStatement(HOST_QUERY);
        lastloginUpdate = connection.prepareStatement(LASTLOGIN_UPDATE);
        saveGameCommand = connection.prepareStatement(SAVE_GAME_COMMAND);
        robotParamsQuery = connection.prepareStatement(ROBOT_PARAMS_QUERY);
        return true;
    }

    public static String getUserPassword(String sUserName) throws SQLException {
        String password = null;
        if (SOCDBHelper.checkConnection()) {
            try {
                userPasswordQuery.setString(1, sUserName);
                ResultSet resultSet = userPasswordQuery.executeQuery();
                if (resultSet.next()) {
                    password = resultSet.getString(1);
                }
                resultSet.close();
            }
            catch (SQLException sqlE) {
                errorCondition = true;
                sqlE.printStackTrace();
                throw sqlE;
            }
        }
        return password;
    }

    public static String getUserFromHost(String host) throws SQLException {
        String nickname = null;
        if (SOCDBHelper.checkConnection()) {
            try {
                hostQuery.setString(1, host);
                ResultSet resultSet = hostQuery.executeQuery();
                if (resultSet.next()) {
                    nickname = resultSet.getString(1);
                }
                resultSet.close();
            }
            catch (SQLException sqlE) {
                errorCondition = true;
                sqlE.printStackTrace();
                throw sqlE;
            }
        }
        return nickname;
    }

    public static boolean createAccount(String userName, String host, String password, String email, long time) throws SQLException {
        if (SOCDBHelper.checkConnection()) {
            try {
                java.sql.Date sqlDate = new java.sql.Date(time);
                Calendar cal = Calendar.getInstance();
                createAccountCommand.setString(1, userName);
                createAccountCommand.setString(2, host);
                createAccountCommand.setString(3, password);
                createAccountCommand.setString(4, email);
                createAccountCommand.setDate(5, sqlDate, cal);
                createAccountCommand.executeUpdate();
                return true;
            }
            catch (SQLException sqlE) {
                errorCondition = true;
                sqlE.printStackTrace();
                throw sqlE;
            }
        }
        return false;
    }

    public static boolean recordLogin(String userName, String host, long time) throws SQLException {
        if (SOCDBHelper.checkConnection()) {
            try {
                java.sql.Date sqlDate = new java.sql.Date(time);
                Calendar cal = Calendar.getInstance();
                recordLoginCommand.setString(1, userName);
                recordLoginCommand.setString(2, host);
                recordLoginCommand.setDate(3, sqlDate, cal);
                recordLoginCommand.executeUpdate();
                return true;
            }
            catch (SQLException sqlE) {
                errorCondition = true;
                sqlE.printStackTrace();
                throw sqlE;
            }
        }
        return false;
    }

    public static boolean updateLastlogin(String userName, long time) throws SQLException {
        if (SOCDBHelper.checkConnection()) {
            try {
                java.sql.Date sqlDate = new java.sql.Date(time);
                Calendar cal = Calendar.getInstance();
                lastloginUpdate.setDate(1, sqlDate, cal);
                lastloginUpdate.setString(2, userName);
                lastloginUpdate.executeUpdate();
                return true;
            }
            catch (SQLException sqlE) {
                errorCondition = true;
                sqlE.printStackTrace();
                throw sqlE;
            }
        }
        return false;
    }

    public static boolean saveGameScores(String gameName, String player1, String player2, String player3, String player4, short score1, short score2, short score3, short score4, Date startTime) throws SQLException {
        if (SOCDBHelper.checkConnection()) {
            try {
                saveGameCommand.setString(1, gameName);
                saveGameCommand.setString(2, player1);
                saveGameCommand.setString(3, player2);
                saveGameCommand.setString(4, player3);
                saveGameCommand.setString(5, player4);
                saveGameCommand.setShort(6, score1);
                saveGameCommand.setShort(7, score2);
                saveGameCommand.setShort(8, score3);
                saveGameCommand.setShort(9, score4);
                saveGameCommand.setTimestamp(10, new Timestamp(startTime.getTime()));
                saveGameCommand.executeUpdate();
                return true;
            }
            catch (SQLException sqlE) {
                errorCondition = true;
                sqlE.printStackTrace();
                throw sqlE;
            }
        }
        return false;
    }

    public static SOCRobotParameters retrieveRobotParams(String robotName) throws SQLException {
        SOCRobotParameters robotParams = null;
        if (SOCDBHelper.checkConnection()) {
            try {
                robotParamsQuery.setString(1, robotName);
                ResultSet resultSet = robotParamsQuery.executeQuery();
                if (resultSet.next()) {
                    int mgl = resultSet.getInt(2);
                    int me = resultSet.getInt(3);
                    float ebf = resultSet.getFloat(4);
                    float af = resultSet.getFloat(5);
                    float laf = resultSet.getFloat(6);
                    float dcm = resultSet.getFloat(7);
                    float tm = resultSet.getFloat(8);
                    int st = resultSet.getInt(9);
                    int tf = resultSet.getInt(14);
                    robotParams = new SOCRobotParameters(mgl, me, ebf, af, laf, dcm, tm, st, tf);
                }
                resultSet.close();
            }
            catch (SQLException sqlE) {
                errorCondition = true;
                sqlE.printStackTrace();
                throw sqlE;
            }
        }
        return robotParams;
    }

    public static void cleanup() throws SQLException {
        if (SOCDBHelper.checkConnection()) {
            try {
                createAccountCommand.close();
                userPasswordQuery.close();
                hostQuery.close();
                lastloginUpdate.close();
                saveGameCommand.close();
                robotParamsQuery.close();
                connection.close();
            }
            catch (SQLException sqlE) {
                errorCondition = true;
                sqlE.printStackTrace();
                throw sqlE;
            }
        }
    }

    private static void dispResultSet(ResultSet rs) throws SQLException {
        int i;
        System.out.println("dispResultSet()");
        ResultSetMetaData rsmd = rs.getMetaData();
        int numCols = rsmd.getColumnCount();
        for (i = 1; i <= numCols; ++i) {
            if (i > 1) {
                System.out.print(",");
            }
            System.out.print(rsmd.getColumnLabel(i));
        }
        System.out.println("");
        boolean more = rs.next();
        while (more) {
            for (i = 1; i <= numCols; ++i) {
                if (i > 1) {
                    System.out.print(",");
                }
                System.out.print(rs.getString(i));
            }
            System.out.println("");
            more = rs.next();
        }
    }

    static {
        CREATE_ACCOUNT_COMMAND = "INSERT INTO users VALUES (?,?,?,?,?);";
        RECORD_LOGIN_COMMAND = "INSERT INTO logins VALUES (?,?,?);";
        USER_PASSWORD_QUERY = "SELECT password FROM users WHERE ( users.nickname = ? );";
        HOST_QUERY = "SELECT nickname FROM users WHERE ( users.host = ? );";
        LASTLOGIN_UPDATE = "UPDATE users SET lastlogin = ?  WHERE nickname = ? ;";
        SAVE_GAME_COMMAND = "INSERT INTO games VALUES (?,?,?,?,?,?,?,?,?,?);";
        ROBOT_PARAMS_QUERY = "SELECT * FROM robotparams WHERE robotname = ?;";
        createAccountCommand = null;
        recordLoginCommand = null;
        userPasswordQuery = null;
        hostQuery = null;
        lastloginUpdate = null;
        saveGameCommand = null;
        robotParamsQuery = null;
    }
}

