/*
 * Decompiled with CFR 0.152.
 */
package soc.server.genericServer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.util.Vector;
import soc.disableDebug.D;
import soc.server.genericServer.Server;

public final class Connection
extends Thread
implements Runnable,
Serializable,
Cloneable {
    static int putters = 0;
    static Object puttersMonitor = new Object();
    protected static final int TIMEOUT_VALUE = 3600000;
    public Object data;
    DataInputStream in = null;
    DataOutputStream out = null;
    Socket s = null;
    Server sv;
    public Thread reader;
    protected String hst;
    protected Exception error = null;
    protected boolean connected = false;
    public Vector outQueue = new Vector();

    Connection(Socket so, Server sve) {
        this.hst = so.getInetAddress().getHostName();
        this.sv = sve;
        this.s = so;
        this.reader = null;
        this.data = null;
    }

    public String host() {
        return this.hst;
    }

    boolean connect() {
        try {
            this.s.setSoTimeout(3600000);
            this.in = new DataInputStream(this.s.getInputStream());
            this.out = new DataOutputStream(this.s.getOutputStream());
            this.connected = true;
            this.reader = this;
            Putter putter = new Putter(this);
            putter.start();
        }
        catch (Exception e) {
            D.ebugPrintln("IOException in Connection.connect (" + this.hst + ") - " + e);
            this.error = e;
            this.disconnect();
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        this.sv.addConnection(this);
        try {
            while (this.connected) {
                this.sv.treat(this.in.readUTF(), this);
            }
        }
        catch (IOException e) {
            D.ebugPrintln("IOException in Connection.run (" + this.hst + ") - " + e);
            if (!this.connected) {
                return;
            }
            this.error = e;
            this.sv.removeConnection(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean put(String str) {
        Vector vector = this.outQueue;
        synchronized (vector) {
            D.ebugPrintln("Adding " + str + " to outQueue for " + this.data);
            this.outQueue.addElement(str);
            this.outQueue.notify();
        }
        return true;
    }

    public boolean putForReal(String str) {
        boolean rv = this.putAux(str);
        if (!rv) {
            if (!this.connected) {
                return false;
            }
            this.sv.removeConnection(this);
            return false;
        }
        return true;
    }

    public final boolean putAux(String str) {
        if (this.error != null || !this.connected) {
            return false;
        }
        try {
            this.out.writeUTF(str);
        }
        catch (IOException e) {
            D.ebugPrintln("IOException in Connection.putAux (" + this.hst + ") - " + e);
            this.error = e;
            return false;
        }
        catch (Exception ex) {
            D.ebugPrintln("generic exception in connection putaux");
            return false;
        }
        return true;
    }

    void disconnect() {
        D.ebugPrintln("DISCONNECTING " + this.data);
        this.connected = false;
        try {
            this.s.close();
        }
        catch (IOException e) {
            D.ebugPrintln("IOException in Connection.disconnect (" + this.hst + ") - " + e);
            this.error = e;
        }
        this.s = null;
        this.in = null;
        this.out = null;
    }

    public boolean isConnected() {
        return this.connected;
    }

    class Putter
    extends Thread {
        Connection con;

        public Putter(Connection c) {
            this.con = c;
            D.ebugPrintln("NEW PUTTER CREATED FOR " + Connection.this.data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.con.connected) {
                String c = null;
                D.ebugPrintln("** " + Connection.this.data + " is at the top of the putter loop");
                Vector vector = Connection.this.outQueue;
                synchronized (vector) {
                    if (Connection.this.outQueue.size() > 0) {
                        c = (String)Connection.this.outQueue.elementAt(0);
                        Connection.this.outQueue.removeElementAt(0);
                    }
                }
                if (c != null) {
                    boolean bl = this.con.putForReal(c);
                }
                vector = Connection.this.outQueue;
                synchronized (vector) {
                    if (Connection.this.outQueue.size() == 0) {
                        try {
                            Connection.this.outQueue.wait(1000L);
                        }
                        catch (Exception ex) {
                            D.ebugPrintln("Exception while waiting for outQueue in " + Connection.this.data + ". - " + ex);
                        }
                    }
                }
            }
            D.ebugPrintln("putter not putting connected==false : " + Connection.this.data);
        }
    }
}

