/*
 * Decompiled with CFR 0.152.
 */
package soc.server.genericServer;

import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import soc.disableDebug.D;
import soc.server.genericServer.Connection;

public abstract class Server
extends Thread
implements Serializable,
Cloneable {
    ServerSocket ss;
    boolean up = false;
    protected Exception error = null;
    protected int port;
    protected int numberOfConnections;
    protected Vector conns = new Vector();
    public Vector inQueue = new Vector();

    public Server(int port) {
        this.port = port;
        this.numberOfConnections = 0;
        try {
            this.ss = new ServerSocket(port);
        }
        catch (IOException e) {
            System.err.println("Could not listen to port " + port + ": " + e);
            this.error = e;
        }
    }

    protected Enumeration getConnections() {
        return this.conns.elements();
    }

    protected synchronized int connectionCount() {
        return this.conns.size();
    }

    protected synchronized boolean isUp() {
        return this.up;
    }

    @Override
    public void run() {
        Treater treater = new Treater(this);
        treater.start();
        if (this.error != null) {
            return;
        }
        this.up = true;
        while (this.isUp()) {
            try {
                while (this.isUp()) {
                    Connection con = new Connection(this.ss.accept(), this);
                    con.start();
                }
            }
            catch (IOException e) {
                this.error = e;
                D.ebugPrintln("Exception " + e + " during accept");
            }
            try {
                this.ss.close();
                this.ss = new ServerSocket(this.port);
            }
            catch (IOException e) {
                System.err.println("Could not listen to port " + this.port + ": " + e);
                this.up = false;
                this.error = e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void treat(String s, Connection c) {
        Vector vector = this.inQueue;
        synchronized (vector) {
            this.inQueue.addElement(new Command(s, c));
            this.inQueue.notify();
        }
    }

    public abstract void processCommand(String var1, Connection var2);

    protected void serverDown() {
    }

    protected void newConnection(Connection c) {
    }

    protected void leaveConnection(Connection c) {
    }

    public synchronized void stopServer() {
        this.up = false;
        this.serverDown();
        Enumeration e = this.conns.elements();
        while (e.hasMoreElements()) {
            ((Connection)e.nextElement()).disconnect();
        }
        this.conns.removeAllElements();
    }

    protected synchronized void removeConnection(Connection c) {
        if (!this.conns.removeElement(c)) {
            return;
        }
        c.disconnect();
        this.leaveConnection(c);
        D.ebugPrintln(c.host() + " left (" + this.connectionCount() + ")  " + new Date().toString() + (c.error != null ? ": " + c.error.toString() : ""));
    }

    protected void removeConnectionCleanup(Connection c) {
    }

    protected synchronized void addConnection(Connection c) {
        if (c.connect()) {
            ++this.numberOfConnections;
            this.newConnection(c);
            this.conns.addElement(c);
            D.ebugPrintln(c.host() + " came (" + this.connectionCount() + ")  " + new Date().toString());
        }
    }

    protected synchronized void broadcast(String m) {
        Enumeration e = this.getConnections();
        while (e.hasMoreElements()) {
            ((Connection)e.nextElement()).put(m);
        }
    }

    class Treater
    extends Thread {
        Server svr;

        public Treater(Server s) {
            this.svr = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.svr.isUp()) {
                Command c = null;
                Vector vector = Server.this.inQueue;
                synchronized (vector) {
                    if (Server.this.inQueue.size() > 0) {
                        c = (Command)Server.this.inQueue.elementAt(0);
                        Server.this.inQueue.removeElementAt(0);
                    }
                }
                try {
                    if (c != null) {
                        this.svr.processCommand(c.str, c.con);
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception in treater (processCommand) - " + e);
                }
                Treater.yield();
                vector = Server.this.inQueue;
                synchronized (vector) {
                    if (Server.this.inQueue.size() == 0) {
                        try {
                            Server.this.inQueue.wait(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    class Command {
        public String str;
        public Connection con;

        public Command(String s, Connection c) {
            this.str = s;
            this.con = c;
        }
    }
}

