import requests
import time
import csv
import pandas as pd
import os
import re

from bs4 import BeautifulSoup

def scrapper(site):
    source = requests.get(site).text
    result = BeautifulSoup(source, 'html.parser')

    return result

fandom_file = pd.read_csv(r'fandom_to_scrape.csv')

print(len(fandom_file))
fp = open("fandom_summaries_full_28.csv", "w", newline='', encoding="utf-8")
csvwriter = csv.writer(fp, delimiter=",",  quoting=csv.QUOTE_NONNUMERIC, quotechar="\"")
csvwriter.writerow(["index", "url", "title", "summary"])

num = 0
while num < len(fandom_file):
# while num < 75:
    print("line", num, "starts search")

    try:

        url = fandom_file['url'][num]
        soup = scrapper(url)
        article = soup.find_all('p')
        summary = ''
        S = 0
        for i, info in enumerate(article):
            info = re.sub('\s+', ' ', info.text)
            # print(i, info)
            if info.strip():
                if len(info.split()) > 1:
                    # print(i, 'enters')
                    summary += info
                    S += 1
            if S == 5:
                break
        title = scrapper(url).find('h1', class_ = 'page-header__title').text.strip()
        csvwriter.writerow([num, url, title, summary])
        # print(num,url,title)
        # print(summary)
        fp.flush()
        os.fsync(fp)

        print(num, 'is complete')
        num += 1

    except:

        print(num, 'an error occured')
        time.sleep(2*60)
        continue

fp.close()




